/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import java.io.IOException;
import java.io.InputStream;

public class NonSyncByteArrayInputStream
extends InputStream {
    private byte[] fData;
    private int fPosition;

    public NonSyncByteArrayInputStream(byte[] buffer) {
        this.fData = buffer;
        this.fPosition = 0;
    }

    public final int read() throws IOException {
        if (this.fPosition < this.fData.length) {
            return this.fData[this.fPosition++] & 0xFF;
        }
        return -1;
    }

    public final int read(byte[] b, int off, int len) {
        int numToCopy;
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        int numCopied = numToCopy = Math.min(available, len);
        FastArrayCopy.copy(this.fData, this.fPosition, b, off, numToCopy);
        this.fPosition += numToCopy;
        return numCopied;
    }

    public int available() {
        return this.fData.length - this.fPosition;
    }

    public void reset() {
        this.fPosition = 0;
    }
}

