/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.ui.properties.KWilyUIStringsKeys;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class CalendarPanel
extends JPanel
implements ActionListener,
KWilyUIStringsKeys {
    private static final long serialVersionUID = 3362942884235589994L;
    private static final int kDefaultStartYear = 1969;
    private static final int kDefaultEndYear = Integer.MAX_VALUE;
    private boolean fInitialized = false;
    private String[] fMonths;
    private String[] fYears;
    private String[] fHours;
    private String[] fLongHours;
    private String[] fMinutes;
    private String[] fAmpms;
    private String[] fDays;
    private int fMinMonth;
    private int fMinYear;
    private int fMinHour;
    private int fMinLongHour;
    private int fMinMinute;
    private int fMinAMPM;
    private int fMinDay;
    private Calendar fCalendar;
    private ActionListener fActionListener;
    private JComboBox fMonthComboBox;
    private JComboBox fDayComboBox;
    private JComboBox fYearComboBox;
    private DayPanel fCur;
    private DayPanel[][] fDaypanels;
    private JComboBox fHourComboBox;
    private JComboBox fLongHourComboBox;
    private JComboBox fMinuteComboBox;
    private JComboBox fAmpmComboBox;
    private boolean fIsModifying = false;
    private boolean fIsSimpleLayout;

    public CalendarPanel(IStringLocalizer localizer) {
        this(localizer, true, localizer.IStringLocalizer_getLocalizedString("Calendar_Panel_Date_Title"));
    }

    public CalendarPanel(IStringLocalizer localizer, boolean displayTime, String localizedPanelLabel) {
        this(localizer, displayTime, false, localizedPanelLabel, 1969, Integer.MAX_VALUE, false, null);
    }

    public CalendarPanel(IStringLocalizer localizer, boolean displayTime, boolean simpleLayout, String localizedPanelLabel, int startYear, int endYear, boolean canEditYears, ActionListener actionListener) {
        super(new BorderLayout());
        Assertion.wilyAssert(startYear <= endYear, "the calendar start year must be less than or equal to the end year");
        this.initialize(startYear, endYear);
        this.fIsSimpleLayout = simpleLayout;
        this.fActionListener = actionListener;
        this.fCalendar = Calendar.getInstance();
        this.fMonthComboBox = new JComboBox<String>(this.fMonths);
        this.fMonthComboBox.addActionListener(this);
        this.fDayComboBox = new JComboBox<String>(this.fDays);
        this.fDayComboBox.addActionListener(this);
        this.fYearComboBox = new JComboBox<String>(this.fYears);
        this.fYearComboBox.setEditable(canEditYears);
        this.fYearComboBox.addActionListener(this);
        JPanel toppanel = new JPanel();
        if (simpleLayout) {
            JLabel title = new JLabel(localizedPanelLabel);
            toppanel.add(title);
        }
        toppanel.add(this.fMonthComboBox);
        if (simpleLayout) {
            toppanel.add(this.fDayComboBox);
        }
        toppanel.add(this.fYearComboBox);
        this.fHourComboBox = new JComboBox<String>(this.fHours);
        this.fHourComboBox.addActionListener(this);
        this.fLongHourComboBox = new JComboBox<String>(this.fLongHours);
        this.fLongHourComboBox.addActionListener(this);
        this.fMinuteComboBox = new JComboBox<String>(this.fMinutes);
        this.fMinuteComboBox.addActionListener(this);
        this.fAmpmComboBox = new JComboBox<String>(this.fAmpms);
        this.fAmpmComboBox.addActionListener(this);
        if (!simpleLayout) {
            this.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new LineBorder(Color.black)));
        } else {
            JLabel atLabel = new JLabel(" " + localizer.IStringLocalizer_getLocalizedString("Date_Hour_Separator_Key") + " ");
            toppanel.add(atLabel);
            toppanel.add(this.fLongHourComboBox);
        }
        JPanel bottompanel = this.buildCalendarPanel((Calendar)this.fCalendar.clone());
        JPanel datePanel = new JPanel(new BorderLayout());
        datePanel.add((Component)toppanel, "North");
        if (!simpleLayout) {
            datePanel.setBorder(new TitledBorder(localizedPanelLabel));
            datePanel.add((Component)bottompanel, "Center");
        }
        this.add((Component)datePanel, "Center");
        if (displayTime) {
            JPanel timePanel = new JPanel();
            timePanel.setBorder(new TitledBorder(localizer.IStringLocalizer_getLocalizedString("Calendar_Panel_Time_Title")));
            timePanel.add(this.fHourComboBox);
            timePanel.add(new JLabel(localizer.IStringLocalizer_getLocalizedString("Calendar_Panel_Time_Separator")));
            timePanel.add(this.fMinuteComboBox);
            timePanel.add(this.fAmpmComboBox);
            this.add((Component)timePanel, "South");
        }
    }

    private void initialize(int startYear, int endYear) {
        if (this.fInitialized) {
            return;
        }
        this.fMonths = this.buildMonths();
        this.fYears = this.buildYears(startYear, endYear);
        this.fHours = this.buildHours();
        this.fLongHours = this.buildLongHours();
        this.fMinutes = this.buildMinutes();
        this.fAmpms = this.buildAMPM();
        this.fDays = this.buildDays(Calendar.getInstance());
        this.fInitialized = true;
    }

    private String[] buildMonths() {
        Calendar calendar = Calendar.getInstance();
        this.fMinMonth = calendar.getMinimum(2);
        int max = calendar.getMaximum(2);
        return this.buildListing("MMMM", 2, this.fMinMonth, max);
    }

    private String[] buildDays(Calendar calendarToUse) {
        this.fMinDay = calendarToUse.getMinimum(5);
        int max = calendarToUse.getMaximum(5);
        return this.buildListing("d", 5, this.fMinDay, max);
    }

    private String[] buildYears(int startYear, int endYear) {
        Calendar calendar = Calendar.getInstance();
        this.fMinYear = startYear;
        int max = endYear == Integer.MAX_VALUE ? calendar.get(1) + 10 : endYear;
        return this.buildListing("yyyy", 1, this.fMinYear, max);
    }

    private String[] buildHours() {
        Calendar calendar = Calendar.getInstance();
        this.fMinHour = calendar.getMinimum(10);
        int max = calendar.getMaximum(10);
        return this.buildListing("h", 10, this.fMinHour, max);
    }

    private String[] buildLongHours() {
        Calendar calendar = Calendar.getInstance();
        this.fMinLongHour = calendar.getMinimum(11);
        int max = calendar.getMaximum(11);
        return this.buildListing("h:mm a", 11, this.fMinLongHour, max);
    }

    private String[] buildMinutes() {
        Calendar calendar = Calendar.getInstance();
        this.fMinMinute = calendar.getMinimum(12);
        int max = calendar.getMaximum(12);
        return this.buildListing("mm", 12, this.fMinMinute, max);
    }

    private String[] buildAMPM() {
        Calendar calendar = Calendar.getInstance();
        this.fMinAMPM = calendar.getMinimum(9);
        int max = calendar.getMaximum(9);
        return this.buildListing("a", 9, this.fMinAMPM, max);
    }

    private String[] buildListing(String pattern, int field, int min, int max) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        String[] values = new String[max - min + 1];
        for (int i = min; i <= max; ++i) {
            calendar.clear();
            if (field == 9) {
                calendar.set(10, 5);
            }
            calendar.set(field, i);
            values[i - min] = df.format(calendar.getTime());
        }
        return values;
    }

    private JPanel buildCalendarPanel(Calendar calendar) {
        int i;
        int weekMin = calendar.getMinimum(7);
        int weekMax = calendar.getMaximum(7);
        int monthMin = calendar.getMinimum(5);
        int monthMax = calendar.getMaximum(5);
        int width = weekMax - weekMin + 1;
        int height = (monthMax - monthMin) / width + ((monthMax - monthMin) % width == 0 ? 1 : 2);
        SimpleDateFormat df = new SimpleDateFormat("E");
        JPanel panel = new JPanel(new GridLayout(height + 1, width));
        for (i = 0; i < width; ++i) {
            calendar.set(7, i + weekMin);
            panel.add(new JLabel(df.format(calendar.getTime()), 0));
        }
        this.fDaypanels = new DayPanel[height][];
        for (i = 0; i < height; ++i) {
            this.fDaypanels[i] = new DayPanel[width];
            for (int j = 0; j < width; ++j) {
                this.fDaypanels[i][j] = new DayPanel();
                panel.add(this.fDaypanels[i][j]);
            }
        }
        return panel;
    }

    private void loadGUI() {
        this.fIsModifying = true;
        int curMonth = this.fCalendar.get(2);
        if (this.fMonthComboBox.getSelectedItem() != this.fMonths[curMonth - this.fMinMonth]) {
            this.fMonthComboBox.setSelectedItem(this.fMonths[curMonth - this.fMinMonth]);
        }
        int curYear = this.fCalendar.get(1);
        int yearDiff = curYear - this.fMinYear;
        if (this.fYearComboBox.isEditable() && yearDiff >= 0 && yearDiff < this.fYears.length || !this.fYearComboBox.isEditable() && this.fYearComboBox.getSelectedItem() != this.fYears[curYear - this.fMinYear]) {
            this.fYearComboBox.setSelectedItem(this.fYears[curYear - this.fMinYear]);
        }
        int curDay = this.fCalendar.get(5);
        this.fDayComboBox.removeAllItems();
        String[] items = this.buildDays(this.fCalendar);
        for (int i = 0; i < items.length; ++i) {
            this.fDayComboBox.addItem(items[i]);
        }
        this.fDayComboBox.setSelectedItem(String.valueOf(curDay));
        if (this.fCur != null) {
            this.fCur.unselect();
        }
        this.fCur = this.loadGrid(curDay);
        if (this.fCur != null) {
            this.fCur.select();
        }
        int curHour = this.fCalendar.get(10);
        if (this.fHourComboBox.getSelectedItem() != this.fHours[curHour - this.fMinHour]) {
            this.fHourComboBox.setSelectedItem(this.fHours[curHour - this.fMinHour]);
        }
        int curLongHour = this.fCalendar.get(11);
        if (this.fLongHourComboBox.getSelectedItem() != this.fLongHours[curLongHour - this.fMinLongHour]) {
            this.fLongHourComboBox.setSelectedItem(this.fLongHours[curLongHour - this.fMinLongHour]);
        }
        int curMinute = this.fCalendar.get(12);
        if (this.fMinuteComboBox.getSelectedItem() != this.fMinutes[curMinute - this.fMinMinute]) {
            this.fMinuteComboBox.setSelectedItem(this.fMinutes[curMinute - this.fMinMinute]);
        }
        int curAMPM = this.fCalendar.get(9);
        if (this.fAmpmComboBox.getSelectedItem() != this.fAmpms[curAMPM - this.fMinAMPM]) {
            this.fAmpmComboBox.setSelectedItem(this.fAmpms[curAMPM - this.fMinAMPM]);
        }
        this.fIsModifying = false;
    }

    private DayPanel loadGrid(int curDay) {
        SimpleDateFormat df = new SimpleDateFormat("d");
        Calendar c = Calendar.getInstance();
        DayPanel dp = null;
        c.set(1, this.fCalendar.get(1));
        c.set(2, this.fCalendar.get(2));
        c.set(5, this.fCalendar.getMinimum(5));
        c.setFirstDayOfWeek(1);
        int minDay = c.getFirstDayOfWeek();
        int startDay = c.get(7);
        int maxDay = c.getActualMaximum(5);
        int width = this.fDaypanels[0].length;
        for (int i = 0; i < this.fDaypanels.length; ++i) {
            for (int j = 0; j < this.fDaypanels[i].length; ++j) {
                if (i * width + j < startDay - minDay) {
                    this.fDaypanels[i][j].setText("");
                    continue;
                }
                if (i * width + j < startDay - minDay + maxDay) {
                    int dayValue = i * width + j - startDay + minDay + 1;
                    c.set(5, dayValue);
                    this.fDaypanels[i][j].setText(df.format(c.getTime()));
                    if (dayValue != curDay) continue;
                    dp = this.fDaypanels[i][j];
                    continue;
                }
                this.fDaypanels[i][j].setText("");
            }
        }
        return dp;
    }

    private void saveGUI() {
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(2, this.getMonth());
        newCal.set(5, this.getDay());
        newCal.set(1, this.getYear());
        if (this.fIsSimpleLayout) {
            newCal.set(11, this.getLongHour());
        } else {
            newCal.set(10, this.getHour());
        }
        newCal.set(12, this.getMinute());
        newCal.set(9, this.getAMPM());
        this.fCalendar = newCal;
    }

    private int getMonth() {
        String selection = (String)this.fMonthComboBox.getSelectedItem();
        return this.findIndex(this.fMonths, selection, this.fCalendar.get(2));
    }

    private int getDay() {
        String selection = (String)this.fDayComboBox.getSelectedItem();
        return this.findIndex(this.fDays, selection, 0) + this.fMinDay;
    }

    private int getYear() {
        String selection = (String)this.fYearComboBox.getSelectedItem();
        if (this.fYearComboBox.isEditable() && !this.canFindIndex(this.fYears, selection)) {
            int selYear = -1;
            try {
                selYear = Integer.parseInt(selection);
            }
            catch (NumberFormatException nfe) {
                return this.fMinYear;
            }
            if (selYear < 0) {
                return this.fMinYear;
            }
            return selYear;
        }
        return this.findIndex(this.fYears, selection, 0) + this.fMinYear;
    }

    private int getHour() {
        String selection = (String)this.fHourComboBox.getSelectedItem();
        return this.findIndex(this.fHours, selection, 0) + this.fMinHour;
    }

    private int getLongHour() {
        String selection = (String)this.fLongHourComboBox.getSelectedItem();
        return this.findIndex(this.fLongHours, selection, 0) + this.fMinLongHour;
    }

    private int getMinute() {
        String selection = (String)this.fMinuteComboBox.getSelectedItem();
        return this.findIndex(this.fMinutes, selection, 0) + this.fMinMinute;
    }

    private int getAMPM() {
        String selection = (String)this.fAmpmComboBox.getSelectedItem();
        return this.findIndex(this.fAmpms, selection, 0) + this.fMinAMPM;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.fIsModifying) {
            return;
        }
        Object obj = e.getSource();
        if (obj instanceof JComboBox) {
            boolean actionPerformed = true;
            if (obj == this.fMonthComboBox) {
                int month = this.getMonth();
                int prevMonth = this.fCalendar.get(2);
                int monthDiff = month - prevMonth;
                this.fCalendar.roll(2, monthDiff);
                this.loadGUI();
            } else if (obj == this.fDayComboBox) {
                this.fCalendar.set(5, this.getDay());
                this.loadGUI();
            } else if (obj == this.fYearComboBox) {
                this.fCalendar.set(1, this.getYear());
                this.loadGUI();
            } else if (obj == this.fHourComboBox) {
                this.fCalendar.set(10, this.getHour());
            } else if (obj == this.fLongHourComboBox) {
                this.fCalendar.set(11, this.getLongHour());
            } else if (obj == this.fMinuteComboBox) {
                this.fCalendar.set(12, this.getMinute());
            } else if (obj == this.fAmpmComboBox) {
                int value = this.getAMPM();
                this.fCalendar.set(10, this.getHour());
                this.fCalendar.set(9, value);
            } else {
                actionPerformed = false;
            }
            if (actionPerformed && this.fActionListener != null) {
                this.fActionListener.actionPerformed(e);
            }
        }
    }

    private boolean canFindIndex(String[] arr, String val) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(val)) continue;
            return true;
        }
        return false;
    }

    private int findIndex(String[] arr, String val, int defaultValue) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(val)) continue;
            return i;
        }
        return defaultValue;
    }

    public void setSelected(DayPanel day) {
        if (this.fCur != day) {
            this.fDayComboBox.setSelectedItem(day.getText());
            if (this.fCur != null) {
                this.fCur.unselect();
            }
            this.fCur = day;
            this.fCur.select();
        }
    }

    public void setDate(Date date) {
        this.fCalendar.setTime(date);
        this.loadGUI();
    }

    public Date getDate() {
        this.saveGUI();
        return this.fCalendar.getTime();
    }

    public long getTimeInMillis() {
        return this.fCalendar.getTime().getTime();
    }

    private class DayPanel
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = -1560651513697237263L;
        private Border emptyBorder;
        private Border lineBorder;

        public DayPanel() {
            super("??", 0);
            this.emptyBorder = new EmptyBorder(1, 1, 1, 1);
            this.lineBorder = new LineBorder(Color.black);
            this.addMouseListener(this);
            this.setBorder(this.emptyBorder);
        }

        public void select() {
            this.setBorder(this.lineBorder);
        }

        public void unselect() {
            this.setBorder(this.emptyBorder);
        }

        public void mouseClicked(MouseEvent e) {
            if (this.isEnabled() && !this.getText().equals("")) {
                CalendarPanel.this.setSelected(this);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

