/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef;

import com.wily.apm.spec.tess.beans.bizdefinition.BizObjectIDParam;
import com.wily.apm.spec.tess.beans.bizdefinition.IBizDefinitionLibrary;
import com.wily.apm.spec.tess.beans.bizdefinition.IBizDefinitionUpdatesRegistrationService;
import com.wily.apm.spec.tess.beans.bizdefinition.ITransactionComponentUpdatesCallback;
import com.wily.apm.spec.tess.beans.bizdefinition.SearchFilter;
import com.wily.apm.spec.tess.beans.bizdefinition.TransactionComponent;
import com.wily.apm.spec.tess.beans.bizdefinition.TransactionComponentUpdatesCallbackWrapper;
import com.wily.introscope.agent.CEMFilterHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizdef.BizParameterSetMap;
import com.wily.introscope.agent.bizdef.IBizOperationType;
import com.wily.introscope.agent.bizdef.IBizParameterSet;
import com.wily.introscope.agent.bizdef.IBizParameterType;
import com.wily.introscope.agent.bizdef.LazyBizParameterSetMap;
import com.wily.introscope.agent.bizdef.adt.CaseSensitiveMap;
import com.wily.introscope.agent.bizdef.constants.KBizConstants;
import com.wily.introscope.agent.bizdef.definition.BizTrxDef;
import com.wily.introscope.agent.bizdef.parameters.BizParameter;
import com.wily.introscope.agent.bizdef.patternDef.BizHttpRulePattern;
import com.wily.introscope.agent.bizdef.patternDef.BizRulePatternArraySet;
import com.wily.introscope.agent.bizdef.patternDef.BizRulePatternSet;
import com.wily.introscope.agent.bizdef.types.BizDefType;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.agent.external.biz.def.ExternalBizDefAdministrator;
import com.wily.introscope.agent.external.biz.util.HeaderExtractor;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.ITraceSupport;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.servlet.ServletParameterLoader;
import com.wily.introscope.agent.urlgroup.TomcatUtil;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.EnumConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class BizDefAdministrator
implements IBizDefSupportBean,
ITraceSupport {
    private static final String kValidParameterTypes = "QUERY,COOKIE,POST,HTTP,X_WTG_INFO,URL";
    private static final Module kModule = new Module("BizDef");
    private static final long kBizDefServiceTimeout = 15000L;
    private static final long kBizDefRegistrationRetryPeriod = 300000L;
    private static final long kBizDefRegistrationInitialRetry = 1000L;
    private static final long kBizDefRegistrationInitialDelay = 5000L;
    public static final String kBizDefListeningEnabled = "introscope.biz.def.listening.enabled";
    private static final String kBizDefMatchPostParams = "introscope.agent.bizdef.matchPost";
    private static final String kBizDefVetoedURIPostParams = "introscope.agent.bizdef.matchPost.vetoedURI";
    private static final String kGenerateDebugMetricsEnablingProperty = "introscope.agent.bizdef.matchPost.vetoedURI.generatemetrics";
    private static final String kBizDefVetoedURIPostParamsMaxNum = "introscope.agent.bizdef.matchPost.vetoedURI.max";
    private static final String kForceTurnOffNonIdentifyingTxnProperty = "introscope.agent.bizdef.turnOff.nonIdentifying.txn";
    private static final String kBizDefMatchPostNeverString = "never";
    private static final String kBizDefMatchPostBeforeString = "before";
    private static final String kBizDefMatchPostAfterString = "after";
    private static final String[] kBizDefMatchPostChoice = new String[]{"never", "before", "after"};
    private static final String SEGMENTSEPARATOR_REPLACEMENT_ENABLED_KEY = "introscope.biz.def.segmentseparator.replacement.enabled";
    private static Boolean segmentSeparatorReplacementEnabled = Boolean.TRUE;
    private static final String[] kBizDefMatchPostChoiceNewConfig = new String[]{"never", "before", "after"};
    private static final int kBizDefMatchPostNever = 0;
    private static final int kBizDefMatchPostBefore = 1;
    private static final int kBizDefMatchPostAfter = 2;
    private BizDefMatchPostConfigurationProperty fBizDefMatchPostProperty = null;
    private volatile int fBizDefMatchPostValue = 0;
    private String fLastPostParameterMessage = "";
    private static volatile boolean fRegisterSuccess = false;
    private volatile boolean isUsingOldConfig = false;
    private volatile boolean fIsUsingPostParams = false;
    protected static boolean fHasInitialized = false;
    private static final int kMapCount = 32;
    private static final int kMapBitField = 31;
    private static final Map[] sIdentifyingBizTrxsToRulePatternMap;
    private static final Map[] sRulePatternSetToIdentifyingBizTrxsMap;
    private static final Map[] sNonIdentifyingBizTrxsToRulePatternMap;
    private static final Map[] sRulePatternSetToNonIdentifyingBizTrxsMap;
    private static final boolean isDotNet;
    private static final String kJavaOnlyClassName = "java.lang.ref.Reference";
    private static BizRulePatternArraySet sRulePatternArraySetForIdentifyingComponents;
    private static BizRulePatternArraySet sRulePatternArraySetForNonIdentifyingComponents;
    private static String fAgentName;
    private static final AtomicReference fVetoedURI;
    private static final AtomicReference fVetoedURIPrefixes;
    private static volatile boolean fGenerateDebugMetrics;
    private static volatile int fMaxVetoedURI;
    private static volatile boolean fMaxVetoedURIWarningGiven;
    private static volatile boolean fForceTurnOffNonIdentifyingTxn;
    private final int bizDefLogLimit = 3;
    private int bizDefLogAttempt = 0;
    private ExternalBizDefAdministrator fExternalBizDefAdm;
    private IAgent fAgent = null;
    private IModuleFeedbackChannel fFeedback;
    private IStringLocalizer fLocalizer;
    private IBizDefinitionUpdatesRegistrationService fBizDefUpdatesRegService;
    private TransactionComponentUpdatesCallbackWrapper fTxCompUpdatesCallbackWrapper;
    private ITransactionComponentUpdatesCallback fTrxComponentCallbackHandler = new TransactionComponentUpdatesCallBackHandler();
    private String fBizDefinitionRegistrationID = null;

    static {
        sRulePatternArraySetForIdentifyingComponents = new BizRulePatternArraySet();
        sRulePatternArraySetForNonIdentifyingComponents = new BizRulePatternArraySet();
        fAgentName = null;
        fVetoedURI = new AtomicReference(new HashSet());
        fVetoedURIPrefixes = new AtomicReference(new LinkedList());
        fGenerateDebugMetrics = false;
        fMaxVetoedURI = 1000;
        fMaxVetoedURIWarningGiven = false;
        fForceTurnOffNonIdentifyingTxn = false;
        sIdentifyingBizTrxsToRulePatternMap = new Map[32];
        sNonIdentifyingBizTrxsToRulePatternMap = new Map[32];
        BizDefAdministrator.initializeBizTrxsToRulePattern();
        sRulePatternSetToIdentifyingBizTrxsMap = new Map[32];
        sRulePatternSetToNonIdentifyingBizTrxsMap = new Map[32];
        BizDefAdministrator.initializeRulePatternSetToBizTrxs();
        BizDefAdministrator.initializeRulePatternArraySet();
        boolean computeDotNet = true;
        try {
            computeDotNet = Class.forName(kJavaOnlyClassName) == null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            computeDotNet = true;
        }
        isDotNet = computeDotNet;
    }

    private static void initializeBizTrxsToRulePattern() {
        BizDefAdministrator.initializeBizTrxsToRulePattern(sIdentifyingBizTrxsToRulePatternMap);
        BizDefAdministrator.initializeBizTrxsToRulePattern(sNonIdentifyingBizTrxsToRulePatternMap);
    }

    private static void initializeBizTrxsToRulePattern(Map[] sBizTrxsToRulePatternMap) {
        int i = 0;
        while (i < 32) {
            sBizTrxsToRulePatternMap[i] = new HashMap();
            ++i;
        }
    }

    private static void initializeRulePatternSetToBizTrxs() {
        BizDefAdministrator.initializeRulePatternSetToBizTrxs(sRulePatternSetToIdentifyingBizTrxsMap);
        BizDefAdministrator.initializeRulePatternSetToBizTrxs(sRulePatternSetToNonIdentifyingBizTrxsMap);
    }

    private static void initializeRulePatternSetToBizTrxs(Map[] sRulePatternSetToBizTrxsMap) {
        int i = 0;
        while (i < 32) {
            sRulePatternSetToBizTrxsMap[i] = new HashMap();
            ++i;
        }
    }

    private static void initializeRulePatternArraySet() {
        sRulePatternArraySetForIdentifyingComponents = new BizRulePatternArraySet();
        sRulePatternArraySetForNonIdentifyingComponents = new BizRulePatternArraySet();
    }

    private BizDefAdministrator() {
    }

    static BizDefAdministrator getInstance() {
        return BizDefAdministratorInstancer.kInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setAgent(IAgent agent) {
        BizDefAdministrator bizDefAdministrator = BizDefAdministratorInstancer.kInstance;
        synchronized (bizDefAdministrator) {
            if (this.fAgent == null && agent != null) {
                this.fAgent = agent;
                this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
                this.fLocalizer = this.fAgent.IAgent_getStringLocalizer();
                this.registerServices();
                this.isUsingOldConfig = agent.IAgent_getComponentTracer().isAgentOldMode();
                this.fExternalBizDefAdm = new ExternalBizDefAdministrator(this.fAgent);
                if (this.isUsingOldConfig) {
                    this.fBizDefMatchPostProperty = new BizDefMatchPostConfigurationProperty(agent);
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)this.fBizDefMatchPostProperty, true);
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new BizDefVetoedURIMaxCountProperty(agent), true);
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new BizDefVetoedURIConfigurationProperty(agent), true);
                } else {
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new BizDefMatchPostConfigurationNewConfigProperty(agent), true);
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new BizDefVetoedURIConfigurationProperty(agent), true);
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new DoGeneratePostVetoedMetricsProperty(agent), true);
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new ForceTurnOffNonIdentifyingTxnProperty(agent), true);
                    agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new BizDefVetoedURIMaxCountProperty(agent), true);
                }
                segmentSeparatorReplacementEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(SEGMENTSEPARATOR_REPLACEMENT_ENABLED_KEY, Boolean.TRUE.booleanValue());
            }
        }
        return true;
    }

    public void registerServices() {
        IRegisteredBehavior behavior;
        WaitForConnectionRunnable target = new WaitForConnectionRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                IsengardServerConnectionManager manager = BizDefAdministrator.this.fAgent.IAgent_getIsengardServerConnection();
                if (manager != null && manager.getConnectedServer() != null && manager.getConnectedServer().isConnected()) {
                    if (!fHasInitialized) {
                        manager.addConnectionObserver(new IServerConnectionNotification(){

                            public void connectionUp() {
                                if (!fRegisterSuccess) {
                                    fRegisterSuccess = BizDefAdministrator.this.registerAgentToEM();
                                    if (fRegisterSuccess) {
                                        fRegisterSuccess = BizDefAdministrator.this.registerCallbacks();
                                    }
                                }
                                if (!fRegisterSuccess) {
                                    behaviorHandle.IRegisteredBehavior_setPeriod(300000L);
                                }
                            }

                            public void connectionDown() {
                                fRegisterSuccess = false;
                            }
                        });
                        manager.addNegotiatedNameChangeListener(new INameChangeListener(){

                            public void INameChangeListener_nameChanged(String newName) {
                                String[] tripletId = BizDefAdministrator.this.fAgent.IAgent_getHostProcessAgentTriplet();
                                String agentName = String.valueOf(tripletId[0]) + "|" + tripletId[1] + "|" + newName;
                                if (fRegisterSuccess && fAgentName != null && !fAgentName.equals(agentName)) {
                                    fRegisterSuccess = BizDefAdministrator.this.updateCallbacks(agentName);
                                }
                            }
                        });
                        fHasInitialized = true;
                    } else if (!fRegisterSuccess) {
                        fRegisterSuccess = BizDefAdministrator.this.registerAgentToEM();
                        if (fRegisterSuccess) {
                            fRegisterSuccess = BizDefAdministrator.this.registerCallbacks();
                        }
                    }
                }
            }
        };
        target.behaviorHandle = behavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)target, "Waiting for Business Defintion Updates", true, 1000L, System.currentTimeMillis() + 5000L);
    }

    public boolean registerAgentToEM() {
        block7: {
            try {
                String[] tripletId = this.fAgent.IAgent_getHostProcessAgentTriplet();
                String agentName = String.valueOf(tripletId[0]) + "|" + tripletId[1] + "|" + tripletId[2];
                SearchFilter a = this.getAgentFilter(agentName);
                SearchFilter b = this.getParamTypeFilter();
                SearchFilter[] filters = new SearchFilter[]{a, b};
                IBizDefinitionLibrary library = this.loadLibrary();
                TransactionComponent[] trxComponents = library.findComprehensiveTransactionComponents(filters);
                this.loadBusinessDefinitions(trxComponents);
                this.checkForPostParameters();
                this.fAgent.IAgent_getIsengardServerConnection().addConnectionObserver((IServerConnectionObserver)CEMFilterHelper.getInstance());
                return true;
            }
            catch (ServiceException se) {
                if (this.bizDefLogAttempt < 3) {
                    this.fFeedback.warn(KBizConstants.kBizDefModule, "Error occurred and could not register Business Definitions");
                    this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + se.getMessage(), (Throwable)se);
                }
            }
            catch (ConnectionException ce) {
                if (this.bizDefLogAttempt < 3) {
                    this.fFeedback.warn(KBizConstants.kBizDefModule, "Error occurred and could not register Business Definitions");
                    this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + ce.getMessage(), (Throwable)ce);
                }
            }
            catch (Exception e) {
                if (this.bizDefLogAttempt >= 3) break block7;
                this.fFeedback.warn(KBizConstants.kBizDefModule, "Error occurred and could not register Business Definitions");
                this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.bizDefLogAttempt < 3) {
            ++this.bizDefLogAttempt;
        }
        return false;
    }

    public boolean registerCallbacks() {
        try {
            String agentName;
            IsengardServerConnectionManager connectionManager = this.fAgent.IAgent_getIsengardServerConnection();
            PostOffice po = connectionManager.getPostOffice();
            Class<IBizDefinitionUpdatesRegistrationService> clazz = IBizDefinitionUpdatesRegistrationService.class;
            IBizDefinitionUpdatesRegistrationService fBizDefUpdatesRegService = (IBizDefinitionUpdatesRegistrationService)MessageServiceFactory.getService((PostOffice)po, clazz, (long)15000L);
            String[] tripletId = this.fAgent.IAgent_getHostProcessAgentTriplet();
            fAgentName = agentName = String.valueOf(tripletId[0]) + "|" + tripletId[1] + "|" + tripletId[2];
            SearchFilter a = this.getAgentFilter(agentName);
            SearchFilter b = this.getParamTypeFilter();
            SearchFilter[] filters = new SearchFilter[]{a, b};
            this.fTrxComponentCallbackHandler = new TransactionComponentUpdatesCallBackHandler();
            TransactionComponentUpdatesCallbackWrapper fTxCompUpdatesCallbackWrapper = new TransactionComponentUpdatesCallbackWrapper(po, this.fTrxComponentCallbackHandler);
            this.fBizDefinitionRegistrationID = fBizDefUpdatesRegService.registerForComprehensiveTCUpdates(fTxCompUpdatesCallbackWrapper, filters);
            return true;
        }
        catch (ServiceException se) {
            this.fFeedback.warn(KBizConstants.kBizDefModule, "Error occurred while registering Business Definition Updates Callback");
            this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + se.getMessage(), (Throwable)se);
        }
        catch (ConnectionException ce) {
            this.fFeedback.warn(KBizConstants.kBizDefModule, "Error occurred while registering Business Definition Updates Callback");
            this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + ce.getMessage(), (Throwable)ce);
        }
        catch (Exception e) {
            this.fFeedback.warn(KBizConstants.kBizDefModule, "Error occurred while registering Business Definition Updates Callback");
            this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private SearchFilter getParamTypeFilter() {
        return new SearchFilter("IDParamType", 0, 1, kValidParameterTypes);
    }

    private SearchFilter getAgentFilter(String agentName) {
        return new SearchFilter("agentName", 0, 1, agentName);
    }

    private SearchFilter getPrevAgentFilter(String agentName) {
        return new SearchFilter("prevAgentName", 0, 1, agentName);
    }

    public boolean updateCallbacks(String newAgentName) {
        try {
            IsengardServerConnectionManager connectionManager = this.fAgent.IAgent_getIsengardServerConnection();
            PostOffice po = connectionManager.getPostOffice();
            Class<IBizDefinitionUpdatesRegistrationService> clazz = IBizDefinitionUpdatesRegistrationService.class;
            IBizDefinitionUpdatesRegistrationService fBizDefUpdatesRegService = (IBizDefinitionUpdatesRegistrationService)MessageServiceFactory.getService((PostOffice)po, clazz, (long)15000L);
            SearchFilter a = this.getPrevAgentFilter(fAgentName);
            SearchFilter b = this.getAgentFilter(newAgentName);
            SearchFilter c = this.getParamTypeFilter();
            SearchFilter[] filters = new SearchFilter[]{a, b, c};
            fBizDefUpdatesRegService.updateTCSearchFilters(this.fBizDefinitionRegistrationID, filters);
            fAgentName = newAgentName;
            return true;
        }
        catch (ServiceException se) {
            this.fFeedback.error(KBizConstants.kBizDefModule, "Error occurred while registering Business Definition Updates Callback");
            this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + se.getMessage(), (Throwable)se);
        }
        catch (ConnectionException ce) {
            this.fFeedback.error(KBizConstants.kBizDefModule, "Error occurred while registering Business Definition Updates Callback");
            this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + ce.getMessage(), (Throwable)ce);
        }
        catch (Exception e) {
            this.fFeedback.error(KBizConstants.kBizDefModule, "Error occurred while registering Business Definition Updates Callback");
            this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to register Business Definitions: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean isPatternSetInitialized() {
        return sRulePatternArraySetForIdentifyingComponents.size() > 0 || sRulePatternArraySetForNonIdentifyingComponents.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBizTrxDef(BizRulePatternSet bizRulePatternSet, IBizTrx bizTrx) {
        Map map;
        int index = this.getIndex(bizRulePatternSet);
        Map[] mapToUse = null;
        if (bizTrx.isIdentifying()) {
            if (bizTrx.isResponseBased()) {
                return;
            }
            mapToUse = sRulePatternSetToIdentifyingBizTrxsMap;
        } else {
            mapToUse = sRulePatternSetToNonIdentifyingBizTrxsMap;
        }
        Map map2 = map = mapToUse[index];
        synchronized (map2) {
            map.put(bizRulePatternSet, bizTrx);
        }
    }

    public IBizTrx removeBizTrx(BizRulePatternSet bizRulePatternSet) {
        int index = this.getIndex(bizRulePatternSet);
        Map mapToUse = bizRulePatternSet.isIdentifying() ? sRulePatternSetToIdentifyingBizTrxsMap[index] : sRulePatternSetToNonIdentifyingBizTrxsMap[index];
        IBizTrx removedBizTrx = this.removeBizTrx(bizRulePatternSet, mapToUse);
        return removedBizTrx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBizTrx removeBizTrx(BizRulePatternSet bizRulePatternSet, Map map) {
        IBizTrx value = null;
        Map map2 = map;
        synchronized (map2) {
            value = (IBizTrx)map.remove(bizRulePatternSet);
        }
        return value;
    }

    private void clearBizTrxDef() {
        this.clearBizTrxDef(sRulePatternSetToIdentifyingBizTrxsMap);
        this.clearBizTrxDef(sRulePatternSetToNonIdentifyingBizTrxsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBizTrxDef(Map[] sRulePatternSetToBizTrxsMap) {
        int i = 0;
        while (i < sRulePatternSetToBizTrxsMap.length) {
            Map map = sRulePatternSetToBizTrxsMap[i];
            synchronized (map) {
                sRulePatternSetToBizTrxsMap[i].clear();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBizTrxDefToRulePatternSet(IBizTrx bizTrx, BizRulePatternSet bizRulePatternSet) {
        Map map;
        int index = this.getIndex(bizTrx);
        Map[] mapToUse = null;
        if (bizTrx.isIdentifying()) {
            if (bizTrx.isResponseBased()) {
                return;
            }
            mapToUse = sIdentifyingBizTrxsToRulePatternMap;
        } else {
            mapToUse = sNonIdentifyingBizTrxsToRulePatternMap;
        }
        Map map2 = map = mapToUse[index];
        synchronized (map2) {
            map.put(bizTrx, bizRulePatternSet);
        }
    }

    public void clearBizTrxDefToRulePatternSet() {
        this.clearBizTrxDefToRulePatternSet(sIdentifyingBizTrxsToRulePatternMap);
        this.clearBizTrxDefToRulePatternSet(sNonIdentifyingBizTrxsToRulePatternMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBizTrxDefToRulePatternSet(Map[] sBizTrxsToRulePatternMap) {
        int i = 0;
        while (i < sBizTrxsToRulePatternMap.length) {
            Map map = sBizTrxsToRulePatternMap[i];
            synchronized (map) {
                sBizTrxsToRulePatternMap[i].clear();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BizRulePatternSet getBizRulePatternSet(IBizTrx bizTrx) {
        int index = this.getIndex(bizTrx);
        Map[] mapToUse = null;
        if (bizTrx.isIdentifying()) {
            if (bizTrx.isResponseBased()) {
                return null;
            }
            mapToUse = sIdentifyingBizTrxsToRulePatternMap;
        } else {
            mapToUse = sNonIdentifyingBizTrxsToRulePatternMap;
        }
        Map map = mapToUse[index];
        BizRulePatternSet value = null;
        Map map2 = map;
        synchronized (map2) {
            value = (BizRulePatternSet)map.get(bizTrx);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BizRulePatternSet removeBizRulePatternSet(IBizTrx bizTrx) {
        int index = this.getIndex(bizTrx);
        Map[] mapToUse = null;
        if (bizTrx.isIdentifying()) {
            if (bizTrx.isResponseBased()) {
                return null;
            }
            mapToUse = sIdentifyingBizTrxsToRulePatternMap;
        } else {
            mapToUse = sNonIdentifyingBizTrxsToRulePatternMap;
        }
        Map map = mapToUse[index];
        BizRulePatternSet value = null;
        Map map2 = map;
        synchronized (map2) {
            value = (BizRulePatternSet)map.remove(bizTrx);
        }
        return value;
    }

    public void addRulePatternSet(BizRulePatternArraySet sRulePatternArraySet, BizRulePatternSet bizRulePatternSet) {
        sRulePatternArraySet.addPatternAtEnd(bizRulePatternSet);
    }

    public void removeRulePatternSet(BizRulePatternArraySet sRulePatternArraySet, BizRulePatternSet bizRulePatternSet) {
        sRulePatternArraySet.removePattern(bizRulePatternSet);
    }

    private IBizTrx computeBizTrx(TransactionComponent trxComponent) {
        BizTrxDef bizTrxDef = null;
        if (trxComponent != null) {
            bizTrxDef = new BizTrxDef(trxComponent.getId(), trxComponent.getBusinessProcessName(), trxComponent.getBusinessTransactionName(), trxComponent.getTransactionComponentName(), trxComponent.getIsIdentifying(), trxComponent.getIsResponseBased());
            if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                this.fFeedback.verbose(KBizConstants.kBizDefModule, "Registered Business Transaction Component...");
                this.fFeedback.verbose(KBizConstants.kBizDefModule, "Business Transaction Definition consists of Business Transaction Component = " + bizTrxDef.getBizFullDescriptionName());
            }
        } else if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
            this.fFeedback.verbose(KBizConstants.kBizDefModule, "Unable to Register Business Transaction Component not defined...");
        }
        return bizTrxDef;
    }

    private BizRulePatternSet computeBizRulePatternSet(TransactionComponent trxComponent) {
        BizObjectIDParam[] params = trxComponent.getIdParams();
        BizRulePatternSet rulePatternSet = new BizRulePatternSet(trxComponent);
        if (params != null) {
            int j = 0;
            while (j < params.length) {
                BizObjectIDParam param = params[j];
                String patternName = param.getName();
                String patternValue = param.getPattern();
                String patternType = param.getType();
                boolean caseSensitiveName = param.isNameCaseSensitive();
                boolean caseSensitiveValue = param.isValueCaseSensitive();
                BizDefType type = null;
                type = patternType.equals("URL") ? (patternName.equals("Path") ? BizDefType.getInstance("PATH") : (patternName.equals("Host") ? BizDefType.getInstance("HOST") : BizDefType.getInstance("PORT"))) : (patternType.equals("COOKIE") ? BizDefType.getInstance("COOKIE") : (patternType.equals("POST") ? BizDefType.getInstance("POST") : (patternType.equals("QUERY") ? BizDefType.getInstance("QUERY") : (patternType.equals("HTTP") ? BizDefType.getInstance("HTTP") : (patternType.equals("X_WTG_INFO") ? BizDefType.getInstance("XWTG") : BizDefType.getInstance(patternType))))));
                int actionType = param.getAction();
                int nameType = param.getNameType();
                IBizOperationType op = null;
                op = actionType == 1 ? KBizConstants.kBizSimpleMatchOperationType : (actionType == 2 ? KBizConstants.kBizNameNotExistsOperationType : (actionType == 3 ? KBizConstants.kBizRegexValueOperationType : KBizConstants.kBizUndefinedOperationType));
                IBizOperationType nameTypeOp = null;
                nameTypeOp = nameType == 0 ? KBizConstants.kBizLiteralNameOperationType : (nameType == 1 ? KBizConstants.kBizRegexNameOperationType : (nameType == 3 ? KBizConstants.kBizRegexNameOperationType : KBizConstants.kBizUndefinedOperationType));
                BizHttpRulePattern rulePattern = new BizHttpRulePattern(patternName, type, patternValue, op, nameTypeOp, caseSensitiveName, caseSensitiveValue);
                if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, "Found the following parameter rules...");
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, "Pattern Name = " + patternName + ", Pattern Value = " + patternValue + ", Type value = " + ((Object)type).toString() + ", NameType Operation value = " + nameTypeOp.toString() + ", Action Operation value = " + op.toString() + ", Case Sensitivity for Pattern Name = " + caseSensitiveName + ", Case Sensitivity for Pattern Value = " + caseSensitiveValue);
                }
                rulePatternSet.addPatternAtEnd(rulePattern);
                ++j;
            }
        }
        return rulePatternSet;
    }

    private void loadBusinessDefinitions(TransactionComponent[] trxComponents) throws ConnectionException {
        block5: {
            this.clearBizTrxDef();
            this.clearBizTrxDefToRulePatternSet();
            BizDefAdministrator.initializeRulePatternArraySet();
            if (trxComponents == null) break block5;
            int i = 0;
            while (i < trxComponents.length) {
                block8: {
                    block6: {
                        BizRulePatternArraySet rulePatternSetArrayToUse;
                        BizRulePatternSet rulePatternSet;
                        IBizTrx bizTrxDef;
                        block9: {
                            block7: {
                                TransactionComponent trxComponent = trxComponents[i];
                                bizTrxDef = this.computeBizTrx(trxComponent);
                                rulePatternSet = this.computeBizRulePatternSet(trxComponent);
                                if (bizTrxDef == null || rulePatternSet.getLength() <= 0) break block6;
                                if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                                    this.fFeedback.verbose(KBizConstants.kBizDefModule, "Adding Business Rule Set and Business Transaction to matching set #" + bizTrxDef.getBizFullName() + " isIdentifying  is## " + bizTrxDef.isIdentifying() + " isResponseBased is## " + bizTrxDef.isResponseBased());
                                }
                                boolean isIdentifying = trxComponent.getIsIdentifying();
                                rulePatternSetArrayToUse = null;
                                if (!isIdentifying) break block7;
                                if (trxComponent.getIsResponseBased().booleanValue()) break block8;
                                rulePatternSetArrayToUse = sRulePatternArraySetForIdentifyingComponents;
                                break block9;
                            }
                            rulePatternSetArrayToUse = sRulePatternArraySetForNonIdentifyingComponents;
                        }
                        if (!rulePatternSetArrayToUse.contains(rulePatternSet)) {
                            this.addRulePatternSet(rulePatternSetArrayToUse, rulePatternSet);
                        }
                        if (rulePatternSet.containsPostParameters()) {
                            ((BizTrxDef)bizTrxDef).setPostParams();
                        }
                        this.addBizTrxDef(rulePatternSet, bizTrxDef);
                        this.addBizTrxDefToRulePatternSet(bizTrxDef, rulePatternSet);
                        break block8;
                    }
                    if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, "Failed to add Business Rule Set and Business Transaction to matching set");
                    }
                }
                ++i;
            }
        }
    }

    private void updateBusinessDefinitions(TransactionComponent[] trxComponents) throws ConnectionException {
        block8: {
            if (trxComponents == null) break block8;
            int i = 0;
            while (i < trxComponents.length) {
                block11: {
                    block9: {
                        BizRulePatternArraySet rulePatternArraySetToUse;
                        BizRulePatternSet oldRulePatternSet;
                        BizRulePatternSet rulePatternSet;
                        IBizTrx bizTrxDef;
                        block12: {
                            block10: {
                                TransactionComponent trxComponent = trxComponents[i];
                                bizTrxDef = this.computeBizTrx(trxComponent);
                                rulePatternSet = this.computeBizRulePatternSet(trxComponent);
                                if (bizTrxDef == null || rulePatternSet.getLength() <= 0) break block9;
                                if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                                    this.fFeedback.verbose(KBizConstants.kBizDefModule, "Updating Business Rule Set and Business Transaction to matching set");
                                }
                                oldRulePatternSet = this.getBizRulePatternSet(bizTrxDef);
                                boolean isIdentifying = trxComponent.getIsIdentifying();
                                rulePatternArraySetToUse = null;
                                if (!isIdentifying) break block10;
                                if (trxComponent.getIsResponseBased().booleanValue()) break block11;
                                rulePatternArraySetToUse = sRulePatternArraySetForIdentifyingComponents;
                                break block12;
                            }
                            rulePatternArraySetToUse = sRulePatternArraySetForNonIdentifyingComponents;
                        }
                        if (rulePatternArraySetToUse.contains(oldRulePatternSet)) {
                            this.removeRulePatternSet(rulePatternArraySetToUse, oldRulePatternSet);
                        }
                        this.removeBizRulePatternSet(bizTrxDef);
                        if (oldRulePatternSet != null) {
                            this.removeBizTrx(oldRulePatternSet);
                        }
                        if (!rulePatternArraySetToUse.contains(rulePatternSet)) {
                            this.addRulePatternSet(rulePatternArraySetToUse, rulePatternSet);
                        }
                        if (rulePatternSet.containsPostParameters()) {
                            ((BizTrxDef)bizTrxDef).setPostParams();
                        }
                        this.addBizTrxDef(rulePatternSet, bizTrxDef);
                        this.addBizTrxDefToRulePatternSet(bizTrxDef, rulePatternSet);
                        if (!this.fAgent.IAgent_getComponentTracer().isAgentOldMode()) {
                            WilyTransactionStructure.getInstance().ageBizTrxDataImmediately(bizTrxDef.getId());
                        }
                        break block11;
                    }
                    if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, "Failed to update Business Rule Set and Business Transaction to matching set");
                    }
                }
                ++i;
            }
        }
    }

    private void removeBusinessDefinitions(TransactionComponent[] trxComponents) throws ConnectionException {
        block9: {
            if (trxComponents == null) break block9;
            int i = 0;
            while (i < trxComponents.length) {
                block11: {
                    BizRulePatternArraySet rulePatternSetArrayToUse;
                    BizRulePatternSet rulePatternSet;
                    IBizTrx bizTrxDef;
                    block12: {
                        block10: {
                            TransactionComponent trxComponent = trxComponents[i];
                            bizTrxDef = this.computeBizTrx(trxComponent);
                            rulePatternSet = null;
                            boolean isIdentifying = trxComponent.getIsIdentifying();
                            rulePatternSetArrayToUse = null;
                            if (!isIdentifying) break block10;
                            if (trxComponent.getIsResponseBased().booleanValue()) break block11;
                            rulePatternSetArrayToUse = sRulePatternArraySetForIdentifyingComponents;
                            break block12;
                        }
                        rulePatternSetArrayToUse = sRulePatternArraySetForNonIdentifyingComponents;
                    }
                    if (bizTrxDef != null) {
                        if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, "Removing Business Rule Set and Business Transaction to matching set");
                        }
                        if ((rulePatternSet = this.getBizRulePatternSet(bizTrxDef)) == null) {
                            this.fFeedback.error(KBizConstants.kBizDefModule, "Cannot remove Business rule Set, because it does not exist. Component = " + bizTrxDef.getBizFullName());
                        } else {
                            if (rulePatternSetArrayToUse.contains(rulePatternSet)) {
                                this.removeRulePatternSet(rulePatternSetArrayToUse, rulePatternSet);
                            }
                            this.removeBizTrx(rulePatternSet);
                            this.removeBizRulePatternSet(bizTrxDef);
                            if (!this.fAgent.IAgent_getComponentTracer().isAgentOldMode()) {
                                WilyTransactionStructure.getInstance().ageBizTrxDataImmediately(bizTrxDef.getId());
                            }
                        }
                    } else if (this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule)) {
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, "Failed to remove Business Rule Set and Business Transaction to matching set");
                    }
                }
                ++i;
            }
        }
    }

    private IBizDefinitionLibrary loadLibrary() throws ServiceException, ConnectionException {
        IsengardServerConnectionManager connectionManager = this.fAgent.IAgent_getIsengardServerConnection();
        PostOffice po = connectionManager.getPostOffice();
        Class<IBizDefinitionLibrary> clazz = IBizDefinitionLibrary.class;
        IBizDefinitionLibrary bizDefLib = (IBizDefinitionLibrary)MessageServiceFactory.getService((PostOffice)po, clazz, (long)15000L);
        return bizDefLib;
    }

    private IBizTrx getBizTrxDef(IBizParameterSet bizParameterSet, int postFlag, boolean isVerbose, InvocationData invocationData) throws Exception {
        if (sRulePatternArraySetForIdentifyingComponents.size() == 0 && sRulePatternArraySetForNonIdentifyingComponents.size() == 0) {
            throw new Exception("Parameter Array Set needs to be initialized with Rule Sets");
        }
        BizRulePatternSet patternSet = sRulePatternArraySetForIdentifyingComponents.matches(bizParameterSet, this.fFeedback, postFlag, isVerbose, fForceTurnOffNonIdentifyingTxn);
        return this.getBizTrxDef(bizParameterSet, patternSet, invocationData, postFlag, isVerbose);
    }

    private IBizTrx getBizTrxDef(IBizParameterSet bizParameterSet, BizRulePatternSet bizRulePatternSet, InvocationData invocationData, int postFlag, boolean isVerbose) throws Exception {
        IBizTrx returnValue;
        boolean isTraceRequestedForIdentifying = false;
        boolean bizTxnDataForTraceAlreadySet = false;
        IBizTrx bizTrxInIdentifyingStructure = null;
        IBizTrx bizNonIdentifyingTrxDef = null;
        int index = -1;
        if (bizRulePatternSet != null) {
            index = this.getIndex(bizRulePatternSet);
            bizTrxInIdentifyingStructure = this.getBizTrxDef(bizRulePatternSet, sRulePatternSetToIdentifyingBizTrxsMap, index);
            if (!fForceTurnOffNonIdentifyingTxn) {
                boolean bl = isTraceRequestedForIdentifying = bizTrxInIdentifyingStructure == null ? false : CEMFilterHelper.getInstance().isTraceRequestedFor(bizTrxInIdentifyingStructure.getBizTrxName());
            }
        }
        if (!(fForceTurnOffNonIdentifyingTxn || bizTrxInIdentifyingStructure != null && isTraceRequestedForIdentifying || (bizRulePatternSet = sRulePatternArraySetForNonIdentifyingComponents.matches(bizParameterSet, this.fFeedback, postFlag, isVerbose, fForceTurnOffNonIdentifyingTxn)) == null || (bizNonIdentifyingTrxDef = this.getBizTrxDef(bizRulePatternSet, sRulePatternSetToNonIdentifyingBizTrxsMap, index = this.getIndex(bizRulePatternSet))) == null || isTraceRequestedForIdentifying || !CEMFilterHelper.getInstance().isTraceRequestedFor(bizNonIdentifyingTrxDef.getBizTrxName()))) {
            if (bizTrxInIdentifyingStructure != null) {
                this.fFeedback.debug("Matched identifying txn business definition " + bizTrxInIdentifyingStructure.getBizFullName() + " As transaction trace filter is not set for identifying component, sending trace by matching with non-identifying transaction #" + bizNonIdentifyingTrxDef.getBizFullName());
            }
            bizTxnDataForTraceAlreadySet = true;
        }
        IBizTrx iBizTrx = returnValue = bizTrxInIdentifyingStructure != null ? bizTrxInIdentifyingStructure : bizNonIdentifyingTrxDef;
        if (returnValue == null || returnValue.isIdentifying()) {
            // empty if block
        }
        if (returnValue != null) {
            this.fFeedback.debug("Found business transaction definition as " + returnValue.getBizFullName() + " isIdentifying  is## " + returnValue.isIdentifying() + " isResponseBased is## " + returnValue.isResponseBased());
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBizTrx getBizTrxDef(BizRulePatternSet bizRulePatternSet, Map[] sRulePatternSetBizTrxsMap, int index) {
        Map map = sRulePatternSetBizTrxsMap[index];
        IBizTrx bizTrx = null;
        Map map2 = map;
        synchronized (map2) {
            bizTrx = (IBizTrx)map.get(bizRulePatternSet);
        }
        return bizTrx;
    }

    private int getIndex(Object key) {
        return key.hashCode() & 0x1F;
    }

    protected BizParameterSetMap buildBizHttpParameterSet(Map params, boolean isVerboseEnabled) throws UnsupportedEncodingException {
        if (params != null && params.size() > 0) {
            if (isVerboseEnabled) {
                this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Building_BizCentricMetrics"));
            }
            BizParameterSetMap bizParameterSet = new BizParameterSetMap();
            for (Map.Entry entry : params.entrySet()) {
                BizParameter parameter;
                BizDefType type;
                if (!(entry.getKey() instanceof String)) continue;
                if (entry.getKey().equals("URL")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("PATH");
                        parameter = new BizParameter("Path", (String)entry.getValue(), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("Server Name")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("HOST");
                        parameter = new BizParameter("Host", (String)entry.getValue(), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("Server Port")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("PORT");
                        parameter = new BizParameter("Port", (String)entry.getValue(), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("URL Query")) {
                    if (entry.getValue() != null) {
                        HashMap queryMap = new HashMap();
                        TomcatUtil.parseParameters(queryMap, (String)((String)entry.getValue()), (String)"US-ASCII");
                        BizDefType type2 = BizDefType.getInstance("QUERY");
                        BizParameter parameter2 = new BizParameter(null, CaseSensitiveMap.getInstance(queryMap), (IBizParameterType)type2);
                        bizParameterSet.put(type2, parameter2);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter2).toString());
                        }
                    }
                } else if (entry.getKey().equals("introscope.agent.HttpServletTracer.postParameters")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("POST");
                        parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("introscope.agent.HttpServletTracer.cookieParameters")) {
                    type = BizDefType.getInstance("COOKIE");
                    parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                    bizParameterSet.put(type, parameter);
                    if (isVerboseEnabled) {
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                    }
                }
                if (entry.getKey().equals("introscope.agent.HttpServletTracer.headerParameters")) {
                    type = BizDefType.getInstance("HTTP");
                    parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                    bizParameterSet.put(type, parameter);
                    if (isVerboseEnabled) {
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                    }
                }
                if (!entry.getKey().equals("XWTG")) continue;
                type = BizDefType.getInstance("XWTG");
                parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                bizParameterSet.put(type, parameter);
                if (!isVerboseEnabled) continue;
                this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
            }
            if (bizParameterSet.isEmpty()) {
                return null;
            }
            return bizParameterSet;
        }
        return null;
    }

    protected BizParameterSetMap buildLazyBizHttpParameterSet(Map params, boolean isVerboseEnabled) throws UnsupportedEncodingException {
        if (params != null && params.size() > 0) {
            if (isVerboseEnabled) {
                this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Building_BizCentricMetrics"));
            }
            BizParameterSetMap bizParameterSet = new BizParameterSetMap();
            for (Map.Entry entry : params.entrySet()) {
                BizParameter parameter;
                BizDefType type;
                if (!(entry.getKey() instanceof String)) continue;
                if (entry.getKey().equals("URL")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("PATH");
                        parameter = new BizParameter("Path", (String)entry.getValue(), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("Server Name")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("HOST");
                        parameter = new BizParameter("Host", (String)entry.getValue(), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("Server Port")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("PORT");
                        parameter = new BizParameter("Port", (String)entry.getValue(), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("URL Query")) {
                    if (entry.getValue() != null) {
                        HashMap queryMap = new HashMap();
                        TomcatUtil.parseParameters(queryMap, (String)((String)entry.getValue()), (String)"US-ASCII");
                        BizDefType type2 = BizDefType.getInstance("QUERY");
                        BizParameter parameter2 = new BizParameter(null, CaseSensitiveMap.getInstance(queryMap), (IBizParameterType)type2);
                        bizParameterSet.put(type2, parameter2);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter2).toString());
                        }
                    }
                } else if (entry.getKey().equals("introscope.agent.HttpServletTracer.postParameters")) {
                    if (entry.getValue() != null) {
                        type = BizDefType.getInstance("POST");
                        parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                        bizParameterSet.put(type, parameter);
                        if (isVerboseEnabled) {
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                            this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                        }
                    }
                } else if (entry.getKey().equals("introscope.agent.HttpServletTracer.cookieParameters")) {
                    type = BizDefType.getInstance("COOKIE");
                    parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                    bizParameterSet.put(type, parameter);
                    if (isVerboseEnabled) {
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                    }
                }
                if (entry.getKey().equals("introscope.agent.HttpServletTracer.headerParameters")) {
                    type = BizDefType.getInstance("HTTP");
                    parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                    bizParameterSet.put(type, parameter);
                    if (isVerboseEnabled) {
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                        this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                    }
                }
                if (!entry.getKey().equals("XWTG")) continue;
                type = BizDefType.getInstance("XWTG");
                parameter = new BizParameter(null, CaseSensitiveMap.getInstance((Map)entry.getValue()), (IBizParameterType)type);
                bizParameterSet.put(type, parameter);
                if (!isVerboseEnabled) continue;
                this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
            }
            if (bizParameterSet.isEmpty()) {
                return null;
            }
            return bizParameterSet;
        }
        return null;
    }

    private void checkForPostParameters() {
        int policy = this.fBizDefMatchPostValue;
        if (sRulePatternArraySetForIdentifyingComponents.containsPostPattern() || sRulePatternArraySetForNonIdentifyingComponents.containsPostPattern()) {
            this.fIsUsingPostParams = true;
            if (policy == 1) {
                if (!this.fLastPostParameterMessage.equals("BizDef_Info_PostMatchBefore")) {
                    this.fFeedback.info(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Info_PostMatchBefore"));
                }
                this.fLastPostParameterMessage = "BizDef_Info_PostMatchBefore";
            }
            if (policy == 2) {
                if (!this.fLastPostParameterMessage.equals("BizDef_Info_PostMatchAfter")) {
                    this.fFeedback.info(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Info_PostMatchAfter"));
                }
                this.fLastPostParameterMessage = "BizDef_Info_PostMatchAfter";
            }
            if (policy == 0) {
                if (!this.fLastPostParameterMessage.equals("BizDef_Warn_PostMatchNever")) {
                    this.fFeedback.warn(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Warn_PostMatchNever"));
                }
                this.fLastPostParameterMessage = "BizDef_Warn_PostMatchNever";
            }
        } else {
            this.fIsUsingPostParams = false;
        }
    }

    public IBizTrx getBusinessTransactionComponent(Object invocationData, boolean isStartTrace) {
        IBizTrx result;
        block27: {
            Map<Object, Object> valueMap;
            IBizParameterSet bizParams;
            int postFlag;
            Map httpParams;
            boolean isVerboseEnabled;
            InvocationData data;
            block28: {
                data = null;
                if (invocationData instanceof InvocationData) {
                    data = (InvocationData)invocationData;
                }
                if (data == null) {
                    return null;
                }
                if (!this.isPatternSetInitialized() && (!this.fExternalBizDefAdm.isExternalbtFeatureOn() || this.isUsingOldConfig || isDotNet)) {
                    return null;
                }
                result = null;
                Boolean bizDefIdentified = (Boolean)data.get("introscope.agent.bizDefIdentified");
                if (bizDefIdentified != null && (isStartTrace || bizDefIdentified.booleanValue())) {
                    result = (IBizTrx)data.get("BusinessTrxData");
                    break block27;
                }
                isVerboseEnabled = this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule);
                int postPolicy = this.fBizDefMatchPostValue;
                httpParams = null;
                if (this.isUsingOldConfig || isDotNet) {
                    httpParams = new HashMap();
                    ServletParameterLoader loader = new ServletParameterLoader(this.fAgent, this.fFeedback, "BizTrxTracer", httpParams);
                    loader.setLoadExtraParams(true);
                    if (isStartTrace && postPolicy == 1 || !isStartTrace && postPolicy != 0) {
                        loader.setLoadPostParams(true);
                    }
                    loader.executeSafe(data);
                } else {
                    httpParams = data.getServletParameterMap();
                }
                String method = (String)httpParams.get("HTTP Method");
                postFlag = 1;
                if (method != null && method.equals("POST")) {
                    postFlag = isStartTrace ? (postPolicy == 2 ? 2 : (postPolicy == 1 ? 0 : 1)) : (postPolicy == 0 ? 1 : 0);
                }
                bizParams = null;
                bizParams = this.isUsingOldConfig ? this.buildBizHttpParameterSet(httpParams, isVerboseEnabled) : new LazyBizParameterSetMap(this, httpParams, this.fAgent);
                data.put("introscope.agent.bizHttpParamSet", (Object)bizParams);
                Boolean isEbtRun = false;
                valueMap = new HashMap();
                if (this.fExternalBizDefAdm.isExternalbtFeatureOn() && !this.isUsingOldConfig && !isDotNet) {
                    String header = null;
                    header = (String)httpParams.get("x-apm-bt");
                    if (header != null && !"".equals(header)) {
                        isEbtRun = true;
                        valueMap = HeaderExtractor.extractHeaderFields(header);
                        if (this.fFeedback.isDebugEnabled(KBizConstants.kBizDefModule)) {
                            this.fFeedback.debug("Invoking External Business Transaction Match");
                        }
                        if ((result = this.fExternalBizDefAdm.getEbtTrxDef(valueMap)) != null) {
                            data.put("introscope.agent.bizDefIdentified", (Object)Boolean.TRUE);
                            data.put("BusinessTrxData", (Object)result);
                            BTThreadLocalAdministrator.getInstance().insert("BusinessTrxData", (Object)result);
                            data.put("BusinessTrxDataUsedForSendingTrace", (Object)result);
                            data.put("x-apm-bt", valueMap);
                            this.fExternalBizDefAdm.addEbtProperties(valueMap, data);
                        } else {
                            data.put("introscope.agent.bizDefIdentified", (Object)Boolean.TRUE);
                            data.put("BusinessTrxData", null);
                        }
                    }
                }
                if (isEbtRun.booleanValue()) break block27;
                if (this.isPatternSetInitialized()) break block28;
                return null;
            }
            try {
                IBizTrx iBizTrx = result = bizParams == null ? null : this.getBizTrxDef(bizParams, postFlag, isVerboseEnabled, data);
                if (result != null) {
                    if (postFlag == 2 && result.containsPostParams()) {
                        data.put("introscope.agent.bizDefIdentified", (Object)Boolean.FALSE);
                        result = null;
                    } else {
                        if (this.fExternalBizDefAdm.isBRTMFeatureOn()) {
                            Map cookieMap = (Map)httpParams.get("introscope.agent.HttpServletTracer.cookieParameters");
                            String browserType = null;
                            String browserVersion = null;
                            if (cookieMap != null && cookieMap.get("x-apm-brtm-bt-p") != null && cookieMap.get("x-apm-brtm-bt-pv") != null) {
                                browserType = URLDecoder.decode(cookieMap.get("x-apm-brtm-bt-p").toString(), "UTF-8");
                                browserVersion = URLDecoder.decode(cookieMap.get("x-apm-brtm-bt-pv").toString(), "UTF-8");
                                if (this.fFeedback.isTraceEnabled()) {
                                    this.fFeedback.trace("Browser agent cookie is found.");
                                }
                            } else {
                                browserType = BTThreadLocalAdministrator.getInstance().getString("p");
                                browserVersion = BTThreadLocalAdministrator.getInstance().getString("pv");
                                if (this.fFeedback.isTraceEnabled()) {
                                    this.fFeedback.trace("Browser agent cookie is not found.");
                                }
                            }
                            if (browserType != null && browserVersion != null) {
                                valueMap.put("p", browserType);
                                valueMap.put("pv", browserVersion);
                            }
                            long cemID = result.getId();
                            String bs = result.getBizProcessName();
                            String bt = result.getBizTrxName();
                            String btc = result.getBizTrxComponentName();
                            result = this.fExternalBizDefAdm.getBRTMTrxDef(result, valueMap);
                            valueMap.put("CEM_ID", String.valueOf(cemID));
                            valueMap.put("bs", bs);
                            valueMap.put("bt", bt);
                            valueMap.put("btc", btc);
                            data.put("x-apm-bt", valueMap);
                        }
                        data.put("introscope.agent.bizDefIdentified", (Object)Boolean.TRUE);
                        data.put("BusinessTrxData", (Object)result);
                        data.put("BusinessTrxDataUsedForSendingTrace", (Object)result);
                        if (this.fExternalBizDefAdm.isBRTMFeatureOn()) {
                            BTThreadLocalAdministrator.getInstance().insert("BusinessTrxData", (Object)result);
                        }
                    }
                } else {
                    data.put("introscope.agent.bizDefIdentified", (Object)Boolean.TRUE);
                    data.put("BusinessTrxData", null);
                }
            }
            catch (Throwable t) {
                this.fFeedback.error(KBizConstants.kBizDefModule, "Error occured while matching Business Definitions");
                this.fFeedback.debug(KBizConstants.kBizDefModule, "Unable to match Business Definitions: ", t);
            }
        }
        return result;
    }

    private boolean isVetoedPostURIByPrefix(String uriString) {
        List list = (List)fVetoedURIPrefixes.get();
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            if (!uriString.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean isVetoedPostURI(Object servletURI) {
        if (!this.fIsUsingPostParams || this.fBizDefMatchPostValue != 1) {
            return false;
        }
        String uriString = servletURI.toString();
        if (this.isVetoedPostURIByPrefix(uriString)) {
            return true;
        }
        Set localHandle = (Set)fVetoedURI.get();
        return localHandle.contains(uriString);
    }

    public boolean addVetoedPostURI(Object Uri) {
        if (!this.fIsUsingPostParams || this.fBizDefMatchPostValue != 1) {
            return false;
        }
        String uriString = Uri.toString();
        if (this.isVetoedPostURIByPrefix(uriString)) {
            return false;
        }
        return this.addVetoedPostURIOnRecursion(uriString);
    }

    private boolean addVetoedPostURIOnRecursion(String servletURI) {
        Set localHandle = (Set)fVetoedURI.get();
        if (localHandle.contains(servletURI)) {
            return false;
        }
        if (localHandle.size() > fMaxVetoedURI) {
            if (!fMaxVetoedURIWarningGiven) {
                fMaxVetoedURIWarningGiven = true;
                this.fFeedback.warn(KBizConstants.kBizDefModule, "Agent has noticed too many URLs that cannot be processed for POST parameters. Please review your configuration.");
            }
            return false;
        }
        HashSet<String> newSet = new HashSet<String>();
        newSet.addAll(localHandle);
        newSet.add(servletURI);
        if (!fVetoedURI.compareAndSet(localHandle, newSet)) {
            return this.addVetoedPostURI(servletURI);
        }
        if (fGenerateDebugMetrics) {
            IStringEveryEventDataAccumulator acc = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Post Safeguards:Vetoed URI for Post");
            acc.IStringEveryEventDataAccumulator_addString(fVetoedURI.get().toString());
        }
        return true;
    }

    public static Boolean isSegmentSeparatorReplacementEnabled() {
        return segmentSeparatorReplacementEnabled;
    }

    /* synthetic */ BizDefAdministrator(BizDefAdministrator bizDefAdministrator) {
        this();
    }

    private static final class BizDefAdministratorInstancer {
        public static final BizDefAdministrator kInstance = new BizDefAdministrator(null);

        private BizDefAdministratorInstancer() {
        }
    }

    private final class BizDefMatchPostConfigurationNewConfigProperty
    extends EnumConfigurationProperty {
        int value;

        private BizDefMatchPostConfigurationNewConfigProperty(IAgent agent) {
            super(BizDefAdministrator.kBizDefMatchPostParams, Integer.valueOf(1), kBizDefMatchPostChoiceNewConfig, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            int value = (Integer)newValue;
            if (value == 2) {
                BizDefAdministrator.this.fAgent.IAgent_getModuleFeedback().info("The parameter after is not allowed for the match post configuration in new mode. It is going to be modified to the value 'before'");
                value = 1;
            }
            BizDefAdministrator.this.fBizDefMatchPostValue = value;
            BizDefAdministrator.this.checkForPostParameters();
        }
    }

    private final class BizDefMatchPostConfigurationProperty
    extends EnumConfigurationProperty {
        private BizDefMatchPostConfigurationProperty(IAgent agent) {
            super(BizDefAdministrator.kBizDefMatchPostParams, Integer.valueOf(2), kBizDefMatchPostChoice, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public int getPostMatchPolicy() {
            return BizDefAdministrator.this.fBizDefMatchPostValue;
        }

        public void set(Object newValue) {
            BizDefAdministrator.this.fBizDefMatchPostValue = (Integer)newValue;
            BizDefAdministrator.this.checkForPostParameters();
        }
    }

    private static final class BizDefVetoedURIConfigurationProperty
    extends StringSetConfigurationProperty {
        public BizDefVetoedURIConfigurationProperty(IAgent agent) {
            this(BizDefAdministrator.kBizDefVetoedURIPostParams, new HashSet(), "Hot_Property_Configuration_Property", null, true, true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        private BizDefVetoedURIConfigurationProperty(String name, Set defaultValue, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, descriptionKey, unitsKey, isHot, isNullValid, feedback, module, localizer);
        }

        public final void set(Object value) {
            if (value != null) {
                String[] values = ((Set)value).toArray(new String[0]);
                LinkedList<String> prefixList = new LinkedList<String>();
                HashSet<String> fixedSet = new HashSet<String>();
                int i = 0;
                while (i < values.length) {
                    if (values[i].endsWith("*")) {
                        String prefix = values[i].substring(0, values[i].length() - 1);
                        prefixList.add(prefix);
                    } else {
                        fixedSet.add(values[i]);
                    }
                    ++i;
                }
                fVetoedURIPrefixes.set(prefixList);
                boolean done = false;
                while (!done) {
                    HashSet oldSet = (HashSet)fVetoedURI.get();
                    HashSet<String> newSet = new HashSet<String>(oldSet);
                    newSet.addAll(fixedSet);
                    done = fVetoedURI.compareAndSet(oldSet, newSet);
                }
            }
        }
    }

    static final class BizDefVetoedURIMaxCountProperty
    extends IntegerConfigurationProperty {
        private BizDefVetoedURIMaxCountProperty(IAgent agent) {
            super(BizDefAdministrator.kBizDefVetoedURIPostParamsMaxNum, Integer.valueOf(1000), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fMaxVetoedURI = (Integer)newValue;
            fMaxVetoedURIWarningGiven = false;
        }
    }

    static final class DoGeneratePostVetoedMetricsProperty
    extends BooleanConfigurationProperty {
        private DoGeneratePostVetoedMetricsProperty(IAgent agent) {
            super(BizDefAdministrator.kGenerateDebugMetricsEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fGenerateDebugMetrics = (Boolean)newValue;
        }
    }

    static final class ForceTurnOffNonIdentifyingTxnProperty
    extends BooleanConfigurationProperty {
        private ForceTurnOffNonIdentifyingTxnProperty(IAgent agent) {
            super(BizDefAdministrator.kForceTurnOffNonIdentifyingTxnProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fForceTurnOffNonIdentifyingTxn = (Boolean)newValue;
        }
    }

    private class TransactionComponentUpdatesCallBackHandler
    implements ITransactionComponentUpdatesCallback {
        public void transactionComponentAdd(TransactionComponent[] tc) throws ConnectionException {
            if (BizDefAdministrator.this.fFeedback.isDebugEnabled()) {
                BizDefAdministrator.this.fFeedback.debug("*****************transactionComponentAdd***********************");
            }
            BizDefAdministrator.this.updateBusinessDefinitions(tc);
            BizDefAdministrator.this.checkForPostParameters();
        }

        public void transactionComponentRemove(TransactionComponent[] tc) throws ConnectionException {
            if (BizDefAdministrator.this.fFeedback.isDebugEnabled()) {
                BizDefAdministrator.this.fFeedback.debug("*****************transactionComponentRemove***********************");
            }
            BizDefAdministrator.this.removeBusinessDefinitions(tc);
            BizDefAdministrator.this.checkForPostParameters();
        }

        public void transactionComponentResetAll(TransactionComponent[] tcs) throws ConnectionException {
            if (BizDefAdministrator.this.fFeedback.isDebugEnabled()) {
                BizDefAdministrator.this.fFeedback.debug("*****************transactionComponentResetAll***********************");
            }
            BizDefAdministrator.this.loadBusinessDefinitions(tcs);
            BizDefAdministrator.this.checkForPostParameters();
        }

        public void transactionComponentUpdate(TransactionComponent[] tc) throws ConnectionException {
            if (BizDefAdministrator.this.fFeedback.isDebugEnabled()) {
                BizDefAdministrator.this.fFeedback.debug("*****************transactionComponentUpdate***********************");
            }
            BizDefAdministrator.this.updateBusinessDefinitions(tc);
            BizDefAdministrator.this.checkForPostParameters();
        }

        public void closing() throws ConnectionException {
        }
    }

    static abstract class WaitForConnectionRunnable
    implements ITimestampedRunnable {
        IRegisteredBehavior behaviorHandle;

        WaitForConnectionRunnable() {
        }
    }
}

