/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.lexer;

import com.wily.introscope.probebuilder.intelligent.instrumentation.parser.ByteCodeParserConstants;
import com.wily.introscope.probebuilder.intelligent.instrumentation.parser.Token;
import java.util.Set;

public class LexerUtils {
    private static final String kTokenAndImageDelimiter = ":";
    private static final char kDelimiter = '$';

    public static int getMethodCallKind(String methodName, String calledMethodName, Set<String> customPrefixes) {
        String calledMethodClassName;
        if (methodName.equals(calledMethodName)) {
            return 14;
        }
        String methodClassName = methodName.substring(0, methodName.indexOf("."));
        if (methodClassName.equals(calledMethodClassName = calledMethodName.substring(0, calledMethodName.indexOf(".")))) {
            return 10;
        }
        String[] methodNameArr = methodClassName.split("/");
        String[] calledMethodNameArr = calledMethodClassName.split("/");
        if (LexerUtils.isUninteresting(methodNameArr, customPrefixes)) {
            return 9;
        }
        int retVal = LexerUtils.scanLeftToRight(methodNameArr, calledMethodNameArr, 2);
        if (retVal != -1) {
            return 13;
        }
        if (methodNameArr.length != calledMethodNameArr.length) {
            return 12;
        }
        retVal = LexerUtils.scanRightToLeft(methodNameArr, calledMethodNameArr);
        if (retVal == -1) {
            return 11;
        }
        return 12;
    }

    private static boolean isUninteresting(String[] methodNameArr, Set<String> customPrefixes) {
        block0: for (String s : customPrefixes) {
            String[] chunks = s.split("\\.");
            int i = 0;
            while (i < chunks.length) {
                if (i >= methodNameArr.length || !chunks[i].equals(methodNameArr[i])) continue block0;
                ++i;
            }
            return true;
        }
        return false;
    }

    private static int scanLeftToRight(String[] arr1, String[] arr2, int maxSegmentComparisons) {
        int i = 0;
        while (i < maxSegmentComparisons) {
            if (!arr1[i].equals(arr2[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int scanRightToLeft(String[] arr1, String[] arr2) {
        int i = arr1.length - 2;
        while (i >= 0) {
            if (!arr1[i].equals(arr2[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static Token createToken(int kind) {
        String image = ByteCodeParserConstants.tokenImage[kind];
        return Token.newToken(kind, image);
    }

    public static void genTokenNameAndImageStream(Token token, StringBuffer buffer) {
        LexerUtils.genStream(token, buffer, true);
    }

    private static void genStream(Token token, StringBuffer buffer, boolean prefixtokenName) {
        Token temp = token;
        while (temp != null) {
            if (prefixtokenName) {
                buffer.append(String.valueOf(ByteCodeParserConstants.tokenImage[temp.kind]) + kTokenAndImageDelimiter);
            }
            buffer.append(String.valueOf(temp.image) + " ");
            temp = temp.next;
        }
    }

    public static void genTokenImageStream(Token token, StringBuffer buffer) {
        LexerUtils.genStream(token, buffer, false);
    }

    public static String combineMethodArtifacts(String clazz, String name, String type) {
        StringBuilder buffer = new StringBuilder(clazz);
        buffer.append(".");
        buffer.append(name);
        buffer.append(type);
        return buffer.toString();
    }

    public static String getBranchImage(int currentLine, int jumpTarget) {
        StringBuilder buffer = new StringBuilder(Integer.toString(currentLine));
        buffer.append('$');
        buffer.append(Integer.toString(jumpTarget));
        return buffer.toString();
    }
}

