/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IDynamicClassMatcher;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.introscope.agent.transformer.dynamic.IDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.introscope.autoprobe.OverheadManagementHelper;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;

public class DGDeepInheritedClassMatcher
extends AImmutableClassMatcher
implements IDynamicClassMatcher {
    private final IClassName fClassName;

    public DGDeepInheritedClassMatcher(IClassName className) {
        this.fClassName = className;
    }

    private boolean executeMatches(IModeledClass cls) {
        if (ClassFileUtilities.looselyMatches((IClassName)this.fClassName, (IClassName)cls.getClassName())) {
            IDeepInheritanceHelper helper = ThreadLocalClassHelper.getDeepInheritanceHelper();
            if (helper != null) {
                helper.noticeFoundRoot(this.fClassName);
            }
            return true;
        }
        if (cls.hasSuperClass() && ClassFileUtilities.looselyMatches((IClassName)this.fClassName, (IClassName)cls.getSuperClassName())) {
            return true;
        }
        if (cls.inheritsDirectlyFromInterface(this.fClassName)) {
            return true;
        }
        IDeepInheritanceHelper helper = ThreadLocalClassHelper.getDeepInheritanceHelper();
        if (helper != null) {
            return helper.addInheritanceMatchRequest(cls, this.fClassName);
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    @Override
    public IClassName getClassName() {
        return this.fClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGDeepInheritedClassMatcher) {
            DGDeepInheritedClassMatcher m = (DGDeepInheritedClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        String overheadMode = OverheadManagementHelper.getOverheadMode();
        if (overheadMode != null && overheadMode.equalsIgnoreCase("none")) {
            return false;
        }
        boolean result = this.executeMatches(cls);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setInheritedClassName(this.fClassName);
            current.setSkipCause(4096);
        }
        return result;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

