/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.util.Glob;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.IModeledClass;

public class DGGlobClassMatcher
extends AImmutableClassMatcher {
    private Glob fGlob;

    public DGGlobClassMatcher(String classPattern) {
        this.fGlob = new Glob(classPattern.replace('.', '/').trim());
    }

    public DGGlobClassMatcher(String classPattern, IClassSchemaPolicy classSchemaPolicy) {
        this.fGlob = new Glob(classSchemaPolicy.getPatternMatchingFriendlyName(classPattern));
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        return this.IClassMatcher_matches(cls.getClassName());
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return true;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        boolean result = this.matches(className.getContainerAndPackageAndNameString());
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(2048);
        }
        return result;
    }

    public String toString() {
        return this.fGlob.toString();
    }

    private boolean matches(String name) {
        return this.fGlob.matches(name);
    }

    public static void main(String[] args) {
        String pattern = args[0];
        DGGlobClassMatcher m = new DGGlobClassMatcher(pattern);
        String name = args[1];
        System.out.println(m.matches(name) ? "matches" : "does not match");
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fGlob.getPattern());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGGlobClassMatcher) {
            DGGlobClassMatcher m = (DGGlobClassMatcher)obj;
            return this.fGlob.getPattern().equals(m.fGlob.getPattern());
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

