/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGAppendFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGChopFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameFrameExtended;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameLocalsOneStackItemFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameLocalsOneStackItemFrameExtended;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGStackMapFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGTopVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfoArray;
import com.wily.wilyassert.Assertion;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGFullFrame
extends DGStackMapFrame {
    private int fNumberOfLocals;
    private DGVerificationTypeInfoArray fLocals;
    private int fNumberOfStackItems;
    private DGVerificationTypeInfoArray fStack;
    public static final int kFrameTag = 255;
    private static final int kFrameSize = 7;

    public DGFullFrame(DataInputStream data, int frameType, int prevOffset) throws IOException {
        super(prevOffset);
        int offsetDelta = data.readUnsignedShort();
        this.setOffsetDelta(offsetDelta);
        this.fNumberOfLocals = data.readUnsignedShort();
        this.fLocals = new DGVerificationTypeInfoArray(this.fNumberOfLocals, data);
        this.fNumberOfStackItems = data.readUnsignedShort();
        this.fStack = new DGVerificationTypeInfoArray(this.fNumberOfStackItems, data);
    }

    public DGFullFrame(int prevoffset, int delta, int numlocals, DGVerificationTypeInfoArray locals, int numstack, DGVerificationTypeInfoArray stack) {
        super(prevoffset);
        this.setOffsetDelta(delta);
        this.fNumberOfLocals = numlocals;
        this.fLocals = locals;
        this.fNumberOfStackItems = numstack;
        this.fStack = stack;
    }

    public DGFullFrame(DGFullFrame prevFrame, DGStackMapFrame stackMapFrame) {
        super(prevFrame.getOffset());
        this.initFullFrameFromPrevFrame(prevFrame, stackMapFrame);
    }

    public void initFullFrameFromPrevFrame(DGFullFrame prevFrame, DGStackMapFrame stackMapFrame) {
        this.setOffsetDelta(stackMapFrame.getOffsetDelta());
        this.fNumberOfLocals = prevFrame.fNumberOfLocals;
        this.fLocals = prevFrame.fLocals;
        this.fNumberOfStackItems = prevFrame.fNumberOfStackItems;
        this.fStack = prevFrame.fStack;
        this.fLocals = stackMapFrame.adjustLocals(this.fLocals);
        this.fNumberOfLocals = this.fLocals.getNumElements();
        this.fStack = stackMapFrame.adjustStack(this.fStack);
        this.fNumberOfStackItems = this.fStack.getNumElements();
    }

    public DGFullFrame(DGFullFrame prevFullFrame, DGStackMapFrame prevFrame, DGStackMapFrame stackMapFrame) {
        super(prevFrame.getOffset());
        if (prevFrame instanceof DGFullFrame) {
            this.initFullFrameFromPrevFrame((DGFullFrame)prevFrame, stackMapFrame);
            return;
        }
        this.setOffsetDelta(stackMapFrame.getOffsetDelta());
        if (prevFrame instanceof DGAppendFrame || prevFrame instanceof DGChopFrame) {
            Assertion.wilyAssert((boolean)false, (String)"StackMap: Unexpected  prevoud stack frame type.");
            return;
        }
        this.fNumberOfLocals = prevFullFrame.fNumberOfLocals;
        this.fLocals = prevFullFrame.fLocals;
        if (prevFrame instanceof DGSameFrame || prevFrame instanceof DGSameFrameExtended) {
            this.fNumberOfStackItems = prevFullFrame.fNumberOfStackItems;
            this.fStack = prevFullFrame.fStack;
        } else if (prevFrame instanceof DGSameLocalsOneStackItemFrame) {
            this.fNumberOfStackItems = 1;
            this.fStack = ((DGSameLocalsOneStackItemFrame)prevFrame).getStack();
        } else if (prevFrame instanceof DGSameLocalsOneStackItemFrameExtended) {
            this.fNumberOfStackItems = 1;
            this.fStack = ((DGSameLocalsOneStackItemFrameExtended)prevFrame).getStack();
        }
        this.fLocals = stackMapFrame.adjustLocals(this.fLocals);
        this.fNumberOfLocals = this.fLocals.getNumElements();
        this.fStack = stackMapFrame.adjustStack(this.fStack);
        this.fNumberOfStackItems = this.fStack.getNumElements();
    }

    public DGVerificationTypeInfoArray getLocals() {
        return this.fLocals;
    }

    public DGVerificationTypeInfoArray getStack() {
        return this.fStack;
    }

    @Override
    public String toString() {
        return "Full(offset=" + this.getOffset() + ", delta=" + this.getOffsetDelta() + ", locals=" + this.getLocals() + ", stack=" + this.getStack() + ")";
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(255);
        out.writeShort(this.getOffsetDelta());
        out.writeShort(this.fNumberOfLocals);
        this.fLocals.write(out);
        out.writeShort(this.fNumberOfStackItems);
        this.fStack.write(out);
    }

    @Override
    public int size() {
        return 7 + this.fLocals.size() + this.fStack.size();
    }

    @Override
    protected DGVerificationTypeInfoArray adjustLocals(DGVerificationTypeInfoArray locals) {
        return this.fLocals;
    }

    @Override
    protected DGVerificationTypeInfoArray adjustStack(DGVerificationTypeInfoArray stack) {
        return this.fStack;
    }

    public void addLocalObjectReferenceVariable(int slot, int pciObject) {
        int index = this.fLocals.getIndexForSlot(slot);
        if (index >= this.fLocals.getNumElements()) {
            DGVerificationTypeInfoArray newLocals = new DGVerificationTypeInfoArray(index + 1);
            int i = 0;
            while (i < this.fNumberOfLocals) {
                newLocals.copyTypeInfo(i, this.fLocals, i);
                ++i;
            }
            newLocals.setTypeInfo(index, (byte)7, pciObject);
            this.fLocals = newLocals;
            this.fNumberOfLocals = this.fLocals.getNumElements();
        } else {
            this.fLocals.setTypeInfo(index, (byte)7, pciObject);
        }
    }

    public void addLocalThisVariable(int slot, DGStackMapFrame initialFrame) {
        int index = this.fLocals.getIndexForSlot(slot);
        if (index >= this.fLocals.getNumElements()) {
            DGVerificationTypeInfoArray newLocals = new DGVerificationTypeInfoArray(index + 1);
            int i = 0;
            while (i < this.fNumberOfLocals) {
                newLocals.copyTypeInfo(i, this.fLocals, i);
                ++i;
            }
            if (!(newLocals.getTypeInfo(0) instanceof DGTopVariableInfo)) {
                newLocals.copyTypeInfo(index, newLocals, 0);
            } else {
                DGFullFrame initialFullFrame = (DGFullFrame)initialFrame;
                DGVerificationTypeInfoArray initialLocals = initialFullFrame.getLocals();
                newLocals.copyTypeInfo(index, initialLocals, 0);
            }
            this.fLocals = newLocals;
            this.fNumberOfLocals = this.fLocals.getNumElements();
        } else {
            this.fLocals.copyTypeInfo(index, this.fLocals, 0);
        }
    }

    @Override
    protected boolean updateUninitializedTypeOffset(int pc, int delta) {
        boolean res1 = this.fLocals.updateUninitializedVariableOffset(pc, delta);
        boolean res2 = this.fStack.updateUninitializedVariableOffset(pc, delta);
        return res1 || res2;
    }
}

