/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.sustainability.ISustainabilityServiceTrace;
import com.wily.introscope.agent.trace.IEnhancedInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IExternalTracer;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationMethodTracer;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.IWallClockDelegate;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.TransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.cas.IStallPoint;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProvider;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.parameter.Parameter;
import com.wily.introscope.agent.trace.parameter.ParameterAllocator;
import com.wily.introscope.agent.trace.servlet.IHttpRequestHelper;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.adt.IdentityHashSet;
import com.wily.util.adt.LazyMap;
import com.wily.util.adt.TwoObjectIdentityHashSet;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class InvocationData
implements IComponentParameterCallback,
IParameterizedMethodTracer,
IStackElement,
IExternalTracer {
    private static final int kBigParameterMap = 16;
    private static final int kSmallParameterMap = 2;
    private static final AtomicInteger invocationIdCount = new AtomicInteger();
    private boolean fStartTraceSkipped = false;
    private static final ICallbackOnEndTrace kCallbackOnEndTrace = new ExecuteOnEndTrace();
    private static final ICallbackOnEndTrace kCallbackOnEndTransaction = new ExecuteOnEndTransactionTrace();
    private static volatile ITransactionCacheProviderFactory fFactory = new TransactionCacheProviderFactory();
    private ICallbackOnEndTrace actualCallbackOnEndTrace = kCallbackOnEndTrace;
    private IPostfinishTraceCallback postfinishTraceCallback;
    private final ProbeInformation fProbeInformation;
    private Object fInvocationObject;
    private Parameter[] fInvocationParameterList;
    private Parameter fInvocationReturnValue;
    private Throwable fInvocationThrownException;
    private long fWallClockStartTime;
    private volatile long fWallClockFinishTime;
    private long fWallClockElapsedTime;
    private SpecialTimes st;
    private IIntegerFluctuatingCounterDataAccumulator fCounter;
    private IIntegerFluctuatingCounterDataAccumulator[] fCounters;
    private String[] fComponentNames;
    private Map fDataStorage;
    private Object fSyncStorage;
    private String fComponentName;
    private String fOrigComponentName;
    private Object fPartialSocketFormattedName;
    private boolean fIsSocketRequired;
    private boolean fHasSocketResource;
    private int[] fAppMapTransactionalState;
    private ArrayList fParameterCallback;
    private IBlameStack fStack = null;
    private int fSamplingTracer = -1;
    private boolean fIsCtorMethodTraced;
    IWallClockDelegate fWallClockDelegate;
    private IMethodTracer fIntelligentInstrumentationTracer = null;
    private IIntelligentInstrumentationTracerHelper fIntelligentInstrumentationService;
    private int fInvocationId = -1;
    private boolean shouldReportAllocatedBytes;
    private boolean shouldDecorateCPUTiming;
    private boolean fShouldTrackInstance;
    private boolean fShouldTrackMethodName;
    private boolean fShouldSkipIntelligentTrace;
    private ITracer[] fTracers;
    public static final int kMaximumAllowableMessageSize = 4096;
    public static final int kStartedTransaction = 2;
    public static final int kStartedBlame = 1;
    public static final int kNone = 0;
    private ISustainabilityServiceTrace sustainabilityTrace;
    private volatile IStackElement fParent;
    private ITransactionCacheProvider fCacheProvider;
    private volatile boolean fIsStalled;
    private volatile boolean fFinished;
    private volatile boolean fNotTop;
    private static final String fAppMapSocketKey = "appMapSocketKey";
    private boolean fHasSockets;
    private boolean fHasUpdatedSocketMetrics;
    private volatile boolean fContainsFrontendTracer;
    boolean fStartedTransaction = false;
    private volatile SharedCrossProcessData fCrossProcessCache;
    private AppMapSupportClass fAppMapSupport;
    private volatile BaseTransactionElementSupportClass fTes;
    private volatile ServletSupportClass servletSupport;
    private final InvocationDataThreadLocal fThreadLocal;
    private boolean fShouldStub;
    private boolean fShouldRunSpecialTracer;
    private boolean socketClamped = false;

    public IPostfinishTraceCallback getPostfinishTraceCallback() {
        return this.postfinishTraceCallback;
    }

    public void setPostfinishTraceCallback(IPostfinishTraceCallback postfinishTraceCallback) {
        this.postfinishTraceCallback = postfinishTraceCallback;
    }

    @Override
    public void setIntelligentInstrumentationService(IIntelligentInstrumentationTracerHelper intelligentInstrumentation, int probeHashCode) {
        this.fIntelligentInstrumentationService = intelligentInstrumentation;
    }

    public Object getHighPerformanceIntelligenceStackElementVirtualStack() {
        return this.fCacheProvider.getCurrentCache().getInvocationDataThreadLocal().fHighPerformanceIntelligenceStackElementVirtualStack;
    }

    public void setHighPerformanceIntelligenceStackElementVirtualStack(Object highPerformanceIntelligenceStackElementVirtualStack) {
        this.fCacheProvider.getCurrentCache().getInvocationDataThreadLocal().fHighPerformanceIntelligenceStackElementVirtualStack = highPerformanceIntelligenceStackElementVirtualStack;
    }

    public int getInvocationId() {
        return this.fInvocationId;
    }

    InvocationData(IAgent agent, ProbeInformation probeInformation, Object invocationObject, boolean canBeRecycled) {
        this.fProbeInformation = probeInformation;
        this.fInvocationObject = invocationObject;
        if (this.fProbeInformation.needsInstanceReentrancy() || this.fProbeInformation.needsMethodNameReentrancy()) {
            String methodName = this.fProbeInformation.getProbeIdentification().getProbeMethodName();
            this.fIsCtorMethodTraced = methodName.equals("<init>");
        }
        this.fWallClockStartTime = -1L;
        this.fWallClockFinishTime = -1L;
        this.fWallClockElapsedTime = -1L;
        this.st = null;
        this.fParameterCallback = null;
        this.fComponentName = null;
        this.fSyncStorage = null;
        this.fShouldStub = false;
        this.fShouldRunSpecialTracer = false;
        this.fWallClockDelegate = null;
        this.fCacheProvider = fFactory.getProvider();
        this.fThreadLocal = this.fCacheProvider.getCurrentCache().getInvocationDataThreadLocal();
        this.shouldReportAllocatedBytes = false;
        this.shouldDecorateCPUTiming = false;
    }

    InvocationData(IAgent agent, ProbeInformation probeInformation, Object invocationObject, boolean canBeRecycled, IWallClockDelegate clockDelegate) {
        this.fProbeInformation = probeInformation;
        this.fInvocationObject = invocationObject;
        if (this.fProbeInformation.needsInstanceReentrancy() || this.fProbeInformation.needsMethodNameReentrancy()) {
            String methodName = this.fProbeInformation.getProbeIdentification().getProbeMethodName();
            this.fIsCtorMethodTraced = methodName.equals("<init>");
        }
        this.fWallClockStartTime = -1L;
        this.fWallClockFinishTime = -1L;
        this.fWallClockElapsedTime = -1L;
        this.st = null;
        this.fParameterCallback = null;
        this.fComponentName = null;
        this.fSyncStorage = null;
        this.fWallClockDelegate = clockDelegate;
        this.fCacheProvider = fFactory.getProvider();
        this.fThreadLocal = this.fCacheProvider.getCurrentCache().getInvocationDataThreadLocal();
    }

    private IAgent getAgent() {
        return this.fProbeInformation.getAgent();
    }

    private IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    public final ProbeInformation getProbeInformation() {
        return this.fProbeInformation;
    }

    private final String getProbeClassName() {
        return this.getProbeInformation().getProbeIdentification().getProbeClassName();
    }

    private final String getRuntimeFullClassName() {
        return this.getProbeInformation().getProbeIdentification().getRuntimeFullClassName();
    }

    private final String getProbeMethodName() {
        return this.getProbeInformation().getProbeIdentification().getProbeMethodName();
    }

    private final String getProbeMethodDescriptor() {
        return this.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor();
    }

    public final Object getInvocationObject() {
        return this.fInvocationObject;
    }

    public final boolean hasInvocationParametersAvailable() {
        return this.fInvocationParameterList != null;
    }

    public final int getInvocationParameterCount() {
        return this.fInvocationParameterList == null ? 0 : this.fInvocationParameterList.length;
    }

    public final Object getInvocationParameterAsObject(int index) {
        return this.fInvocationParameterList[index].toObject();
    }

    public final boolean hasMethodResultAvailable() {
        return this.fInvocationParameterList != null;
    }

    public final Object getInvocationReturnValueAsObject() {
        return this.fInvocationReturnValue.toObject();
    }

    @Override
    public final boolean hasInvocationThrownException() {
        return this.getInvocationThrownException() != null;
    }

    public final Throwable getInvocationThrownException() {
        return this.fInvocationThrownException;
    }

    public final String formatWithParameters(String original) {
        return this.safeFormat(original);
    }

    private final String safeFormat(String original) {
        try {
            if (this.fInvocationParameterList != null && this.fInvocationParameterList.length > 0 && original != null) {
                original = MessageFormat.format(original, this.fInvocationParameterList);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Formatting_Name_Error_Message", original, this.getProbeClassName(), this.getProbeMethodName(), this.getProbeMethodDescriptor()));
            this.getModuleFeedback().verbose(t);
        }
        return original;
    }

    @Override
    public final void setParameterCallback(IInvocationDataParameterCallback parameterCallback) {
        if (this.fParameterCallback == null) {
            this.fParameterCallback = new ArrayList(2);
        }
        this.fParameterCallback.add(parameterCallback);
    }

    public final boolean isParameterCallbackInitialized() {
        return false;
    }

    @Override
    public final void IComponentParameterCallback_addParameters(Map parameters) {
        parameters.put("Method", this.getProbeMethodName());
        parameters.put("Method Descriptor", this.getProbeMethodDescriptor());
        parameters.put("Class", this.getRuntimeFullClassName());
        if (this.hasInvocationThrownException()) {
            try {
                Throwable thrown = this.getInvocationThrownException();
                parameters.put("Exception", InvocationData.limitSize(String.valueOf(thrown.getClass().getName()) + ": " + thrown.getMessage()));
            }
            catch (Exception e) {
                this.getAgent().IAgent_getModuleFeedback().verbose(this.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Transaction_Trace_Error_Accessing_Parameters"));
                this.getAgent().IAgent_getModuleFeedback().verbose(e);
            }
        }
        if (this.fParameterCallback != null) {
            int i = 0;
            while (i < this.fParameterCallback.size()) {
                IInvocationDataParameterCallback callback = (IInvocationDataParameterCallback)this.fParameterCallback.get(i);
                callback.IInvocationDataParameterCallback_addParameters(this, parameters);
                ++i;
            }
        }
    }

    public final long storeWallClockStartTime() {
        if (this.fWallClockStartTime < 0L) {
            this.fWallClockStartTime = this.fWallClockDelegate != null ? this.fWallClockDelegate.getStartTime() : MasterClock.currentTimeMillis();
        }
        return this.fWallClockStartTime;
    }

    public final long getWallClockTime() {
        long wallClockTime = this.fWallClockDelegate != null ? this.fWallClockDelegate.getStartTime() : MasterClock.currentTimeMillis();
        return wallClockTime;
    }

    @Override
    public final long getWallClockStartTime() {
        Assertion.wilyAssert(false);
        return this.fWallClockStartTime;
    }

    @Override
    public final long getWallClockFinishTime() {
        if (this.fWallClockFinishTime < 0L) {
            this.fWallClockFinishTime = this.fWallClockDelegate != null ? this.fWallClockDelegate.getFinishTime() : MasterClock.currentTimeMillis();
        }
        return this.fWallClockFinishTime;
    }

    @Override
    public final long getWallClockElapsedTime() {
        if (this.fWallClockElapsedTime < 0L) {
            this.fWallClockElapsedTime = this.getWallClockFinishTime() - this.getWallClockStartTime();
        }
        return this.fWallClockElapsedTime;
    }

    public final int getWallClockElapsedTimeAsInt() {
        return (int)this.getWallClockElapsedTime();
    }

    public final void setCPUStartTime(long startTime) {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        Assertion.wilyAssert(false);
        this.st.fCPUStartTime = startTime;
    }

    public final long getCPUStartTime() {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        return this.st.fCPUStartTime;
    }

    public final void setCPUFinishTime(long finishTime) {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        Assertion.wilyAssert(false);
        this.st.fCPUFinishTime = finishTime;
    }

    public final long getCPUFinishTime() {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        return this.st.fCPUFinishTime;
    }

    public final void setCPUStartTimeNanos(long startTime) {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        Assertion.wilyAssert(false);
        this.st.fCPUStartTimeNanos = startTime;
    }

    public final long getCPUStartTimeNanos() {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        return this.st.fCPUStartTimeNanos;
    }

    public final void setCPUFinishTimeNanos(long finishTime) {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        Assertion.wilyAssert(false);
        this.st.fCPUFinishTimeNanos = finishTime;
    }

    public final long getCPUFinishTimeNanos() {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        return this.st.fCPUFinishTimeNanos;
    }

    public final void setWallClockStartTimeNanos(long startTime) {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        Assertion.wilyAssert(false);
        this.st.fWallClockStartTimeNanos = startTime;
    }

    public final long getWallClockStartTimeNanos() {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        return this.st.fWallClockStartTimeNanos;
    }

    public final void setWallClockFinishTimeNanos(long finishTime) {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        Assertion.wilyAssert(false);
        this.st.fWallClockFinishTimeNanos = finishTime;
    }

    public final long getWallClockFinishTimeNanos() {
        if (this.st == null) {
            this.initializeForSpecialTimes();
        }
        return this.st.fWallClockFinishTimeNanos;
    }

    public final long getWallClockElapsedTimeNanos() {
        return this.getWallClockFinishTimeNanos() - this.getWallClockStartTimeNanos();
    }

    public final boolean storeConcurrentInovocationCounter(IIntegerFluctuatingCounterDataAccumulator counter) {
        if (this.fCounter == null) {
            this.fCounter = counter;
            return true;
        }
        return false;
    }

    public final IIntegerFluctuatingCounterDataAccumulator retrieveConcurrentInvocationCounter() {
        return this.fCounter;
    }

    @Override
    public final Object put(String name, Object value) {
        Assertion.wilyAssert(false);
        if (this.fDataStorage == null) {
            this.fDataStorage = new HashMap(this.fContainsFrontendTracer ? 16 : 2);
        }
        return this.fDataStorage.put(name, value);
    }

    @Override
    public final Object get(String name) {
        Assertion.wilyAssert(false);
        if (this.fDataStorage == null) {
            return null;
        }
        return this.fDataStorage.get(name);
    }

    public final void setSyncStorage(Object storage) {
        this.fSyncStorage = storage;
    }

    public final Object getSyncStorage() {
        return this.fSyncStorage;
    }

    private void calculateReentrancyTracking(InvocationDataThreadLocal tl) {
        String value;
        Object object;
        String methodName;
        String className;
        ProbeIdentification pid;
        ProbeInformation pinfo = this.getProbeInformation();
        if (pinfo.needsInstanceReentrancy()) {
            pid = pinfo.getProbeIdentification();
            className = pid.getProbeClassName();
            methodName = pid.getProbeMethodName();
            object = this.getInvocationObject();
            value = object == null ? className : (this.fIsCtorMethodTraced ? className : object);
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            if (tl.instanceSet == null) {
                tl.instanceSet = new IdentityHashSet();
            }
            this.fShouldTrackInstance = tl.instanceSet.add(value);
        }
        if (pinfo.needsMethodNameReentrancy()) {
            pid = pinfo.getProbeIdentification();
            className = pid.getProbeClassName();
            methodName = pid.getProbeMethodName();
            object = this.getInvocationObject();
            value = object == null ? className : (this.fIsCtorMethodTraced ? className : object);
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            if (tl.methodSet == null) {
                tl.methodSet = new TwoObjectIdentityHashSet();
            }
            this.fShouldTrackMethodName = tl.methodSet.add(value, methodName);
        }
    }

    private void cleanupReentrancyTracking(InvocationDataThreadLocal tl) {
        String className;
        ProbeIdentification pid;
        ProbeInformation pinfo = this.getProbeInformation();
        if (pinfo.needsInstanceReentrancy() && this.fShouldTrackInstance && tl.instanceSet != null) {
            pid = pinfo.getProbeIdentification();
            className = pid.getProbeClassName();
            Object object = this.getInvocationObject();
            String value = object == null ? className : (this.fIsCtorMethodTraced ? className : object);
            Assertion.wilyAssert(false);
            tl.instanceSet.remove(value);
        }
        if (pinfo.needsMethodNameReentrancy() && this.fShouldTrackMethodName && tl.methodSet != null) {
            pid = pinfo.getProbeIdentification();
            className = pid.getProbeClassName();
            String methodName = pid.getProbeMethodName();
            Object object = this.getInvocationObject();
            String value = object == null ? className : (this.fIsCtorMethodTraced ? className : object);
            Assertion.wilyAssert(false);
            tl.methodSet.remove(value, methodName);
        }
    }

    private boolean shouldTrackInstance() {
        return this.fShouldTrackInstance;
    }

    private boolean shouldTrackMethodName() {
        return this.fShouldTrackMethodName;
    }

    private boolean shouldRunTracer(ITracerFactory tracerFactory) {
        if (!tracerFactory.ITracerFactory_isShutoff()) {
            ReentrancyLevel level = tracerFactory.ITracerFactory_getReentrancyLevel();
            if (level == ReentrancyLevel.kNone) {
                return true;
            }
            if (level == ReentrancyLevel.kInstance) {
                return this.shouldTrackInstance();
            }
            if (level == ReentrancyLevel.kMethodName) {
                return this.shouldTrackMethodName();
            }
            Assertion.wilyFail("unknown reentrancy level");
        }
        return false;
    }

    private void releaseTracers() {
        ITracerFactory[] factories = this.getProbeInformation().getTracerFactories();
        int i = this.fTracers.length - 1;
        while (i >= 0) {
            if (this.fTracers[i] != null) {
                try {
                    factories[i].ITracerFactory_releaseTracer(i, this.fTracers[i]);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        this.getAgent().IAgent_safeReportError("Exception releasing method tracer for " + this.getProbeClassName() + "." + this.getProbeMethodName(), t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                }
            }
            --i;
        }
    }

    public final void skipIntelligentTracerForThisMethod() {
        this.fShouldSkipIntelligentTrace = true;
    }

    @Override
    public final void IMethodTracer_startTrace() {
        block50: {
            if (this.checkForNoneOverheadMode()) {
                this.fStartTraceSkipped = true;
                return;
            }
            this.fCacheProvider = fFactory.getProvider();
            if (!this.fThreadLocal.reentrant || this.fThreadLocal.reentrancyOverwrite) {
                this.calculateReentrancyTracking(this.fThreadLocal);
                boolean shouldRunIntelligentTracer = false;
                try {
                    try {
                        this.fThreadLocal.reentrant = true;
                        this.fInvocationId = invocationIdCount.incrementAndGet();
                        ITracerFactory[] factories = this.getProbeInformation().getTracerFactories();
                        int factoriesLength = factories.length;
                        this.fTracers = new ITracer[factoriesLength];
                        int i = 0;
                        while (i < factoriesLength) {
                            if (this.shouldRunTracer(factories[i]) || this.fThreadLocal.reentrancyOverwrite) {
                                try {
                                    this.fTracers[i] = factories[i].ITracerFactory_allocateTracer(i, this);
                                    shouldRunIntelligentTracer = true;
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (Throwable t) {
                                    try {
                                        this.getAgent().IAgent_safeReportError("Exception allocating method tracer for " + this.getProbeClassName() + "." + this.getProbeMethodName(), t);
                                    }
                                    catch (ThreadDeath td2) {
                                        throw td2;
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                            ++i;
                        }
                        this.fThreadLocal.reentrancyOverwrite = false;
                        i = 0;
                        while (i < factoriesLength) {
                            if (this.IMethodTracer_shouldStub()) break;
                            if (this.fTracers[i] != null) {
                                try {
                                    this.fTracers[i].ITracer_startTrace(i, this);
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (Throwable t) {
                                    try {
                                        this.getAgent().IAgent_safeReportError("Exception starting method tracer " + this.fTracers[i].getClass().getName() + " actual trace for " + this.getProbeClassName() + "." + this.getProbeMethodName(), t);
                                    }
                                    catch (ThreadDeath td2) {
                                        throw td2;
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                            ++i;
                        }
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            this.getAgent().IAgent_safeReportError("Exception starting method tracer for " + this.getProbeClassName() + "." + this.getProbeMethodName(), t);
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {}
                        this.fThreadLocal.reentrant = false;
                        this.fThreadLocal.reentrancyOverwrite = false;
                        try {
                            if (!this.fShouldSkipIntelligentTrace && !this.IMethodTracer_shouldStub() && this.fIntelligentInstrumentationService != null && shouldRunIntelligentTracer) {
                                this.fIntelligentInstrumentationTracer = this.fIntelligentInstrumentationService.getIntelligentInstrumentationTracer(this);
                                if (this.fIntelligentInstrumentationTracer != null) {
                                    ((IIntelligentInstrumentationMethodTracer)this.fIntelligentInstrumentationTracer).IMethodTracer_startTrace(this);
                                }
                            }
                            if (this.sustainabilityTrace != null) {
                                this.sustainabilityTrace.endStartTrace();
                            }
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {}
                        if (this.IMethodTracer_shouldStub() && this.getInvocationThrownException() != null) {
                            AgentShim.throwApplicationException(this.getInvocationThrownException());
                        }
                        break block50;
                    }
                }
                catch (Throwable throwable) {
                    this.fThreadLocal.reentrant = false;
                    this.fThreadLocal.reentrancyOverwrite = false;
                    try {
                        if (!this.fShouldSkipIntelligentTrace && !this.IMethodTracer_shouldStub() && this.fIntelligentInstrumentationService != null && shouldRunIntelligentTracer) {
                            this.fIntelligentInstrumentationTracer = this.fIntelligentInstrumentationService.getIntelligentInstrumentationTracer(this);
                            if (this.fIntelligentInstrumentationTracer != null) {
                                ((IIntelligentInstrumentationMethodTracer)this.fIntelligentInstrumentationTracer).IMethodTracer_startTrace(this);
                            }
                        }
                        if (this.sustainabilityTrace != null) {
                            this.sustainabilityTrace.endStartTrace();
                        }
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable2) {}
                    if (this.IMethodTracer_shouldStub() && this.getInvocationThrownException() != null) {
                        AgentShim.throwApplicationException(this.getInvocationThrownException());
                    }
                    throw throwable;
                }
                this.fThreadLocal.reentrant = false;
                this.fThreadLocal.reentrancyOverwrite = false;
                try {
                    if (!this.fShouldSkipIntelligentTrace && !this.IMethodTracer_shouldStub() && this.fIntelligentInstrumentationService != null && shouldRunIntelligentTracer) {
                        this.fIntelligentInstrumentationTracer = this.fIntelligentInstrumentationService.getIntelligentInstrumentationTracer(this);
                        if (this.fIntelligentInstrumentationTracer != null) {
                            ((IIntelligentInstrumentationMethodTracer)this.fIntelligentInstrumentationTracer).IMethodTracer_startTrace(this);
                        }
                    }
                    if (this.sustainabilityTrace != null) {
                        this.sustainabilityTrace.endStartTrace();
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
                if (this.IMethodTracer_shouldStub() && this.getInvocationThrownException() != null) {
                    AgentShim.throwApplicationException(this.getInvocationThrownException());
                }
            }
        }
    }

    @Override
    public final void IMethodTracer_finishTrace() {
        block42: {
            if (this.checkForNoneOverheadMode() && this.fStartTraceSkipped) {
                return;
            }
            try {
                if (!this.fShouldSkipIntelligentTrace && !this.IMethodTracer_shouldStub() && this.fIntelligentInstrumentationTracer != null) {
                    ((IIntelligentInstrumentationMethodTracer)this.fIntelligentInstrumentationTracer).IMethodTracer_finishTrace(this);
                }
                if (this.sustainabilityTrace != null) {
                    this.sustainabilityTrace.startEndTrace();
                }
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
            if (!this.fThreadLocal.reentrant || this.fThreadLocal.reentrancyOverwrite) {
                try {
                    try {
                        this.fThreadLocal.reentrant = true;
                        this.fThreadLocal.reentrancyOverwrite = false;
                        if (this.fTracers != null) {
                            int i = this.fTracers.length - 1;
                            while (i >= 0) {
                                if (this.IMethodTracer_shouldStub()) break;
                                if (this.fTracers[i] != null) {
                                    try {
                                        this.fTracers[i].ITracer_finishTrace(i, this);
                                    }
                                    catch (ThreadDeath td) {
                                        throw td;
                                    }
                                    catch (Throwable t) {
                                        try {
                                            this.getAgent().IAgent_safeReportError("Exception finishing method tracer " + this.fTracers[i].getClass().getName() + " actual trace for " + this.getProbeClassName() + "." + this.getProbeMethodName(), t);
                                        }
                                        catch (ThreadDeath td2) {
                                            throw td2;
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                }
                                --i;
                            }
                            this.releaseTracers();
                        }
                        this.actualCallbackOnEndTrace.executeOnEndTransaction(this, this.fThreadLocal);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            this.getAgent().IAgent_safeReportError("Exception finishing method tracer actual trace for " + this.getProbeClassName() + "." + this.getProbeMethodName(), t);
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {}
                        this.fThreadLocal.reentrant = false;
                        this.fThreadLocal.reentrancyOverwrite = false;
                        try {
                            if (this.sustainabilityTrace != null) {
                                this.sustainabilityTrace.endEndTrace();
                            }
                            if (this.postfinishTraceCallback != null) {
                                this.postfinishTraceCallback.doPostFinishCallback(this);
                            }
                            break block42;
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {
                            break block42;
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.fThreadLocal.reentrant = false;
                    this.fThreadLocal.reentrancyOverwrite = false;
                    try {
                        if (this.sustainabilityTrace != null) {
                            this.sustainabilityTrace.endEndTrace();
                        }
                        if (this.postfinishTraceCallback != null) {
                            this.postfinishTraceCallback.doPostFinishCallback(this);
                        }
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                this.fThreadLocal.reentrant = false;
                this.fThreadLocal.reentrancyOverwrite = false;
                try {
                    if (this.sustainabilityTrace != null) {
                        this.sustainabilityTrace.endEndTrace();
                    }
                    if (this.postfinishTraceCallback != null) {
                        this.postfinishTraceCallback.doPostFinishCallback(this);
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public final void IMethodTracer_setInvocationObject(Object o) {
        try {
            Assertion.wilyAssert(false);
            this.fInvocationObject = o;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting invocation object method tracer for " + this.getProbeClassName() + "." + this.getProbeMethodName(), t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void allocateSpaceForParameters(IMethodSignature methodDescriptor) {
        if (methodDescriptor != null && this.fInvocationParameterList == null) {
            this.fInvocationParameterList = new Parameter[methodDescriptor.getParameterCount()];
            int i = 0;
            while (i < this.fInvocationParameterList.length) {
                this.fInvocationParameterList[i] = ParameterAllocator.allocateParameter(methodDescriptor.getParameterSignatureByIndex(i));
                ++i;
            }
            this.fInvocationReturnValue = ParameterAllocator.allocateParameter(methodDescriptor.getReturnSlotSignature());
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, byte value) {
        try {
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting byte parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, char value) {
        try {
            boolean checkType;
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            boolean bl = checkType = !this.fInvocationParameterList[index].isExpectedType(value);
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting char parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, double value) {
        try {
            boolean checkType;
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            boolean bl = checkType = !this.fInvocationParameterList[index].isExpectedType(value);
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting double parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, float value) {
        try {
            boolean checkType;
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            boolean bl = checkType = !this.fInvocationParameterList[index].isExpectedType(value);
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting float parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, int value) {
        try {
            boolean checkType;
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            boolean bl = checkType = !this.fInvocationParameterList[index].isExpectedType(value);
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting int parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, long value) {
        try {
            boolean checkType;
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            boolean bl = checkType = !this.fInvocationParameterList[index].isExpectedType(value);
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting long parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, short value) {
        try {
            boolean checkType;
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            boolean bl = checkType = !this.fInvocationParameterList[index].isExpectedType(value);
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting short parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, boolean value) {
        try {
            boolean checkType;
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            boolean bl = checkType = !this.fInvocationParameterList[index].isExpectedType(value);
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting boolean parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setParameter(int index, Object value) {
        try {
            if (this.fInvocationParameterList == null) {
                Assertion.wilyAssert("No parameters allocated");
                return;
            }
            if (index < 0 || index >= this.fInvocationParameterList.length) {
                Assertion.wilyAssert("Invalid parameter index");
                return;
            }
            if (this.fInvocationParameterList[index] == null) {
                Assertion.wilyAssert("No parameter allocated at given index");
                return;
            }
            this.fInvocationParameterList[index].setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting object parameter.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(byte value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting byte return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(char value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting char return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(double value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting double return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(float value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting float return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(int value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting int return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(long value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting long return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(short value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting short return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(boolean value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting boolean return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setReturnValue(Object value) {
        try {
            if (this.fInvocationReturnValue == null) {
                Assertion.wilyAssert("No return value allocated");
                return;
            }
            this.fInvocationReturnValue.setValue(value);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting Object return value.", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final void IParameterizedMethodTracer_setThrownException(Object exception) {
        try {
            this.fInvocationThrownException = (Throwable)exception;
            if (this.fIntelligentInstrumentationTracer != null) {
                ((IIntelligentInstrumentationMethodTracer)this.fIntelligentInstrumentationTracer).IIntelligentInstrumentationMethodTracer_setThrownException(exception, this);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_safeReportError("Exception setting thrown exception", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    public static final String limitSize(String s) {
        if (s != null && s.length() > 4096) {
            return s.substring(0, 4096);
        }
        return s;
    }

    public void setComponentName(String name) {
        this.fComponentName = name;
        this.fOrigComponentName = name;
    }

    @Override
    public String getComponentName() {
        return this.fComponentName;
    }

    public String getOriginalComponentName() {
        return this.fOrigComponentName;
    }

    public IIntegerFluctuatingCounterDataAccumulator getCounterAt(int index) {
        IIntegerFluctuatingCounterDataAccumulator result = null;
        try {
            if (this.fCounters != null) {
                result = this.fCounters[index];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.getAgent().IAgent_getModuleFeedback().debug(e);
        }
        return result;
    }

    public void setCounterAt(IIntegerFluctuatingCounterDataAccumulator counter, int index) {
        try {
            if (this.fCounters == null) {
                this.fCounters = new IIntegerFluctuatingCounterDataAccumulator[this.fTracers.length];
            }
            this.fCounters[index] = counter;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.getAgent().IAgent_getModuleFeedback().debug(e);
        }
    }

    public String getComponentNameAt(int index) {
        String result = null;
        try {
            if (this.fComponentNames != null) {
                result = this.fComponentNames[index];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return result;
    }

    public void setComponentNameAt(String componentName, int index) {
        try {
            if (this.fComponentNames == null) {
                this.fComponentNames = new String[this.fTracers.length];
            }
            this.fComponentNames[index] = componentName;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public static InvocationData debug_createInvocationData(IAgent agent, ProbeInformation probeInformation, Object invocationObject) {
        InvocationData result = new InvocationData(agent, probeInformation, invocationObject, false);
        result.initializeForTransactionElements(agent.IAgent_getComponentTracer().isAgentOldMode(), probeInformation.hasSandwich());
        return result;
    }

    public Object getPartialSocketFormattedName() {
        return this.fPartialSocketFormattedName;
    }

    public void setPartialSocketFormattedName(Object value) {
        this.fPartialSocketFormattedName = value;
    }

    public void setSocketRequired(boolean b) {
        this.fIsSocketRequired = b;
    }

    public boolean isSocketRequired() {
        return this.fIsSocketRequired;
    }

    public boolean hasSocketResource() {
        return this.fHasSocketResource;
    }

    public void setHasSocketResource(boolean b) {
        this.fHasSocketResource = b;
    }

    public IBlameStack getStack(ComponentTracer componentTracer, boolean createFlag) {
        if (this.fStack == null) {
            this.fStack = componentTracer.getCurrentThreadStack(createFlag);
        }
        return this.fStack;
    }

    public boolean setSamplingTracer(int tracerIndex) {
        if (this.fSamplingTracer < 0) {
            this.fSamplingTracer = tracerIndex;
            return true;
        }
        return false;
    }

    public int getSamplingTracer() {
        return this.fSamplingTracer;
    }

    public void setAppMapTransactionalStateAt(int fAppMapTransactionalState, int tracerIndex) {
        if (this.fAppMapTransactionalState == null) {
            this.fAppMapTransactionalState = new int[this.fTracers.length];
        }
        if (tracerIndex < this.fTracers.length) {
            this.fAppMapTransactionalState[tracerIndex] = fAppMapTransactionalState;
        }
    }

    public int getAppMapTransactionalStateAt(int tracerIndex) {
        if (this.fAppMapTransactionalState != null && tracerIndex < this.fTracers.length) {
            return this.fAppMapTransactionalState[tracerIndex];
        }
        return 0;
    }

    @Override
    public final boolean isStalled() {
        return this.fIsStalled;
    }

    @Override
    public final void setStalled() {
        this.fIsStalled = true;
    }

    @Override
    public void setFinished(boolean finished) {
        this.fFinished = finished;
    }

    @Override
    public boolean isFinished() {
        return this.fFinished;
    }

    public final void setStartedTransaction() {
        this.fStartedTransaction = true;
    }

    public final void setStartedBlame(int tracer) {
        this.fTes.setStartedBlame(tracer);
    }

    public final boolean getStartedTransaction() {
        return this.fStartedTransaction;
    }

    public final boolean hasBeenPushedAlready() {
        return this.fTes.hasBeenPushedAlready();
    }

    @Override
    public final int getStartCursorsCount() {
        return this.fTes.getStartCursorsCount();
    }

    @Override
    public final ITransactionElement getStartCursorAt(int index) {
        return this.fTes.getStartCursorAt(index);
    }

    @Override
    public final int getStartInstancePositionAt(int tracerIndex) {
        return this.fTes.getStartInstancePositionAt(tracerIndex);
    }

    public final void setStartCursorAt(ITransactionElement cursor, int index) {
        this.fTes.setStartCursorAt(cursor, index);
    }

    @Override
    public final void setStartInstancePositionAt(int position, int index) {
        this.fTes.setStartInstancePositionAt(position, index);
    }

    @Override
    public final ITransactionElement getCursor() {
        return this.fTes.getCursor();
    }

    @Override
    public final void setCursor(ITransactionElement e) {
        this.fTes.setCursor(e);
    }

    @Override
    public final IStackElement getParent() {
        return this.fParent;
    }

    public final boolean setParent(IStackElement id) {
        if (this.fParent != null || this.fStartedTransaction) {
            return false;
        }
        this.fParent = id;
        return true;
    }

    public final void setMyThread(Runnable fMyThread) {
        this.fTes.setMyThread(fMyThread);
    }

    @Override
    public final Runnable getMyThread() {
        if (this.fTes != null) {
            return this.fTes.getMyThread();
        }
        return null;
    }

    public void setParent(IStackType stackType, IStackElement previous) {
        this.setParent(previous);
    }

    public boolean startedTransaction(int tracerIndex) {
        return this.fTes.startedTransaction(tracerIndex);
    }

    public boolean startedBlame(int tracerIndex) {
        return this.fTes.startedBlame(tracerIndex);
    }

    public int getTransactionStatus(int tracerIndex) {
        return this.fTes.getTransactionStatus(tracerIndex);
    }

    public boolean hasNewAppMapCursor() {
        return this.fTes.hasNewAppMapCursor();
    }

    public void setHasNewCursor() {
        this.fTes.setHasNewCursor();
    }

    @Override
    public Iterator getStartCursorsIterator() {
        return this.fTes.getStartCursorsIterator();
    }

    @Override
    public void unsetStalled() {
        this.fIsStalled = false;
    }

    @Override
    public void addParameterCallbacks(Map parameters) {
        if (this.fParameterCallback != null) {
            int i = 0;
            while (i < this.fParameterCallback.size()) {
                IInvocationDataParameterCallback callback = (IInvocationDataParameterCallback)this.fParameterCallback.get(i);
                callback.IInvocationDataParameterCallback_addParameters(this, parameters);
                ++i;
            }
        }
    }

    @Override
    public Map getParameterCallbacks(Map parameters) {
        Map result = parameters;
        if (this.fParameterCallback != null) {
            int i = 0;
            while (i < this.fParameterCallback.size()) {
                Object parameterCallback = this.fParameterCallback.get(i);
                if (parameterCallback instanceof IEnhancedInvocationDataParameterCallback) {
                    result = ((IEnhancedInvocationDataParameterCallback)parameterCallback).IInvocationDataParameterCallback_addParametersAndReturnMap(this, result);
                } else if (parameterCallback instanceof IInvocationDataParameterCallback) {
                    IInvocationDataParameterCallback callback = (IInvocationDataParameterCallback)this.fParameterCallback.get(i);
                    callback.IInvocationDataParameterCallback_addParameters(this, result);
                }
                ++i;
            }
        }
        return result;
    }

    public void setNotTop(boolean fIsCurrent) {
        this.fNotTop = fIsCurrent;
    }

    public boolean isNotTop() {
        return this.fNotTop;
    }

    @Override
    public void addAppMapSocketCursor(ITransactionElement result) {
        this.fHasSockets = true;
        HashSet<ITransactionElement> set = (HashSet<ITransactionElement>)this.get(fAppMapSocketKey);
        if (set == null) {
            set = new HashSet<ITransactionElement>(2);
            this.put(fAppMapSocketKey, set);
        }
        set.add(result);
    }

    @Override
    public Iterator getAppMapSocketCursors() {
        Set set;
        if (this.fHasSockets && (set = (Set)this.get(fAppMapSocketKey)) != null) {
            return set.iterator();
        }
        return null;
    }

    public Iterator getAppMapSocketCursorsForMetricUpdate() {
        Set set;
        if (this.fHasSockets && !this.fHasUpdatedSocketMetrics && (set = (Set)this.get(fAppMapSocketKey)) != null) {
            this.fHasUpdatedSocketMetrics = true;
            return set.iterator();
        }
        return null;
    }

    @Override
    public void markStartTransaction() {
        this.actualCallbackOnEndTrace = kCallbackOnEndTransaction;
    }

    public final void setFrontBoundary(int tracerIndex) {
        this.fCacheProvider.getCurrentCache().setFrontBoundary(this.fComponentNames[tracerIndex]);
    }

    public final void setEndBoundary(int tracerIndex) {
        this.fCacheProvider.getCurrentCache().setEndBoundary(this.fComponentNames[tracerIndex]);
    }

    public final void setEntryPointBoundary(int tracerIndex) {
        this.fCacheProvider.getCurrentCache().setEntryPointBoundary(this.fComponentNames[tracerIndex]);
    }

    public final void unsetFrontBoundary(int tracerIndex) {
        this.fCacheProvider.getCurrentCache().unsetFrontBoundary(this.fComponentNames[tracerIndex]);
    }

    public final void unsetEndBoundary(int tracerIndex) {
        this.fCacheProvider.getCurrentCache().unsetEndBoundary(this.fComponentNames[tracerIndex]);
    }

    public final void unsetEntryPointBoundary(int tracerIndex) {
        this.fCacheProvider.getCurrentCache().unsetEntryPointBoundary(this.fComponentNames[tracerIndex]);
    }

    @Override
    public final boolean hasFrontBoundary() {
        return this.fCacheProvider.getCurrentCache().getFrontend() != null;
    }

    public final String getFrontBoundary() {
        return this.fCacheProvider.getCurrentCache().getFrontend();
    }

    public String getEndBoundary() {
        return this.fCacheProvider.getCurrentCache().getBackend();
    }

    public String getEntryPointBoundary() {
        return this.fCacheProvider.getCurrentCache().getEntryPoint();
    }

    public void incrementErrorMetric() {
        this.fCacheProvider.getCurrentCache().incrementErrorMetric();
    }

    @Override
    public ITransactionElement getLastFrontendCursor() {
        return this.fTes.getLastFrontendCursor();
    }

    @Override
    public void setLastFrontendCursor(ITransactionElement frontend) {
        this.fTes.setLastFrontendCursor(frontend);
    }

    public ITracer[] getTracersByType(Class c) {
        int length = 0;
        if (this.fTracers != null) {
            length = this.fTracers.length;
        }
        ITracer[] result = new ITracer[length];
        int i = 0;
        while (i < result.length) {
            if (c == null || this.fTracers[i] != null && c.isInstance(this.fTracers[i])) {
                result[i] = this.fTracers[i];
            }
            ++i;
        }
        return result;
    }

    public boolean hasTraceFactoryClass(Class class1) {
        ITracerFactory[] array = this.getProbeInformation().getTracerFactories();
        int max = array.length;
        int i = 0;
        while (i < max) {
            if (array[i] != null && class1.isInstance(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasTracerFactory(Object o) {
        ITracerFactory[] array = this.getProbeInformation().getTracerFactories();
        int max = array.length;
        int i = 0;
        while (i < max) {
            if (o == array[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SharedCrossProcessData getSharedCrossProcessData() {
        return this.fCrossProcessCache;
    }

    public CrossCorrelationStringParameterProvider getCrossProcessStringParentProvider() {
        if (this.fAppMapSupport == null) {
            this.fAppMapSupport = new AppMapSupportClass();
        }
        return this.fAppMapSupport.fProvider;
    }

    public void setAppMapParent(CrossCorrelationStringParameterProvider provider, InvocationData fAppMapParent) {
        if (this.fCrossProcessCache == null) {
            this.fCrossProcessCache = fAppMapParent != null ? fAppMapParent.fCrossProcessCache : CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        }
        if (this.fAppMapSupport == null) {
            this.fAppMapSupport = new AppMapSupportClass();
        }
        this.fAppMapSupport.fAppMapParent = fAppMapParent;
        this.fAppMapSupport.fProvider = provider;
    }

    public InvocationData getAppMapParent() {
        return this.fAppMapSupport.fAppMapParent;
    }

    public void ensureCrossProcessCache() {
        if (this.fCrossProcessCache == null) {
            this.fCrossProcessCache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        }
    }

    public void setContainsFrontendTracer(boolean fContainsFrontendTracer) {
        this.fContainsFrontendTracer = fContainsFrontendTracer;
    }

    @Override
    public ITransactionElement getStartTransactionElement() {
        return this.fCacheProvider.getCurrentCache().getStartTransactionElement();
    }

    @Override
    public void setStartTransactionElement(ITransactionElement element) {
        this.fCacheProvider.getCurrentCache().setStartTransactionElement(element);
    }

    public static void setCacheHelper(ITransactionCacheProviderFactory factory) {
        fFactory = factory;
    }

    public static ITransactionCacheProviderFactory getCacheHelper() {
        return fFactory;
    }

    public static boolean isFrontendMarkedForThisThread() {
        ITransactionCacheProvider cacheProvider;
        if (fFactory != null && (cacheProvider = fFactory.getProvider()) != null) {
            return cacheProvider.getCurrentCache().getFrontend() != null;
        }
        return false;
    }

    public final Object putInTransactionCache(Object key, Object value) {
        return this.fCacheProvider.getCurrentCache().putInCache(key, value);
    }

    public final Object getFromTransactionCache(Object key) {
        return this.fCacheProvider.getCurrentCache().getFromCache(key);
    }

    @Override
    public List getTransactionInstanceList() {
        return this.fCacheProvider.getCurrentCache().getTransactionInstanceList();
    }

    @Override
    public TransactionCollectStatus getTransactionCollectionStatus() {
        return this.fCacheProvider.getCurrentCache().getTransactionCollectionStatus();
    }

    @Override
    public void setTransactionCollectStatus(TransactionCollectStatus tcs) {
        this.fCacheProvider.getCurrentCache().setTransactionCollectStatus(tcs);
    }

    @Override
    public IStallPoint getStallPoint() {
        return this.fCacheProvider.getCurrentCache().getStallPoint();
    }

    public int getThreadHashCode() {
        return this.fCacheProvider.getCurrentCache().getThreadHashCode();
    }

    public ITransactionCacheProvider getVirtualCursor() {
        return this.fCacheProvider;
    }

    @Override
    public void setMarkedForDiscoveryTrace(boolean discoveryTrace) {
        this.fCacheProvider.getCurrentCache().setMarkedForDiscoveryTrace(discoveryTrace);
    }

    @Override
    public boolean isMarkedForDiscoveryTrace() {
        return this.fCacheProvider.getCurrentCache().isMarkedForDiscoveryTrace();
    }

    @Override
    public boolean isTransactionAborted() {
        if (this.fTes != null) {
            return this.fTes.isTransactionAborted();
        }
        return false;
    }

    @Override
    public void notifyStackElementOfNewCrossCorrelation(Object key) {
        this.fCacheProvider.getCurrentCache().notifyStackElementOfNewCrossCorrelation(key);
    }

    public void submitForLateCrossCorrelationNotification() {
        if (!this.fCacheProvider.getCurrentCache().isCorrelationIdWasInvoked()) {
            this.fCacheProvider.getCurrentCache().addStackElementForNotificationOnCrossCorrelation(this);
        }
    }

    public boolean hasSandwich() {
        return this.fTes.hasSandwich();
    }

    public void setEmergencyMode() {
        this.fTes = EmergencyTransactionSupportClass.kEmergencyTes;
    }

    @Override
    public final void setSustainabilityTrace(ISustainabilityServiceTrace trace) {
        this.sustainabilityTrace = trace;
        trace.setProbeInfo(this.getProbeInformation());
    }

    public final void initializeForSpecialTimes() {
        this.st = new SpecialTimes();
        this.st.fCPUFinishTime = -1L;
        this.st.fCPUFinishTimeNanos = -1L;
        this.st.fCPUStartTime = -1L;
        this.st.fCPUStartTimeNanos = -1L;
        this.st.fWallClockFinishTimeNanos = -1L;
        this.st.fWallClockStartTimeNanos = -1L;
    }

    public final void initializeForTransactionElements(boolean isOldMode, boolean hasSandwich) {
        if (!isOldMode) {
            this.fTes = new TransactionElementSupportClass();
            this.fTes.setHasSandwich(hasSandwich);
            this.setMyThread(this.fCacheProvider.getCurrentCache().getThread());
        }
    }

    public boolean hasASPSupport() {
        return false;
    }

    public boolean hasServletSupport() {
        return this.servletSupport != null;
    }

    public void setServletSupport(Object request, Object servlet, IHttpRequestHelper helper, LoaderContext context, Map cacheParameterMap, LazyMap.ILazyMapProvider provider, LazyMap map) {
        this.servletSupport = new ServletSupportClass(request, servlet, helper, context, cacheParameterMap, provider, map);
    }

    public ServletSupportClass getServletSupport() {
        return this.servletSupport;
    }

    public Map getServletParameterMap() {
        return this.servletSupport == null ? null : this.servletSupport.servletParametersMap;
    }

    public void setServletSupportInTransactionCache(ServletSupportClass support) {
        this.fCacheProvider.getCurrentCache().setServletSupport(support);
    }

    public boolean isSocketClamped() {
        return this.socketClamped;
    }

    public void setSocketClamp(boolean clamp) {
        this.socketClamped = clamp;
    }

    public AutoTracingCollectStatus getAutoTracingCollectStatus() {
        return this.fCacheProvider.getCurrentCache().getAutoTracingCollectStatus();
    }

    public void setAutoTracingCollectStatus(AutoTracingCollectStatus aTCS) {
        this.fCacheProvider.getCurrentCache().setAutoTracingCollectStatus(aTCS);
    }

    @Override
    public boolean IMethodTracer_shouldStub() {
        return this.fShouldStub;
    }

    @Override
    public void IMethodTracer_setShouldStub(boolean flag) {
        this.fShouldStub = flag;
        if (flag) {
            this.releaseTracers();
            int i = 0;
            while (i < this.fTracers.length) {
                this.fTracers[i] = null;
                ++i;
            }
        }
    }

    public boolean IMethodTracer_shouldReportAllocatedBytesMetric() {
        return this.shouldReportAllocatedBytes;
    }

    public void IMethodTracer_setShouldReportAllocatedBytesMetric(boolean flag) {
        this.shouldReportAllocatedBytes = flag;
    }

    public boolean IMethodTracer_shouldDecorateCPUTiming() {
        return this.shouldDecorateCPUTiming;
    }

    public void IMethodTracer_setShouldDecorateCPUTiming(boolean flag) {
        this.shouldDecorateCPUTiming = flag;
    }

    @Override
    public void IMethodTracer_setReentrancyOverwrite(boolean flag) {
        this.fThreadLocal.reentrancyOverwrite = flag;
    }

    private boolean checkForNoneOverheadMode() {
        return OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }

    static class AppMapSupportClass {
        CrossCorrelationStringParameterProvider fProvider;
        volatile InvocationData fAppMapParent;

        AppMapSupportClass() {
        }
    }

    static abstract class BaseTransactionElementSupportClass {
        volatile Runnable fMyThread;
        private boolean fHasSandwich;

        BaseTransactionElementSupportClass() {
        }

        abstract boolean isTransactionAborted();

        public final void setMyThread(Runnable thread) {
            this.fMyThread = thread;
        }

        public final Runnable getMyThread() {
            return this.fMyThread;
        }

        public void setHasSandwich(boolean hasSandwich) {
            this.fHasSandwich = hasSandwich;
        }

        public boolean hasSandwich() {
            return this.fHasSandwich;
        }

        public abstract int getStartCursorsCount();

        public abstract ITransactionElement getStartCursorAt(int var1);

        public abstract Iterator getStartCursorsIterator();

        public abstract void setStartCursorAt(ITransactionElement var1, int var2);

        public abstract int getStartInstancePositionAt(int var1);

        public abstract void setStartInstancePositionAt(int var1, int var2);

        public abstract ITransactionElement getCursor();

        public abstract void setCursor(ITransactionElement var1);

        public abstract ITransactionElement getLastFrontendCursor();

        public abstract void setLastFrontendCursor(ITransactionElement var1);

        public abstract boolean hasNewAppMapCursor();

        public abstract void setHasNewCursor();

        public abstract void setStartedBlame(int var1);

        public abstract boolean hasBeenPushedAlready();

        public abstract boolean startedTransaction(int var1);

        public abstract boolean startedBlame(int var1);

        public abstract int getTransactionStatus(int var1);
    }

    static class EmergencyTransactionSupportClass
    extends BaseTransactionElementSupportClass {
        public static final EmergencyTransactionSupportClass kEmergencyTes = new EmergencyTransactionSupportClass();

        EmergencyTransactionSupportClass() {
        }

        @Override
        public boolean isTransactionAborted() {
            return true;
        }

        @Override
        public ITransactionElement getLastFrontendCursor() {
            return null;
        }

        @Override
        public void setLastFrontendCursor(ITransactionElement frontend) {
        }

        @Override
        public boolean hasNewAppMapCursor() {
            return false;
        }

        @Override
        public void setHasNewCursor() {
        }

        @Override
        public int getStartCursorsCount() {
            return 0;
        }

        @Override
        public ITransactionElement getStartCursorAt(int index) {
            return null;
        }

        @Override
        public Iterator getStartCursorsIterator() {
            return null;
        }

        @Override
        public void setStartCursorAt(ITransactionElement cursor, int index) {
        }

        @Override
        public int getStartInstancePositionAt(int tracerIndex) {
            return 0;
        }

        @Override
        public void setStartInstancePositionAt(int position, int index) {
        }

        @Override
        public ITransactionElement getCursor() {
            return null;
        }

        @Override
        public void setCursor(ITransactionElement e) {
        }

        @Override
        public void setStartedBlame(int tracer) {
        }

        @Override
        public boolean hasBeenPushedAlready() {
            return false;
        }

        @Override
        public boolean startedTransaction(int tracerIndex) {
            return false;
        }

        @Override
        public boolean startedBlame(int tracerIndex) {
            return false;
        }

        @Override
        public int getTransactionStatus(int tracerIndex) {
            return 0;
        }
    }

    public static final class ExecuteOnEndTrace
    implements ICallbackOnEndTrace {
        @Override
        public final void executeOnEndTransaction(InvocationData data, InvocationDataThreadLocal dataInfo) {
            data.cleanupReentrancyTracking(dataInfo);
        }

        @Override
        public void executeOnFinally(InvocationData data, InvocationDataThreadLocal dataInfo) {
        }
    }

    public static final class ExecuteOnEndTransactionTrace
    implements ICallbackOnEndTrace {
        @Override
        public final void executeOnEndTransaction(InvocationData data, InvocationDataThreadLocal dataInfo) {
            data.cleanupReentrancyTracking(dataInfo);
            SharedCrossProcessData cache = data.getSharedCrossProcessData();
            if (cache != null) {
                cache.clear();
            } else {
                CrossProcessCorrelationAdmin.invalidateCrossProcessDataCache();
            }
        }

        @Override
        public void executeOnFinally(InvocationData data, InvocationDataThreadLocal dataInfo) {
        }
    }

    private static interface ICallbackOnEndTrace {
        public void executeOnFinally(InvocationData var1, InvocationDataThreadLocal var2);

        public void executeOnEndTransaction(InvocationData var1, InvocationDataThreadLocal var2);
    }

    public static interface IPostfinishTraceCallback {
        public void doPostFinishCallback(InvocationData var1);
    }

    public static class InvocationDataThreadLocal {
        boolean reentrant;
        IdentityHashSet instanceSet;
        TwoObjectIdentityHashSet methodSet;
        Object fHighPerformanceIntelligenceStackElementVirtualStack;
        boolean reentrancyOverwrite;
    }

    public static class ServletSupportClass {
        public LazyMap servletParametersMap;
        public Object request;
        public Object servlet;
        private Map cacheAttributeRequestMap;
        public IHttpRequestHelper helper;
        private LazyMap.ILazyMapProvider provider;
        private LoaderContext context;
        public String appName;

        public ServletSupportClass(Object frequest, Object fservlet, IHttpRequestHelper fhelper, LoaderContext fcontext, Map fcacheParameterMap, LazyMap.ILazyMapProvider fprovider, LazyMap map) {
            this.request = frequest;
            this.servlet = fservlet;
            this.helper = fhelper;
            this.context = fcontext;
            this.cacheAttributeRequestMap = fcacheParameterMap;
            this.provider = fprovider;
            this.servletParametersMap = map;
        }
    }

    static class SpecialTimes {
        long fWallClockStartTimeNanos;
        long fWallClockFinishTimeNanos;
        long fCPUStartTime;
        long fCPUFinishTime;
        long fCPUStartTimeNanos;
        long fCPUFinishTimeNanos;

        SpecialTimes() {
        }
    }

    class TransactionElementSupportClass
    extends BaseTransactionElementSupportClass {
        final int fSize;
        ITransactionElement[] fStartCursors;
        int[] fStartInstancePosition;
        ITransactionElement fCursor;
        ITransactionElement fLastFrontend;
        boolean kHasDefaultBackend;
        int fStartedTransactionTracer = -1;

        public TransactionElementSupportClass() {
            this.fSize = InvocationData.this.getProbeInformation().getTracerFactories().length;
        }

        @Override
        public boolean isTransactionAborted() {
            if (InvocationData.this.fCacheProvider == null) {
                if (this.fCursor == null) {
                    return false;
                }
                return this.fCursor.isNotValid();
            }
            if (InvocationData.this.fCacheProvider.getCurrentCache().isTransactionAborted()) {
                return true;
            }
            if (this.fCursor == null) {
                return false;
            }
            return this.fCursor.isNotValid();
        }

        @Override
        public final int getStartCursorsCount() {
            if (this.fStartCursors == null) {
                this.fStartCursors = new ITransactionElement[this.fSize];
            }
            return this.fSize;
        }

        @Override
        public final ITransactionElement getStartCursorAt(int index) {
            if (this.fStartCursors == null) {
                this.fStartCursors = new ITransactionElement[this.fSize];
            }
            return this.fStartCursors[index];
        }

        @Override
        public final Iterator getStartCursorsIterator() {
            if (this.fStartCursors == null) {
                this.fStartCursors = new ITransactionElement[this.fSize];
            }
            return Arrays.asList(this.fStartCursors).iterator();
        }

        @Override
        public final void setStartCursorAt(ITransactionElement cursor, int index) {
            if (this.fStartCursors == null) {
                this.fStartCursors = new ITransactionElement[this.fSize];
            }
            this.fStartCursors[index] = cursor;
            this.setCursor(cursor);
        }

        @Override
        public final int getStartInstancePositionAt(int tracerIndex) {
            if (this.fStartInstancePosition != null) {
                return this.fStartInstancePosition[tracerIndex];
            }
            return 0;
        }

        @Override
        public final void setStartInstancePositionAt(int position, int index) {
            if (this.fStartInstancePosition == null) {
                this.fStartInstancePosition = new int[this.fSize];
            }
            this.fStartInstancePosition[index] = position;
        }

        @Override
        public final ITransactionElement getCursor() {
            return this.fCursor;
        }

        @Override
        public final void setCursor(ITransactionElement e) {
            this.fCursor = e;
        }

        @Override
        public final ITransactionElement getLastFrontendCursor() {
            return this.fLastFrontend;
        }

        @Override
        public final void setLastFrontendCursor(ITransactionElement frontend) {
            this.fLastFrontend = frontend;
        }

        @Override
        public final boolean hasNewAppMapCursor() {
            return this.kHasDefaultBackend;
        }

        @Override
        public final void setHasNewCursor() {
            this.kHasDefaultBackend = true;
        }

        @Override
        public final void setStartedBlame(int tracer) {
            if (this.fStartedTransactionTracer < 0) {
                this.fStartedTransactionTracer = tracer;
            }
        }

        @Override
        public final boolean hasBeenPushedAlready() {
            return this.fStartedTransactionTracer >= 0;
        }

        @Override
        public final boolean startedTransaction(int tracerIndex) {
            return InvocationData.this.fStartedTransaction && tracerIndex == this.fStartedTransactionTracer;
        }

        @Override
        public final boolean startedBlame(int tracerIndex) {
            return tracerIndex == this.fStartedTransactionTracer;
        }

        @Override
        public final int getTransactionStatus(int tracerIndex) {
            if (tracerIndex == this.fStartedTransactionTracer) {
                if (InvocationData.this.fStartedTransaction) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
    }
}

