/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncComponent;
import com.wily.introscope.agent.async.AsyncComponentInstance;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.IAsyncMetricProvider;
import com.wily.introscope.agent.async.IAsyncMetricUpdater;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.filter.SamplingInput;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProvider;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.hc2.WilyStartTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampHelper;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.trace.intelligent.AutoTracingHelper;
import com.wily.introscope.agent.trace.intelligent.DiscoveryTracingEnabledProperty;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import com.wily.util.adt.ConcurrentMapFactory;
import com.wily.util.adt.ICappedMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AsyncVirtualStack {
    protected IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncVirtualStack");
    static final String ASYN_THREAD_CORRELATION_FRONTEND_INFO = "asyn.thread.correlation.frontend.info";
    static final String ASYN_THREAD_CORRELATION_BACKEND_INFO = "asyn.thread.correlation.backend.info";
    static final String STALLED_TRANSACTION = "Stalled Transaction";
    static final String ABORTED_TRANSACTION = "Transaction aborted due to timeout.";
    private static final Object nullObject = new Object();
    public static final String FRONTEND_COMPONENT = "Frontend component";
    public static final String BACKEND_COMPONENT = "Backend component";
    public static volatile long disoveryTraceAgingPeriod = 3600000L;
    private final IAgent agent;
    private ConcurrentMapFactory factory = null;
    private static final String kAsyncComponentMapName = "AsyncComponentMap";
    private static final String kAsyncComponentInstanceMapName = "AsyncComponentInstanceMap";
    private static final String kAsyncTransactionTraceSupressEmptyFragments = "introscope.agent.async.transactiontrace.supress.empty";
    private static volatile boolean bSupressEmptyFragmentTracing = true;
    private static final String kFragmentsByFrontendPropertyKey = "introscope.agent.async.fragments.by.frontend";
    private static volatile boolean fragmentsByFrontends = false;
    private static final String kFragmentsAsFrontendPropertyKey = "introscope.agent.async.fragments.as.frontend";
    private static volatile boolean fragmentsAsFrontends = false;
    private final ConcurrentHighPerformanceLRUHashMap<String, AsyncComponent> asyncComponents;
    private final ConcurrentHighPerformanceLRUHashMap<Long, AsyncComponentInstance> asyncComponentInstances;
    private static GUIDGenerator guidGenerator = GUIDGenerator.getInstance();
    public boolean sampled;
    private static AtomicReference<AsyncVirtualStack> instance = new AtomicReference<Object>(null);

    public static AsyncVirtualStack getInstance(IAgent agent) {
        AsyncVirtualStack processor = instance.get();
        if (processor == null) {
            ConfigurationManager cm;
            if (instance.compareAndSet(null, new AsyncVirtualStack(agent)) && (cm = agent.IAgent_getConfigurationManager()) != null) {
                AsyncVirtualStack.defineConfigurationProperties(cm, agent.IAgent_getModule(), agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
            }
            processor = instance.get();
        }
        return processor;
    }

    private AsyncVirtualStack(IAgent agent) {
        this.feedback = agent.IAgent_getModuleFeedback();
        this.factory = (ConcurrentMapFactory)agent.IAgent_getConcurrentMapFactory();
        ConcurrentMapFactory.ConcurrentMapPolicy p = new ConcurrentMapFactory.ConcurrentMapPolicy(kAsyncComponentMapName, ConcurrentMapFactory.ConcurrentMapType.Capped, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, 1000, 0, 0.75f, 1000, 0);
        IntervalHeartbeat beat = agent.IAgent_getCommonHeartbeat();
        this.factory.addMapPolicy(kAsyncComponentMapName, p, this.feedback, beat);
        this.asyncComponents = this.factory.getConcurrentCappedHashMap(kAsyncComponentMapName);
        p = new ConcurrentMapFactory.ConcurrentMapPolicy(kAsyncComponentInstanceMapName, ConcurrentMapFactory.ConcurrentMapType.Capped, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, 1000, 0, 0.75f, 1000, 0);
        this.factory.addMapPolicy(kAsyncComponentInstanceMapName, p, this.feedback, beat);
        this.asyncComponentInstances = this.factory.getConcurrentCappedHashMap(kAsyncComponentInstanceMapName);
        this.agent = agent;
        FilterController.addSupressTraceFilter(new FilterController.ISupressTraceFilter(){

            @Override
            public boolean isTraceSupressed(List<WilyTransactionInstance> trace, TransactionCollectStatus tcs) {
                WilyTransactionElement element;
                WilyStartTransactionInstance start;
                ITransactionElement e;
                if (!bSupressEmptyFragmentTracing) {
                    return false;
                }
                WilyTransactionInstance root = trace.get(0);
                if (root instanceof WilyStartTransactionInstance && (e = (start = (WilyStartTransactionInstance)root).getTransactionElement()) instanceof WilyTransactionElement && (element = (WilyTransactionElement)e).getComponentName().startsWith("Fragments|")) {
                    int i = 1;
                    while (i < trace.size()) {
                        WilyTransactionInstance instance = trace.get(i);
                        if (instance instanceof WilyStartTransactionInstance) {
                            WilyTransactionElement current;
                            ITransactionElement e2 = ((WilyStartTransactionInstance)instance).getTransactionElement();
                            if (e instanceof WilyTransactionElement && !(current = (WilyTransactionElement)e2).getComponentName().startsWith("Handovers|")) {
                                return false;
                            }
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected String calculateDiscoveryKey(TransactionComponentData root) {
        return root.getResource();
    }

    protected String calculateDiscoveryKey(AsyncComponentInstance instance) {
        return instance.info.componentName;
    }

    public AsyncTransactionContext.AsyncComponentInvocation pushFrontend(String componentName, InvocationData data, IAsyncMetricProvider metricProvider) {
        AsyncTransactionContext.AsyncComponentInvocation info = new AsyncTransactionContext.AsyncComponentInvocation();
        ThreadCorrelationId corrid = new ThreadCorrelationId();
        SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        info.callerTxId = cache.getStringParamIn("TxnTraceId");
        info.callerComponentID = cache.getStringParamIn("Caller Component ID");
        info.transactionId = CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot(data);
        if (info.transactionId == null) {
            CrossProcessCorrelationAdmin.prepForNewTransaction(this.agent, data);
            info.transactionId = CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot(data);
        }
        info.correlationGuid = cache.getCorrelationID();
        info.componentName = componentName;
        info.frontendInfo = null;
        SharedCrossProcessData outgoingCorId = corrid.getOutgoingNonSerializedCrossProcessData();
        cache.removeParamOut("TxnTraceId");
        corrid = new ThreadCorrelationId(outgoingCorId);
        return this.push(componentName, info, data, metricProvider);
    }

    public AsyncTransactionContext.AsyncComponentInvocation pushBackend(String componentName, InvocationData data, IAsyncMetricProvider metricProvider) {
        AsyncTransactionContext.AsyncComponentInvocation info = new AsyncTransactionContext.AsyncComponentInvocation();
        SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        info.callerTxId = CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot(data);
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        if (frontendInfo != null) {
            info.frontendInfo = frontendInfo;
        } else {
            frontendInfo = this.createSyncFrontendInfo(data);
        }
        info.frontendInfo = frontendInfo;
        info.transactionId = guidGenerator.generateKey();
        info.componentName = componentName;
        info.correlationGuid = cache.getCorrelationID();
        return this.push(componentName, info, data, metricProvider);
    }

    public AsyncTransactionContext.AsyncComponentInvocation push(String componentName, AsyncTransactionContext.AsyncComponentInvocation info, InvocationData data, IAsyncMetricProvider metricProvider) {
        data.storeWallClockStartTime();
        info.componentId = data.getInvocationId();
        AsyncComponent component = this.asyncComponents.get(componentName);
        if (component == null) {
            component = new AsyncComponent();
            component.metrics = metricProvider.constructAsyncComponentMetrics(info.componentName);
            this.registerMetrics(info.componentName, component.metrics);
            AsyncComponent already_exists = this.asyncComponents.putIfAbsent(componentName, component);
            if (already_exists != null) {
                component = already_exists;
            }
        }
        AsyncComponentInstance instance = new AsyncComponentInstance();
        instance.startTime = data.getWallClockStartTime();
        instance.component = component;
        instance.info = info;
        instance.metricProvider = metricProvider;
        metricProvider.updateAsyncComponentMetricsAtStart(component.metrics, instance.startTime);
        this.asyncComponentInstances.putIfAbsent(info.componentId, instance);
        if (DiscoveryTracingEnabledProperty.discoveryTracingEnabled) {
            long lastSent = component.discoveryStamp;
            long now = System.currentTimeMillis();
            if (lastSent == 0L || lastSent + disoveryTraceAgingPeriod < now) {
                this.markForDiscoveryTrace(info, info.componentName);
                component.discoveryStamp = now;
                if (info.frontendInfo != null && !info.frontendInfo.markedForAutoTrace) {
                    this.markForDiscoveryTrace(info.frontendInfo, info.componentName);
                }
                AutoTracingController.markForPriorityAutoTracing(data, "New transaction path discovered", info.componentName);
                data.setMarkedForDiscoveryTrace(true);
            }
        }
        return info;
    }

    public void markSampled(AsyncTransactionContext.AsyncComponentInvocation info, ISamplingResult sampled) {
        info.sampled = sampled;
        this.feedback.debug(ISamplingResult.kSamplingModule, "Set sampled=" + sampled + " to AsyncComponentInvocation");
    }

    public void pop(AsyncTransactionContext.AsyncComponentInvocation info, InvocationData data, IAsyncMetricUpdater metricUpdater) {
        AsyncComponentInstance instance = this.asyncComponentInstances.remove(info.componentId);
        if (instance == null) {
            return;
        }
        AsyncComponent component = instance.component;
        if (component != null) {
            long finishTime = data.getWallClockFinishTime();
            metricUpdater.updateAsyncComponentMetricsAtEnd(component.metrics, instance.startTime, finishTime, instance.stallReported);
            this.createComponentTrace(instance, info, finishTime);
        }
    }

    private void registerMetrics(String componentName, AsyncMetricHolder[] metrics) {
        ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>(5);
        int i = 0;
        while (i < metrics.length) {
            metrics[i].sds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(metrics[i].metric), metrics[i].sds);
            metricsForGrouping.add(metrics[i].metric[0]);
            ++i;
        }
        this.agent.IAgent_getMetricRecordingAdministrator().addMetricGroup(componentName, metricsForGrouping);
    }

    public CorrelationId createCorrelationIdForComponent(AsyncTransactionContext.AsyncComponentInvocation info) {
        SharedCrossProcessData current = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        String correlationGuid = current.getCorrelationID();
        if (correlationGuid == null) {
            new CorrelationId();
        }
        SharedCrossProcessData cache = SharedCrossProcessData.createNewInstance(current);
        cache.addParamOut("TxnTraceId", info.transactionId);
        CorrelationId corId = new CorrelationId(cache);
        return corId;
    }

    private void createComponentTrace(AsyncComponentInstance instance, AsyncTransactionContext.AsyncComponentInvocation info, long finishTime) {
        String component = instance.info.componentName;
        long startTime = instance.startTime;
        long duration = finishTime - startTime;
        String corid = info.correlationGuid;
        String txId = info.transactionId;
        String callerTxId = info.callerTxId;
        String frontendTransactionId = null;
        String frontendComponentName = null;
        if (info.frontendInfo != null) {
            frontendTransactionId = info.frontendInfo.transactionId;
            frontendComponentName = info.frontendInfo.componentName;
        }
        String callerComponentID = info.callerComponentID;
        HashMap<String, String> params = new HashMap<String, String>();
        if (instance.parameters != null) {
            params.putAll(instance.parameters);
        }
        if (instance.stallReported) {
            params.put("Error Message", STALLED_TRANSACTION);
        }
        if (instance.errorMessage != null) {
            params.put("Error Message", instance.errorMessage);
        }
        params.put("Trace Type", "Normal");
        params.put("CorCrossProcessData", corid);
        params.put("TxnTraceId", txId);
        if (callerTxId != null) {
            params.put("CallerTxnTraceId", callerTxId);
        }
        if (frontendTransactionId != null) {
            params.put("FrontendTxnTraceId", frontendTransactionId);
        }
        params.put("Component ID", "1");
        if (callerComponentID != null) {
            params.put("Caller Component ID", callerComponentID);
        }
        TransactionComponentData root = TransactionComponentData.createMilliSecTransactionComponentData(component, startTime, duration, params, TransactionComponentData.kNoCalledComponents);
        if (AsyncVirtualStack.reportFragmentsAsFrontend() && component.startsWith("Backends")) {
            TransactionComponentData backend = root;
            root = TransactionComponentData.createMilliSecTransactionComponentData("Frontends|asyncBackendCall|" + frontendComponentName.substring(10) + "|" + component, startTime, duration, params, new TransactionComponentData[]{backend});
        }
        boolean shouldTrace = false;
        if (AutoTracingHelper.sAutoTracingEnabled && (info.markedForAutoTrace || info.frontendInfo != null && info.frontendInfo.markedForAutoTrace) && (shouldTrace = AutoTracingClampHelper.checkPriorityClampAndIncrement())) {
            String reason = info.autoTraceReason;
            String compId = info.autoTraceComponent;
            if (reason == null) {
                reason = info.frontendInfo.autoTraceReason;
                compId = info.frontendInfo.autoTraceComponent;
            }
            if (AutoTracingController.useDetailedTriggerReasonInTrace() && compId != null) {
                reason = String.valueOf(reason) + " [" + compId + "]";
            }
            root.setParameterValue("Autotrace Trigger Criteria", reason);
            root.setParameterValue("Trace Reason", "Autotrace");
        }
        this.processTransactionTrace(root, shouldTrace, info.sampled);
    }

    private void createErrorSnapshot(AsyncComponentInstance instance, long time) {
        String component = instance.info.componentName;
        AsyncTransactionContext.AsyncComponentInvocation info = instance.info;
        long startTime = instance.startTime;
        long duration = time - startTime;
        String corid = info.correlationGuid;
        String txId = info.transactionId;
        String callerTxId = info.callerTxId;
        String frontendTransactionId = null;
        if (info.frontendInfo != null) {
            frontendTransactionId = info.frontendInfo.transactionId;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (instance.stallReported) {
            params.put("Error Message", STALLED_TRANSACTION);
        }
        if (instance.errorMessage != null) {
            params.put("Error Message", instance.errorMessage);
        }
        params.put("Trace Type", "ErrorSnapshot");
        params.put("CorCrossProcessData", corid);
        params.put("TxnTraceId", txId);
        if (callerTxId != null) {
            params.put("CallerTxnTraceId", callerTxId);
        }
        if (frontendTransactionId != null) {
            params.put("FrontendTxnTraceId", frontendTransactionId);
        }
        TransactionComponentData root = TransactionComponentData.createMilliSecTransactionComponentData(component, startTime, duration, params, TransactionComponentData.kNoCalledComponents);
        this.agent.IAgent_queueEvent(root);
    }

    private void processTransactionTrace(final TransactionComponentData root, boolean shouldTrace, ISamplingResult sample) {
        if (!shouldTrace) {
            shouldTrace = FilterController.pessimisticLegacyFiltersExecute(root);
        }
        if (shouldTrace) {
            sample.determineSampling(SamplingInput.wrap(root), ISamplingResult.Callback.NO_OP_CALLBACK);
            TransactionComponentData root0 = this.realizeBizDefIfNeeded(root);
            root0.setParameterValue("Trace Type", "Normal");
            this.agent.IAgent_queueEvent(root0);
            return;
        }
        this.feedback.debug(ISamplingResult.kSamplingModule, "Trying to determine sampling for tcd=" + root + ", sample=" + sample + ", shouldTrace=" + shouldTrace);
        if (sample == null) {
            sample = ISamplingResult.NO;
        }
        sample.determineSampling(SamplingInput.wrap(root), new ISamplingResult.Callback(){

            @Override
            public void onSamplingDetermined(ISamplingResult.Answer answer) {
                AsyncVirtualStack.this.feedback.debug(ISamplingResult.kSamplingModule, "Sampling for tcd=" + root + " is determined " + answer);
                switch (answer.choice) {
                    case MAYBE: {
                        return;
                    }
                    case NO: {
                        return;
                    }
                    case YES: {
                        TransactionComponentData root0 = AsyncVirtualStack.this.realizeBizDefIfNeeded(root);
                        root0.setParameterValue("Trace Type", "Sampled");
                        if (answer.byWho != null) {
                            root0.setParameterValue("Trace Reason", answer.byWho);
                        }
                        AsyncVirtualStack.this.agent.IAgent_queueEvent(root0);
                        return;
                    }
                }
            }
        });
    }

    private TransactionComponentData realizeBizDefIfNeeded(TransactionComponentData root) {
        if (root.getParameterValue("Business Definition") == null) {
            return root;
        }
        root.tempChildren = new ArrayList();
        TransactionComponentData bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(root);
        if (bizDefComponent == null) {
            return root;
        }
        HighPerformanceIntelligentStackHelper.realizeSubcomponent(bizDefComponent);
        return bizDefComponent;
    }

    private void markForDiscoveryTrace(AsyncTransactionContext.AsyncComponentInvocation info, String component) {
        this.markForAutoTracing(info, "New transaction path discovered", component, true);
    }

    private void markForAutoTracing(AsyncTransactionContext.AsyncComponentInvocation info, String reason, String component, boolean priority) {
        if (info != null) {
            info.markedForAutoTrace = true;
            info.autoTraceReason = reason;
            info.autoTraceComponent = component;
            info.isPriorityAutoTrace = priority;
        }
    }

    private void markFrontendForAutoTracing(InvocationData data, String reason, String component, boolean priority) {
        AsyncTransactionContext.AsyncComponentInvocation info = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        this.markForAutoTracing(info, reason, component, priority);
    }

    public String getFrontendTxIdInCurrentThread(InvocationData data) {
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        String frontend = virtualCursor.getCurrentCache().getFrontend();
        if (frontend != null && !frontend.startsWith("Fragments|")) {
            String transactionId = CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot(data);
            return transactionId;
        }
        return null;
    }

    public String getFrontendNameInCurrentThread(InvocationData data) {
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        String frontend = virtualCursor.getCurrentCache().getFrontend();
        if (frontend != null && !frontend.startsWith("Fragments|")) {
            return frontend;
        }
        return null;
    }

    public AsyncTransactionContext.AsyncComponentInvocation createSyncFrontendInfo(InvocationData data) {
        String frontendTxId = this.getFrontendTxIdInCurrentThread(data);
        if (frontendTxId != null) {
            AsyncTransactionContext.AsyncComponentInvocation frontendInfo = new AsyncTransactionContext.AsyncComponentInvocation();
            frontendInfo.isSynchronousFrontend = true;
            frontendInfo.transactionId = frontendTxId;
            frontendInfo.componentName = this.getFrontendNameInCurrentThread(data);
            this.putAsyncFrontendInfoToTransactionCache(data, frontendInfo);
            return frontendInfo;
        }
        return null;
    }

    public static AsyncTransactionContext.AsyncComponentInvocation getAsyncFrontendInfoFromTransactionCache(InvocationData data) {
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        Object result = virtualCursor.getCurrentCache().getFromCache(ASYN_THREAD_CORRELATION_FRONTEND_INFO);
        if (result == nullObject) {
            return null;
        }
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = (AsyncTransactionContext.AsyncComponentInvocation)result;
        return frontendInfo;
    }

    public void putAsyncFrontendInfoToTransactionCache(InvocationData data, AsyncTransactionContext.AsyncComponentInvocation frontendInfo) {
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        ITransactionCache tc = virtualCursor.getCurrentCache();
        tc.putInCache(ASYN_THREAD_CORRELATION_FRONTEND_INFO, frontendInfo);
    }

    public AsyncTransactionContext.AsyncComponentInvocation getAsyncBackendInfoFromTransactionCache(InvocationData data) {
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        Object result = virtualCursor.getCurrentCache().getFromCache(ASYN_THREAD_CORRELATION_BACKEND_INFO);
        if (result == nullObject) {
            return null;
        }
        AsyncTransactionContext.AsyncComponentInvocation info = (AsyncTransactionContext.AsyncComponentInvocation)result;
        return info;
    }

    public void putAsyncBackendInfoToTransactionCache(InvocationData data, AsyncTransactionContext.AsyncComponentInvocation backendInfo) {
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        virtualCursor.getCurrentCache().putInCache(ASYN_THREAD_CORRELATION_BACKEND_INFO, backendInfo);
    }

    public void clearAsyncBackendInfoToTransactionCache(InvocationData data) {
        ITransactionCacheProvider virtualCursor = data.getVirtualCursor();
        virtualCursor.getCurrentCache().putInCache(ASYN_THREAD_CORRELATION_BACKEND_INFO, nullObject);
    }

    public static void decorateComponentWithError(InvocationData data, String errMsg) {
        AsyncVirtualStack stack = instance.get();
        if (stack != null) {
            stack.decorateAsyncStackWithError(data, errMsg);
        }
    }

    public static void markForAutoTracing(InvocationData data, String reason, String component, boolean priority) {
        AsyncVirtualStack stack = instance.get();
        if (stack != null) {
            stack.markFrontendForAutoTracing(data, reason, component, priority);
        }
    }

    public void decorateAsyncStackWithError(InvocationData data, String errMsg) {
        AsyncTransactionContext.AsyncComponentInvocation info = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        if (info != null) {
            this.decorateComponentWithError(info, errMsg, data.getWallClockTime());
        }
        if ((info = this.getAsyncBackendInfoFromTransactionCache(data)) != null) {
            this.decorateComponentWithError(info, errMsg, data.getWallClockTime());
        }
    }

    public void decorateComponentWithError(AsyncTransactionContext.AsyncComponentInvocation info, String errMsg, long time) {
        AsyncComponentInstance instance = this.asyncComponentInstances.get(info.componentId);
        if (instance == null) {
            return;
        }
        if (instance.errorMessage != null && instance.errorMessage.equals(errMsg)) {
            return;
        }
        instance.errorMessage = errMsg;
        AsyncComponent component = instance.component;
        if (component == null) {
            return;
        }
        instance.metricProvider.updateAsyncComponentMetricsAtError(component.metrics, time);
        this.createErrorSnapshot(instance, time);
    }

    public static void runStallCheck(long stallThreshold, long transactionAbortThreshold) {
        AsyncVirtualStack stack = instance.get();
        if (stack != null) {
            stack.stallCheck(stallThreshold, transactionAbortThreshold);
        }
    }

    public void stallCheck(long stallThreshold, final long transactionAbortThreshold) {
        final long nowInMillis = System.currentTimeMillis();
        final long stalledStart = nowInMillis - stallThreshold;
        final long abosrtStart = nowInMillis - transactionAbortThreshold;
        final ArrayList abortedComponents = new ArrayList();
        this.asyncComponentInstances.iterateThrougEntries(new ICappedMap.IOperateOnEntry(){

            @Override
            public void doOnEntry(Map.Entry entry) {
                Long id = (Long)entry.getKey();
                AsyncComponentInstance instance = (AsyncComponentInstance)entry.getValue();
                if (instance == null) {
                    if (id != null) {
                        abortedComponents.add(id);
                    }
                    return;
                }
                if (instance.startTime < stalledStart && !instance.stallReported) {
                    instance.stallReported = true;
                    AsyncVirtualStack.this.decorateComponentWithStall(instance, nowInMillis);
                }
                if (transactionAbortThreshold > 0L && instance.startTime < abosrtStart) {
                    abortedComponents.add(id);
                    instance.metricProvider.updateAsyncComponentMetricsAtAbort(instance.component.metrics, nowInMillis, instance.stallReported);
                    instance.errorMessage = AsyncVirtualStack.ABORTED_TRANSACTION;
                    AsyncVirtualStack.this.createErrorSnapshot(instance, nowInMillis);
                }
            }
        });
        Iterator iterator = abortedComponents.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            this.asyncComponentInstances.remove(id);
        }
    }

    public void decorateComponentWithStall(AsyncComponentInstance instance, long time) {
        AsyncComponent component = instance.component;
        if (component == null) {
            return;
        }
        instance.metricProvider.updateAsyncComponentMetricsAtStall(component.metrics, time);
        this.createErrorSnapshot(instance, time);
    }

    private static void defineConfigurationProperties(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        configManager.add(new BooleanConfigurationProperty(kAsyncTransactionTraceSupressEmptyFragments, true, null, feedback, module, localizer){

            @Override
            public void set(Object value) {
                bSupressEmptyFragmentTracing = (Boolean)value;
            }
        });
        configManager.add(new BooleanConfigurationProperty(kFragmentsAsFrontendPropertyKey, false, null, feedback, module, localizer){

            @Override
            public void set(Object value) {
                fragmentsAsFrontends = (Boolean)value;
            }
        });
        configManager.add(new BooleanConfigurationProperty(kFragmentsByFrontendPropertyKey, true, null, feedback, module, localizer){

            @Override
            public void set(Object value) {
                fragmentsByFrontends = (Boolean)value;
            }
        });
    }

    public void decorateComponentWithParam(InvocationData data, String name, String value, String type) {
        AsyncTransactionContext.AsyncComponentInvocation info = null;
        if (FRONTEND_COMPONENT.equalsIgnoreCase(type)) {
            info = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        } else if (BACKEND_COMPONENT.equalsIgnoreCase(type)) {
            info = this.getAsyncBackendInfoFromTransactionCache(data);
        }
        if (info != null) {
            AsyncComponentInstance instance = this.asyncComponentInstances.get(info.componentId);
            if (instance == null) {
                if (this.feedback.isDebugEnabled(module)) {
                    this.feedback.debug(module, "Failed to find correlated async component instance. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
                }
                return;
            }
            instance.putParameter(name, value);
        } else if (this.feedback.isDebugEnabled(module)) {
            this.feedback.debug(module, "Failed to find correlated async component " + type + " info. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
        }
    }

    public String getComponentDecoratedWithParam(InvocationData data, String name, String type) {
        AsyncTransactionContext.AsyncComponentInvocation info = null;
        if (FRONTEND_COMPONENT.equalsIgnoreCase(type)) {
            info = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        } else if (BACKEND_COMPONENT.equalsIgnoreCase(type)) {
            info = this.getAsyncBackendInfoFromTransactionCache(data);
        }
        if (info != null) {
            AsyncComponentInstance instance = this.asyncComponentInstances.get(info.componentId);
            if (instance == null) {
                if (this.feedback.isDebugEnabled(module)) {
                    this.feedback.debug(module, "Failed to find correlated async component instance. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
                }
                return null;
            }
            Object v = instance.getParameter(name);
            return v != null ? v.toString() : null;
        }
        if (this.feedback.isDebugEnabled(module)) {
            this.feedback.debug(module, "Failed to find correlated async component " + type + " info. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
        }
        return null;
    }

    public static boolean reportFragmentsByFrontend() {
        return fragmentsByFrontends;
    }

    public static boolean reportFragmentsAsFrontend() {
        return fragmentsAsFrontends;
    }

    public static String formatFragmentName(String frontendName, String fragmentName) {
        String name = fragmentName;
        if (frontendName != null) {
            StringBuilder sb = new StringBuilder(frontendName.substring("Frontends|".length()));
            name = sb.append("|").append(name).toString();
        }
        return name;
    }

    public static String addFragmentPrefix(String fragmentName) {
        String prefix = AsyncVirtualStack.reportFragmentsAsFrontend() ? "Frontends|" : "Fragments|";
        StringBuilder sb = new StringBuilder(prefix);
        return sb.append(fragmentName).toString();
    }

    public static class AsyncMetricHolder {
        public IRepository sds;
        public AgentMetric[] metric;

        public AsyncMetricHolder(IRepository sds, AgentMetric[] metric) {
            this.sds = sds;
            this.metric = metric;
        }
    }
}

