/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.environment.IMacAddressResolver;
import com.wily.introscope.agent.environment.SubNetworkDescriptor;
import com.wily.introscope.agent.environment.SubNetworks;
import com.wily.introscope.agent.environment.UnsignedByteArray;
import com.wily.introscope.agent.util.AgentStringUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Iterator;
import java.util.List;

public class NetworkInterfaceDescriptor {
    private final String name;
    private final String displayName;
    private final int index;
    private final boolean isIPv4Address;
    private final InetAddress ipAddress;
    private final UnsignedByteArray ipAddressBytes;
    private final String ipAddressAsString;
    private final String macAddress;
    private final String hostName;
    private final String domainName;
    private final InetAddress[] defaultIPAddresses;
    private final int weight;
    private final SubNetworks subNetworks;

    public NetworkInterfaceDescriptor(NetworkInterface ni, InetAddress ipAddress, InetAddress[] defaultIPAddresses, int index, IMacAddressResolver macAddressResolver, SubNetworks subNetworks) throws IllegalArgumentException {
        this.name = this.getNetworkInterfaceName(ni);
        this.displayName = this.getNetworkInterfaceDisplayName(ni);
        this.defaultIPAddresses = defaultIPAddresses;
        this.index = index;
        this.subNetworks = subNetworks;
        this.isIPv4Address = ipAddress instanceof Inet4Address;
        this.ipAddress = ipAddress;
        this.ipAddressBytes = new UnsignedByteArray(ipAddress.getAddress());
        this.ipAddressAsString = this.computeIPAddressAsString();
        UnsignedByteArray macAddresBytes = macAddressResolver != null ? macAddressResolver.getMacAddress(ni) : null;
        this.macAddress = macAddresBytes != null ? macAddresBytes.format(1, 2, "-", false, true) : null;
        String canonicalHostName = ipAddress.getCanonicalHostName();
        if (canonicalHostName != null && !canonicalHostName.equals(this.ipAddressAsString)) {
            String[] fqdn = AgentStringUtils.splitOnIndexOf(canonicalHostName, '.');
            this.hostName = fqdn[0];
            this.domainName = fqdn.length > 1 ? fqdn[1] : null;
        } else {
            this.hostName = canonicalHostName;
            this.domainName = null;
        }
        this.weight = this.computeWeight();
    }

    private String getNetworkInterfaceName(NetworkInterface ni) {
        return ni.getName();
    }

    private String getNetworkInterfaceDisplayName(NetworkInterface ni) {
        return ni.getDisplayName();
    }

    public boolean isDefaultIPAddress() {
        if (this.ipAddress == null && this.defaultIPAddresses == null) {
            return false;
        }
        int i = 0;
        while (i < this.defaultIPAddresses.length) {
            if (this.ipAddress.equals(this.defaultIPAddresses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLoopbackAddress() {
        return this.ipAddress != null && this.ipAddress.isLoopbackAddress();
    }

    public boolean isIPv6Tunnel() {
        return this.subNetworks != null && !this.isIPv4Address && this.isInSubNet(this.subNetworks.getIPv6TunnelingSubNets());
    }

    public boolean isLocalAddress() {
        return this.isLinkLocalAddress() || this.isSiteLocalAddress() || this.isPrivateAddress();
    }

    public boolean isLinkLocalAddress() {
        return this.ipAddress != null && this.ipAddress.isLinkLocalAddress();
    }

    public boolean isSiteLocalAddress() {
        return this.ipAddress != null && this.ipAddress.isSiteLocalAddress();
    }

    public boolean isPrivateAddress() {
        return this.subNetworks != null && this.isInSubNet(this.isIPv4Address ? this.subNetworks.getPrivateIPv4SubNets() : this.subNetworks.getPrivateIPv6SubNets());
    }

    private boolean isInSubNet(List subNets) {
        Iterator i = subNets.iterator();
        while (i.hasNext()) {
            if (!((SubNetworkDescriptor)i.next()).isInSubNet(this.ipAddressBytes)) continue;
            return true;
        }
        return false;
    }

    private int computeWeight() {
        int addressWeight = 0;
        if (!this.isLoopbackAddress()) {
            if (!this.isLocalAddress()) {
                ++addressWeight;
            }
            if (!this.isIPv6Tunnel()) {
                ++addressWeight;
            }
            if (this.isDefaultIPAddress()) {
                addressWeight += 2;
            }
        }
        return addressWeight + (this.isEmpty(this.macAddress) ? 0 : 5) + (this.isEmpty(this.hostName) ? 0 : 5) + (this.isEmpty(this.domainName) ? 0 : 5);
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private String computeIPAddressAsString() {
        return this.isIPv4Address ? this.formatIPAddressAsString(1, ".") : this.formatIPAddressAsString(2, ":");
    }

    private String formatIPAddressAsString(int fieldWidth, String separator) {
        return this.ipAddressBytes.format(fieldWidth, 1, separator, this.isIPv4Address, false);
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortName() {
        return String.valueOf(this.name) + "." + this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getIpAddressFamily() {
        return this.isIPv4Address ? "IPv4" : "IPv6";
    }

    public String getIpAddressAsString() {
        return this.ipAddressAsString;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public int getWeight() {
        return this.weight;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.weight;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkInterfaceDescriptor other = (NetworkInterfaceDescriptor)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.weight == other.weight && this.index == other.index;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.name).append(".").append(String.valueOf(this.index)).append("\" ").append(this.getIpAddressFamily()).append("=").append(this.ipAddressAsString).append(", mac=").append(this.macAddress).append(", host=").append(this.hostName).append(", domain=").append(this.domainName).append(", local=").append(this.isLocalAddress()).append(", private=").append(this.isPrivateAddress()).append(", tunnel=").append(this.isIPv6Tunnel()).append(", link local=").append(this.isLinkLocalAddress()).append(", site local=").append(this.isSiteLocalAddress()).append(", loopback=").append(this.isLoopbackAddress()).append(", weight=").append(String.valueOf(this.weight));
        return sb.toString();
    }
}

