/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.VirtualStackFeatureHelper;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.filter.ISampler;
import com.wily.introscope.agent.filter.SamplingInput;
import com.wily.introscope.agent.filter.SamplingResult;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.ICallbackOnStartHarvestTransaction;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceListProvider;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.intelligent.AutoTracingHelper;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.DownstreamTransactionHarvester;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class TransactionHarvestHelper {
    public static final int kTempChildrenDefaultSize = 4;
    private static IAgent sAgent;
    public static boolean fIntelligentInstrumentationEnabled;
    public static final String kIntelligentInstrumentationEnablingProperty = "introscope.agent.deep.instrumentation.enabled";
    public static final boolean kIntelligentInstrumentationEnablingPropertyDefaultValue = true;
    public static final String kLanguageDefaultValue = "java";
    public static volatile String fLanguage;

    static {
        fLanguage = kLanguageDefaultValue;
        try {
            sAgent = AgentShim.getAgent();
            fIntelligentInstrumentationEnabled = sAgent.IAgent_getIndexedProperties().getBooleanProperty(kIntelligentInstrumentationEnablingProperty, true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static void doHarvest(ITransactionInstanceListProvider structure, IStackElement stckElement) {
        boolean synchronous;
        boolean currentTxnMarkedForCollection;
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
        if (tcs == null) {
            feedback.warn("TransactionHarvestHelper.doHarvest fails with null tcs. need to configure a tracer that creates tcs");
            return;
        }
        ISamplingResult samplingResult = tcs.getSampled();
        ISamplingResult.Answer sampleAnswer = samplingResult.shouldStartSampling();
        List trace0 = stckElement.getTransactionInstanceList();
        if (trace0.isEmpty()) {
            return;
        }
        if (FilterController.isTraceSupressed(trace0, tcs)) {
            return;
        }
        ITransactionInstance tFirstEnd = (ITransactionInstance)trace0.get(trace0.size() - 1);
        if (!structure.validateTransaction(tFirstEnd)) {
            return;
        }
        ISamplingInput samplingInput = SamplingInput.wrap(stckElement);
        if (TransactionTraceController.getHasBeenClamped()) {
            switch (sampleAnswer.choice) {
                case YES: {
                    TransactionHarvestHelper.doHarvestSynchronously(stckElement, true);
                    return;
                }
                case MAYBE: {
                    TransactionHarvestHelper.doHarvestAsynchronously(stckElement, samplingInput);
                    return;
                }
                case NO: {
                    if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
                        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.cleanupOnWhenTraceIsClamped();
                    }
                    return;
                }
            }
        }
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled && TransactionHarvestHelper.processAutoTracing(stckElement)) {
            samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
            return;
        }
        switch (sampleAnswer.choice) {
            case YES: {
                currentTxnMarkedForCollection = true;
                synchronous = true;
                break;
            }
            case MAYBE: {
                currentTxnMarkedForCollection = false;
                synchronous = false;
                break;
            }
            default: {
                currentTxnMarkedForCollection = false;
                synchronous = true;
            }
        }
        boolean bl = currentTxnMarkedForCollection = currentTxnMarkedForCollection || synchronous && FilterController.canCurrentTransactionBeMarkedForCollection(stckElement);
        if (!currentTxnMarkedForCollection) {
            Map filterParams = tcs.getFilterParameters();
            filterParams.put("introscope.transactiontrace.threshold.key", tFirstEnd.getDuration());
            if (tcs.getErrorsSeenInThisTxn().size() > 0) {
                filterParams.put("introscope.transactiontrace.errorfilter.key", tcs.getErrorsSeenInThisTxn());
            }
            currentTxnMarkedForCollection = FilterController.finalFiltersExecute(tcs) || FilterController.pessimisticFiltersExecute(tcs);
            currentTxnMarkedForCollection = currentTxnMarkedForCollection || tcs.anyPendingTailFilters();
        }
        boolean bl2 = synchronous = synchronous || currentTxnMarkedForCollection;
        if (synchronous) {
            samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
            TransactionHarvestHelper.doHarvestSynchronously(stckElement, currentTxnMarkedForCollection);
        } else {
            TransactionHarvestHelper.doHarvestAsynchronously(stckElement, samplingInput);
        }
    }

    private static void doHarvestAsynchronously(IStackElement stckElement, ISamplingInput samplingInput) {
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        ISamplingResult samplingResult = tcs.getSampled();
        if (!fIntelligentInstrumentationEnabled || !DeepTraceConfigurations.fDeepTracingEnabled) {
            IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
            if (feedback.isWarningEnabled(ISampler.kSamplingModule)) {
                feedback.warn(ISampler.kSamplingModule, "Either Intelligent Instrumentation or Deep Tracing are disabled, however one of selected sampling strategy requires them. Trace is discarded");
            }
            samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
            return;
        }
        samplingResult.determineSampling(samplingInput, new HarvestCallback(stckElement));
    }

    private static void doHarvestSynchronously(IStackElement stckElement, boolean currentTxnMarkedForCollection) {
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
            if (currentTxnMarkedForCollection) {
                HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceCallBack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
                IntelligentTransactionHarvesterHelper.harvestTransaction(stckElement, highPerformanceCallBack, true);
            } else {
                TransactionHarvestHelper.submitTransactionToCache(stckElement);
            }
            return;
        }
        if (!currentTxnMarkedForCollection) {
            return;
        }
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        List trace = stckElement.getTransactionInstanceList();
        int position = trace.size() - 1;
        long duration = 0L;
        TransactionComponentData root = null;
        Stack<TransactionComponentData> traversingStack = new Stack<TransactionComponentData>();
        HashSet<SocketTransactionElement> socketTxnElementsWhichHaveMaskingBackends = new HashSet<SocketTransactionElement>();
        ArrayList<SocketRedundancyCheckPostProcessingTask> socketRedundancyCheckPostProcessingTasks = new ArrayList<SocketRedundancyCheckPostProcessingTask>();
        do {
            ITransactionInstance tend;
            if ((tend = (ITransactionInstance)trace.get(position)) == null) {
                return;
            }
            ITransactionElement te = tend.getTransactionElement();
            if (te == null) {
                return;
            }
            if (!(te instanceof BlameTransactionElement)) continue;
            BlameTransactionElement last = (BlameTransactionElement)te;
            if (!last.isStartTrace()) {
                TransactionComponentData bizDefComponent;
                ITransactionInstance tStart = tend.getStartInstance();
                if (tStart == null) {
                    return;
                }
                tStart.getTransactionElement();
                long startTrace = tStart.getData().getWallClockStartTime();
                duration = tend.getDuration();
                if (duration < 0L) {
                    Assertion.wilyAssert(duration >= 0L, "The duration should be bigger than zero");
                    duration = 0L;
                }
                TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(last.getResourceName(), startTrace, duration);
                BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", startTrace);
                if (traversingStack.isEmpty()) {
                    root = component;
                } else {
                    TransactionComponentData peekedItem = (TransactionComponentData)traversingStack.peek();
                    peekedItem.tempChildren.add(0, component);
                }
                component.tempChildren = new ArrayList(4);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                component.setParameters(parameters);
                IStackElement dataElement = tend.getData();
                if (dataElement != null) {
                    ProbeInformation fInfo;
                    if (last instanceof WilyTransactionElement && dataElement instanceof InvocationData && (fInfo = ((InvocationData)dataElement).getProbeInformation()) != null) {
                        parameters.put("Method", fInfo.getProbeIdentification().getProbeMethodName());
                        parameters.put("Method Descriptor", fInfo.getProbeIdentification().getProbeMethodDescriptor());
                        parameters.put("Class", fInfo.getProbeIdentification().getRuntimeFullClassName());
                        String lineInfo = fInfo.getProbeIdentification().getSourceFileLine();
                        if (lineInfo != null) {
                            parameters.put("Source Line", lineInfo);
                        }
                        parameters.put("Resource Name", component.getResource());
                        IFactoryLevelParameterCallback[] staticCallbacks = fInfo.getCallbacks();
                        int i = 0;
                        while (i < staticCallbacks.length) {
                            if (staticCallbacks[i] != null) {
                                staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
                            }
                            ++i;
                        }
                    }
                    VirtualStack.addParameterCallbacks(parameters, dataElement);
                    dataElement.addParameterCallbacks(parameters);
                }
                Object error = dataElement.get("Exception");
                Object errMsg = dataElement.get("Error Message");
                if (error != null) {
                    parameters.put("Exception", error);
                }
                if (errMsg != null) {
                    parameters.put("Error Message", errMsg);
                }
                if (last.isBackend()) {
                    TransactionHarvestHelper.includeSocketParams(parameters, tend.getData(), socketTxnElementsWhichHaveMaskingBackends, null);
                } else if (tend.getData().getAppMapSocketCursors() != null) {
                    socketRedundancyCheckPostProcessingTasks.add(new SocketRedundancyCheckPostProcessingTask(tend.getData(), parameters));
                }
                if (root == component && !component.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(component)) != null) {
                    root = bizDefComponent;
                    traversingStack.push(bizDefComponent);
                }
                traversingStack.push(component);
                continue;
            }
            if (traversingStack.isEmpty()) continue;
            traversingStack.pop();
        } while (--position >= 0);
        TransactionHarvestHelper.includeRootParams(root.getParameters(), stckElement);
        VirtualStackFeatureHelper.realizeSubcomponent(root);
        TransactionHarvestHelper.removeRedundantSocketDecorationByPostProcessing(socketTxnElementsWhichHaveMaskingBackends, socketRedundancyCheckPostProcessingTasks);
        ISamplingResult.Answer samplingAnswer = tcs.getSampled().shouldStartSampling();
        if (samplingAnswer.choice == ISamplingResult.Choice.YES) {
            root.setParameterValue("Trace Type", "Sampled");
            if (samplingAnswer.byWho != null) {
                root.setParameterValue("Trace Reason", samplingAnswer.byWho);
            }
        } else {
            root.setParameterValue("Trace Type", "Normal");
        }
        if (tcs.isComponentClampAlreadyHitForTxn()) {
            root.setParameterValue("Components Not Shown", Integer.toString(tcs.getComponentClampAfterCount()));
        }
        if (tcs.getTraceCollectionReason() != null) {
            root.setParameterValue("Trace Reason", tcs.getTraceCollectionReason());
        }
        sAgent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(root);
    }

    public static void removeRedundantSocketDecorationByPostProcessing(HashSet<SocketTransactionElement> socketTransactionElementsMaskedByBackends, ArrayList<SocketRedundancyCheckPostProcessingTask> socketRedundancyCheckPostProcessingTasks) {
        for (SocketRedundancyCheckPostProcessingTask task : socketRedundancyCheckPostProcessingTasks) {
            TransactionHarvestHelper.includeSocketParams(task.parameters, task.data, null, socketTransactionElementsMaskedByBackends);
        }
    }

    private static boolean processAutoTracing(IStackElement stckElement) {
        if (!fIntelligentInstrumentationEnabled || !DeepTraceConfigurations.fDeepTracingEnabled) {
            return false;
        }
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceCallBack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        if (!AutoTracingHelper.checkForAutoTracingWithClamp()) {
            return false;
        }
        stckElement.getTransactionCollectionStatus().setSampled(ISamplingResult.NO);
        boolean result = IntelligentTransactionHarvesterHelper.harvestTransaction(stckElement, highPerformanceCallBack, false);
        if (result) {
            SustainabilityMetricsHelper.reportAutoTracingSustainibilityMetricsSent(1);
        }
        return result;
    }

    public static void submitTransactionToCache(IStackElement stckElement) {
        if (!fIntelligentInstrumentationEnabled || !DeepTraceConfigurations.fDeepTracingEnabled) {
            return;
        }
        IntelligentTransactionHarvesterHelper.submitTransactionToCache(stckElement);
    }

    private static IEventDataNode findFrontendNode(IEventDataNode root) {
        LinkedList<IEventDataNode> queue = new LinkedList<IEventDataNode>();
        queue.offer(root);
        int level = 0;
        queue.offer(null);
        while (!queue.isEmpty()) {
            IEventDataNode node = (IEventDataNode)queue.poll();
            if (node.getParameterValue("Business Definition") != null) {
                return node;
            }
            int i = 0;
            while (i < node.getSubNodeCount()) {
                queue.offer(node.getSubNode(i));
                ++i;
            }
            if (queue.peek() != null) continue;
            if (level >= 15) {
                return null;
            }
            queue.poll();
            if (queue.isEmpty()) continue;
            ++level;
            queue.offer(null);
        }
        return null;
    }

    public static TransactionComponentData buildBusinessTransactionComponent(TransactionComponentData component) {
        TransactionComponentData bizDefComponent = null;
        IEventDataNode frontendComponent = component;
        String bizDefStr = frontendComponent.getParameterValue("Business Definition");
        if (bizDefStr == null && (frontendComponent = TransactionHarvestHelper.findFrontendNode(component)) != null) {
            bizDefStr = frontendComponent.getParameterValue("Business Definition");
        }
        if (bizDefStr != null) {
            String EBTFeature;
            bizDefComponent = TransactionComponentData.createMilliSecTransactionComponentData(bizDefStr, component.getStartTimeInMillisecs(), component.getDurationInMillisecs());
            HashMap<String, String> bizDefParameters = new HashMap<String, String>();
            bizDefComponent.setParameters(bizDefParameters);
            Map params = frontendComponent.getParameters();
            bizDefParameters.put("Business Definition", bizDefStr);
            params.remove("Business Definition");
            bizDefParameters.put("Language", fLanguage);
            String ttParamName = frontendComponent.getParameterValue("EUM Business Transaction");
            String corGuid = frontendComponent.getParameterValue("CorGUID");
            String url = frontendComponent.getParameterValue("URL");
            String traceId = frontendComponent.getParameterValue("TxnTraceId");
            if (ttParamName != null) {
                bizDefParameters.put("EUM Business Transaction", ttParamName);
                params.remove("EUM Business Transaction");
            }
            if (corGuid != null) {
                bizDefParameters.put("CorGUID", corGuid);
                params.remove("CorGUID");
            }
            if (url != null) {
                bizDefParameters.put("URL", url);
            }
            if (traceId != null) {
                bizDefParameters.put("TxnTraceId", traceId);
            }
            String userId = component.getParameterValue("User ID");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("BS/BT User Id Problem: UserId got is: " + userId);
            }
            if (userId != null) {
                bizDefParameters.put("User ID", userId);
            }
            if ((EBTFeature = sAgent.IAgent_getConfigurationManager().getProperty("introscope.agent.external.biz.enabled")) != null && "true".equalsIgnoreCase(EBTFeature)) {
                String appname;
                String tenant;
                String sdk;
                String connection;
                String os;
                String device;
                String location;
                String carrier = component.getParameterValue("x-apm-bt.Carrier");
                if (carrier != null) {
                    bizDefParameters.put("x-apm-bt.Carrier", carrier);
                    params.remove("x-apm-bt.Carrier");
                }
                if ((location = component.getParameterValue("x-apm-bt.Location")) != null) {
                    bizDefParameters.put("x-apm-bt.Location", location);
                    params.remove("x-apm-bt.Location");
                }
                if ((device = component.getParameterValue("x-apm-bt.Device")) != null) {
                    bizDefParameters.put("x-apm-bt.Device", device);
                    params.remove("x-apm-bt.Device");
                }
                if ((os = component.getParameterValue("x-apm-bt.OS Version")) != null) {
                    bizDefParameters.put("x-apm-bt.OS Version", os);
                    params.remove("x-apm-bt.OS Version");
                }
                if ((connection = component.getParameterValue("x-apm-bt.Connection")) != null) {
                    bizDefParameters.put("x-apm-bt.Connection", connection);
                    params.remove("x-apm-bt.Connection");
                }
                if ((sdk = component.getParameterValue("x-apm-bt.Identifier Version")) != null) {
                    bizDefParameters.put("x-apm-bt.Identifier Version", sdk);
                    params.remove("x-apm-bt.Identifier Version");
                }
                if ((tenant = component.getParameterValue("x-apm-bt.Tenant")) != null) {
                    bizDefParameters.put("x-apm-bt.Tenant", tenant);
                    params.remove("x-apm-bt.Tenant");
                }
                if ((appname = component.getParameterValue("x-apm-bt.Application Name")) != null) {
                    bizDefParameters.put("x-apm-bt.Application Name", appname);
                    params.remove("x-apm-bt.Application Name");
                }
            }
            bizDefComponent.tempChildren = new ArrayList(4);
            bizDefComponent.tempChildren.add(component);
        }
        return bizDefComponent;
    }

    private static void includeCorParams(Map parameters) {
        String corid;
        SharedCrossProcessData cache = sAgent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache != null && (corid = cache.getCorrelationID()) != null) {
            String openTracingDownStream;
            String seqid;
            parameters.put("CorCrossProcessData", corid);
            SequenceId id = cache.getSeqID();
            if (id != null && (seqid = id.getSequenceId()) != null) {
                parameters.put("SeqNoCrossProcessData", seqid);
            }
            String txnTraceId = cache.getStringParamIn("TxnTraceId");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller GUID " + txnTraceId);
            }
            if (txnTraceId != null) {
                parameters.put("CallerTxnTraceId", txnTraceId);
            }
            String callerTxnTime = cache.getStringParamIn("CallerTimestamp");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller's timestamp " + callerTxnTime);
            }
            if (callerTxnTime != null) {
                parameters.put("CallerTimestamp", callerTxnTime);
            }
            String nonBlockTxn = cache.getStringParamIn("NBThreadTxn");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack current Txn Non Blocking = " + nonBlockTxn);
            }
            if (nonBlockTxn != null) {
                parameters.put("NBThreadTxn", nonBlockTxn);
            }
            String callerComponentID = cache.getStringParamIn("Caller Component ID");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack current caller component ID = " + callerComponentID);
            }
            if (callerComponentID != null) {
                parameters.put("Caller Component ID", callerComponentID);
            }
            if ((openTracingDownStream = cache.getStringParamIn("isOpenTracingDownstreamTrace")) != null) {
                parameters.put("isOpenTracingDownstreamTrace", openTracingDownStream);
            }
        }
    }

    public static void includeRootParams(Map parameters, IStackElement data) {
        parameters.put("Trace Type", "Normal");
        Runnable thread = null;
        if (data != null) {
            thread = data.getMyThread();
        }
        String threadName = null;
        String threadGroupName = null;
        if (thread == null) {
            threadName = InvocationData.limitSize(Thread.currentThread().getName());
            threadGroupName = InvocationData.limitSize(Thread.currentThread().getThreadGroup().getName());
        } else if (thread instanceof Thread) {
            Thread t = (Thread)thread;
            threadName = InvocationData.limitSize(t.getName());
            threadGroupName = InvocationData.limitSize(t.getThreadGroup().getName());
        } else {
            threadName = thread.toString();
            threadGroupName = "NA";
        }
        if (threadName != null) {
            parameters.put("Thread Name", threadName);
        }
        if (threadGroupName != null) {
            parameters.put("Thread Group Name", threadGroupName);
        }
        parameters.put("Language", fLanguage);
        TransactionHarvestHelper.includeCorParams(parameters);
    }

    static String formatSocketConnectionString(String localAddress, String remoteAddress, int port) {
        StringBuilder sb = new StringBuilder();
        if (localAddress.contains(":")) {
            sb.append("[");
            sb.append(localAddress);
            sb.append("]");
        } else {
            sb.append(localAddress);
        }
        sb.append("->");
        if (remoteAddress.contains(":")) {
            sb.append("[");
            sb.append(remoteAddress);
            sb.append("]");
        } else {
            sb.append(remoteAddress);
        }
        sb.append(":");
        sb.append(port);
        return sb.toString();
    }

    public static void includeSocketParams(Map parameters, IStackElement data) {
        TransactionHarvestHelper.includeSocketParams(parameters, data, null, null);
    }

    public static void includeSocketParams(Map parameters, IStackElement data, HashSet<SocketTransactionElement> elements, HashSet<SocketTransactionElement> filterElements) {
        Iterator i;
        if (data != null && (i = data.getAppMapSocketCursors()) != null) {
            int index = 1;
            while (i.hasNext()) {
                SocketTransactionElement element = (SocketTransactionElement)i.next();
                if (elements != null) {
                    elements.add(element);
                }
                if (filterElements != null && filterElements.contains(element)) continue;
                int currentIndex = index++;
                TransactionHarvestHelper.includeSocketParams(currentIndex, element, parameters);
            }
        }
    }

    public static void includeSocketParams(int socketIndex, SocketTransactionElement element, Map parameters) {
        if (element.hasMetrics()) {
            parameters.put("Socket" + socketIndex, element.getSocketDescription());
        }
        String remoteServerHost = element.getHostName();
        String remoteServerAddress = element.getHostAddress();
        String localServerAddress = element.getLocalAddress();
        int port = element.getPort();
        if (remoteServerHost != null) {
            parameters.put("Remote Server Name" + socketIndex, remoteServerHost);
        }
        if (remoteServerAddress != null) {
            parameters.put("Remote Server Address" + socketIndex, remoteServerAddress);
        }
        if (port > 0) {
            parameters.put("Remote Port" + socketIndex, Integer.toString(port));
        }
        if (localServerAddress != null) {
            parameters.put("Local Address" + socketIndex, localServerAddress);
        }
    }

    private static boolean passesLegacyTailFilters(TransactionComponentData root, TransactionCollectStatus tcs) {
        return FilterController.pessimisticLegacyFiltersExecute(root, tcs);
    }

    private static final class HarvestCallback
    implements ISamplingResult.Callback {
        private IStackElement stckElement;
        private HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack;
        private boolean corruptedTcd;

        HarvestCallback(IStackElement stckElement) {
            this.stckElement = stckElement;
        }

        private void releaseStackElement() {
            this.stckElement = null;
        }

        @Override
        public synchronized void onSamplingDetermined(ISamplingResult.Answer answer) {
            switch (answer.choice) {
                case MAYBE: {
                    this.onMaybe();
                    return;
                }
                case YES: {
                    this.onYes(answer);
                    return;
                }
                case NO: {
                    this.onNo();
                    return;
                }
            }
        }

        private void onMaybe() {
            if (this.deepStack != null) {
                return;
            }
            this.deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            this.deepStack.prepareOnStartHarvestTransaction();
            this.deepStack.shouldCache(ICallbackOnStartHarvestTransaction.CacheOwner.DELAYED_SAMPLER);
            IStackElement stckElement = this.stckElement;
            this.releaseStackElement();
            int numTcds = IntelligentTransactionHarvesterHelper.prepareTopTCDElementsForCache(stckElement);
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.tearDown();
            if (numTcds <= 0) {
                IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
                if (feedback.isDebugEnabled(ISampler.kSamplingModule)) {
                    feedback.debug(ISampler.kSamplingModule, "Attempt to prepare top TCD element for " + this.deepStack + " failed due to corrupted transaction, will not report it and cleanup.");
                }
                this.deepStack.release(ICallbackOnStartHarvestTransaction.CacheOwner.DELAYED_SAMPLER, false);
                this.corruptedTcd = true;
                return;
            }
            if (IntelligentTransactionHarvesterHelper.isDownStreamAgentForTx()) {
                this.deepStack.shouldCache(ICallbackOnStartHarvestTransaction.CacheOwner.CROSS_PROCESS);
            }
        }

        private void onYes(final ISamplingResult.Answer answer) {
            if (this.deepStack == null) {
                TransactionCollectStatus tcs = this.stckElement.getTransactionCollectionStatus();
                tcs.setSampled(SamplingResult.YES(answer.byWho));
                TransactionHarvestHelper.doHarvestSynchronously(this.stckElement, true);
                this.releaseStackElement();
                return;
            }
            if (this.corruptedTcd) {
                return;
            }
            DownstreamTransactionHarvester.createAndSendTCDHelper(this.deepStack, new DownstreamTransactionHarvester.TCDPreSendCallback(){

                @Override
                public void beforeSending(TransactionComponentData tcd) {
                    tcd.setParameterValue("Trace Type", "Sampled");
                    if (answer.byWho != null) {
                        tcd.setParameterValue("Trace Reason", answer.byWho);
                    }
                }
            });
            this.deepStack.release(ICallbackOnStartHarvestTransaction.CacheOwner.DELAYED_SAMPLER, false);
        }

        private void onNo() {
            if (this.deepStack == null) {
                if (TransactionTraceController.getHasBeenClamped()) {
                    if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
                        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.cleanupOnWhenTraceIsClamped();
                    }
                    this.releaseStackElement();
                    return;
                }
                TransactionCollectStatus tcs = this.stckElement.getTransactionCollectionStatus();
                tcs.setSampled(ISamplingResult.NO);
                TransactionHarvestHelper.doHarvestSynchronously(this.stckElement, false);
                this.releaseStackElement();
                return;
            }
            if (this.corruptedTcd) {
                return;
            }
            this.deepStack.release(ICallbackOnStartHarvestTransaction.CacheOwner.DELAYED_SAMPLER, false);
        }
    }

    public static class SocketRedundancyCheckPostProcessingTask {
        final IStackElement data;
        final Map parameters;

        public SocketRedundancyCheckPostProcessingTask(IStackElement data, Map parameters) {
            this.data = data;
            this.parameters = parameters;
        }
    }
}

