/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import com.wily.isengard.client.transport.websocket.ProxySupport;
import com.wily.isengard.client.transport.websocket.TimedPipedInputStream;
import com.wily.isengard.client.transport.websocket.WebSocketClientImpl;
import com.wily.isengard.client.transport.websocket.WebSocketClientJavaImpl;
import com.wily.isengard.client.transport.websocket.WebSocketClientNettyImpl;
import com.wily.isengard.client.transport.websocket.WebSocketTransportService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class WebSocketAdapter
extends Socket {
    private static final String kBearerToken = "Bearer ";
    private static final String kAuthorizationHeader = "Authorization";
    public static final String kAgentWebSocketImplShortPropertyKey = "agentManager.websocket.impl";
    public static final String kAgentWebSocketSniEnabledShortPropertyKey = "agentManager.websocket.sni.enabled";
    private static final int connectionTimeoutInSeconds = 10;
    private final IModuleFeedbackChannel feedback;
    private final Module module;
    private final TimedPipedInputStream isengardInputStream;
    private final PipedOutputStream isengardOutputStream;
    private final PipedInputStream websocketInputStream;
    private final PipedOutputStream websocketOutputStream;
    private final SSLContext sslContext;
    private final boolean validateHandshake;
    private final String[] ciphers;
    private final String[] protocols;
    private final boolean sniEnabled;
    private final URI uri;
    private final String credential;
    private final String implementation;
    private WebSocketClientImpl client;
    private Thread writerThread;

    public WebSocketAdapter(URI uri, IndexedProperties props, IModuleFeedbackChannel feedback, Module module) throws IOException {
        this(uri, props, feedback, module, null, false, null, null);
    }

    public WebSocketAdapter(URI uri, IndexedProperties props, IModuleFeedbackChannel feedback, Module module, SSLContext sslctx, boolean validateHandshake, String[] ciphers, String[] protocols) throws IOException {
        this.feedback = feedback;
        this.module = module;
        this.uri = uri;
        this.sslContext = sslctx;
        this.validateHandshake = validateHandshake;
        this.ciphers = ciphers;
        this.protocols = protocols;
        this.credential = props.getProperty("agentManager.credential");
        this.implementation = props.getProperty(kAgentWebSocketImplShortPropertyKey, "netty");
        this.sniEnabled = props.getBooleanProperty(kAgentWebSocketSniEnabledShortPropertyKey, true);
        ProxySupport.initialize(props, this.getFeedbackChannel(), this.getModule());
        this.websocketOutputStream = new PipedOutputStream();
        this.isengardInputStream = new TimedPipedInputStream(this.websocketOutputStream);
        WebSocketTransportService.registerTimedPipedInputStream(this.isengardInputStream);
        this.isengardOutputStream = new PipedOutputStream();
        this.websocketInputStream = new PipedInputStream(this.isengardOutputStream);
        this.client = null;
        this.writerThread = null;
    }

    private WebSocketClientImpl getWebSocketImplementation(URI uri, Map<String, String> headers) {
        WebSocketClientImpl impl = this.implementation.equals("java") ? new WebSocketClientJavaImpl(uri, headers, this) : new WebSocketClientNettyImpl(uri, headers, this);
        this.feedback.debug(this.module, "Using websocket implementation class " + impl.getClass().getCanonicalName());
        return impl;
    }

    public boolean isSniEnabled() {
        return this.sniEnabled;
    }

    public void connect() throws IOException, UnknownHostException {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        if (this.credential != null && !this.credential.isEmpty()) {
            httpHeaders.put(kAuthorizationHeader, kBearerToken + this.credential);
        }
        this.client = this.getWebSocketImplementation(this.uri, httpHeaders);
        if (this.sslContext != null) {
            String host = this.uri.getHost();
            int port = this.uri.getPort();
            this.client.setSSLContext(this.sslContext, this.validateHandshake, this.ciphers, this.protocols, host, port > 0 ? port : 443);
        }
        this.client.connect(10000);
        if (!this.client.isOpen()) {
            this.feedback.error(this.module, "WebSocket connection attempt timed out: " + this.uri);
            throw new IOException("WebSocket connection attempt timed out: " + this.uri);
        }
        this.writerThread = new Thread((Runnable)new WebSocketWriter(this.websocketInputStream, this.client, this.feedback, this.module), "Websocket Adapter Writer");
        this.writerThread.start();
    }

    public void onMessage(ByteBuffer bytes) {
        try {
            if (bytes.hasArray()) {
                this.websocketOutputStream.write(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
            } else {
                WritableByteChannel channel = Channels.newChannel(this.websocketOutputStream);
                channel.write(bytes);
            }
        }
        catch (IOException e) {
            this.feedback.error(this.module, "Cannot write to Isengard");
            this.feedback.debug(this.module, "IOException: ", (Throwable)e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.client != null && this.client.isOpen();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.isengardInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.isengardOutputStream;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.client.getInetAddress();
    }

    @Override
    public int getPort() {
        return this.client.getPort();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.isengardOutputStream.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.websocketOutputStream.close();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        this.isengardOutputStream.close();
    }

    public void onClose() {
        try {
            this.websocketOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public String toString() {
        return "websocket: " + this.uri;
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.isengardInputStream.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.client.setTcpNoDelay(on);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.isengardInputStream.getSoTimeout();
    }

    public IModuleFeedbackChannel getFeedbackChannel() {
        return this.feedback;
    }

    public Module getModule() {
        return this.module;
    }

    private static class WebSocketWriter
    implements Runnable {
        private final IModuleFeedbackChannel feedback;
        private final Module module;
        private final InputStream in;
        private final WebSocketClientImpl client;

        WebSocketWriter(InputStream in, WebSocketClientImpl client, IModuleFeedbackChannel feedback, Module module) {
            this.in = in;
            this.client = client;
            this.feedback = feedback;
            this.module = module;
        }

        @Override
        public void run() {
            byte[] buff = new byte[8192];
            while (this.client.isOpen()) {
                try {
                    int bytes = this.in.read(buff, 0, 8192);
                    if (bytes < 0) {
                        this.feedback.info(this.module, "Isengard Input Stream closed.");
                        this.client.close();
                        break;
                    }
                    if (bytes <= 0 || !this.client.isOpen()) continue;
                    this.client.send(ByteBuffer.wrap(buff, 0, bytes));
                }
                catch (IOException e) {
                    this.feedback.error(this.module, "IOException: ", (Throwable)e);
                    this.client.close();
                    break;
                }
            }
        }
    }
}

