/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.datetime;

import com.wily.util.datetime.DateFormatException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;

public class DateParser {
    private static DateFormat canonicalDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
    private static DateParser defaultInstance;
    private Locale locale;
    private DateFormat friendlyTimestampFormat;
    private final String[] dayFormats = new String[]{"MM/dd/yyyy", "MM-dd-yyyy"};
    private final String[] hourFormats = new String[]{"HH:mm:ss", "HH:mm"};
    private final ArrayList timestampFormats = new ArrayList();

    public static DateParser getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DateParser();
        }
        return defaultInstance;
    }

    public DateParser() {
        this(Locale.getDefault(), TimeZone.getDefault());
    }

    public DateParser(Locale loc, TimeZone tz) {
        this.locale = loc;
        for (int d = 0; d < this.dayFormats.length; ++d) {
            this.timestampFormats.add(new SimpleDateFormat(this.dayFormats[d], this.locale));
        }
        for (int h = 0; h < this.hourFormats.length; ++h) {
            for (int d = 0; d < this.dayFormats.length; ++d) {
                this.timestampFormats.add(new SimpleDateFormat(this.dayFormats[d] + " " + this.hourFormats[h], this.locale));
            }
        }
        Collections.sort(this.timestampFormats, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((SimpleDateFormat)o1).toPattern();
                String s2 = ((SimpleDateFormat)o2).toPattern();
                if (s1.length() > s2.length()) {
                    return -1;
                }
                return 1;
            }
        });
        this.timestampFormats.add(0, DateFormat.getDateTimeInstance(2, 3, this.locale));
        this.friendlyTimestampFormat = DateFormat.getDateTimeInstance(3, 3, this.locale);
        this.timestampFormats.add(0, this.friendlyTimestampFormat);
        Iterator i = this.timestampFormats.iterator();
        while (i.hasNext()) {
            DateFormat df = (DateFormat)i.next();
            df.setTimeZone(tz);
            df.setLenient(false);
        }
    }

    public String formatFriendlyTimestamp(Date d) {
        if (d == null) {
            return "";
        }
        return this.friendlyTimestampFormat.format(d);
    }

    public Date parseTimestamp(String s) throws DateFormatException {
        if (s == null || s.length() == 0) {
            return null;
        }
        s = s.trim();
        for (int i = 0; i < this.timestampFormats.size(); ++i) {
            DateFormat f = (DateFormat)this.timestampFormats.get(i);
            ParsePosition p = new ParsePosition(0);
            Date date = f.parse(s, p);
            if (p.getIndex() < s.length()) continue;
            return date;
        }
        throw new DateFormatException("Cannot parse date time: " + s);
    }

    public static String getCanonicalStringRep(Date d) {
        if (d != null) {
            return canonicalDateFormat.format(d);
        }
        return "";
    }

    public static Date parseCanonicalString(String timestamp) throws DateFormatException {
        if (timestamp != null && timestamp.length() > 0) {
            try {
                return canonicalDateFormat.parse(timestamp);
            }
            catch (ParseException pe) {
                throw new DateFormatException("Invalid timestamp: " + timestamp);
            }
        }
        return null;
    }
}

