/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.webappsupport.jboss;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.webappsupport.AWebAppAgentNamer;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.util.MBeanServerLocator;

public class JBossAgentNamer
extends AWebAppAgentNamer {
    private IAgent fAgent;
    private IModuleFeedbackChannel fFeedback;

    public JBossAgentNamer(IAgent agent) {
        super(agent);
        this.fAgent = agent;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
    }

    public String IAppserverEnvironmentInfoCallback_getAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String clusterPartitionName = null;
        String serverName = null;
        ObjectName serviceName = null;
        MBeanServer localServer = null;
        try {
            localServer = MBeanServerLocator.locateJBoss();
            serviceName = new ObjectName("user:service=IntroscopeCustomService");
            localServer.getAttribute(serviceName, "State");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new CallbackFailedTemporarilyException((ILocalizableMessage)new LocalizedMessage("JBoss server not yet started"));
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new LocalizedMessage("Problem accessing MBeans"), (Throwable)e);
        }
        try {
            serviceName = new ObjectName("jboss.system:type=ServerConfig");
            Object serverAttribute = localServer.getAttribute(serviceName, "ServerName");
            if (serverAttribute != null) {
                serverName = localServer.getAttribute(serviceName, "ServerName").toString();
            }
            if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("JBAN: server name = -->" + (serverName == null ? "null" : serverName) + "<--");
            }
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new LocalizedMessage("Problem accessing MBeans"), (Throwable)e);
        }
        try {
            serviceName = new ObjectName("jboss:service=HAJNDI");
            Object localServerAttribute = localServer.getAttribute(serviceName, "PartitionName");
            if (localServerAttribute != null) {
                clusterPartitionName = localServerAttribute.toString();
            }
            if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("JBAN: server name = -->" + (serverName == null ? "null" : serverName) + "<--");
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            clusterPartitionName = null;
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new LocalizedMessage("Problem accessing MBeans"), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)serverName)) {
            if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("JBAN: server name is null");
            }
            return null;
        }
        if (StringUtils.isEmpty(clusterPartitionName)) {
            if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("JBAN: cluster partition name is null");
            }
            return serverName;
        }
        return StringUtils.concatAndEscapeStrings((String)clusterPartitionName, (String)serverName, (char)'/', (char)'_');
    }
}

