/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.IGenericServices;
import com.wily.ui.action.AOneWayExtendedAction;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.swing.WilyJDialog;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class ConfirmationAction
extends AOneWayExtendedAction {
    private static final long serialVersionUID = 6187100576965128053L;
    private IGenericServices fGenericServices;
    private Component fParentComponent;
    private String fLocalizedPrompt;
    private String fLocalizedTitle;
    private int fMessageType;
    private Icon fIcon;
    private String[] fOptions;
    private String fInitialValue;
    private int fPositioningFlags;

    public ConfirmationAction(IGenericServices genericServices, Component parentComponent, String localizedPrompt, String localizedTitle, int messageType, Icon icon, String[] options, String initialValue, int positioningFlags) {
        super(localizedTitle);
        this.initialize(genericServices, parentComponent, localizedPrompt, localizedTitle, messageType, icon, options, initialValue, positioningFlags);
    }

    public ConfirmationAction(IGenericServices genericServices, Component parentComponent, String localizedPrompt, String localizedTitle, int messageType, Icon icon, String[] options, String initialValue) {
        this(genericServices, parentComponent, localizedPrompt, localizedTitle, messageType, icon, options, initialValue, 1);
    }

    public ConfirmationAction(IGenericServices genericServices, Component parentComponent, String localizedPrompt, String localizedTitle, int messageType) {
        this(genericServices, parentComponent, localizedPrompt, localizedTitle, messageType, null, null, null);
    }

    public ConfirmationAction(IGenericServices genericServices, Component parentComponent, String localizedPrompt, String localizedTitle) {
        this(genericServices, parentComponent, localizedPrompt, localizedTitle, 3);
    }

    private void initialize(IGenericServices genericServices, Component parentComponent, String localizedPrompt, String localizedTitle, int messageType, Icon icon, String[] options, String initialValue, int positioningFlags) {
        this.fGenericServices = genericServices;
        this.fParentComponent = parentComponent;
        this.fLocalizedPrompt = localizedPrompt;
        this.fLocalizedTitle = localizedTitle;
        this.fMessageType = messageType;
        this.fIcon = icon;
        this.fOptions = options;
        this.fInitialValue = initialValue;
        this.fPositioningFlags = positioningFlags;
    }

    private IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    public void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        this.promptAndCancelIfNecessary();
    }

    protected void promptAndCancelIfNecessary() {
        this.setCancelled(!this.promptUserForConfirmation());
    }

    protected boolean promptUserForConfirmation() {
        SwingAssertion.assertSwingSafe();
        int option = this.fOptions == null || this.fInitialValue == null ? WilyJDialog.showConfirmDialog(this.getGenericServices(), this.fParentComponent, (Object)this.fLocalizedPrompt, this.fLocalizedTitle, 1, this.fMessageType, this.fPositioningFlags) : WilyJDialog.showOptionDialog(this.getGenericServices(), this.fParentComponent, this.fLocalizedPrompt, this.fLocalizedTitle, 1, this.fMessageType, this.fIcon, this.fOptions, this.fInitialValue, this.fPositioningFlags);
        return option == 0;
    }
}

