/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.dndlist;

import com.wily.ui.swing.dndlist.TransferableListItems;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.swing.JList;

public abstract class AbstractListTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    protected static final Insets kDefaultAutoscrollInsets = new Insets(20, 20, 20, 20);
    protected Insets autoscrollInsets;
    protected JList list;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private static BufferedImage image = null;
    private Rectangle rect2D = new Rectangle();
    private boolean drawImage;
    protected int[] selectedIndices = null;
    protected int addIndex = -1;
    protected int addCount = 0;

    protected AbstractListTransferHandler(Insets autoscrollInsets, JList list, int action, boolean drawIcon) {
        this.autoscrollInsets = autoscrollInsets;
        this.list = list;
        this.drawImage = drawIcon;
        this.dragSource = new DragSource();
        DragGestureRecognizer defaultDragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(list, action, this);
        this.dropTarget = new DropTarget(list, 3, this);
    }

    protected AbstractListTransferHandler(JList list, int action, boolean drawIcon) {
        this(kDefaultAutoscrollInsets, list, action, drawIcon);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        DragSourceContext dsc;
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2 && (dsc = dsde.getDragSourceContext()).getComponent() instanceof JList) {
            JList list = (JList)dsc.getComponent();
            if (dsde.getDropSuccess()) {
                this.cleanup(list, dsde.getDropAction());
            } else {
                this.cleanup(list, 0);
            }
        }
    }

    public final void dragEnter(DragSourceDragEvent dsde) {
        this.addIndex = -1;
        this.addCount = 0;
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dragOver(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dropActionChanged(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public final void dragGestureRecognized(DragGestureEvent dge) {
        this.selectedIndices = this.list.getSelectedIndices();
        Object[] selectedValues = this.list.getSelectedValues();
        if (selectedValues != null && selectedValues.length > 0) {
            this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, image, new Point(0, 0), new TransferableListItems(selectedValues), this);
        }
    }

    public final void dragEnter(DropTargetDragEvent dtde) {
        this.addIndex = -1;
        this.addCount = 0;
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.canPerformAction(this.list, dtde, pt)) {
            dtde.acceptDrag(action);
            if (this.drawImage) {
                this.paintImage(pt);
            }
        } else {
            dtde.rejectDrag();
            if (this.drawImage) {
                this.clearImage();
            }
        }
    }

    public final void dragExit(DropTargetEvent dte) {
        if (this.drawImage) {
            this.clearImage();
        }
    }

    protected Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    protected void autoscroll(Point cursorLocation) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.list.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.list.scrollRectToVisible(scrollRect);
        }
    }

    public final void dragOver(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        this.autoscroll(pt);
        if (this.canPerformAction(this.list, dtde, pt)) {
            dtde.acceptDrag(action);
            if (this.drawImage) {
                this.paintImage(pt);
            }
        } else {
            dtde.rejectDrag();
            if (this.drawImage) {
                this.clearImage();
            }
        }
    }

    public final void dropActionChanged(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.canPerformAction(this.list, dtde, pt)) {
            dtde.acceptDrag(action);
            if (this.drawImage) {
                this.paintImage(pt);
            }
        } else {
            dtde.rejectDrag();
            if (this.drawImage) {
                this.clearImage();
            }
        }
    }

    public final void drop(DropTargetDropEvent dtde) {
        try {
            int dropIndex;
            if (this.drawImage) {
                this.clearImage();
            }
            int action = dtde.getDropAction();
            Transferable transferable = dtde.getTransferable();
            Object[] transferableItem = null;
            boolean dataFlavorSupported = transferable.isDataFlavorSupported(TransferableListItems.LISTITEMS_FLAVOR);
            if (dataFlavorSupported) {
                transferableItem = (Object[])transferable.getTransferData(TransferableListItems.LISTITEMS_FLAVOR);
            }
            Point pt = dtde.getLocation();
            int indexToInsertBefore = this.getIndexToInsertBefore(pt);
            if (dataFlavorSupported && this.canPerformAction(this.list, indexToInsertBefore, action) && this.executeDrop(this.list, transferableItem, dropIndex = this.getIndexToInsertBefore(pt), action)) {
                dtde.acceptDrop(action);
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        catch (UnsupportedFlavorException e) {
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        catch (IOException ioe) {
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
    }

    private final void paintImage(Point pt) {
        Rectangle rect;
        this.list.paintImmediately(this.rect2D.getBounds());
        int index = this.getIndexToInsertBefore(pt);
        boolean bDrawAfterLastLine = index == this.list.getModel().getSize();
        Rectangle rect2DNew = new Rectangle();
        int lineWidth = 0;
        int lineHeight = 0;
        int lineX = 0;
        int lineY = 0;
        boolean bDrawNewLine = false;
        if (bDrawAfterLastLine) {
            rect = null;
            if (this.list.getModel().getSize() == 0) {
                rect = this.list.getBounds();
                if (rect != null) {
                    lineWidth = rect.width;
                    lineHeight = 2;
                    lineX = rect.x;
                    lineY = rect.y;
                    bDrawNewLine = true;
                    rect2DNew.setRect(lineX, lineY - 2, lineWidth, lineHeight + 4);
                }
            } else {
                int lastIndex = this.list.getModel().getSize() - 1;
                rect = this.list.getCellBounds(lastIndex, lastIndex);
                if (rect != null) {
                    lineWidth = rect.width;
                    lineHeight = 2;
                    lineX = rect.x;
                    lineY = rect.y + rect.height - lineHeight;
                    bDrawNewLine = true;
                    rect2DNew.setRect(lineX, lineY - 2, lineWidth, lineHeight + 4);
                }
            }
        } else {
            rect = this.list.getCellBounds(index, index);
            if (rect != null) {
                lineWidth = rect.width;
                lineHeight = 2;
                lineX = rect.x;
                lineY = rect.y;
                bDrawNewLine = true;
                rect2DNew.setRect(lineX, lineY - 2, lineWidth, lineHeight + 4);
            }
        }
        if (!this.rect2D.equals(rect2DNew)) {
            this.list.paintImmediately(this.rect2D.getBounds());
            this.rect2D.setBounds(rect2DNew);
        }
        if (bDrawNewLine) {
            Graphics g = this.list.getGraphics();
            g.fillRect(lineX + 2, lineY, lineWidth - 4, lineHeight);
            g.drawLine(lineX + 1, lineY - 1, lineX + 1, lineY + 2);
            g.drawLine(lineX, lineY - 2, lineX, lineY + 3);
            g.drawLine(lineX + lineWidth - 2, lineY - 1, lineX + lineWidth - 2, lineY + 2);
            g.drawLine(lineX + lineWidth - 1, lineY - 2, lineX + lineWidth - 1, lineY + 3);
        }
    }

    protected int getIndexToInsertBefore(Point pt) {
        int indexAtPoint = this.list.locationToIndex(pt);
        Rectangle rect = this.list.getCellBounds(indexAtPoint, indexAtPoint);
        if (rect != null) {
            if (pt.y > rect.y + (int)Math.ceil((float)rect.height / 2.0f)) {
                return indexAtPoint + 1;
            }
            return indexAtPoint;
        }
        return this.list.getModel().getSize();
    }

    private final void clearImage() {
        this.list.paintImmediately(this.rect2D.getBounds());
    }

    protected boolean canPerformAction(JList target, DropTargetDragEvent dtde, Point location) {
        List<DataFlavor> currentDataFlavorsAsList = dtde.getCurrentDataFlavorsAsList();
        if (!currentDataFlavorsAsList.contains(TransferableListItems.LISTITEMS_FLAVOR)) {
            return false;
        }
        int indexToInsertBefore = this.getIndexToInsertBefore(location);
        return this.canPerformAction(target, indexToInsertBefore, dtde.getDropAction());
    }

    public abstract boolean canPerformAction(JList var1, int var2, int var3);

    public abstract boolean executeDrop(JList var1, Object[] var2, int var3, int var4);

    public abstract void cleanup(JList var1, int var2);
}

