/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.diagnos.cmp.tracer.TracerUtilities;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSReceiveStackTTraceController;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveFrontendTransactionElement;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveParentTracer;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveSharedTracerHelper;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class JMSReceiveFrontendTracer
extends FrontendTracer
implements BackendProtocolsConstants,
IInvocationDataParameterCallback {
    private static final Module ModuleName = new Module("JMSReceiveFrontendTracer");
    private final JMSReceiveSharedTracerHelper helper;
    private final IAgent agent;
    private final Object INVOCATION_OBJECT = new Object();
    private final String tracerEncoding;
    private final String ttTracerEncoding = this.buildTTTracerEncoding(this.getNameParameter());
    private final String corTracerEncoding = ",com.wily.introscope.agent.trace.correlation.jms.JMSIncomingCorrelationByReturnTracer,name=MessageReceiver&reentrancy=instance";

    public JMSReceiveFrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.tracerEncoding = String.valueOf(this.ttTracerEncoding) + ",com.wily.introscope.agent.trace.correlation.jms.JMSIncomingCorrelationByReturnTracer,name=MessageReceiver&reentrancy=instance";
        this.agent = agent;
        this.helper = new JMSReceiveSharedTracerHelper(agent, parameters, probe, sampleTracedObject);
        JMSReceiveStackTTraceController.init(agent);
    }

    private void startTxnTraceForReceive(InvocationData data) {
        JMSReceiveSharedTracerHelper.JMSReceiveTxnCache jmsReceiveTxnCache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(data);
        jmsReceiveTxnCache.firstConsumer = data.getInvocationObject();
        jmsReceiveTxnCache.firstDestination = JMSHelper.getConsumerDestination(data);
        if (!jmsReceiveTxnCache.isParentTracerAvailable) {
            return;
        }
        InvocationData syntheticInvocationData = this.newInvocationDataWithTxnTracer(data);
        syntheticInvocationData.IMethodTracer_setReentrancyOverwrite(true);
        syntheticInvocationData.setCursor(data.getCursor());
        syntheticInvocationData.IMethodTracer_startTrace();
        this.clearParams(syntheticInvocationData);
        JMSHelper.debug(ModuleName, "Started the Receive Txn Trace. " + Thread.currentThread());
        syntheticInvocationData.put("jms.synthetic.tracer.run.key", (Object)"true");
        jmsReceiveTxnCache.data = syntheticInvocationData;
    }

    private void clearParams(InvocationData data) {
        data.put("jms.receive.invocationobj.key", null);
    }

    private InvocationData newInvocationDataWithTxnTracer(InvocationData data) {
        ProbeIdentification probe = data.getProbeInformation().getProbeIdentification();
        String probeClassName = probe.getProbeClassName();
        String probeMethodName = probe.getProbeMethodName();
        String probeMethodDescriptor = probe.getProbeMethodDescriptor();
        int probeHashCode = TracerUtilities.calculateProbeHashCode((String)probeClassName, (String)probeMethodName, (String)probeMethodDescriptor, (String)this.tracerEncoding);
        InvocationData newInvocationDataWithTxnTracer = (InvocationData)AgentShim.ProbeBuilderEntryPoint_loadParameterizedTracer((int)probeHashCode, (String)probeClassName, (String)probeMethodName, (String)probeMethodDescriptor, (Object)this.INVOCATION_OBJECT, (String)this.tracerEncoding);
        newInvocationDataWithTxnTracer.put("Method", (Object)probeMethodName);
        newInvocationDataWithTxnTracer.put("Class", (Object)probeClassName);
        this.cloneRequiredParams(data, newInvocationDataWithTxnTracer);
        return newInvocationDataWithTxnTracer;
    }

    private void cloneRequiredParams(InvocationData source, InvocationData dest) {
        String hostName;
        if (JMSHelper.isCachedDestTypeAQueue(source)) {
            dest.put("ATTR_Queue Name", (Object)JMSHelper.getCachedDestinationName(source));
        } else if (JMSHelper.isCachedDestTypeATopic(source)) {
            dest.put("ATTR_Topic Name", (Object)JMSHelper.getCachedDestinationName(source));
        }
        dest.put("jms.destination.type", source.get("jms.destination.type"));
        dest.put("Jms.Destination.Key", source.get("Jms.Destination.Key"));
        dest.put("jms.receive.invocationobj.key", source.getInvocationReturnValueAsObject());
        String queueManagerName = JMSHelper.getCachedQueueManagerName(source);
        if (queueManagerName != null && !queueManagerName.equals("Unknown")) {
            dest.put("QueueManager", (Object)queueManagerName);
        }
        if ((hostName = JMSHelper.getCachedHostName(source)) != null && !hostName.equals("Unknown")) {
            dest.put("Hostname", (Object)hostName);
        }
    }

    private String buildTTTracerEncoding(String name) {
        StringBuilder builder = new StringBuilder(",com.wily.introscope.agent.trace.frontend.jms.JMSReceiveFrontendTTTracer,name=");
        String result = builder.append("Frontends|").append(name).append("&nameformatter=com.wily.introscope.agent.trace.backend.jms.nameformatter.JMSReceiverNameFormatter&newmode=true&reentrancy=instance").toString();
        return result;
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        return this.helper.constructTransactionElement(key, componentName, blameStatus, isStartTrace, parent, previous, start, probeInformation);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean foundInMap;
        JMSReceiveSharedTracerHelper.finishTxnTraceForReceive(data);
        boolean bl = foundInMap = JMSHelper.getDestinationInfoFromSession(data.getInvocationObject()) != null;
        if (JMSReceiveSharedTracerHelper.isParentAlreadyInstrumented(data) && foundInMap && JMSHelper.isStackEmpty(data)) {
            data.put("frontend.jms.JMSReceiveFrontendTracer", (Object)Boolean.TRUE);
            data.setParameterCallback((IInvocationDataParameterCallback)this);
            super.ITracer_startTrace(tracerIndex, data);
        } else if (foundInMap) {
            JMSHelper.debug(ModuleName, "failed to run JMSReceiveFrontendTracer.ITracer_startTrace because the Stack was found to be Empty");
        } else {
            JMSHelper.debug(ModuleName, "failed to run JMSReceiveFrontendTracer.ITracer_startTrace  because the destination  was NULL for the Consumer object. Possibly JMSSessionTracer didn't run.");
        }
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }

    public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData invocationData = (InvocationData)elementData;
        if (invocationData.getInvocationReturnValueAsObject() == null) {
            JMSHelper.debug(ModuleName, "failed to call doOnEndTrace because the message received was seen as NULL");
            return;
        }
        WilyTransactionElement wte = (WilyTransactionElement)((WilyTransactionElement)element).getStartTraceBlamePoint();
        JMSReceiveSharedTracerHelper.JMSReceiveTxnCache jmsReceiveTxnCache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(invocationData);
        jmsReceiveTxnCache.estimatedTimeRepo = ((JMSReceiveFrontendTransactionElement)wte).getEstimatedTimeRepository();
        jmsReceiveTxnCache.lastReceiveTimeInThisThread = invocationData.getWallClockFinishTime();
        super.doOnEndTrace(tracerIndex, elementData, element);
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        super.doOnStartTrace(tracerIndex, elementData, element);
        this.helper.updateTheCustomMetricInStartTrace(tracerIndex, elementData, element);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Boolean wasStartTraceQualified = (Boolean)data.get("frontend.jms.JMSReceiveFrontendTracer");
        if (wasStartTraceQualified != null && wasStartTraceQualified.booleanValue()) {
            super.ITracer_finishTrace(tracerIndex, data);
            if (data.getInvocationReturnValueAsObject() == null && data.getInvocationThrownException() == null) {
                return;
            }
            if (JMSReceiveParentTracer.isTxnTraceEnabled()) {
                if (tracerIndex == 0) {
                    data.setPostfinishTraceCallback((InvocationData.IPostfinishTraceCallback)new PostFinishTraceCallBack());
                } else {
                    JMSHelper.error(ModuleName, "Can't start the Txn Tracing for Receive. " + this.getClass().getName() + " must be the first tracer on receive call");
                }
            }
        }
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map params) {
        String queueManagerName = JMSHelper.getCachedQueueManagerName(data);
        if (queueManagerName != null && !queueManagerName.equals("Unknown")) {
            String topicName;
            params.put("ATTR_QueueManager Name", queueManagerName);
            String hostName = JMSHelper.getCachedHostName(data);
            if (hostName != null && !hostName.equals("Unknown")) {
                params.put("ATTR_QueueManager Hostname", hostName);
            }
            if (JMSHelper.isCachedDestTypeAQueue(data)) {
                String queueName = JMSHelper.getCachedDestinationName(data);
                if (queueName != null) {
                    queueName = queueName.contains("mdWriteEnabled") ? queueName.substring(9, queueName.indexOf("?")) : queueName.replace("queue_", "").replaceAll("/", "");
                    params.put("ATTR_Queue Name", queueName);
                }
            } else if (JMSHelper.isCachedDestTypeATopic(data) && (topicName = JMSHelper.getCachedDestinationName(data)) != null) {
                topicName = topicName.contains("mdWriteEnabled") ? topicName.substring(9, topicName.indexOf("?")) : topicName.replace("topic_", "").replaceAll("/", "");
                params.put("ATTR_Topic Name", topicName);
            }
        } else if (JMSHelper.isCachedDestTypeAQueue(data)) {
            params.put("ATTR_Queue Name", JMSHelper.getCachedDestinationName(data));
        } else if (JMSHelper.isCachedDestTypeATopic(data)) {
            params.put("ATTR_Topic Name", JMSHelper.getCachedDestinationName(data));
        }
    }

    private final class PostFinishTraceCallBack
    implements InvocationData.IPostfinishTraceCallback {
        private PostFinishTraceCallBack() {
        }

        public void doPostFinishCallback(InvocationData data) {
            JMSReceiveFrontendTracer.this.startTxnTraceForReceive(data);
        }
    }
}

