/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledMethod;

public final class AnnotationMethodMatcher
implements IMethodMatcher {
    private final IClassName fClassName;

    public AnnotationMethodMatcher(IClassName name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.fClassName = name;
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        boolean result = method.containsAnnotation(this.fClassName);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(16384);
            current.setAnnotationName(this.fClassName.getContainerAndPackageAndNameString());
        }
        return result;
    }

    public String toString() {
        return "[NamedMethodMatcher: Annotation=" + this.fClassName + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof AnnotationMethodMatcher) {
            AnnotationMethodMatcher matcher = (AnnotationMethodMatcher)o;
            return this.fClassName.equals(matcher.fClassName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

