/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;

public class IntegerFluctuatingCounterMetric
implements MetricValueListener<Integer> {
    final IIntegerFluctuatingCounterDataAccumulator acc;

    public IntegerFluctuatingCounterMetric(String metricName) {
        JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
        if (!clamp.isClampHit()) {
            clamp.incrementMetricCounter();
            this.acc = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
        } else {
            clamp.printClampWarning();
            this.acc = null;
        }
    }

    @Override
    public void update(Integer value) {
        if (this.acc != null) {
            this.acc.IIntegerCounterDataAccumulator_setValue(value.intValue());
        }
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Integer;
    }

    @Override
    public void close() {
        if (this.acc != null) {
            JmxClamp.getInstance(Configuration.getAgent()).decrementMetricCounter();
            Configuration.getAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.acc);
        }
    }

    public int hashCode() {
        return this.acc == null ? 0 : this.acc.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerFluctuatingCounterMetric other = (IntegerFluctuatingCounterMetric)obj;
        return !(this.acc == null ? other.acc != null : !this.acc.equals(other.acc));
    }
}

