/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGAnnotationClassMatcher
extends AImmutableClassMatcher {
    private static final Map<String, DGAnnotationClassMatcher> singleton = new HashMap<String, DGAnnotationClassMatcher>();
    private ThreadLocal<ResultPair<IModeledClass, Boolean>> cachedResult;
    private final IClassName fClassName;

    private DGAnnotationClassMatcher(IClassName className) {
        if (singleton.containsKey(className.getReflectionFriendlyQualifiedNameString())) {
            throw new RuntimeException("Instance already created");
        }
        this.fClassName = className;
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult = new ThreadLocal();
        }
    }

    public static DGAnnotationClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGAnnotationClassMatcher(className));
        }
        return singleton.get(name);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        ResultPair<IModeledClass, Boolean> prevResult;
        if (AutoProbeTransformer.cacheDirectiveResults && (prevResult = this.cachedResult.get()) != null && ((IModeledClass)prevResult.first).equals(cls)) {
            return (Boolean)prevResult.second;
        }
        boolean result = cls.containsAnnotation(this.fClassName);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setAnnotationName(this.fClassName.getContainerAndPackageAndNameString());
            current.setComment("DGAnnotationClassMatcher detected the annotation name as annotation in the modelled class");
            current.setSkipCause(256);
        }
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult.set(new ResultPair<IModeledClass, Boolean>(cls, result));
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGAnnotationClassMatcher) {
            DGAnnotationClassMatcher m = (DGAnnotationClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getReflectionFriendlyQualifiedNameString())};
    }
}

