/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;

public class DGCorbaClassMatcher
extends AImmutableClassMatcher {
    private static DGCorbaClassMatcher singleton;
    private ThreadLocal<ResultPair<IModeledClass, Boolean>> cachedResult;

    private DGCorbaClassMatcher() {
        if (singleton != null) {
            throw new RuntimeException("Instance already created");
        }
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult = new ThreadLocal();
        }
    }

    public static DGCorbaClassMatcher getInstance() {
        if (singleton == null) {
            singleton = new DGCorbaClassMatcher();
        }
        return singleton;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        ResultPair<IModeledClass, Boolean> prevResult;
        if (AutoProbeTransformer.cacheDirectiveResults && (prevResult = this.cachedResult.get()) != null && ((IModeledClass)prevResult.first).equals(cls)) {
            return (Boolean)prevResult.second;
        }
        boolean result = this.IClassMatcher_matches(cls.getClassName());
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult.set(new ResultPair<IModeledClass, Boolean>(cls, result));
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return true;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        boolean result;
        String unqualified = className.getNameString();
        boolean bl = result = unqualified.startsWith("_sk_") || unqualified.startsWith("_st_");
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setCorbaName(unqualified);
            current.setSkipCause(512);
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof DGCorbaClassMatcher;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

