/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.introscope.agent.transformer.dynamic.IOldDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.introscope.api.instrument.DeepInheritanceHelper;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.autoprobe.OverheadManagementHelper;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGDeepInheritedAnnotationClassMatcher
extends AImmutableClassMatcher {
    private static final Map<String, DGDeepInheritedAnnotationClassMatcher> singleton = new HashMap<String, DGDeepInheritedAnnotationClassMatcher>();
    private ThreadLocal<ResultPair<IModeledClass, Boolean>> cachedResult;
    private final IClassName fAnnotationClassName;
    private final String fRootAnnotationName;
    private final int fRootAnnotationNameIndex;

    private DGDeepInheritedAnnotationClassMatcher(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (singleton.containsKey(name)) {
            throw new RuntimeException("Instance already created");
        }
        this.fAnnotationClassName = className;
        this.fRootAnnotationName = name;
        this.fRootAnnotationNameIndex = DeepInheritanceHelper.classNameForest.addAndGetID(this.fRootAnnotationName);
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult = new ThreadLocal();
        }
    }

    public static DGDeepInheritedAnnotationClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGDeepInheritedAnnotationClassMatcher(className));
        }
        return singleton.get(name);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        boolean result;
        ResultPair<IModeledClass, Boolean> prevResult;
        String overheadMode = OverheadManagementHelper.getOverheadMode();
        if (overheadMode != null && overheadMode.equalsIgnoreCase("none")) {
            return false;
        }
        if (AutoProbeTransformer.cacheDirectiveResults && (prevResult = this.cachedResult.get()) != null && ((IModeledClass)prevResult.first).equals(cls)) {
            return (Boolean)prevResult.second;
        }
        if (System.getProperty("com.wily.introscope.agent.starter").equals("premain") && System.getProperty("com.wily.introscope.deepInheritance.implementationVersion", "1").equals("1")) {
            IOldDeepInheritanceHelper helper = ThreadLocalClassHelper.getDeepInheritanceHelper();
            result = cls.containsAnnotation(this.fAnnotationClassName);
            if (helper != null) {
                if (result) {
                    helper.noticeFoundAnnotationRoot(cls.getClassName(), this.fAnnotationClassName);
                } else {
                    result = helper.addAnnotationMatchRequest(cls, this.fAnnotationClassName);
                }
            }
        } else {
            result = DeepInheritanceHelper.matchForAnnotation((int)this.fRootAnnotationNameIndex, (IModeledClass)cls, (boolean)false);
        }
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult.set(new ResultPair<IModeledClass, Boolean>(cls, result));
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    public IClassName getClassName() {
        return this.fAnnotationClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fAnnotationClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGDeepInheritedAnnotationClassMatcher) {
            DGDeepInheritedAnnotationClassMatcher m = (DGDeepInheritedAnnotationClassMatcher)obj;
            return this.fAnnotationClassName.equals(m.fAnnotationClassName);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

