/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IDynamicClassMatcher;
import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.introscope.agent.transformer.dynamic.IOldDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.introscope.api.instrument.DeepInheritanceHelper;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.autoprobe.OverheadManagementHelper;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGDeepInheritedClassMatcher
extends AImmutableClassMatcher
implements IDynamicClassMatcher {
    private static final Map<String, DGDeepInheritedClassMatcher> singleton = new HashMap<String, DGDeepInheritedClassMatcher>();
    private ThreadLocal<ResultPair<IModeledClass, Boolean>> cachedResult;
    private final IClassName fClassName;
    private final String fRootClassName;
    private final int fRootClassNameIndex;

    private DGDeepInheritedClassMatcher(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (singleton.containsKey(name)) {
            throw new RuntimeException("Instance already created");
        }
        this.fClassName = className;
        this.fRootClassName = name;
        this.fRootClassNameIndex = DeepInheritanceHelper.classNameForest.addAndGetID(this.fRootClassName);
        this.cachedResult = new ThreadLocal();
    }

    public static DGDeepInheritedClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGDeepInheritedClassMatcher(className));
        }
        return singleton.get(name);
    }

    private boolean executeMatches(IModeledClass cls) {
        if (System.getProperty("com.wily.introscope.agent.starter").equals("premain") && System.getProperty("com.wily.introscope.deepInheritance.implementationVersion", "1").equals("1")) {
            IOldDeepInheritanceHelper helper = ThreadLocalClassHelper.getDeepInheritanceHelper();
            if (ClassFileUtilities.looselyMatches((IClassName)this.fClassName, (IClassName)cls.getClassName())) {
                if (helper != null) {
                    helper.noticeFoundRoot(this.fClassName);
                }
                return true;
            }
            if (cls.hasSuperClass() && ClassFileUtilities.looselyMatches((IClassName)this.fClassName, (IClassName)cls.getSuperClassName())) {
                return true;
            }
            if (cls.inheritsDirectlyFromInterface(this.fClassName)) {
                return true;
            }
            if (helper != null) {
                return helper.addInheritanceMatchRequest(cls, this.fClassName);
            }
            return false;
        }
        return DeepInheritanceHelper.matchForClass((int)this.fRootClassNameIndex, (IModeledClass)cls, (boolean)false);
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    @Override
    public IClassName getClassName() {
        return this.fClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGDeepInheritedClassMatcher) {
            DGDeepInheritedClassMatcher m = (DGDeepInheritedClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        ResultPair<IModeledClass, Boolean> prevResult;
        String overheadMode = OverheadManagementHelper.getOverheadMode();
        if (overheadMode != null && overheadMode.equalsIgnoreCase("none")) {
            return false;
        }
        if (AutoProbeTransformer.cacheDirectiveResults && (prevResult = this.cachedResult.get()) != null && ((IModeledClass)prevResult.first).equals(cls)) {
            return (Boolean)prevResult.second;
        }
        boolean result = this.executeMatches(cls);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setInheritedClassName(this.fClassName);
            current.setSkipCause(4096);
        }
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult.set(new ResultPair<IModeledClass, Boolean>(cls, result));
        }
        return result;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

