/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGExactClassMatcher
extends AImmutableClassMatcher {
    private static final Map<String, DGExactClassMatcher> singleton = new HashMap<String, DGExactClassMatcher>();
    private ThreadLocal<ResultPair<IModeledClass, Boolean>> cachedResult;
    protected final IClassName fClassName;

    private DGExactClassMatcher(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (singleton.containsKey(name)) {
            throw new RuntimeException("Instance already created");
        }
        this.fClassName = className;
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult = new ThreadLocal();
        }
    }

    public static DGExactClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGExactClassMatcher(className));
        }
        return singleton.get(name);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        ResultPair<IModeledClass, Boolean> prevResult;
        if (AutoProbeTransformer.cacheDirectiveResults && (prevResult = this.cachedResult.get()) != null && ((IModeledClass)prevResult.first).equals(cls)) {
            return (Boolean)prevResult.second;
        }
        boolean result = this.IClassMatcher_matches(cls.getClassName());
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult.set(new ResultPair<IModeledClass, Boolean>(cls, result));
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return true;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        boolean result = ClassFileUtilities.looselyMatches((IClassName)this.fClassName, (IClassName)className);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(1024);
            current.setExactClassMatcherPattern(this.fClassName);
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGExactClassMatcher) {
            DGExactClassMatcher m = (DGExactClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getPackageAndNameString())};
    }
}

