/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.Glob;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGGlobClassMatcher
extends AImmutableClassMatcher {
    private static final Map<String, DGGlobClassMatcher> singleton = new HashMap<String, DGGlobClassMatcher>();
    private ThreadLocal<ResultPair<IModeledClass, Boolean>> cachedResult;
    private Glob fGlob;

    private DGGlobClassMatcher(String classPattern) {
        if (singleton.containsKey(classPattern)) {
            throw new RuntimeException("Instance already created");
        }
        this.fGlob = new Glob(classPattern.replace('.', '/').trim());
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult = new ThreadLocal();
        }
    }

    public static DGGlobClassMatcher getInstance(String classPattern) {
        if (!singleton.containsKey(classPattern)) {
            singleton.put(classPattern, new DGGlobClassMatcher(classPattern));
        }
        return singleton.get(classPattern);
    }

    private DGGlobClassMatcher(String classPattern, IClassSchemaPolicy classSchemaPolicy) {
        String patternMatchingFriendlyName = classSchemaPolicy.getPatternMatchingFriendlyName(classPattern);
        if (singleton.containsKey(patternMatchingFriendlyName)) {
            throw new RuntimeException("Instance already created");
        }
        this.fGlob = new Glob(patternMatchingFriendlyName);
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult = new ThreadLocal();
        }
    }

    public static DGGlobClassMatcher getInstance(String classPattern, IClassSchemaPolicy classSchemaPolicy) {
        String patternMatchingFriendlyName = classSchemaPolicy.getPatternMatchingFriendlyName(classPattern);
        if (!singleton.containsKey(patternMatchingFriendlyName)) {
            singleton.put(patternMatchingFriendlyName, new DGGlobClassMatcher(classPattern, classSchemaPolicy));
        }
        return singleton.get(patternMatchingFriendlyName);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        ResultPair<IModeledClass, Boolean> prevResult;
        if (AutoProbeTransformer.cacheDirectiveResults && (prevResult = this.cachedResult.get()) != null && ((IModeledClass)prevResult.first).equals(cls)) {
            return (Boolean)prevResult.second;
        }
        boolean result = this.IClassMatcher_matches(cls.getClassName());
        if (AutoProbeTransformer.cacheDirectiveResults) {
            this.cachedResult.set(new ResultPair<IModeledClass, Boolean>(cls, result));
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return true;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        boolean result = this.matches(className.getContainerAndPackageAndNameString());
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(2048);
        }
        return result;
    }

    public String toString() {
        return this.fGlob.toString();
    }

    private boolean matches(String name) {
        return this.fGlob.matches(name);
    }

    public static void main(String[] args) {
        String pattern = args[0];
        String name = args[1];
        DGGlobClassMatcher m = DGGlobClassMatcher.getInstance(pattern);
        System.out.println(m.matches(name) ? "matches" : "does not match");
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fGlob.getPattern());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGGlobClassMatcher) {
            DGGlobClassMatcher m = (DGGlobClassMatcher)obj;
            return this.fGlob.getPattern().equals(m.fGlob.getPattern());
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

