/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.log;

import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.DGSummaryInfo;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.ISummaryInfo;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.util.INameChangeListener;
import com.wily.util.LogFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.io.NullOutputStream;
import com.wily.util.text.IStringLocalizer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class DGCompilerLog
implements ICompilerLog,
INameChangeListener {
    private static final String kProcessingClassPrefix = "Processing class ";
    private static final String kProcessingClassRedefineSuffix = " (redefine/retransform)";
    private static final String kSkippingClassPrefix = "Skipping class ";
    private static final String kSkippingBootstrapClassPrefix = "Skipping bootstrap class ";
    public static final String kSkippingClassForFlagPrefix = "Skipping class for Tracer group ";
    private static final String kProcessingMethodPrefix = "Processing method ";
    private static final String kProcessingMethodClassSeparator = "::";
    private static final String kSkippingMethodPrefix = "Skipping method ";
    private static final String kSkippingMethodClassSeparator = "::";
    private static final String kCopyingFilePrefix = "Copying file ";
    private static final String kSkippingFilePrefix = "Skipping file ";
    private static final String kStartingDirectory = "Starting directory ";
    private static final String kFinishedDirectory = "Finished directory ";
    private static final String kStartingArchive = "Starting archive ";
    private static final String kFinishedArchive = "Finished archive ";
    private static final String kClassAlreadyInstrumentedMessage = "The class file has already been instrumented.  No additional changes will be attempted.";
    private static final String kAbortedMessage = "Processing aborted for ";
    private static final String kErrorMessage = "Processing stopped because of error for ";
    private static final String kFileSettingsHeader = "Instrumentation File Settings";
    private static final String kFileSettingsCopyItemsMessage = "Copy non-bytecode files and archive entries";
    private static final String kFileSettingsSkipItemsMessage = "Skip non-bytecode files and archive entries";
    private static final String kStartingFileDumpPrefix = "Starting file dump for ";
    private static final String kFileDumpIndent = "> ";
    private static final String kEndingFileDumpPrefix = "Finished file dump for ";
    private static final String kInvalidSettingsPrefix = "Unable to instrument.  Invalid settings provided: ";
    private static final String kExceptionWithoutContextPrefix = "A problem occurred";
    private static final String kExceptionWithContextPrefix = "A problem occurred while processing ";
    private static final String kMessageSeparator = ": ";
    private static final String kSummaryHeader = "Results Summary:";
    private static final String kSummaryNumClassesPrefix = "\tTotal Classes Encountered:     ";
    private static final String kSummaryNumModifiedClassesPrefix = "\tTotal Classes Modified:        ";
    private static final String kSummaryNumSkippedClassesPrefix = "\tTotal Classes Skipped:         ";
    private static final String kSummaryNumArchivesPrefix = "\tTotal Number Of Archives:      ";
    private static final String kSummaryNumCopiedFilesPrefix = "\tTotal Number Of Files Copied:  ";
    private static final String kSummaryNumSkippedFilesPrefix = "\tTotal Number Of Files Skipped: ";
    private static final String kSummaryNumErrorsPrefix = "\tTotal Number Of Errors:        ";
    private static final char kTitleCharacter = '=';
    private static final char kErrorCharacter = '*';
    private final Lock fLoggingLock = new Lock();
    private String fEncoding = null;
    private PrintWriter fLog;
    private String fPath;
    private int fAutoProbeLogLimit = -1;
    private static final int kLogSizeCheckFrequency = 100;
    private File file;
    private static int count = 0;
    private IStringLocalizer fStringLocalizer = null;
    private IModuleFeedbackChannel fModuleFeedback = null;
    private String fApplicationName = null;
    private String fFullName = null;
    private String fBaseName = null;
    private DGSummaryInfo fSummary;
    private boolean fCurrentClassModified;
    private File[] fCreatedDirs;
    private static final int kIndentation = 35;
    private boolean fUseTabSeparator = false;
    private IModeledClass fLastMutatedClass;

    public DGCompilerLog(File file, String applicationName, IStringLocalizer localizer, IModuleFeedbackChannel feedback) throws IOException {
        this.initialize(file.toString(), file.toString(), this.safeMakeOutputStream(file.toString()), applicationName, localizer, feedback);
    }

    public DGCompilerLog(String fullName, String baseName, OutputStream out, String applicationName, IStringLocalizer localizer, IModuleFeedbackChannel feedback) throws IOException {
        this.initialize(fullName, baseName, out, applicationName, localizer, feedback);
    }

    public DGCompilerLog(String fullName, String baseName, OutputStream out, String path, String applicationName, IStringLocalizer localizer, IModuleFeedbackChannel feedback) throws IOException {
        this.initialize(fullName, baseName, out, applicationName, localizer, feedback);
        this.fPath = path;
    }

    public DGCompilerLog(String fullName, OutputStream out, String applicationName, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        this.initialize(fullName, fullName, out, applicationName, localizer, feedback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(String fullName, String baseName, OutputStream out, String applicationName, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        String logSize;
        this.fApplicationName = applicationName;
        this.fStringLocalizer = localizer;
        this.fModuleFeedback = feedback;
        this.fLastMutatedClass = null;
        this.fEncoding = System.getProperty("com.wily.introscope.default.encoding");
        if (this.fEncoding == null || "".equals(this.fEncoding)) {
            this.fEncoding = System.getProperty("file.encoding");
        }
        if ((logSize = System.getProperty("com.wily.autoprobe.logSizeInKB")) != null) {
            try {
                this.fAutoProbeLogLimit = Integer.parseInt(logSize);
            }
            catch (Exception e) {
                this.getModuleFeedback().error("Error occured while getting autoprobe log limit ", (Throwable)e);
                this.fAutoProbeLogLimit = -1;
            }
        }
        if (this.fAutoProbeLogLimit > 0) {
            PrintWriter log;
            try {
                log = this.createPrintWriterWithFile(fullName, out);
                if (log == null) {
                    log = this.createPrintWriterForEncoding(this.fEncoding, out);
                }
            }
            catch (FileNotFoundException fnfe) {
                this.getModuleFeedback().error("File Not Found", (Throwable)fnfe);
                log = this.createPrintWriterForEncoding(this.fEncoding, out);
            }
            Lock lock = this.getLoggingLock();
            synchronized (lock) {
                this.fLog = log;
            }
        }
        PrintWriter log = this.createPrintWriterForEncoding(this.fEncoding, out);
        Lock lock = this.getLoggingLock();
        synchronized (lock) {
            this.fLog = log;
        }
        this.fFullName = fullName;
        this.fBaseName = baseName;
        this.fSummary = new DGSummaryInfo();
        this.fCurrentClassModified = false;
        if (this.fPath == null && this.file != null) {
            this.fPath = this.file.getAbsolutePath();
        }
    }

    private PrintWriter createPrintWriterWithFile(String fullName, OutputStream out) throws FileNotFoundException {
        PrintWriter log = null;
        try {
            this.file = new File(fullName);
            if (this.file != null) {
                log = new PrintWriter(new FileOutputStream(this.file, true));
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Throwable t) {
            this.getModuleFeedback().error("Exception occured", t);
            log = this.createPrintWriterForEncoding(this.fEncoding, out);
        }
        return log;
    }

    private PrintWriter createPrintWriterForEncoding(String fEncoding, OutputStream out) {
        try {
            if (fEncoding == null || "".equals(fEncoding)) {
                return new PrintWriter(out, true);
            }
            return new PrintWriter((Writer)new OutputStreamWriter(out, fEncoding), true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new PrintWriter(out, true);
        }
    }

    private final Lock getLoggingLock() {
        return this.fLoggingLock;
    }

    protected OutputStream safeMakeOutputStream(String fileName) throws IOException {
        File filePath = this.safeMakeFile(fileName);
        return new BufferedOutputStream(new FileOutputStream(filePath));
    }

    protected File safeMakeFile(String fileName) throws IOException {
        ExtendedFile path;
        File filePath = ExtendedFile.getCanonicalFile((String)fileName);
        String pathHead = filePath.getParent();
        if (pathHead != null && !(path = new ExtendedFile(pathHead)).exists()) {
            this.fCreatedDirs = this.missingDirs(path.getFile());
            path.makeDirectories();
        }
        this.fPath = filePath.getAbsolutePath();
        return filePath;
    }

    private File[] missingDirs(File path) {
        Vector<File> newDirs = new Vector<File>();
        while (path != null && !path.exists()) {
            newDirs.addElement(path);
            String parent = path.getParent();
            path = new File(parent);
        }
        Object[] dirs = new File[newDirs.size()];
        newDirs.copyInto(dirs);
        return dirs;
    }

    public File[] getCreatedDirectories() {
        return this.fCreatedDirs;
    }

    @Override
    public String ICompilerLog_getPath() {
        return this.fPath;
    }

    @Override
    public ISummaryInfo ICompilerLog_getSummaryInfo() {
        return this.fSummary;
    }

    @Override
    public void ICompilerLog_logHeader(String copyrightString, String releaseAndBuildVersion, String dgVersion) {
        this.ICompilerLog_logMessage(String.valueOf(this.fApplicationName) + " Log: " + this.fFullName);
        this.ICompilerLog_logMessage(String.valueOf(releaseAndBuildVersion) + "(" + dgVersion + ")");
        this.ICompilerLog_logMessage("Log opened at " + new Date());
        this.ICompilerLog_logMessage(copyrightString);
        this.ICompilerLog_logMessage("==================================================================");
    }

    @Override
    public void ICompilerLog_logSkippedBootstrapClass(String className) {
        this.ICompilerLog_logMessage(kProcessingClassPrefix + className);
        this.fSummary.ISummaryInfo_addClass();
        this.ICompilerLog_logMessage(kSkippingBootstrapClassPrefix + className);
        this.fSummary.ISummaryInfo_addSkippedClass();
    }

    @Override
    public void ICompilerLog_logSkippedClass(String className) {
        this.ICompilerLog_logMessage(kProcessingClassPrefix + className);
        this.fSummary.ISummaryInfo_addClass();
        this.ICompilerLog_logMessage(kSkippingClassPrefix + className);
        this.fSummary.ISummaryInfo_addSkippedClass();
    }

    @Override
    public void ICompilerLog_logSkippedClassForFlag(String flagName) {
        this.logOperation(kSkippingClassForFlagPrefix + flagName);
    }

    @Override
    public void ICompilerLog_logSkippedMethod(IClassName className, IMethodName methodName) {
        this.ICompilerLog_logMessage(kSkippingMethodPrefix + className.getContainerAndPackageAndNameString() + "::" + methodName.getNameAndSignatureString());
    }

    @Override
    public void ICompilerLog_setCurrentClass(IClassName className, boolean isRedefine) {
        String message = kProcessingClassPrefix + className.getContainerAndPackageAndNameString();
        if (isRedefine) {
            message = String.valueOf(message) + kProcessingClassRedefineSuffix;
        }
        this.ICompilerLog_logMessage(message);
        this.fSummary.ISummaryInfo_addClass();
        this.fCurrentClassModified = false;
    }

    @Override
    public void ICompilerLog_setCurrentMethod(IClassName className, IMethodName methodName) {
        this.ICompilerLog_logMessage(kProcessingMethodPrefix + className.getContainerAndPackageAndNameString() + "::" + methodName.getNameAndSignatureString());
    }

    @Override
    public void ICompilerLog_setSkippedClass(IClassName className) {
        this.ICompilerLog_logMessage(kSkippingClassPrefix + className.getContainerAndPackageAndNameString());
        this.fSummary.ISummaryInfo_addSkippedClass();
    }

    @Override
    public void ICompilerLog_setCopiedFile(String filename) {
        this.ICompilerLog_logMessage(kCopyingFilePrefix + filename);
        this.fSummary.ISummaryInfo_addCopiedFile();
    }

    @Override
    public void ICompilerLog_setSkippedFile(String filename) {
        this.ICompilerLog_logMessage(kSkippingFilePrefix + filename);
        this.fSummary.ISummaryInfo_addSkippedFile();
    }

    @Override
    public void ICompilerLog_startArchive(String archive) {
        this.ICompilerLog_logMessage("");
        this.ICompilerLog_logTitleMessage(kStartingArchive + archive);
        this.fSummary.ISummaryInfo_addArchive();
    }

    @Override
    public void ICompilerLog_finishArchive(String archive) {
        this.ICompilerLog_logTitleMessage(kFinishedArchive + archive);
        this.ICompilerLog_logMessage("");
    }

    @Override
    public void ICompilerLog_startDirectory(String directory) {
        this.ICompilerLog_logMessage("");
        this.ICompilerLog_logTitleMessage(kStartingDirectory + directory);
    }

    @Override
    public void ICompilerLog_finishDirectory(String directory) {
        this.ICompilerLog_logTitleMessage(kFinishedDirectory + directory);
        this.ICompilerLog_logMessage("");
    }

    @Override
    public void ICompilerLog_finishAborted(String element) {
        this.ICompilerLog_logErrorMessage(kAbortedMessage + element);
    }

    @Override
    public void ICompilerLog_finishException(String element) {
        this.ICompilerLog_logErrorMessage(kErrorMessage + element);
        this.ICompilerLog_logMessage("");
    }

    @Override
    public void ICompilerLog_logInheritanceChange(IClassName originalSuperClass, IClassName newSuperClass) {
        this.logOperation("Inheritance Change: Superclass changed from " + originalSuperClass.getContainerAndPackageAndNameString() + " to " + newSuperClass.getContainerAndPackageAndNameString());
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logMemberReferenceChange(String originalMember, String newMember) {
        this.logOperation("Member reference change: references changed from " + originalMember + " to " + newMember);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logStartupCallInsertion(IModeledMethod method, int lineNumber, IClassName traceClassName) {
        this.logOperation(method, lineNumber, "Inserted startup call to " + traceClassName.getContainerAndPackageAndNameString() + ".ProbeBuilderEntryPoint_initializeAgentShim()");
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logClassSubstitution(IModeledMethod method, int lineNumber, String originalClassName, String substituteClassName) {
        this.logOperation(method, lineNumber, "Substitute Class Allocation: " + originalClassName + " replaced by " + substituteClassName);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logInstrumentation(IModeledMethod method, int lineNumber, String fullyQualifiedMethodName) {
        this.logOperation(method, lineNumber, "Instrumentation Point: call to static method " + fullyQualifiedMethodName);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logMethodTracer(IModeledMethod method, int lineNumber, MethodTracer tracer) {
        String tracerName = tracer.getTracerClass().getContainerAndPackageAndNameString();
        this.logOperation(method, lineNumber, "inserted method tracer object allocation: " + tracerName);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logSubstituteResult(IModeledMethod method, String substituteMethod) {
        this.logOperation(method, 0, "substituted result with result of: " + substituteMethod);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logInsertOnMethod(IModeledMethod method, String insertionMethod) {
        this.logOperation(method, 0, "inserted static method: " + insertionMethod);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logNoticeConstructorCompletion(IModeledMethod method, String notificationMethod) {
        this.logOperation(method, 0, "noticed constructor completion with: " + notificationMethod);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logNoticeObjectCreation(IModeledMethod method, String createdType, IClassName notificationClass) {
        this.logOperation(method, 0, "noticed creation of type " + createdType + " with class " + notificationClass.getContainerAndPackageAndNameString());
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logNoticeFieldAssignment(IModeledMethod method, String fieldClass, String fieldName, IClassName notificationClass) {
        this.logOperation(method, 0, "noticed assignment of field " + fieldClass + "." + fieldName + " with class " + notificationClass.getContainerAndPackageAndNameString());
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logClassAlreadyInstrumented() {
        this.ICompilerLog_logMessage(kClassAlreadyInstrumentedMessage);
    }

    @Override
    public void ICompilerLog_logInternalError(IModeledMethod method, int lineNumber, String msg) {
        this.logOperation(method, lineNumber, "Error: " + msg);
        this.fSummary.ISummaryInfo_addError();
    }

    private void logOperation(String message) {
        this.logOperation("< n/a >", message);
    }

    private void logOperation(IModeledClass targetClass, String message) {
        this.logOperation(targetClass.getClassName().getNameString(), message);
    }

    private void logOperation(IModeledMethod method, int lineNumber, String message) {
        String methodName = "<Unknown>";
        if (method != null) {
            methodName = String.valueOf(method.getModeledClass().getClassName().getNameString()) + "." + method.getMethodName().getNameString();
        }
        String line = null;
        if (lineNumber <= 0 && method instanceof DGMethod) {
            lineNumber = ((DGMethod)method).getLineOfCode();
        }
        if (lineNumber > 0) {
            line = Integer.toString(lineNumber);
        }
        String desc = line == null ? methodName : String.valueOf(methodName) + ":" + line;
        this.logOperation(desc, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrint(String desc, String message) {
        Lock lock = this.getLoggingLock();
        synchronized (lock) {
            if (desc != null) {
                this.fLog.println(String.valueOf(this.buildIndentation()) + this.padPostfix(desc, 35) + message);
            } else {
                this.fLog.println(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogBorder(int length, char borderChar) {
        Lock lock = this.getLoggingLock();
        synchronized (lock) {
            int i = 0;
            while (i < length) {
                this.fLog.print(borderChar);
                ++i;
            }
            this.fLog.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOperationWithAutoprobeSizeSet(int length, char borderChar) {
        if (++count >= 100) {
            if (this.file.length() / 1000L >= (long)this.fAutoProbeLogLimit) {
                Lock lock = this.getLoggingLock();
                synchronized (lock) {
                    this.fLog.close();
                }
            } else {
                this.doLogBorder(length, borderChar);
                count = 0;
            }
        } else {
            this.doLogBorder(length, borderChar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOperationWithAutoprobeSizeSet(String desc, String message) {
        if (++count >= 100) {
            if (this.file.length() / 1000L >= (long)this.fAutoProbeLogLimit) {
                Lock lock = this.getLoggingLock();
                synchronized (lock) {
                    this.fLog.close();
                }
            } else {
                this.doPrint(desc, message);
                count = 0;
            }
        } else {
            this.doPrint(desc, message);
        }
    }

    private void logOperationWithAutoprobeSizeSet(String message) {
        this.logOperationWithAutoprobeSizeSet(null, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOperation(String desc, String message) {
        if (this.fAutoProbeLogLimit > 0) {
            this.logOperationWithAutoprobeSizeSet(desc, message);
        } else {
            Lock lock = this.getLoggingLock();
            synchronized (lock) {
                this.fLog.println(String.valueOf(this.buildIndentation()) + this.padPostfix(desc, 35) + message);
            }
        }
    }

    @Override
    public void ICompilerLog_logFileSettings(DGFileSettings fileSettings) {
        this.ICompilerLog_logTitleMessage(kFileSettingsHeader);
        if (fileSettings.shouldCopyItems()) {
            this.ICompilerLog_logMessage(kFileSettingsCopyItemsMessage);
        } else {
            this.ICompilerLog_logMessage(kFileSettingsSkipItemsMessage);
        }
    }

    @Override
    public void ICompilerLog_dumpFile(String context, String filename, List contents) {
        this.ICompilerLog_logMessage("");
        this.ICompilerLog_logMessage(context);
        this.ICompilerLog_logMessage(kStartingFileDumpPrefix + filename);
        if (contents != null) {
            int i = 0;
            while (i < contents.size()) {
                this.ICompilerLog_logMessage(kFileDumpIndent + (String)contents.get(i));
                ++i;
            }
        }
        this.ICompilerLog_logMessage(kEndingFileDumpPrefix + filename);
        this.ICompilerLog_logMessage("");
    }

    @Override
    public void ICompilerLog_logInvalidSettings(String specifics) {
        AInstrumentationHelper.setAutoProbeInvalidSettings((boolean)true);
        this.ICompilerLog_logErrorMessage(kInvalidSettingsPrefix + specifics);
    }

    @Override
    public void ICompilerLog_logTitleMessage(String message) {
        this.logBorder(message.length(), '=');
        this.ICompilerLog_logMessage(message);
        this.logBorder(message.length(), '=');
    }

    @Override
    public void ICompilerLog_logErrorMessage(String error) {
        this.logBorder(error.length(), '*');
        this.ICompilerLog_logMessage(error);
        this.logBorder(error.length(), '*');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logBorder(int length, char borderChar) {
        if (this.fAutoProbeLogLimit > 0) {
            this.logOperationWithAutoprobeSizeSet(length, borderChar);
        } else {
            Lock lock = this.getLoggingLock();
            synchronized (lock) {
                int i = 0;
                while (i < length) {
                    this.fLog.print(borderChar);
                    ++i;
                }
                this.fLog.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ICompilerLog_logMessage(String message) {
        if (this.fAutoProbeLogLimit > 0) {
            this.logOperationWithAutoprobeSizeSet(message);
        } else {
            Lock lock = this.getLoggingLock();
            synchronized (lock) {
                this.fLog.println(message);
            }
        }
    }

    @Override
    public void ICompilerLog_logException(Throwable e) {
        this.ICompilerLog_logException(null, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ICompilerLog_logException(String context, Throwable e) {
        Lock lock = this.getLoggingLock();
        synchronized (lock) {
            if (context == null) {
                this.ICompilerLog_logErrorMessage("A problem occurred: " + e.getMessage());
            } else {
                this.ICompilerLog_logErrorMessage(kExceptionWithContextPrefix + context + kMessageSeparator + e.getMessage());
            }
            e.printStackTrace(this.fLog);
            this.fSummary.ISummaryInfo_addError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ICompilerLog_close() {
        Lock lock = this.getLoggingLock();
        synchronized (lock) {
            this.logSummary();
            this.logFooter();
            this.fLog.close();
        }
    }

    private void logSummary() {
        this.ICompilerLog_logMessage("");
        this.ICompilerLog_logMessage(kSummaryHeader);
        this.ICompilerLog_logMessage(kSummaryNumClassesPrefix + this.fSummary.ISummaryInfo_getNumClasses());
        this.ICompilerLog_logMessage(kSummaryNumModifiedClassesPrefix + this.fSummary.ISummaryInfo_getNumModifiedClasses());
        this.ICompilerLog_logMessage(kSummaryNumSkippedClassesPrefix + this.fSummary.ISummaryInfo_getNumSkippedClasses());
        this.ICompilerLog_logMessage(kSummaryNumArchivesPrefix + this.fSummary.ISummaryInfo_getNumArchives());
        this.ICompilerLog_logMessage(kSummaryNumCopiedFilesPrefix + this.fSummary.ISummaryInfo_getNumCopiedFiles());
        this.ICompilerLog_logMessage(kSummaryNumSkippedFilesPrefix + this.fSummary.ISummaryInfo_getNumSkippedFiles());
        this.ICompilerLog_logMessage(kSummaryNumErrorsPrefix + this.fSummary.ISummaryInfo_getNumErrors());
        this.ICompilerLog_logMessage("");
    }

    private void logFooter() {
        this.ICompilerLog_logMessage("Log closed at: " + new Date());
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fModuleFeedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void INameChangeListener_nameChanged(String newAgentName) {
        Lock lock = this.getLoggingLock();
        synchronized (lock) {
            if (this.fBaseName != null && this.fFullName != null) {
                String newFilename = LogFileUtilities.appendIdentifierToLogFileName((String)this.fBaseName, (String)newAgentName);
                if (this.fFullName.equals(newFilename)) {
                    return;
                }
                this.fLog.close();
                boolean success = LogFileUtilities.renameLogFile((String)this.fFullName, (String)newFilename, (boolean)false, (int)262144);
                FileOutputStream output = null;
                if (success) {
                    try {
                        output = new FileOutputStream(newFilename, true);
                    }
                    catch (FileNotFoundException fnfe) {
                        success = false;
                        this.getModuleFeedback().verbose((Throwable)fnfe);
                    }
                }
                if (success) {
                    if (this.fAutoProbeLogLimit <= 0) {
                        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Log_File_Renamed", this.fApplicationName, this.fFullName, newFilename));
                        this.fFullName = newFilename;
                        this.fLog = this.createPrintWriterForEncoding(this.fEncoding, output);
                    } else {
                        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Log_File_Renamed", this.fApplicationName, this.fFullName, newFilename));
                        this.fFullName = newFilename;
                        try {
                            this.fLog = this.createPrintWriterWithFile(this.fFullName, output);
                        }
                        catch (FileNotFoundException fnfe) {
                            this.getModuleFeedback().error("File Not Found", (Throwable)fnfe);
                            this.fLog = this.createPrintWriterForEncoding(this.fEncoding, output);
                        }
                    }
                } else {
                    this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Log_File_Renaming_Failed", this.fApplicationName, this.fFullName, newFilename));
                    try {
                        if (this.fAutoProbeLogLimit <= 0) {
                            output = new FileOutputStream(this.fFullName, true);
                            this.fLog = this.createPrintWriterForEncoding(this.fEncoding, output);
                        } else {
                            this.fLog = this.createPrintWriterWithFile(this.fFullName, output);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Log_File_Unable_To_Open_Log_File", this.fApplicationName, this.fFullName, fnfe.getLocalizedMessage()));
                        this.getModuleFeedback().verbose((Throwable)fnfe);
                        this.fLog = new PrintWriter((OutputStream)new NullOutputStream());
                    }
                }
            }
        }
    }

    private String buildIndentation() {
        String indentation = "        ";
        if (this.fUseTabSeparator) {
            indentation = "\t";
        }
        return indentation;
    }

    private String padPostfix(String string, int desired_length) {
        if (this.fUseTabSeparator) {
            return String.valueOf(string) + "\t";
        }
        return DGCompilerLog.staticPadPostfix(string, desired_length);
    }

    public static String staticPadPostfix(String string, int desired_length) {
        if (string.length() >= desired_length) {
            return ".." + string.substring(string.length() - desired_length + 3) + " ";
        }
        char[] temp = new char[desired_length - string.length()];
        int i = 0;
        while (i < temp.length) {
            temp[i] = 32;
            ++i;
        }
        return String.valueOf(string) + new String(temp);
    }

    @Override
    public void ICompilerLog_logClassTraced(String className) {
    }

    @Override
    public void ICompilerLog_suggestFlush() {
    }

    @Override
    public void ICompilerLog_logMethodCalls(IModeledMethod method, List methodCalls) {
        this.logOperation(method, 0, "not modified: ");
    }

    @Override
    public void ICompilerLog_logMethodTraced(IModeledMethod method) {
        this.logOperation(method, 0, "modified");
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    @Override
    public void ICompilerLog_logDetails(CompilerLogDetails details) {
    }

    @Override
    public boolean ICompilerLog_isLogDynamicInstrEnabled() {
        return false;
    }

    @Override
    public void ICompilerLog_saveLastMutatedClass(IModeledClass mutatedClass) {
        this.fLastMutatedClass = mutatedClass;
    }

    @Override
    public void ICompilerLog_logLastMutatedClass() {
        if (this.fLastMutatedClass != null) {
            this.fLastMutatedClass.debugDump(this.fLog);
        }
    }

    @Override
    public void ICompilerLog_logFieldInjection(IModeledClass targetClass, String fieldName, String fieldDesc) {
        this.logOperation(targetClass, "New Field is added  fieldName = " + fieldName + " fieldDesc = " + fieldDesc);
        if (!this.fCurrentClassModified) {
            this.fSummary.ISummaryInfo_addModifiedClass();
            this.fCurrentClassModified = true;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

