/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import java.util.HashMap;
import java.util.Map;

public final class ComplexMethodMatcher
implements IMethodMatcher {
    private static ComplexMethodMatcher singleton1;
    private static ComplexMethodMatcher singleton2;
    private final ThreadLocal<ResultPair<IModeledClass, Map<IModeledMethod, Boolean>>> cachedResult;
    private boolean fConsiderRestricted;

    private ComplexMethodMatcher(boolean considerRestricted) {
        if (considerRestricted ? singleton2 != null : singleton1 != null) {
            throw new RuntimeException("Instance already created");
        }
        this.fConsiderRestricted = considerRestricted;
        this.cachedResult = new ThreadLocal();
    }

    public static ComplexMethodMatcher getInstance() {
        if (singleton1 == null) {
            singleton1 = new ComplexMethodMatcher(false);
        }
        return singleton1;
    }

    public static ComplexMethodMatcher getInstance(boolean considerRestricted) {
        if (considerRestricted) {
            if (singleton2 == null) {
                singleton2 = new ComplexMethodMatcher(true);
            }
            return singleton2;
        }
        if (singleton1 == null) {
            singleton1 = new ComplexMethodMatcher(false);
        }
        return singleton1;
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        IModeledClass cls = method.getModeledClass();
        ResultPair<IModeledClass, Map<IModeledMethod, Boolean>> tempResult = this.cachedResult.get();
        if (tempResult != null) {
            if (tempResult.first != null && ((IModeledClass)tempResult.first).equals(cls)) {
                if (tempResult.second == null) {
                    tempResult.second = new HashMap();
                } else if (((Map)tempResult.second).containsKey(method)) {
                    return (Boolean)((Map)tempResult.second).get(method);
                }
            } else {
                tempResult.first = cls;
                if (tempResult.second != null) {
                    ((Map)tempResult.second).clear();
                }
            }
        } else if (AutoProbeTransformer.cacheDirectiveResults) {
            tempResult = new ResultPair(cls, new HashMap(0, 1.0f));
        }
        boolean result = method.isComplex(this.fConsiderRestricted);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(32768);
        }
        if (AutoProbeTransformer.cacheDirectiveResults && ((Map)tempResult.second).size() <= 500) {
            ((Map)tempResult.second).put(method, result);
            this.cachedResult.set(tempResult);
        }
        return result;
    }

    public String toString() {
        return "[ComplexMethodMatcher: ConsiderRestricted=" + this.fConsiderRestricted + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof ComplexMethodMatcher) {
            ComplexMethodMatcher matcher = (ComplexMethodMatcher)o;
            return this.fConsiderRestricted == matcher.fConsiderRestricted;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

