/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.Glob;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import java.util.HashMap;
import java.util.Map;

public class GlobMethodMatcher
implements IMethodMatcher {
    private static final Map<String, GlobMethodMatcher> singleton = new HashMap<String, GlobMethodMatcher>();
    private final ThreadLocal<ResultPair<IModeledClass, Map<IModeledMethod, Boolean>>> cachedResult;
    protected final String methodPattern;
    private final Glob glob;

    private GlobMethodMatcher(String pattern) {
        if (singleton.containsKey(pattern)) {
            throw new RuntimeException("Instance already created");
        }
        this.methodPattern = pattern;
        this.glob = new Glob(this.methodPattern.trim());
        this.cachedResult = new ThreadLocal();
    }

    public static GlobMethodMatcher getInstance(String pattern) {
        if (!singleton.containsKey(pattern)) {
            singleton.put(pattern, new GlobMethodMatcher(pattern));
        }
        return singleton.get(pattern);
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        IModeledClass cls = method.getModeledClass();
        ResultPair<IModeledClass, Map<IModeledMethod, Boolean>> tempResult = this.cachedResult.get();
        if (tempResult != null) {
            if (tempResult.first != null && ((IModeledClass)tempResult.first).equals(cls)) {
                if (tempResult.second == null) {
                    tempResult.second = new HashMap();
                } else if (((Map)tempResult.second).containsKey(method)) {
                    return (Boolean)((Map)tempResult.second).get(method);
                }
            } else {
                tempResult.first = cls;
                if (tempResult.second != null) {
                    ((Map)tempResult.second).clear();
                }
            }
        } else if (AutoProbeTransformer.cacheDirectiveResults) {
            tempResult = new ResultPair(cls, new HashMap(0, 1.0f));
        }
        boolean result = this.matches(method.getMethodName().getNameString());
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(0x200000);
        }
        if (AutoProbeTransformer.cacheDirectiveResults && ((Map)tempResult.second).size() <= 500) {
            ((Map)tempResult.second).put(method, result);
            this.cachedResult.set(tempResult);
        }
        return result;
    }

    protected boolean matches(String name) {
        return this.glob.matches(name);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.methodPattern + "]";
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.glob.getPattern());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlobMethodMatcher) {
            GlobMethodMatcher other = (GlobMethodMatcher)obj;
            return this.methodPattern.equals(other.methodPattern);
        }
        return false;
    }
}

