/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import java.util.HashMap;
import java.util.Map;

public final class InstanceConstructorMethodMatcher
implements IMethodMatcher {
    private static InstanceConstructorMethodMatcher singleton;
    private final ThreadLocal<ResultPair<IModeledClass, Map<IModeledMethod, Boolean>>> cachedResult;

    private InstanceConstructorMethodMatcher() {
        if (singleton != null) {
            throw new RuntimeException("Instance already created");
        }
        this.cachedResult = new ThreadLocal();
    }

    public static InstanceConstructorMethodMatcher getInstance() {
        if (singleton == null) {
            singleton = new InstanceConstructorMethodMatcher();
        }
        return singleton;
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        IModeledClass cls = method.getModeledClass();
        ResultPair<IModeledClass, Map<IModeledMethod, Boolean>> tempResult = this.cachedResult.get();
        if (tempResult != null) {
            if (tempResult.first != null && ((IModeledClass)tempResult.first).equals(cls)) {
                if (tempResult.second == null) {
                    tempResult.second = new HashMap();
                } else if (((Map)tempResult.second).containsKey(method)) {
                    return (Boolean)((Map)tempResult.second).get(method);
                }
            } else {
                tempResult.first = cls;
                if (tempResult.second != null) {
                    ((Map)tempResult.second).clear();
                }
            }
        } else if (AutoProbeTransformer.cacheDirectiveResults) {
            tempResult = new ResultPair(cls, new HashMap(0, 1.0f));
        }
        boolean result = method.isInstanceConstructor();
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(65536);
        }
        if (AutoProbeTransformer.cacheDirectiveResults && ((Map)tempResult.second).size() <= 500) {
            ((Map)tempResult.second).put(method, result);
            this.cachedResult.set(tempResult);
        }
        return result;
    }

    public String toString() {
        return "[InstanceConstructorMethodMatcher]";
    }

    public boolean equals(Object o) {
        return o instanceof InstanceConstructorMethodMatcher;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

