/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.classmatcher.ResultPair;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import java.util.HashMap;
import java.util.Map;

public final class NamedMethodMatcher
implements IMethodMatcher {
    private static final Map<String, NamedMethodMatcher> singleton = new HashMap<String, NamedMethodMatcher>();
    private final ThreadLocal<ResultPair<IModeledClass, Map<IModeledMethod, Boolean>>> cachedResult;
    private final IMethodName fName;

    private NamedMethodMatcher(IMethodName name) {
        if (singleton.containsKey(name.getNameAndSignatureString())) {
            throw new RuntimeException("Instance already created");
        }
        this.fName = name;
        this.cachedResult = new ThreadLocal();
    }

    public static NamedMethodMatcher getInstance(IMethodName name) {
        String fullName = name.getNameAndSignatureString();
        if (!singleton.containsKey(fullName)) {
            singleton.put(fullName, new NamedMethodMatcher(name));
        }
        return singleton.get(fullName);
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        IModeledClass cls = method.getModeledClass();
        ResultPair<IModeledClass, Map<IModeledMethod, Boolean>> tempResult = this.cachedResult.get();
        if (tempResult != null) {
            if (tempResult.first != null && ((IModeledClass)tempResult.first).equals(cls)) {
                if (tempResult.second == null) {
                    tempResult.second = new HashMap();
                } else if (((Map)tempResult.second).containsKey(method)) {
                    return (Boolean)((Map)tempResult.second).get(method);
                }
            } else {
                tempResult.first = cls;
                if (tempResult.second != null) {
                    ((Map)tempResult.second).clear();
                }
            }
        } else if (AutoProbeTransformer.cacheDirectiveResults) {
            tempResult = new ResultPair(cls, new HashMap(0, 1.0f));
        }
        boolean result = ClassFileUtilities.looselyMatches((IMethodName)this.fName, (IMethodName)method.getMethodName());
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(131072);
            current.setMethodMatchName(this.fName);
        }
        if (AutoProbeTransformer.cacheDirectiveResults && ((Map)tempResult.second).size() <= 500) {
            ((Map)tempResult.second).put(method, result);
            this.cachedResult.set(tempResult);
        }
        return result;
    }

    public IMethodName getMethodName() {
        return this.fName;
    }

    public String toString() {
        return "[NamedMethodMatcher: method=" + this.fName + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof NamedMethodMatcher) {
            NamedMethodMatcher matcher = (NamedMethodMatcher)o;
            return this.fName.equals(matcher.fName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

