/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.blame.BoundaryBlameStack;
import com.wily.introscope.agent.blame.MaxDBConnectionsProperty;
import com.wily.introscope.agent.blame.MaxInvocationDatasFromWebServicesProperty;
import com.wily.introscope.agent.blame.MaxStackElementsCallerHasSeenProperty;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.feature.StallPoint;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.cas.IBoundaryBlameStackHelper;
import com.wily.introscope.agent.trace.cas.IStallPoint;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.util.adt.CacheHashSet;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.adt.WeakWeakIdentityHashMap;
import com.wily.util.properties.hot.ConfigurationManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TransactionCache
implements ITransactionCache,
IBoundaryBlameStackHelper {
    static int sMaxDBConnections = 100;
    static int sMaxCallerHasSeenStackElements;
    WeakWeakIdentityHashMap fCallerHasSeenStackElementMap = new WeakWeakIdentityHashMap(4);
    private Runnable fThread;
    private IStackElement fRoot;
    public boolean fHasAlreadyCheckedAppMapLazyName;
    private boolean isDownstreamServletTracing = true;
    private boolean isServletTracingInProgress;
    private boolean isSocketTracingDisabled = false;
    private int fServletStackDepthValue;
    public final ArrayList<ITransactionInstance> transactionInstanceList = new ArrayList(16);
    private final WeakIdentityHashMap fCache = new WeakIdentityHashMap(4);
    private final HashSet<Object> fErrorsSeenInThisTxn;
    private IBizTrx fBizTrx;
    private boolean fAborted = false;
    public Object startComponent;
    private ITransactionElement fFirstElement;
    private boolean fVirtualElementEndedTxn = false;
    TransactionCollectStatus tcs;
    private Map.Entry<ITransactionTraceFilter, Long>[] fPendingFilterArray = null;
    private Object[] fPendingFilterStatusArray = null;
    private ITransactionTraceFilter[] fTailFilterArray = null;
    private StallPoint fStallPoint;
    private int hashcode;
    private volatile BoundaryBlameStack fBoundaryBlameStack;
    private String fFrontendString;
    private String fBackendString;
    private String fEntryPointString;
    private int fBackendsCount;
    private final InvocationData.InvocationDataThreadLocal fInvocationDataThreadLocal;
    private boolean fCorrelationIdWasInvoked;
    private AutoTracingCollectStatus fAutoTCS;
    static int sMaxInvocationDatasFromWebServices;
    private final ArrayList<IStackElement> fInvocationDatasFromWebServices = new ArrayList(1);
    private InvocationData.ServletSupportClass fServletSupport;
    private boolean fCrossProcessElementEndedTxn = false;
    private boolean fTriggerHeadFilterPass;
    private boolean fMarkedForDiscoveryTrace = false;

    static {
        ConfigurationManager cm = VirtualStack.fAgent.IAgent_getConfigurationManager();
        MaxDBConnectionsProperty maxElements = new MaxDBConnectionsProperty(VirtualStack.fAgent);
        cm.add(maxElements, true);
        sMaxCallerHasSeenStackElements = TransactionCache.initializeMaxStackElementsCallerHasSeen();
        sMaxInvocationDatasFromWebServices = TransactionCache.initializeMaxInvocationDatasFromWebServices();
    }

    static int initializeMaxStackElementsCallerHasSeen() {
        ConfigurationManager cm = VirtualStack.fAgent.IAgent_getConfigurationManager();
        MaxStackElementsCallerHasSeenProperty maxElements = new MaxStackElementsCallerHasSeenProperty(VirtualStack.fAgent);
        cm.add(maxElements, true);
        return maxElements.value;
    }

    public TransactionCache(Runnable t) {
        this.fThread = t;
        this.initializeStallPoint();
        this.initializeHashCode();
        this.fInvocationDataThreadLocal = new InvocationData.InvocationDataThreadLocal();
        this.fErrorsSeenInThisTxn = new CacheHashSet<Object>(2, ErrorFeature.getMaxErrorCacheSize(VirtualStack.fAgent));
    }

    private void initializeHashCode() {
        this.hashcode = this.fThread == null ? Thread.currentThread().hashCode() : this.fThread.hashCode();
    }

    @Override
    public Runnable getThread() {
        return this.fThread;
    }

    @Override
    public void setThread(Runnable t) {
        this.fThread = t;
    }

    private void initializeStallPoint() {
        this.fStallPoint = StallFeatureBase.initializeStallPoint(this.fThread);
    }

    public void clear() {
        this.fHasAlreadyCheckedAppMapLazyName = false;
        this.isDownstreamServletTracing = true;
        this.isServletTracingInProgress = false;
        this.isSocketTracingDisabled = false;
        this.fServletStackDepthValue = 0;
        this.fRoot = null;
        this.fFirstElement = null;
        this.fBizTrx = null;
        this.fCache.clear();
        if (this.fErrorsSeenInThisTxn.size() > 0) {
            this.fErrorsSeenInThisTxn.clear();
        }
        if (this.isTransactionAborted()) {
            this.initializeStallPoint();
        }
        this.setNotAborted();
        TransactionCollectStatus tcs = this.tcs;
        if (tcs != null) {
            FilterController.resetTransactionCollectStatusValues(tcs, false, false, 0);
        }
        this.transactionInstanceList.clear();
        this.transactionInstanceList.trimToSize();
        this.fFrontendString = null;
        this.fBackendString = null;
        this.fEntryPointString = null;
        this.fBackendsCount = 0;
        this.fServletSupport = null;
        this.fCorrelationIdWasInvoked = false;
        if (this.fInvocationDatasFromWebServices.size() > 0) {
            this.fInvocationDatasFromWebServices.clear();
        }
        this.fTriggerHeadFilterPass = false;
        this.fMarkedForDiscoveryTrace = false;
        this.fCallerHasSeenStackElementMap.clear();
        this.fAutoTCS = null;
    }

    static int initializeMaxInvocationDatasFromWebServices() {
        ConfigurationManager cm = VirtualStack.fAgent.IAgent_getConfigurationManager();
        MaxInvocationDatasFromWebServicesProperty maxInvocationDatas = new MaxInvocationDatasFromWebServicesProperty(VirtualStack.fAgent);
        cm.add(maxInvocationDatas, true);
        return maxInvocationDatas.value;
    }

    public boolean isfTriggerHeadFilterPass() {
        return this.fTriggerHeadFilterPass;
    }

    public void setfTriggerHeadFilterPass(boolean fTriggerHeadFilterPass) {
        this.fTriggerHeadFilterPass = fTriggerHeadFilterPass;
    }

    public boolean isVirtualElementEndedTxn() {
        return this.fVirtualElementEndedTxn;
    }

    public void setfVirtualElementEndedTxn(boolean virtualElementEndedTxn) {
        this.fVirtualElementEndedTxn = virtualElementEndedTxn;
    }

    public void disableDownstreamServletTracing() {
        this.isDownstreamServletTracing = false;
    }

    public void enableDownstreamServletTracing() {
        this.isDownstreamServletTracing = true;
    }

    public boolean isDownstreamServletTracing() {
        return this.isDownstreamServletTracing;
    }

    public void clearServletTracingInProgress() {
        this.isServletTracingInProgress = false;
    }

    public void setServletTracingInProgress() {
        this.isServletTracingInProgress = true;
    }

    public boolean isServletTracingInProgress() {
        return this.isServletTracingInProgress;
    }

    public void disableSocketTracing() {
        this.isSocketTracingDisabled = true;
    }

    public void enableSocketTracing() {
        this.isSocketTracingDisabled = false;
    }

    public boolean isSocketTracingDisabled() {
        return this.isSocketTracingDisabled;
    }

    public int getStackDepthValue() {
        return this.fServletStackDepthValue;
    }

    public void incrementStackDepth() {
        ++this.fServletStackDepthValue;
    }

    public void decrementStackDepth() {
        --this.fServletStackDepthValue;
    }

    public void setRoot(IStackElement fRoot) {
        this.fRoot = fRoot;
    }

    public IStackElement getRoot() {
        return this.fRoot;
    }

    public IBizTrx getBizTrx() {
        return this.fBizTrx;
    }

    public void setBizTrx(IBizTrx bizTrx) {
        this.fBizTrx = bizTrx;
    }

    @Override
    public HashSet<Object> getErrorsSeenInThisTxn() {
        return this.fErrorsSeenInThisTxn;
    }

    @Override
    public List<ITransactionInstance> getTransactionInstanceList() {
        return this.transactionInstanceList;
    }

    @Override
    public boolean isTransactionAborted() {
        return this.fAborted;
    }

    public void setAborted() {
        this.fAborted = true;
    }

    public void setNotAborted() {
        this.fAborted = false;
    }

    @Override
    public boolean isMarkedForDiscoveryTrace() {
        return this.fMarkedForDiscoveryTrace;
    }

    @Override
    public void setMarkedForDiscoveryTrace(boolean setDiscoveryTrace) {
        this.fMarkedForDiscoveryTrace = setDiscoveryTrace;
    }

    @Override
    public Object putInCache(Object key, Object value) {
        if (sMaxDBConnections <= 0) {
            return value;
        }
        if (this.fCache.size() >= sMaxDBConnections) {
            if (VirtualStack.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                VirtualStack.fAgent.IAgent_getModuleFeedback().debug(VirtualStack.kModule, "Clearing TransactionCache.fCache which has " + this.fCache.size() + " elements. Maximum number of connections cached are: " + sMaxDBConnections);
            }
            this.fCache.clear();
        }
        return this.fCache.put(key, value);
    }

    @Override
    public Object getFromCache(Object key) {
        return this.fCache.get(key);
    }

    @Override
    public TransactionCollectStatus getTransactionCollectionStatus() {
        return this.tcs;
    }

    @Override
    public void setTransactionCollectStatus(TransactionCollectStatus tcs) {
        tcs.setTransactionCache(this);
        this.tcs = tcs;
    }

    @Override
    public void setStartTransactionElement(ITransactionElement fFirstElement) {
        this.fFirstElement = fFirstElement;
    }

    @Override
    public ITransactionElement getStartTransactionElement() {
        return this.fFirstElement;
    }

    @Override
    public Map.Entry<ITransactionTraceFilter, Long>[] getPendingFilterArray() {
        return this.fPendingFilterArray;
    }

    @Override
    public Object[] getPendingFilterStatusArray() {
        return this.fPendingFilterStatusArray;
    }

    @Override
    public void setPendingFilterArray(Map.Entry<ITransactionTraceFilter, Long>[] pendingFilterArray, Object[] pendingFilterStatusArray) {
        this.fPendingFilterArray = pendingFilterArray;
        this.fPendingFilterStatusArray = pendingFilterStatusArray;
    }

    @Override
    public ITransactionTraceFilter[] getfTailFilterArray() {
        return this.fTailFilterArray;
    }

    @Override
    public void setfTailFilterArray(ITransactionTraceFilter[] fTailFilterArray) {
        this.fTailFilterArray = fTailFilterArray;
    }

    @Override
    public IStallPoint getStallPoint() {
        return this.fStallPoint;
    }

    @Override
    public int getThreadHashCode() {
        return this.hashcode;
    }

    @Override
    public void setBoundaryBlameStack(BoundaryBlameStack boundaryBlameStack) {
        this.fBoundaryBlameStack = boundaryBlameStack;
    }

    @Override
    public void signalNewFrontend(String fHeadNode) {
        this.fFrontendString = fHeadNode;
    }

    @Override
    public void signalNewBackend(String fEndNode) {
        this.fBackendString = fEndNode;
    }

    @Override
    public void setFrontBoundary(String frontend) {
        if (this.fBoundaryBlameStack != null) {
            this.fBoundaryBlameStack.setFrontBoundary(frontend);
            if (frontend.equals(this.fFrontendString)) {
                this.fBoundaryBlameStack.addVetoedFrontendInErrors(frontend);
            }
        } else {
            this.fFrontendString = frontend;
        }
    }

    @Override
    public void setEndBoundary(String backend) {
        if (this.fBoundaryBlameStack != null) {
            this.fBoundaryBlameStack.setEndBoundary(backend);
            if (backend.equals(this.fBackendString)) {
                this.fBoundaryBlameStack.addVetoedBackendInErrors(backend);
            }
        } else {
            this.fBackendString = backend;
        }
    }

    @Override
    public void setEntryPointBoundary(String entryPoint) {
        this.fEntryPointString = entryPoint;
    }

    @Override
    public void unsetFrontBoundary(String frontend) {
        if (this.fBoundaryBlameStack != null) {
            if (frontend != null) {
                this.fBoundaryBlameStack.unsetFrontBoundary(frontend);
            }
            if (this.fFrontendString == null) {
                this.fBoundaryBlameStack.removeVetoedFrontendInErrors();
            }
        } else {
            this.fFrontendString = null;
        }
    }

    @Override
    public void unsetEndBoundary(String backend) {
        if (this.fBoundaryBlameStack != null) {
            this.fBoundaryBlameStack.unsetEndBoundary(backend);
            if (this.fBackendString == null) {
                this.fBoundaryBlameStack.removeVetoedBackendInErrors();
            }
        } else {
            this.fBackendString = null;
        }
    }

    @Override
    public void unsetEntryPointBoundary(String entryPoint) {
        this.fEntryPointString = null;
    }

    @Override
    public String getFrontend() {
        return this.fFrontendString;
    }

    @Override
    public String getBackend() {
        return this.fBackendString;
    }

    @Override
    public String getEntryPoint() {
        return this.fEntryPointString;
    }

    @Override
    public void signalFrontendPopped(String fHeadNode) {
        this.fFrontendString = null;
    }

    @Override
    public void signalBackendPopped(String fEndNode) {
        this.fBackendString = null;
    }

    @Override
    public boolean isInBackend() {
        return this.fBackendString != null;
    }

    @Override
    public int incrementAndGetBackendsCount() {
        return ++this.fBackendsCount;
    }

    @Override
    public int decrementAndGetBackendsCount() {
        return --this.fBackendsCount;
    }

    public int getBackendsCount() {
        return this.fBackendsCount;
    }

    @Override
    public void incrementErrorMetric() {
        if (this.fBoundaryBlameStack != null) {
            this.fBoundaryBlameStack.noteBoundaryError();
        }
    }

    public void setCorrelationIdWasInvoked() {
        this.fCorrelationIdWasInvoked = true;
    }

    @Override
    public boolean isCorrelationIdWasInvoked() {
        return this.fCorrelationIdWasInvoked;
    }

    @Override
    public void addStackElementForNotificationOnCrossCorrelation(InvocationData data) {
        if (this.fInvocationDatasFromWebServices.size() > sMaxInvocationDatasFromWebServices && sMaxInvocationDatasFromWebServices > 0) {
            VirtualStack.fAgent.IAgent_getModuleFeedback().debug(VirtualStack.kModule, "Clearing TransactionCache.fInvocationDatasFromWebServices which has " + this.fInvocationDatasFromWebServices.size() + " elements, more than max allowed: " + sMaxInvocationDatasFromWebServices);
            this.fInvocationDatasFromWebServices.clear();
        }
        this.fInvocationDatasFromWebServices.add(data);
    }

    @Override
    public void notifyStackElementOfNewCrossCorrelation(Object key) {
        for (IStackElement element : this.fInvocationDatasFromWebServices) {
            if (!(element instanceof InvocationData)) continue;
            ((InvocationData)element).setHasNewCursor();
        }
        this.fInvocationDatasFromWebServices.clear();
        this.fInvocationDatasFromWebServices.trimToSize();
    }

    @Override
    public InvocationData.InvocationDataThreadLocal getInvocationDataThreadLocal() {
        return this.fInvocationDataThreadLocal;
    }

    public boolean isCrossCorrelationElementEndedTxn() {
        return this.fCrossProcessElementEndedTxn;
    }

    public void setfCrossCorrelationElementEndedTxn(boolean crossCorrelationElementEndedTxn) {
        this.fCrossProcessElementEndedTxn = crossCorrelationElementEndedTxn;
    }

    public boolean hasCallerSeenStackElement(Object caller, IStackElement data) {
        if (data == null) {
            return false;
        }
        if (this.fCallerHasSeenStackElementMap.size() > sMaxCallerHasSeenStackElements && sMaxCallerHasSeenStackElements > 0) {
            VirtualStack.fAgent.IAgent_getModuleFeedback().debug(VirtualStack.kModule, "Clearing TransactionCache.fCallerHasSeenStackElementMap which has " + this.fCallerHasSeenStackElementMap.size() + " elements, more than max allowed: " + sMaxCallerHasSeenStackElements);
            this.fCallerHasSeenStackElementMap.clear();
        }
        return data == (IStackElement)this.fCallerHasSeenStackElementMap.put(caller, data);
    }

    public int getSizeOfCallerHasSeenStackElementMap() {
        return this.fCallerHasSeenStackElementMap.size();
    }

    @Override
    public void setServletSupport(InvocationData.ServletSupportClass servletSupport) {
        if (this.fServletSupport == null) {
            this.fServletSupport = servletSupport;
        }
    }

    @Override
    public InvocationData.ServletSupportClass getServletSupport() {
        return this.fServletSupport;
    }

    @Override
    public AutoTracingCollectStatus getAutoTracingCollectStatus() {
        return this.fAutoTCS;
    }

    @Override
    public void setAutoTracingCollectStatus(AutoTracingCollectStatus aTCS) {
        this.fAutoTCS = aTCS;
    }
}

