/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.config;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigLoggingService
extends ASimpleService
implements IConfigurationListener {
    private static final Module kModule = new Module("Properties");
    private IModuleFeedbackChannel feedback;
    private IndexedProperties fPrevious;

    public ConfigLoggingService() {
        super("Config Logging");
    }

    @Override
    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        this.feedback = agent.IAgent_getModuleFeedback();
        this.feedback.info(kModule, "Starting config logger.");
        agent.addConfigurationListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChange(IndexedProperties properties) {
        StringBuilder b;
        boolean[] warn = new boolean[1];
        ConfigLoggingService configLoggingService = this;
        synchronized (configLoggingService) {
            if (this.fPrevious == properties) {
                return;
            }
            IndexedProperties previous = this.fPrevious;
            this.fPrevious = properties;
            if (previous == null) {
                b = new StringBuilder(8192);
                this.appendDump(b, properties);
            } else {
                b = new StringBuilder(512);
                if (!this.appendDiff(b, previous, properties, warn)) {
                    return;
                }
            }
        }
        if (warn[0]) {
            this.feedback.warn(kModule, b.toString());
        } else {
            this.feedback.info(kModule, b.toString());
        }
    }

    private void appendDump(StringBuilder b, IndexedProperties properties) {
        Object key;
        b.append("Current configuration:\n");
        Set<String> set = properties.getAllKeys();
        Object[] keys = set.toArray(new String[0]);
        Arrays.sort(keys);
        int maxLength = 0;
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            key = objectArray[n2];
            maxLength = Math.max(maxLength, properties.getPropertySource((String)key).length());
            ++n2;
        }
        objectArray = keys;
        n = keys.length;
        n2 = 0;
        while (n2 < n) {
            key = objectArray[n2];
            if (properties.getProperty((String)key) != null) {
                String type = properties.getPropertySource((String)key);
                b.append("\t[");
                this.padRight(b, type, maxLength);
                b.append("] ");
                this.appendTo(b, (String)key, true);
                b.append('=');
                this.appendValueMaskingPassword(b, properties, (String)key);
                b.append('\n');
            }
            ++n2;
        }
    }

    private void appendValueMaskingPassword(StringBuilder b, IndexedProperties properties, String key) {
        if (ConfigLoggingService.isPassword(key)) {
            b.append("***");
        } else {
            this.appendTo(b, properties.getProperty(key), false);
        }
    }

    private static boolean isPassword(String key) {
        String lowerCased = key.toLowerCase();
        return lowerCased.contains("password") || lowerCased.contains("pwd") || lowerCased.contains("passcode") || lowerCased.contains("passphrase") || lowerCased.contains("secretkey") || lowerCased.contains("clientsecret");
    }

    private boolean appendDiff(StringBuilder b, IndexedProperties oldProperties, IndexedProperties newProperties, boolean[] warn) {
        List<IndexedProperties.Difference> diff = IndexedProperties.diff(oldProperties, newProperties);
        if (diff.isEmpty()) {
            return false;
        }
        for (IndexedProperties.Difference delta : diff) {
            boolean bl = warn[0] = warn[0] || delta.type.ignored;
        }
        if (warn[0]) {
            b.append("Configuration had been updated, however some modification were ignored because they are overriden in System Properties and/or Environment Variables");
        } else {
            b.append("Configiration had been updated");
        }
        b.append('\n');
        int maxModificationType = 0;
        int maxLength = 0;
        for (IndexedProperties.Difference delta : diff) {
            maxModificationType = Math.max(maxModificationType, delta.type.text.length());
            switch (delta.type) {
                case Deleted: {
                    maxLength = Math.max(maxLength, oldProperties.getPropertySource(delta.property).length());
                    break;
                }
                default: {
                    maxLength = Math.max(maxLength, newProperties.getPropertySource(delta.property).length());
                }
            }
        }
        for (IndexedProperties.Difference delta : diff) {
            IndexedProperties properties;
            String key = delta.property;
            switch (delta.type) {
                case Deleted: 
                case DeletionIgnored: {
                    properties = oldProperties;
                    break;
                }
                default: {
                    properties = newProperties;
                }
            }
            if (properties.getProperty(key) == null) continue;
            b.append("\t[");
            this.padRight(b, delta.type.toString(), maxModificationType);
            b.append("] [");
            String type = properties.getPropertySource(key);
            this.padRight(b, type, maxLength);
            b.append("] ");
            this.appendTo(b, key, true);
            switch (delta.type) {
                case Deleted: {
                    break;
                }
                default: {
                    b.append('=');
                    this.appendValueMaskingPassword(b, properties, key);
                }
            }
            b.append('\n');
        }
        return true;
    }

    private void padRight(StringBuilder b, String text, int length) {
        b.append(text);
        int remaining = length - text.length();
        int i = 0;
        while (i < remaining) {
            b.append(' ');
            ++i;
        }
    }

    private void appendTo(StringBuilder b, String text, boolean escapeSpaceAndEqual) {
        int len = text.length();
        int x = 0;
        while (x < len) {
            char aChar = text.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    b.append('\\');
                    b.append('\\');
                } else {
                    b.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': 
                    case ':': 
                    case '=': {
                        if (x == 0 || escapeSpaceAndEqual) {
                            b.append('\\');
                        }
                        b.append(aChar);
                        break;
                    }
                    case '\t': {
                        b.append('\\');
                        b.append('t');
                        break;
                    }
                    case '\n': {
                        b.append('\\');
                        b.append('n');
                        break;
                    }
                    case '\r': {
                        b.append('\\');
                        b.append('r');
                        break;
                    }
                    case '\f': {
                        b.append('\\');
                        b.append('f');
                        break;
                    }
                    case '!': 
                    case '#': {
                        b.append('\\');
                        b.append(aChar);
                        break;
                    }
                    default: {
                        b.append(aChar);
                    }
                }
            }
            ++x;
        }
    }
}

