/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.TransactionCache;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.IThreadStackSnapshotHelper;
import com.wily.introscope.agent.filter.FilterEncodeHelper;
import com.wily.introscope.agent.filter.FilterMaskEnablerUtil;
import com.wily.introscope.agent.filter.sampling.SamplingManager;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.transactiontrace.INoParameterTransactionTraceFilter;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.agent.transactiontrace.URLSamplingTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AFilterListTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IStatefulTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITailParameterTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.OrTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ParameterValueTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ThresholdTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.adt.SimpleEntry;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class FilterController {
    private static final ConcurrentHashMap<ITransactionTraceFilter, Long> fFilters = new ConcurrentHashMap();
    private static final CopyOnWriteArraySet<Map.Entry<ITransactionTraceFilter, Long>> fFilterArray = new CopyOnWriteArraySet();
    private static volatile boolean sDynamicFilterPresence = false;
    private static volatile boolean sTailFilterPresence = false;
    private static volatile boolean sErrorFilterPresence = false;
    private static volatile boolean sTransientHeadFilterPresence = false;
    private static volatile int fComponentCountClamp;
    private static volatile int fHeadFilterClamp;
    private static volatile boolean fTailFilterPropagate;
    private static volatile boolean fSustainabilityMetricEnabled;
    private static volatile long lastFetchedPermanentFilters;
    private static DataAccumulatorFactory dataAccumulator;
    private static final String kTransactionTraceFilterDebugMetricsEnabledProperty = "com.wily.introscope.agent.trace.filter.metrics.enabled";
    private static String sFilterCountMetricName;
    private static volatile HashMap<ITransactionTraceFilter, Long> sPermanentFilters;
    private static AtomicInteger transientFilterCount;
    private static SamplingManager sSampler;
    private static final CopyOnWriteArrayList<ISupressTraceFilter> sSupressTraceFilters;

    static {
        fSustainabilityMetricEnabled = false;
        dataAccumulator = null;
        sFilterCountMetricName = "Agent Stats|Sustainability|Transaction Trace Filter:Transient Filter Count";
        sPermanentFilters = new HashMap();
        transientFilterCount = new AtomicInteger(0);
        sSupressTraceFilters = new CopyOnWriteArrayList();
    }

    public static void addSupressTraceFilter(ISupressTraceFilter filter) {
        sSupressTraceFilters.add(filter);
    }

    public static boolean isTraceSupressed(List<ITransactionInstance> trace, TransactionCollectStatus tcs) {
        for (ISupressTraceFilter filter : sSupressTraceFilters) {
            if (!filter.isTraceSupressed(trace, tcs)) continue;
            return true;
        }
        return false;
    }

    public static TransactionCollectStatus updateTransactionCollectStatus(IStackElement data, boolean stopTracingFlag, boolean stopCheckingFlag, int headComponentCount) {
        TransactionCollectStatus tcs = new TransactionCollectStatus();
        SharedCrossProcessData cache = null;
        if (data instanceof InvocationData) {
            cache = ((InvocationData)data).getSharedCrossProcessData();
        }
        if (data instanceof WrappedInvocationData) {
            cache = ((WrappedInvocationData)data).getInvocationData().getSharedCrossProcessData();
        }
        if (cache == null) {
            cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        }
        tcs.cache = cache;
        FilterController.resetTransactionCollectStatusValues(tcs, stopTracingFlag, stopCheckingFlag, headComponentCount);
        data.setTransactionCollectStatus(tcs);
        return tcs;
    }

    public static void resetTransactionCollectStatusValues(TransactionCollectStatus tcs, boolean stopTracingFlag, boolean stopCheckingFlag, int headComponentCount) {
        tcs.stopCheckingFlag = stopCheckingFlag;
        tcs.startedTrackingOnStartTransaction = false;
        tcs.stopTracingFlag = stopTracingFlag;
        tcs.doTraceFlag = false;
        tcs.setTraceCollectionReason(null);
        tcs.setSampled(null);
        tcs.setSamplingEvaluated(false);
        tcs.headComponentCount = headComponentCount;
        tcs.fComponentCountInTT = 0;
        tcs.fComponentClampAlreadyHitForTT = false;
        tcs.fTriggerHeadFilterPass = false;
        tcs.filterParameters = new HashMap<String, Object>();
    }

    public static void prepareFiltersForTransaction(TransactionCollectStatus status, IAgent agent) {
        status.stopCheckingFlag = false;
        status.stopTracingFlag = false;
        status.doTraceFlag = false;
        status.setTraceCollectionReason(null);
        FilterController.updatePermanentFilters(agent);
        status.addPendingFilters(fFilterArray);
        FilterController.initializePendingFilterStatus(status);
    }

    public static void triggerTxnTraceCollectionAtHeadFilterTime() {
        VirtualStack.getTransactionCache().setfTriggerHeadFilterPass(true);
    }

    public static void resetTxnTraceCollectionAtHeadFilterTime() {
        VirtualStack.getTransactionCache().setfTriggerHeadFilterPass(false);
    }

    public static boolean shouldTraceTransactionInstances() {
        return FilterController.shouldTraceTransaction(VirtualStack.getTransactionCollectStatus());
    }

    public static boolean shouldTraceTransactionInstances(IStackElement data) {
        return FilterController.shouldTraceTransaction(data.getTransactionCollectionStatus());
    }

    public static boolean shouldTraceTransactionInstances(ITransactionCache cache) {
        return FilterController.shouldTraceTransaction(cache.getTransactionCollectionStatus());
    }

    private static boolean shouldTraceTransaction(TransactionCollectStatus tcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            return !tcs.stopTracingFlag;
        }
        return true;
    }

    public static void supressTransactionTrace(IStackElement data) {
        FilterController.supressTransactionTrace(data.getTransactionCollectionStatus());
    }

    public static void supressTransactionTrace(ITransactionCache cache) {
        FilterController.supressTransactionTrace(cache.getTransactionCollectionStatus());
    }

    private static void supressTransactionTrace(TransactionCollectStatus tcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            tcs.setDoTraceFlag(false);
            tcs.setStopTracingFlag(true);
            tcs.setStopCheckingFlag(true);
            tcs.setSampled(null);
            tcs.setSamplingEvaluated(true);
            tcs.fTriggerHeadFilterPass = false;
        }
    }

    public static final boolean canCurrentTransactionBeMarkedForCollection(ITransactionCache cache) {
        return FilterController.canTransactionBeMarkedForCollection(cache.getTransactionCollectionStatus());
    }

    public static final boolean canCurrentTransactionBeMarkedForCollection(IStackElement data) {
        return FilterController.canTransactionBeMarkedForCollection(data.getTransactionCollectionStatus());
    }

    public static final boolean isCurrentTransactionMarkedForCollection() {
        return FilterController.canTransactionBeMarkedForCollection(VirtualStack.getTransactionCollectStatus());
    }

    private static boolean canTransactionBeMarkedForCollection(TransactionCollectStatus tcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            return tcs.getDoTraceFlag();
        }
        return false;
    }

    public static void addFilter(ITransactionTraceFilter filter) {
        if (filter instanceof AndTransactionTraceFilter) {
            AndTransactionTraceFilter af = (AndTransactionTraceFilter)filter;
            boolean isThreadDumpSession = false;
            long interval = 1000L;
            long duration = 600000L;
            int minStack = 0;
            int maxStack = 0;
            boolean isInstrumented = true;
            boolean isNotInstrumented = true;
            String namePattern = ".*";
            String state = "ALL";
            ITransactionTraceFilter[] iTransactionTraceFilterArray = af.getContainedTransactionFilters();
            int n = iTransactionTraceFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterValueTransactionTraceFilter pf;
                ITransactionTraceFilter f = iTransactionTraceFilterArray[n2];
                if (f instanceof ThresholdTransactionTraceFilter) {
                    ThresholdTransactionTraceFilter tf = (ThresholdTransactionTraceFilter)f;
                    interval = tf.getThresholdInMillis();
                }
                if (f instanceof ParameterValueTransactionTraceFilter && "httpsession.attribute.stack".equals((pf = (ParameterValueTransactionTraceFilter)f).getParameterName())) {
                    String value = pf.getParameterValue();
                    String[] params = value.split(" ");
                    namePattern = params[0];
                    if (params.length > 1) {
                        minStack = Integer.parseInt(params[1]);
                    }
                    if (params.length > 2) {
                        maxStack = Integer.parseInt(params[2]);
                    }
                    if (params.length > 3) {
                        isInstrumented = Boolean.parseBoolean(params[3]);
                    }
                    if (params.length > 4) {
                        isNotInstrumented = Boolean.parseBoolean(params[4]);
                    }
                    if (params.length > 5) {
                        state = params[5];
                    }
                    isThreadDumpSession = true;
                }
                ++n2;
            }
            if (isThreadDumpSession) {
                IThreadStackSnapshotHelper helper = ErrorFeature.sThreadStackHelper;
                helper.startThreadDumpSession(namePattern, state, interval, duration, minStack, maxStack, isInstrumented, isNotInstrumented);
                return;
            }
        }
        FilterController.categorizeAndAddFilter(fFilters, filter);
        for (Map.Entry<ITransactionTraceFilter, Long> e : fFilters.entrySet()) {
            if (!fFilterArray.add(new SimpleEntry<ITransactionTraceFilter, Long>(e.getKey(), e.getValue()))) continue;
            transientFilterCount.incrementAndGet();
        }
        sSampler.updateMasterEnabled(SamplingManager.DisableReason.TraceSession, false);
        FilterController.updateHeadAndTailFilterPresenceStatus();
        FilterController.updateErrorFilterPresenceStatus();
        FilterController.updateTransientFilterSustainabilityMetric();
    }

    public static void removeFilter(ITransactionTraceFilter filter) {
        int remaining;
        if (filter instanceof AndTransactionTraceFilter) {
            AndTransactionTraceFilter af = (AndTransactionTraceFilter)filter;
            ITransactionTraceFilter[] iTransactionTraceFilterArray = af.getContainedTransactionFilters();
            int n = iTransactionTraceFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterValueTransactionTraceFilter pf;
                ITransactionTraceFilter f = iTransactionTraceFilterArray[n2];
                if (f instanceof ParameterValueTransactionTraceFilter && "httpsession.attribute.stack".equals((pf = (ParameterValueTransactionTraceFilter)f).getParameterName())) {
                    IThreadStackSnapshotHelper helper = ErrorFeature.sThreadStackHelper;
                    helper.stopThreadDumpSession();
                    return;
                }
                ++n2;
            }
        }
        Long value = filter instanceof IFailFastTransactionTraceFilter ? fFilters.remove(filter) : fFilters.remove(new AFailFastTransactionTraceFilter(filter));
        fFilterArray.retainAll(fFilters.entrySet());
        fFilterArray.addAll(sPermanentFilters.entrySet());
        if (value != null && (remaining = transientFilterCount.decrementAndGet()) == 0) {
            sSampler.updateMasterEnabled(SamplingManager.DisableReason.TraceSession, true);
        }
        FilterController.updateHeadAndTailFilterPresenceStatus();
        FilterController.updateErrorFilterPresenceStatus();
        FilterController.updateTransientFilterSustainabilityMetric();
    }

    public static boolean shouldCurrentTraceBePropagated() {
        TransactionCache transactionCache = VirtualStack.getTransactionCache();
        return FilterController.shouldTraceBePropagated(transactionCache.getTransactionCollectionStatus(), transactionCache.getAutoTracingCollectStatus());
    }

    public static boolean shouldCurrentTraceBePropagated(IStackElement data) {
        return FilterController.shouldTraceBePropagated(data.getTransactionCollectionStatus(), VirtualStack.getTransactionCache().getAutoTracingCollectStatus());
    }

    public static boolean shouldCurrentTraceBePropagated(ITransactionCache cache) {
        return FilterController.shouldTraceBePropagated(cache.getTransactionCollectionStatus(), cache.getAutoTracingCollectStatus());
    }

    private static boolean shouldTraceBePropagated(TransactionCollectStatus tcs, AutoTracingCollectStatus atcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            return tcs.getDoTraceFlag() || !tcs.getStopTracingFlag() && fTailFilterPropagate && FilterController.getTailFilterPresence();
        }
        return false;
    }

    private static void updateHeadAndTailFilterPresenceStatus() {
        sDynamicFilterPresence = false;
        sTailFilterPresence = false;
        sTransientHeadFilterPresence = false;
        Iterator<Map.Entry<ITransactionTraceFilter, Long>> itr = fFilters.entrySet().iterator();
        while (itr.hasNext()) {
            sDynamicFilterPresence = true;
            Map.Entry<ITransactionTraceFilter, Long> entry = itr.next();
            ITransactionTraceFilter filter = entry.getKey();
            if (filter.isHeadFilter()) {
                sTransientHeadFilterPresence = true;
            } else {
                sTailFilterPresence = true;
            }
            if (!sTransientHeadFilterPresence || !sTailFilterPresence) continue;
            return;
        }
    }

    private static void updateErrorFilterPresenceStatus() {
        for (Map.Entry<ITransactionTraceFilter, Long> entry : fFilters.entrySet()) {
            ITransactionTraceFilter filter = entry.getKey();
            int type = filter.ITransactionTraceFilter_getFilterType();
            if (type != 4) continue;
            sErrorFilterPresence = true;
            return;
        }
        sErrorFilterPresence = false;
    }

    public static boolean getDynamicFilterPresence() {
        return sDynamicFilterPresence;
    }

    public static boolean getTailFilterPresence() {
        return sTailFilterPresence;
    }

    public static boolean getPermanentFilterMayBePresent(IAgent agent) {
        long lastPermanentFiltersUpdated = agent.IAgent_getTransactionTraceController().getLastUpdatedPermanentFilters();
        return sPermanentFilters.size() > 0 || lastFetchedPermanentFilters < lastPermanentFiltersUpdated;
    }

    public static boolean getErrorFilterPresence() {
        return sErrorFilterPresence;
    }

    public static boolean getTransientHeadFilterPresence() {
        return sTransientHeadFilterPresence;
    }

    private static void categorizeAndAddFilter(Map<ITransactionTraceFilter, Long> filterMap, ITransactionTraceFilter filter) {
        long encoding = FilterEncodeHelper.getFilterEncoding(filter);
        if (filter instanceof IFailFastTransactionTraceFilter) {
            filterMap.put(filter, encoding);
        } else {
            filterMap.put(new AFailFastTransactionTraceFilter(filter), encoding);
        }
    }

    private static String formatTraceCollectionReason(ITransactionTraceFilter filter) {
        String reason = filter.toString();
        return reason;
    }

    public static ISamplingResult samplingExecute(long filterEnablerKey, ITransactionInstanceProvider instanceProvider, IStackElement data, IAgent agent) {
        ISamplingResult preSample;
        if (instanceProvider != null && data != null && (preSample = instanceProvider.preSample(data)) != null) {
            return preSample.derivativeSamplingResult();
        }
        if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(4L, filterEnablerKey)) {
            return sSampler.shouldSample();
        }
        return null;
    }

    public static boolean errorFilterExecute(TransactionComponentData root) {
        boolean ret = false;
        if (sErrorFilterPresence) {
            for (Map.Entry<ITransactionTraceFilter, Long> entry : fFilters.entrySet()) {
                ITransactionTraceFilter filter = entry.getKey();
                int type = filter.ITransactionTraceFilter_getFilterType();
                if (type != 4 || !filter.ITransactionTraceFilter_passesFilter(root)) continue;
                return true;
            }
        }
        return ret;
    }

    public static boolean optimisticFilterExecute(long filterEnablerKey, TransactionCollectStatus tcs, IStackElement data, IAgent agent) {
        Map.Entry<ITransactionTraceFilter, Long>[] filterEntries = tcs.getPendingFilters();
        Object[] filterStatus = tcs.getPendingFilterStatus();
        if (!tcs.anyPendingHeadFilters()) {
            return false;
        }
        Map<String, Object> parameters = null;
        int i = 0;
        while (i < filterEntries.length) {
            Map.Entry<ITransactionTraceFilter, Long> entry = filterEntries[i];
            if (entry != null) {
                Boolean headFilterResult;
                IFailFastTransactionTraceFilter filter = (IFailFastTransactionTraceFilter)entry.getKey();
                if (!(filter instanceof INoParameterTransactionTraceFilter) && parameters == null) {
                    parameters = tcs.getParameters(data);
                    VirtualStack.addParameterCallbacks(parameters, data);
                }
                long filterencoding = entry.getValue();
                if (!filter.isHeadFilter()) {
                    if (filter instanceof AndTransactionTraceFilter) {
                        if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(filterencoding, filterEnablerKey) && (headFilterResult = FilterController.shouldCollectHead(filter, parameters, filterStatus[i])) != null) {
                            if (headFilterResult.booleanValue()) {
                                tcs.addFilterForTailCheck(filter);
                                tcs.removePendingHeadFilter(i);
                            } else {
                                tcs.removePendingHeadFilter(i);
                            }
                        }
                    } else if (filter instanceof OrTransactionTraceFilter) {
                        if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(filterencoding, filterEnablerKey) && (headFilterResult = FilterController.shouldCollectHead(filter, parameters, filterStatus[i])) != null) {
                            if (headFilterResult.booleanValue()) {
                                tcs.setTraceCollectionReason(FilterController.formatTraceCollectionReason(filter));
                                return true;
                            }
                            tcs.addFilterForTailCheck(filter);
                            tcs.removePendingHeadFilter(i);
                        }
                    } else {
                        tcs.addFilterForTailCheck(filter);
                        tcs.removePendingHeadFilter(i);
                    }
                } else if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(filterencoding, filterEnablerKey) && (headFilterResult = FilterController.shouldCollectHead(filter, parameters, filterStatus[i])) != null) {
                    if (headFilterResult.booleanValue()) {
                        tcs.setTraceCollectionReason(FilterController.formatTraceCollectionReason(filter));
                        return true;
                    }
                    tcs.removePendingHeadFilter(i);
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean updatePermanentFilters(IAgent agent) {
        long lastPermanentFiltersUpdated = agent.IAgent_getTransactionTraceController().getLastUpdatedPermanentFilters();
        if (lastFetchedPermanentFilters < lastPermanentFiltersUpdated) {
            lastFetchedPermanentFilters = lastPermanentFiltersUpdated;
            Set<ITransactionTraceFilter> permanentFiltersSet = agent.IAgent_getTransactionTraceController().getPermanentFilters();
            ArrayList<ITransactionTraceFilter> permanentFiltersWeWantToConsider = new ArrayList<ITransactionTraceFilter>();
            for (ITransactionTraceFilter o : permanentFiltersSet) {
                if (o instanceof URLSamplingTransactionTraceFilter) continue;
                permanentFiltersWeWantToConsider.add(o);
            }
            HashMap<ITransactionTraceFilter, Long> newPermanentFilters = new HashMap<ITransactionTraceFilter, Long>();
            int j = 0;
            while (j < permanentFiltersWeWantToConsider.size()) {
                FilterController.categorizeAndAddFilter(newPermanentFilters, (ITransactionTraceFilter)permanentFiltersWeWantToConsider.get(j));
                ++j;
            }
            sPermanentFilters = newPermanentFilters;
            fFilterArray.retainAll(fFilters.entrySet());
            fFilterArray.addAll(sPermanentFilters.entrySet());
        }
        return sPermanentFilters.size() > 0;
    }

    private static void initializePendingFilterStatus(TransactionCollectStatus tcs) {
        Map.Entry<ITransactionTraceFilter, Long>[] filterEntries = tcs.getPendingFilters();
        if (filterEntries == null) {
            return;
        }
        Object[] filterStatus = tcs.getPendingFilterStatus();
        int i = 0;
        while (i < filterEntries.length && i < filterStatus.length) {
            ITransactionTraceFilter filter;
            Map.Entry<ITransactionTraceFilter, Long> filterEntry = filterEntries[i];
            if (filterEntry != null && (filter = filterEntries[i].getKey()) instanceof IStatefulTransactionTraceFilter) {
                filterStatus[i] = ((IStatefulTransactionTraceFilter)filter).initializeFilterState(filterStatus[i]);
            }
            ++i;
        }
    }

    private static Boolean shouldCollectHead(IFailFastTransactionTraceFilter filter, Map parameters, Object status) {
        if (filter instanceof IStatefulTransactionTraceFilter) {
            return ((IStatefulTransactionTraceFilter)((Object)filter)).shouldCollectHead(parameters, status);
        }
        return filter.shouldCollectHead(parameters);
    }

    private static boolean shouldCollectFinal(IFailFastTransactionTraceFilter filter, Object status) {
        if (filter instanceof IStatefulTransactionTraceFilter) {
            return ((IStatefulTransactionTraceFilter)((Object)filter)).shouldCollectFinal(status);
        }
        return filter.shouldCollectFinal();
    }

    public static boolean finalFiltersExecute(TransactionCollectStatus tcs) {
        Map.Entry<ITransactionTraceFilter, Long>[] filterEntries = tcs.getPendingFilters();
        Object[] filterStatus = tcs.getPendingFilterStatus();
        if (!tcs.anyPendingHeadFilters()) {
            return false;
        }
        int i = 0;
        while (i < filterEntries.length) {
            Map.Entry<ITransactionTraceFilter, Long> entry = filterEntries[i];
            if (entry != null) {
                boolean headFilterResult;
                IFailFastTransactionTraceFilter filter = (IFailFastTransactionTraceFilter)entry.getKey();
                if (!filter.isHeadFilter()) {
                    if (filter instanceof AndTransactionTraceFilter) {
                        headFilterResult = FilterController.shouldCollectFinal(filter, filterStatus[i]);
                        if (headFilterResult) {
                            tcs.addFilterForTailCheckIfMissing(filter);
                        }
                    } else if (filter instanceof OrTransactionTraceFilter) {
                        headFilterResult = FilterController.shouldCollectFinal(filter, filterStatus[i]);
                        if (headFilterResult) {
                            tcs.setTraceCollectionReason(FilterController.formatTraceCollectionReason(filter));
                            return true;
                        }
                        tcs.addFilterForTailCheckIfMissing(filter);
                    }
                } else {
                    headFilterResult = FilterController.shouldCollectFinal(filter, filterStatus[i]);
                    if (headFilterResult) {
                        tcs.setTraceCollectionReason(FilterController.formatTraceCollectionReason(filter));
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean pessimisticLegacyFiltersExecute(TransactionComponentData rootTcdData, TransactionCollectStatus tcs) {
        if (!tcs.anyPendingTailFilters()) {
            return false;
        }
        ITransactionTraceFilter[] filters = tcs.getFiltersForTailCheck();
        if (filters == null || filters.length == 0) {
            return false;
        }
        boolean filterResult = false;
        int i = 0;
        while (i < filters.length) {
            ITransactionTraceFilter filter = filters[i];
            if (filter != null && (filterResult = filter instanceof AFilterListTransactionTraceFilter ? ((AFilterListTransactionTraceFilter)filter).passesTailFilter(rootTcdData) : filter.ITransactionTraceFilter_passesFilter(rootTcdData))) {
                tcs.setTraceCollectionReason(FilterController.formatTraceCollectionReason(filter));
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean pessimisticFiltersExecute(TransactionCollectStatus tcs) {
        if (!tcs.anyPendingTailFilters()) {
            return false;
        }
        ITransactionTraceFilter[] filters = tcs.getFiltersForTailCheck();
        if (filters == null || filters.length == 0) {
            return false;
        }
        boolean filterResult = false;
        int i = 0;
        while (i < filters.length) {
            boolean isFilterProcessed = false;
            ITransactionTraceFilter filter = filters[i];
            if (filter != null) {
                if (filter instanceof AFilterListTransactionTraceFilter) {
                    if (!((AFilterListTransactionTraceFilter)filter).hasCustomLegacyTailFilter()) {
                        isFilterProcessed = true;
                        filterResult = ((ITailParameterTransactionTraceFilter)((Object)filter)).ITailParameterTransactionTraceFilter_passesFilter(tcs.getFilterParameters());
                    }
                } else if (filter instanceof AFailFastTransactionTraceFilter && !((AFailFastTransactionTraceFilter)filter).hasCustomLegacyTailFilter()) {
                    isFilterProcessed = true;
                    filterResult = ((AFailFastTransactionTraceFilter)filter).ITailParameterTransactionTraceFilter_passesFilter(tcs.getFilterParameters());
                }
                if (filterResult) {
                    tcs.setTraceCollectionReason(FilterController.formatTraceCollectionReason(filter));
                    return true;
                }
                if (isFilterProcessed) {
                    tcs.removePendingTailFilter(i);
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean pessimisticLegacyFiltersExecute(TransactionComponentData rootTcdData) {
        if (sDynamicFilterPresence) {
            for (Map.Entry<ITransactionTraceFilter, Long> entry : fFilters.entrySet()) {
                ITransactionTraceFilter filter = entry.getKey();
                boolean filterResult = filter.ITransactionTraceFilter_passesFilter(rootTcdData);
                if (!filterResult) continue;
                rootTcdData.setParameterValue("Trace Reason", filter.toString());
                return true;
            }
        }
        if (!sPermanentFilters.isEmpty()) {
            for (ITransactionTraceFilter filter : sPermanentFilters.keySet()) {
                boolean filterResult = filter.ITransactionTraceFilter_passesFilter(rootTcdData);
                if (!filterResult) continue;
                rootTcdData.setParameterValue("Trace Reason", filter.toString());
                return true;
            }
        }
        return false;
    }

    public static int getComponentCountLimit() {
        return fComponentCountClamp;
    }

    public static int getHeadFilterComponentLimit() {
        return fHeadFilterClamp;
    }

    private static boolean isSustainabilityMetricsEnabled() {
        return fSustainabilityMetricEnabled;
    }

    private static void updateTransientFilterSustainabilityMetric() {
        if (dataAccumulator != null && FilterController.isSustainabilityMetricsEnabled()) {
            dataAccumulator.safeGetIntegerFluctuatingCounterDataAccumulator(sFilterCountMetricName).IIntegerCounterDataAccumulator_setValue(transientFilterCount.intValue());
        }
    }

    public static void init(IAgent agent) {
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        if (cm != null) {
            FilterController.defineConfigurationProperties(cm, agent.IAgent_getModule(), agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
            if (sSampler == null) {
                sSampler = new SamplingManager(agent);
                sSampler.configure();
            }
            if (dataAccumulator == null) {
                dataAccumulator = agent.IAgent_getDataAccumulatorFactory();
            }
        } else {
            agent.IAgent_getModuleFeedback().warn("Filter Controller properties could not be initialized because the configuration manager was not found");
        }
    }

    private static void defineConfigurationProperties(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontrace.componentCountClamp", 5000, "TT_Component_Count_Limit", feedback, module, localizer){

            @Override
            public void set(Object value) {
                fComponentCountClamp = (Integer)value;
            }
        });
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontrace.headFilterClamp", 30, "TT_Head_Filter_Limit", feedback, module, localizer){

            @Override
            public void set(Object value) {
                fHeadFilterClamp = (Integer)value;
                WilyTransactionStructure.fHeadFilterClampEventLogged = false;
            }
        });
        configManager.add(new BooleanConfigurationProperty("introscope.agent.transactiontracer.tailfilterPropagate.enable", Boolean.TRUE, feedback, module, localizer){

            @Override
            public void set(Object value) {
                fTailFilterPropagate = (Boolean)value;
            }
        });
        configManager.add(new BooleanConfigurationProperty(kTransactionTraceFilterDebugMetricsEnabledProperty, Boolean.FALSE, feedback, module, localizer){

            @Override
            public void set(Object value) {
                fSustainabilityMetricEnabled = (Boolean)value;
                FilterController.updateTransientFilterSustainabilityMetric();
            }
        });
    }

    public static interface ISupressTraceFilter {
        public boolean isTraceSupressed(List<ITransactionInstance> var1, TransactionCollectStatus var2);
    }
}

