/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IDataAccumulatorTracker;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IChildRead;
import com.wily.introscope.agent.trace.cas.IEditableTransactionElement;
import com.wily.introscope.agent.trace.cas.IInstanceFactoryRepository;
import com.wily.introscope.agent.trace.cas.IMetricHolder;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.SetElement;
import com.wily.introscope.agent.trace.cas.SharedDataStructure4;
import com.wily.introscope.agent.trace.cas.SharedDataStructure5;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.timeslice.ANumericalTimeslicedValue;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.util.feedback.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class WilyAggregateMetricsHarvester {
    private static final int countNodes = 0;
    private static final int countDepth = 13;
    private static final int maxDepthTree = 14;
    private static final int countHarvest = 15;
    private static final int maxHarvestingNodeTime = 16;
    private static final int readTimeQueueStrTree = 1;
    private static final int mergeTimeQueueStrTree = 2;
    private static final int readTimeSynchStrTree = 3;
    private static final int mergeTimeSynchStrTree = 4;
    private static final int readTimeOthersTree = 5;
    private static final int mergeTimeOthersTree = 6;
    private static final int readTimeQueueStrMap = 7;
    private static final int mergeTimeQueueStrMap = 8;
    private static final int readTimeSynchStrMap = 9;
    private static final int mergeTimeSynchStrMap = 10;
    private static final int readTimeOthersMap = 11;
    private static final int mergeTimeOthersMap = 12;
    private static final int repositoriesConsidered = 17;
    private static final int metricMerged = 18;
    private static final int repositoriesSkipped = 19;
    private static final int countMap = 20;
    private static final int countMapSkipped = 21;
    private static final int queueSizeQueueStrMap = 22;
    private static final int queueSizeQueueStrTree = 23;
    private static final AtomicReference longerCursor = new AtomicReference();
    private static final int kResting = 0;
    private static final int kHarvesting = 1;
    private static final int kCleaning = 2;
    private static final AtomicInteger fHarvestingState = new AtomicInteger(0);
    private volatile WilyTransactionStructure structure;
    private final HashMap longmetrics = new HashMap();
    private long lastStartTimestamp = Long.MAX_VALUE;
    private long lastEndTimestamp = Long.MAX_VALUE;
    private static final long kProbablySkippedHaverstCycle = 7500L;
    static final ATimeslicedValue[] emptySlice = new ATimeslicedValue[0];
    private static final Module kHarvertingTrace = new Module("TraceHarvesting");

    public WilyAggregateMetricsHarvester(WilyTransactionStructure structure) {
        this.structure = structure;
    }

    public WilyAggregateMetricsHarvester() {
    }

    private void doHarvest(IAgent agent, long readTime, final boolean isHarvestingMetrics, boolean isHarvestingTrace, long[] counter, ITransactionElement root) {
        final Stack<Object> target = new Stack<Object>();
        final Integer[] newCursorDepth = new Integer[]{0};
        IChildRead read = new IChildRead(){

            @Override
            public void readElement(ITransactionElement e) {
                target.push(e);
                if (isHarvestingMetrics) {
                    target.push(newCursorDepth[0]);
                }
            }
        };
        Integer currentCursorDepth = null;
        target.push(root.touch(readTime));
        if (isHarvestingMetrics) {
            target.push(0);
        }
        while (!target.isEmpty()) {
            boolean isCorrectCasting;
            if (isHarvestingMetrics) {
                currentCursorDepth = (Integer)target.pop();
            }
            ITransactionElement cursor = (ITransactionElement)target.pop();
            boolean bl = isCorrectCasting = isHarvestingTrace && cursor != null && cursor instanceof WilyTransactionElement;
            if (isCorrectCasting && isHarvestingTrace) {
                agent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "Start harvesting element " + ((WilyTransactionElement)cursor).getBlameName());
            }
            IMetricHolder element = null;
            if (cursor instanceof IMetricHolder) {
                element = (IMetricHolder)((Object)cursor);
                this.harvestWilyElement(agent, isHarvestingMetrics, counter, cursor, element);
            } else if (cursor instanceof SetElement && ((SetElement)cursor).element instanceof IMetricHolder) {
                element = (IMetricHolder)((Object)((SetElement)cursor).element);
                this.harvestWilyElement(agent, isHarvestingMetrics, counter, cursor, element);
            }
            boolean optimizeHarvesting = WilyTransactionStructure.fOptimizeHarvestingProperty.value;
            if (!optimizeHarvesting || cursor.wasTouchedSinceLastReadTime()) {
                if (cursor.hasChildren()) {
                    if (isCorrectCasting && isHarvestingTrace) {
                        agent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "Start iterating element " + ((WilyTransactionElement)cursor).getBlameName() + " childrens ");
                    }
                    if (isHarvestingMetrics) {
                        newCursorDepth[0] = currentCursorDepth + 1;
                    }
                    if (cursor instanceof IEditableTransactionElement) {
                        ((IEditableTransactionElement)((Object)cursor)).offerChildrenForRead(read);
                    } else {
                        Iterator i = cursor.iterateChildren();
                        while (i.hasNext()) {
                            target.push(i.next());
                            if (!isHarvestingMetrics) continue;
                            target.push(newCursorDepth[0]);
                        }
                    }
                } else if (isHarvestingMetrics && (long)currentCursorDepth.intValue() > counter[14]) {
                    counter[14] = currentCursorDepth.intValue();
                }
            }
            cursor.markReadTime(readTime);
            counter[0] = counter[0] + 1L;
            if (!isCorrectCasting || !isHarvestingTrace) continue;
            agent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "End harvesting element " + ((WilyTransactionElement)cursor).getBlameName());
        }
    }

    private void harvestWilyElement(IAgent agent, boolean isHarvestingMetrics, long[] counter, ITransactionElement cursor, IMetricHolder element) {
        boolean elementHasReactivatedAccumulators = false;
        long startElement = 0L;
        if (element != null) {
            long endElement;
            Iterator iterator;
            if (isHarvestingMetrics) {
                startElement = System.nanoTime();
            }
            if ((iterator = element.getMetrics()) != null && iterator.hasNext() && (elementHasReactivatedAccumulators = this.harvestMap(agent, isHarvestingMetrics, counter, iterator))) {
                this.activateAccumulators(element);
            }
            if (isHarvestingMetrics && counter[16] < (endElement = (System.nanoTime() - startElement) / 1000000L)) {
                counter[16] = endElement;
                longerCursor.set(cursor);
            }
        }
    }

    private void activateAccumulators(IMetricHolder element) {
        IDataAccumulatorTracker fTracker = this.structure.getTracker();
        Iterator iterator = element.getMetrics();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            AgentMetric[] metric = (AgentMetric[])entry.getValue();
            int i = 0;
            while (i < metric.length) {
                Object key;
                MetricAgingSharedElementWrapper existing = (MetricAgingSharedElementWrapper)this.longmetrics.get(metric[i]);
                if (existing != null && existing.IDataAccumulator_isShutOff()) {
                    fTracker.IDataAccumulatorTracker_trackAccumulator(existing);
                } else if (existing == null && (key = entry.getKey()) instanceof IInstanceFactoryRepository) {
                    existing = new MetricAgingSharedElementWrapper((IInstanceFactoryRepository)key, metric[i]);
                    this.longmetrics.put(metric[i], existing);
                    fTracker.IDataAccumulatorTracker_trackAccumulator(existing);
                }
                ++i;
            }
        }
    }

    private boolean harvestMap(IAgent agent, boolean isHarvestingMetrics, long[] counter, Iterator iterator) {
        long startReadNano = 0L;
        IDataAccumulatorTracker fTracker = this.structure.getTracker();
        boolean reactivate = false;
        while (iterator.hasNext()) {
            long endNano;
            int index;
            Map.Entry entry = (Map.Entry)iterator.next();
            IRepository rep = (IRepository)entry.getKey();
            if (rep == null) {
                Object[] metricsArray = (AgentMetric[])entry.getValue();
                agent.IAgent_getModuleFeedback().error("Detected null repository in transaction structure with metrics: " + Arrays.toString(metricsArray));
                continue;
            }
            IRepository.IRepositorySustainabilityCallback callback = null;
            if (isHarvestingMetrics) {
                counter[17] = counter[17] + 1L;
                final long[] myCounter = counter;
                callback = new IRepository.IRepositorySustainabilityCallback(){

                    @Override
                    public void onRead(int elementsInQueue) {
                        myCounter[23] = myCounter[23] + (long)elementsInQueue;
                    }
                };
            }
            if (!rep.shouldBeHarvested()) {
                if (!isHarvestingMetrics) continue;
                counter[19] = counter[19] + 1L;
                continue;
            }
            boolean hasNotChanged = rep.hasNotChanged();
            AgentMetric[] metric = (AgentMetric[])entry.getValue();
            ISharedElement offered = null;
            if (isHarvestingMetrics) {
                index = 0;
                index = rep instanceof SharedDataStructure4 ? 1 : (rep instanceof SharedDataStructure5 ? 3 : 5);
                if (index == 1) {
                    startReadNano = System.nanoTime();
                    offered = rep.read(callback);
                    endNano = System.nanoTime();
                } else {
                    startReadNano = System.nanoTime();
                    offered = rep.read();
                    endNano = System.nanoTime();
                }
                int n = index;
                counter[n] = counter[n] + (endNano - startReadNano);
            } else {
                offered = rep.read();
            }
            if (isHarvestingMetrics) {
                startReadNano = System.nanoTime();
            }
            int i = 0;
            while (i < metric.length) {
                block22: {
                    block23: {
                        block21: {
                            if (metric[i] != AgentMetric.kNullAgentMetric) break block21;
                            agent.IAgent_getModuleFeedback().debug(kHarvertingTrace, "[harvestMap]Skipping NullAgentMetric");
                            break block22;
                        }
                        MetricAgingSharedElementWrapper existing = (MetricAgingSharedElementWrapper)this.longmetrics.get(metric[i]);
                        if (existing == null) {
                            if (!hasNotChanged) {
                                existing = new MetricAgingSharedElementWrapper(rep, offered.getSharedElementInstance(), metric[i]);
                                fTracker.IDataAccumulatorTracker_trackAccumulator(existing);
                                this.longmetrics.put(metric[i], existing);
                                reactivate = true;
                            }
                        } else if (!hasNotChanged) {
                            if (existing.fRemoved) {
                                reactivate = true;
                            } else {
                                existing.countCyclesWithoutUpdates = -1;
                            }
                        }
                        if (existing == null) break block23;
                        if (existing.IDataAccumulator_isShutOff() && !reactivate) break block22;
                        existing.element.merge(offered);
                    }
                    if (isHarvestingMetrics) {
                        counter[18] = counter[18] + 1L;
                    }
                }
                ++i;
            }
            if (!isHarvestingMetrics) continue;
            index = 0;
            endNano = System.nanoTime();
            index = rep instanceof SharedDataStructure4 ? 2 : (rep instanceof SharedDataStructure5 ? 4 : 6);
            int n = index;
            counter[n] = counter[n] + (endNano - startReadNano);
        }
        return reactivate;
    }

    private void harvestMap2(boolean isHarvestingMetrics, IAgent fAgent, long[] counter, Iterator iterator) {
        long startReadNano = 0L;
        IRepository.IRepositorySustainabilityCallback callback = null;
        IDataAccumulatorTracker fTracker = this.structure.getTracker();
        if (isHarvestingMetrics) {
            final long[] myCounter = counter;
            callback = new IRepository.IRepositorySustainabilityCallback(){

                @Override
                public void onRead(int elementsInQueue) {
                    myCounter[22] = myCounter[22] + (long)elementsInQueue;
                }
            };
        }
        while (iterator.hasNext()) {
            long endNano;
            Map.Entry entry = (Map.Entry)iterator.next();
            counter[20] = counter[20] + 1L;
            IRepository rep = (IRepository)entry.getValue();
            if (rep == null) continue;
            if (!rep.shouldBeHarvested()) {
                counter[21] = counter[21] + 1L;
                continue;
            }
            boolean hasNotChanged = rep.hasNotChanged();
            AAgentMetricArray metric = (AAgentMetricArray)entry.getKey();
            ISharedElement offered = null;
            if (isHarvestingMetrics) {
                int index = 0;
                index = rep instanceof SharedDataStructure4 ? 7 : (rep instanceof SharedDataStructure5 ? 9 : 11);
                if (index == 7) {
                    startReadNano = System.nanoTime();
                    offered = rep.read(callback);
                    endNano = System.nanoTime();
                } else {
                    startReadNano = System.nanoTime();
                    offered = rep.read();
                    endNano = System.nanoTime();
                }
                int n = index;
                counter[n] = counter[n] + (endNano - startReadNano);
            } else {
                offered = rep.read();
            }
            if (isHarvestingMetrics) {
                startReadNano = System.nanoTime();
            }
            Object[] metrics = metric.getMetrics();
            int i = 0;
            while (i < metrics.length) {
                block21: {
                    block22: {
                        block20: {
                            if (metrics[i] != AgentMetric.kNullAgentMetric) break block20;
                            fAgent.IAgent_getModuleFeedback().debug(kHarvertingTrace, "[harvestMap2]Skipping NullAgentMetric");
                            break block21;
                        }
                        MetricAgingSharedElementWrapper existing = (MetricAgingSharedElementWrapper)this.longmetrics.get((AgentMetric)metrics[i]);
                        if (existing == null) {
                            if (!hasNotChanged) {
                                existing = new MetricAgingSharedElementWrapper(rep, offered.getSharedElementInstance(), (AgentMetric)metrics[i]);
                                fTracker.IDataAccumulatorTracker_trackAccumulator(existing);
                                this.longmetrics.put((AgentMetric)metrics[i], existing);
                            }
                        } else if (!hasNotChanged) {
                            if (existing.fRemoved) {
                                fTracker.IDataAccumulatorTracker_trackAccumulator(existing);
                            } else {
                                existing.countCyclesWithoutUpdates = -1;
                            }
                        }
                        if (existing == null) break block22;
                        if (existing.IDataAccumulator_isShutOff()) break block21;
                        existing.element.merge(offered);
                    }
                    if (isHarvestingMetrics) {
                        counter[18] = counter[18] + 1L;
                    }
                }
                ++i;
            }
            if (!isHarvestingMetrics) continue;
            endNano = System.nanoTime();
            int index = rep instanceof SharedDataStructure4 ? 8 : (rep instanceof SharedDataStructure5 ? 10 : 12);
            int n = index;
            counter[n] = counter[n] + (endNano - startReadNano);
        }
    }

    private void harvestHolder(boolean isHarvestingMetrics, IAgent fAgent, long[] counter, Set elementMetrics) {
        long startReadNano = 0L;
        IRepository.IRepositorySustainabilityCallback callback = null;
        IDataAccumulatorTracker fTracker = this.structure.getTracker();
        if (isHarvestingMetrics) {
            final long[] myCounter = counter;
            callback = new IRepository.IRepositorySustainabilityCallback(){

                @Override
                public void onRead(int elementsInQueue) {
                    myCounter[22] = myCounter[22] + (long)elementsInQueue;
                }
            };
        }
        for (IMetricHolder holder : elementMetrics) {
            Iterator iterator = holder.getMetrics();
            while (iterator.hasNext()) {
                long endNano;
                Map.Entry entry = (Map.Entry)iterator.next();
                counter[20] = counter[20] + 1L;
                IRepository rep = (IRepository)entry.getKey();
                if (!rep.shouldBeHarvested()) {
                    counter[21] = counter[21] + 1L;
                    continue;
                }
                boolean hasNotChanged = rep.hasNotChanged();
                ISharedElement offered = null;
                if (isHarvestingMetrics) {
                    int index = 0;
                    index = rep instanceof SharedDataStructure4 ? 7 : (rep instanceof SharedDataStructure5 ? 9 : 11);
                    if (index == 7) {
                        startReadNano = System.nanoTime();
                        offered = rep.read(callback);
                        endNano = System.nanoTime();
                    } else {
                        startReadNano = System.nanoTime();
                        offered = rep.read();
                        endNano = System.nanoTime();
                    }
                    int n = index;
                    counter[n] = counter[n] + (endNano - startReadNano);
                } else {
                    offered = rep.read();
                }
                AgentMetric[] metrics = (AgentMetric[])entry.getValue();
                if (isHarvestingMetrics) {
                    startReadNano = System.nanoTime();
                }
                int i = 0;
                while (i < metrics.length) {
                    block22: {
                        block21: {
                            MetricAgingSharedElementWrapper existing = (MetricAgingSharedElementWrapper)this.longmetrics.get(metrics[i]);
                            if (existing == null) {
                                if (!hasNotChanged) {
                                    existing = new MetricAgingSharedElementWrapper(rep, offered.getSharedElementInstance(), metrics[i]);
                                    fTracker.IDataAccumulatorTracker_trackAccumulator(existing);
                                    this.longmetrics.put(metrics[i], existing);
                                }
                            } else if (!hasNotChanged) {
                                if (existing.fRemoved) {
                                    fTracker.IDataAccumulatorTracker_trackAccumulator(existing);
                                } else {
                                    existing.countCyclesWithoutUpdates = -1;
                                }
                            }
                            if (existing == null) break block21;
                            if (existing.IDataAccumulator_isShutOff()) break block22;
                            existing.element.merge(offered);
                        }
                        if (isHarvestingMetrics) {
                            counter[18] = counter[18] + 1L;
                        }
                    }
                    ++i;
                }
                if (!isHarvestingMetrics) continue;
                endNano = System.nanoTime();
                int index = rep instanceof SharedDataStructure4 ? 8 : (rep instanceof SharedDataStructure5 ? 10 : 12);
                int n = index;
                counter[n] = counter[n] + (endNano - startReadNano);
            }
        }
    }

    public AgentMetricData[] doHarvest(IAgent fAgent) {
        if (!fHarvestingState.compareAndSet(0, 1)) {
            return new AgentMetricData[0];
        }
        try {
            AgentMetricData[] agentMetricDataArray = this.unsafeDoHarvest(fAgent);
            return agentMetricDataArray;
        }
        finally {
            fHarvestingState.set(0);
        }
    }

    private AgentMetricData[] unsafeDoHarvest(IAgent fAgent) {
        long currentTime;
        boolean harvestMetric;
        boolean isHarvestingTrace = fAgent.IAgent_getModuleFeedback().isTraceEnabled(kHarvertingTrace);
        boolean bl = harvestMetric = WilyTransactionStructure.fDebugMetricProperty == null ? false : WilyTransactionStructure.fDebugMetricProperty.value;
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "Start harvesting");
        }
        if ((currentTime = System.currentTimeMillis()) < this.lastStartTimestamp) {
            this.lastStartTimestamp = currentTime;
        }
        this.lastEndTimestamp = currentTime;
        this.structure = WilyTransactionStructure.getInstance();
        long[] counter = new long[24];
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "Start harvesting elements");
        }
        this.doHarvest(fAgent, currentTime, harvestMetric, isHarvestingTrace, counter, this.structure.getRoot());
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "End harvesting elements");
        }
        if (harvestMetric) {
            this.tryLog(fAgent, counter);
        }
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "Start harvesting map");
        }
        this.harvestMap2(harvestMetric, fAgent, counter, this.structure.iterateOverGlobalGatherer());
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "End harvesting map");
        }
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "Start harvesting map");
        }
        this.harvestHolder(harvestMetric, fAgent, counter, this.structure.privateMetricHolder);
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "End harvesting map");
        }
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "Start creating timeslices");
        }
        ArrayList<AgentMetricData> bindings = new ArrayList<AgentMetricData>();
        Frequency frequency = Frequency.kDefaultAgentFrequency;
        Iterator i = this.longmetrics.entrySet().iterator();
        while (i.hasNext()) {
            AgentMetricData newBinding;
            ISharedElement element;
            ANumericalTimeslicedValue slice;
            Map.Entry e = i.next();
            MetricAgingSharedElementWrapper wrapper = (MetricAgingSharedElementWrapper)e.getValue();
            if (wrapper.isRemoved()) {
                i.remove();
                continue;
            }
            if (wrapper.IDataAccumulator_isShutOff()) continue;
            AgentMetric metric = (AgentMetric)e.getKey();
            if (metric == AgentMetric.kNullAgentMetric) {
                fAgent.IAgent_getModuleFeedback().debug(kHarvertingTrace, "[unsafeDoHarvest]Skipping NullAgentMetric");
                continue;
            }
            boolean treatZeroAsHole = TypeInquisitor.isTreatZeroCountAsHole(metric.getAttributeType());
            boolean isLong = TypeInquisitor.isLong(metric.getAttributeType());
            ++wrapper.countCyclesWithoutUpdates;
            if (isLong) {
                slice = null;
                element = wrapper.element;
                slice = element == null ? new LongTimeslicedValue(metric.getAttributeType(), this.lastStartTimestamp, this.lastEndTimestamp, BlameStackSnapshot.kEmptyBlameStackSnapshot, true) : (element.getCount() == 0L && treatZeroAsHole && !wrapper.IDataAccumulator_hasNewData(0) ? new LongTimeslicedValue(metric.getAttributeType(), this.lastStartTimestamp, this.lastEndTimestamp, BlameStackSnapshot.kEmptyBlameStackSnapshot, true) : new LongTimeslicedValue(metric.getAttributeType(), element.getStartTimestamp(), this.lastEndTimestamp, BlameStackSnapshot.kEmptyBlameStackSnapshot, element.getCount(), false, element.getValue(), element.getMinimum(), element.getMaximum()));
                newBinding = new AgentMetricData(metric, frequency, slice);
                bindings.add(newBinding);
                element.reset();
                continue;
            }
            slice = null;
            element = wrapper.element;
            slice = element == null ? new IntegerTimeslicedValue(metric.getAttributeType(), this.lastStartTimestamp, this.lastEndTimestamp, BlameStackSnapshot.kEmptyBlameStackSnapshot, true) : (element.getCount() == 0L && treatZeroAsHole && !wrapper.IDataAccumulator_hasNewData(0) ? new IntegerTimeslicedValue(metric.getAttributeType(), this.lastStartTimestamp, this.lastEndTimestamp, BlameStackSnapshot.kEmptyBlameStackSnapshot, true) : new IntegerTimeslicedValue(metric.getAttributeType(), element.getStartTimestamp(), this.lastEndTimestamp, BlameStackSnapshot.kEmptyBlameStackSnapshot, element.getCount(), false, (int)element.getValue(), (int)element.getMinimum(), (int)element.getMaximum()));
            newBinding = new AgentMetricData(metric, frequency, slice);
            bindings.add(newBinding);
            element.reset();
        }
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "The time slice metrics are " + this.longmetrics.size());
        }
        this.lastStartTimestamp = currentTime;
        if (isHarvestingTrace) {
            fAgent.IAgent_getModuleFeedback().trace(kHarvertingTrace, "End creating timeslices");
        }
        return bindings.toArray(AgentMetricData.kZeroLengthESETimeslicedBindingArray);
    }

    private void tryLog(IAgent agent, long[] counter) {
        try {
            IIntegerFluctuatingCounterDataAccumulator accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester:Count Nodes Harvested");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[0]);
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester:Maximum Structure Depth");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[14]);
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester:Maximum Harvesting time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[16]);
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Structure|QueueStructure:Read Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[1] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Structure|QueueStructure:Merge Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[2] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Structure|QueueStructure:Total Queue size");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[23]);
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Structure|SynchStructure:Read Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[3] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Structure|SynchStructure:Merge Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[4] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Structure|Others:Read Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[5] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Structure|Others:Merge Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[6] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Shared Repositories|QueueStructure:Read Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[7] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Shared Repositories|QueueStructure:Merge Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[8] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Shared Repositories|QueueStructure:Total Queue size");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[22]);
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Shared Repositories|SynchStructure:Read Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[9] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Shared Repositories|SynchStructure:Merge Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[10] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Shared Repositories|Others:Read Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[11] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Shared Repositories|Others:Merge Time");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)(counter[12] / 1000000L));
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Repositories:Repositories Considered");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[17]);
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Repositories:Repositories Skipped");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[19]);
            accumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester|Repositories:Metric Merged");
            accumulator.IIntegerCounterDataAccumulator_setValue((int)counter[18]);
            if (agent.IAgent_getModuleFeedback().isDebugEnabled(kHarvertingTrace) && longerCursor.get() != null) {
                agent.IAgent_getModuleFeedback().debug(kHarvertingTrace, "longer element harvesting time " + (int)counter[16] + "\n" + longerCursor.get());
            }
        }
        catch (Exception e) {
            agent.IAgent_getModuleFeedback().debug(e.getMessage(), e);
        }
    }

    protected AgentMetric[] createDebugCounterMetric(String formattedMetricName) {
        int metricType = 0x40002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.structure.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    public void doCleanup(IAgent fAgent) {
        if (!fHarvestingState.compareAndSet(0, 2)) {
            return;
        }
        try {
            this.structure = WilyTransactionStructure.getInstance();
            this.cleanupTransactionStructure();
            for (IMetricHolder holder : this.structure.privateMetricHolder) {
                this.cleanupMetricHolderRepositories(holder);
            }
            Iterator iterator = this.structure.iterateOverGlobalGatherer();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                IRepository rep = (IRepository)entry.getValue();
                if (!rep.shouldBeHarvested()) continue;
                rep.cleanup(true);
            }
        }
        finally {
            fHarvestingState.set(0);
        }
    }

    private void cleanupTransactionStructure() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.lastStartTimestamp) {
            this.lastStartTimestamp = currentTime;
        }
        this.lastEndTimestamp = currentTime;
        ITransactionElement root = this.structure.getRoot();
        final Stack<ITransactionElement> target = new Stack<ITransactionElement>();
        IChildRead read = new IChildRead(){

            @Override
            public void readElement(ITransactionElement e) {
                target.push(e);
            }
        };
        target.push(root.touch(currentTime));
        while (!target.isEmpty()) {
            ITransactionElement cursor = (ITransactionElement)target.pop();
            IMetricHolder element = null;
            if (cursor instanceof IMetricHolder) {
                element = (IMetricHolder)((Object)cursor);
            } else if (cursor instanceof SetElement && ((SetElement)cursor).element instanceof IMetricHolder) {
                element = (IMetricHolder)((Object)((SetElement)cursor).element);
            }
            this.cleanupMetricHolderRepositories(element);
            boolean optimizeHarvesting = false;
            if (optimizeHarvesting && !cursor.wasTouchedSinceLastReadTime() || !cursor.hasChildren()) continue;
            if (cursor instanceof IEditableTransactionElement) {
                ((IEditableTransactionElement)((Object)cursor)).offerChildrenForRead(read);
                continue;
            }
            Iterator i = cursor.iterateChildren();
            while (i.hasNext()) {
                target.push((ITransactionElement)i.next());
            }
        }
    }

    private void cleanupMetricHolderRepositories(IMetricHolder element) {
        Iterator iterator;
        if (element != null && (iterator = element.getMetrics()) != null && iterator.hasNext()) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                IRepository rep = (IRepository)entry.getKey();
                if (!rep.shouldBeHarvested()) continue;
                rep.cleanup(true);
            }
        }
    }

    static class MetricAgingSharedElementWrapper
    implements IDataAccumulator,
    IGatherer {
        volatile int countCyclesWithoutUpdates;
        final IRepository repository;
        final ISharedElement element;
        final AgentMetric metric;
        volatile boolean fShutoff;
        volatile boolean fRemoved;

        MetricAgingSharedElementWrapper(IInstanceFactoryRepository r, AgentMetric m) {
            this.repository = r;
            this.element = r.getSharedElementInstance();
            this.metric = m;
        }

        MetricAgingSharedElementWrapper(IRepository r, ISharedElement e, AgentMetric m) {
            this.repository = r;
            this.element = e;
            this.metric = m;
        }

        @Override
        public AgentMetric IDataAccumulator_getMetric() {
            return this.metric;
        }

        @Override
        public IGatherer IDataAccumulator_getGatherer() {
            return this;
        }

        @Override
        public boolean IDataAccumulator_isConstant() {
            return false;
        }

        @Override
        public boolean IDataAccumulator_isShutOff() {
            return this.fShutoff;
        }

        @Override
        public void IDataAccumulator_setShutOff(boolean isShutOff) {
            this.fShutoff = isShutOff;
            this.repository.setShutOff(isShutOff);
            if (!this.fShutoff) {
                this.countCyclesWithoutUpdates = -1;
                this.fRemoved = false;
            }
        }

        @Override
        public void forceMetricToExist(BlameStackSnapshot snapshot) {
        }

        @Override
        public boolean IDataAccumulator_hasNewData(int timeslices) {
            return this.countCyclesWithoutUpdates <= timeslices;
        }

        @Override
        public boolean isRemoved() {
            return this.fRemoved;
        }

        @Override
        public void setRemoval() {
            this.fRemoved = true;
            this.fShutoff = true;
        }

        @Override
        public ATimeslicedValue[] IGatherer_harvestAndReset(long when) {
            return emptySlice;
        }

        @Override
        public ATimeslicedValue[] IGatherer_harvestAndReset(long when, BlameStackSnapshot blameStack) {
            return emptySlice;
        }

        @Override
        public ATimeslicedValue[] IGatherer_harvest(long when) {
            return emptySlice;
        }

        @Override
        public ATimeslicedValue[] IGatherer_harvest(long when, BlameStackSnapshot blameStack) {
            return emptySlice;
        }

        @Override
        public void IGatherer_reset(long when) {
        }

        @Override
        public void IGatherer_acceptAggregateTimeslicedValue(ATimeslicedValue newAggregate) throws IncompatibleTypesException {
        }

        @Override
        public void IGatherer_reinitialize() {
        }

        @Override
        public int IGatherer_getESETypeCookie() {
            return this.metric.getAttributeType();
        }

        @Override
        public boolean IGatherer_canCombineData() {
            return false;
        }

        @Override
        public void forceToExist(BlameStackSnapshot blameStack) {
        }

        @Override
        public void acceptValueNonSync(IMetricDataValue value) throws IncompatibleTypesException {
        }

        @Override
        public IMetricDataValue harvestAndReinitializeNonSync(long harvestTimeMS) {
            return null;
        }

        @Override
        public IMetricDataValue harvestAndAbandonNonSync(long harvestTimeMS) {
            return null;
        }

        @Override
        public boolean IGatherer_hasNewData(int timeslices) {
            return false;
        }

        @Override
        public long IGatherer_getStartTimestamp() {
            return 0L;
        }
    }
}

