/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ConfigurationWatcherElement;
import com.wily.util.IConfigurationListener;
import com.wily.util.IConfigurationVariableResolver;
import com.wily.util.adt.WeakHashSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class ConfigurationWatcher
implements ITimestampedRunnable {
    private LinkedHashMap configWatcherElements = new LinkedHashMap();
    private IntervalHeartbeat heartbeat;
    private IRegisteredBehavior behavior;
    private WeakHashSet listeners;
    private WeakHashSet resolvers;
    private IModuleFeedbackChannel feedback;
    private volatile IndexedProperties props;
    private volatile boolean isRunning = false;
    private static final int kConsecutiveFailureThreshold = 10;
    private WeakHashSet tweakers;

    public ConfigurationWatcher(IntervalHeartbeat heartbeat, HashMap resources, IModuleFeedbackChannel feedback) {
        this.heartbeat = heartbeat;
        this.feedback = feedback;
        this.listeners = new WeakHashSet();
        this.resolvers = new WeakHashSet();
        this.tweakers = new WeakHashSet();
        for (String profileName : resources.keySet()) {
            IResource resource = (IResource)resources.get(profileName);
            if (!resource.IResource_isFileResource()) continue;
            ConfigurationWatcherElement configWatcherElem = new ConfigurationWatcherElement();
            FileBasedResource fileResource = (FileBasedResource)resource;
            File fConfigurationFile = new File(fileResource.IResource_getLocation());
            long fLastModified = fConfigurationFile.lastModified();
            configWatcherElem.setfConfigurationFile(fConfigurationFile);
            configWatcherElem.setfLastModified(fLastModified);
            configWatcherElem.setResource(resource);
            configWatcherElem.setConsecutiveFailures(0);
            this.configWatcherElements.put(profileName, configWatcherElem);
        }
        this.props = this.reloadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processContentChange() {
        HashSet iterateOn = null;
        WeakHashSet weakHashSet = this.listeners;
        synchronized (weakHashSet) {
            if (this.listeners.size() > 0) {
                iterateOn = new HashSet(this.listeners.keySet());
            }
        }
        if (iterateOn != null) {
            IndexedProperties newProps;
            this.props = newProps = this.reloadConfiguration();
            if (newProps != null) {
                for (IConfigurationListener listener : iterateOn) {
                    listener.onChange(newProps);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resolveVariables(IndexedProperties props, ConfigurationWatcherElement element) {
        HashSet iterateOn = null;
        WeakHashSet weakHashSet = this.resolvers;
        synchronized (weakHashSet) {
            if (this.resolvers.size() > 0) {
                iterateOn = new HashSet(this.resolvers.keySet());
            }
        }
        if (iterateOn != null) {
            for (IConfigurationVariableResolver resolver : iterateOn) {
                resolver.resolve(props, element);
            }
        }
    }

    @Override
    public void ITimestampedRunnable_execute(long nowInMillis) {
        this.isRunning = true;
        if (this.contentsChanged()) {
            this.processContentChange();
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IndexedProperties reloadConfiguration() {
        IndexedProperties result = new IndexedProperties();
        Iterator itr = this.configWatcherElements.keySet().iterator();
        IndexedProperties[] indexPropertiesArr = new IndexedProperties[this.configWatcherElements.size()];
        String[] profileNameArr = new String[this.configWatcherElements.size()];
        int indexPropertyCount = 0;
        while (itr.hasNext()) {
            String profileName = (String)itr.next();
            ConfigurationWatcherElement configWatcherElem = (ConfigurationWatcherElement)this.configWatcherElements.get(profileName);
            try {
                IndexedProperties newProps = new IndexedProperties();
                if (configWatcherElem.getConsecutiveFailures() >= 10) continue;
                if (configWatcherElem.getResource() instanceof FileBasedResource) {
                    newProps.load(configWatcherElem.getResource().IResource_getSourceContents());
                } else {
                    newProps.load(configWatcherElem.getResource().IResource_getContents());
                }
                this.resolveVariables(newProps, configWatcherElem);
                indexPropertiesArr[indexPropertyCount] = newProps;
                profileNameArr[indexPropertyCount] = profileName;
                ++indexPropertyCount;
                configWatcherElem.setConsecutiveFailures(0);
                this.feedback.info("re-loading configuration resource " + configWatcherElem.getResource().IResource_getLocation());
            }
            catch (Exception e) {
                if (this.feedback != null) {
                    this.feedback.warn("Error re-loading configuration resource " + configWatcherElem.getResource().IResource_getLocation());
                    this.feedback.verbose(e);
                }
                int consecutiveFailures = configWatcherElem.getConsecutiveFailures();
                configWatcherElem.setConsecutiveFailures(consecutiveFailures + 1);
                if (consecutiveFailures != 10 || this.feedback == null) continue;
                this.feedback.warn("10 consecutive failures attempting to re-load properties, giving up");
                this.heartbeat.removeBehavior(this.behavior);
            }
        }
        HashSet<Object> keySet = new HashSet<Object>();
        int arrCount = indexPropertiesArr.length;
        int i = 0;
        while (i < arrCount) {
            IndexedProperties properties = indexPropertiesArr[i];
            if (properties == null) {
                indexPropertiesArr[i] = new IndexedProperties();
            } else if (i == 0) {
                keySet.addAll(properties.ownKeySet());
            } else {
                HashSet<Object> keys = new HashSet<Object>(properties.ownKeySet());
                keys.retainAll(keySet);
                if (!keys.isEmpty()) {
                    for (String string : keys) {
                        this.feedback.info("Property " + string + " in " + profileNameArr[i] + " overwrites previously defined property with new value: " + properties.getProperty(string));
                    }
                }
                keySet.addAll(properties.ownKeySet());
            }
            ++i;
        }
        i = 0;
        while (i < arrCount) {
            IndexedProperties properties = indexPropertiesArr[i];
            String profileName = profileNameArr[i];
            result.putAll(properties, profileName);
            ++i;
        }
        HashSet iterateOn = null;
        WeakHashSet properties = this.tweakers;
        synchronized (properties) {
            if (this.tweakers.size() > 0) {
                iterateOn = new HashSet(this.tweakers.keySet());
            }
        }
        if (iterateOn != null) {
            for (IConfigurationListener tweaker : iterateOn) {
                tweaker.onChange(result);
            }
        }
        return result;
    }

    public void shutdown() {
        if (this.behavior != null) {
            this.heartbeat.removeBehavior(this.behavior);
        }
    }

    public void checkForChange(long delay) {
        IntervalHeartbeat.BehaviorNode node = (IntervalHeartbeat.BehaviorNode)this.behavior;
        if (node != null) {
            int count = 0;
            while (this.isRunning && count < 10) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                ++count;
            }
            node.scheduleForNow(System.currentTimeMillis() + delay);
            node.IRegisteredBehavior_setEnableState(false);
            node.IRegisteredBehavior_setEnableState(true);
        }
    }

    public void checkForChangeNow() {
        this.checkForChange(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationListener(IConfigurationListener listener) {
        boolean startBehavior = false;
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            if (this.listeners.size() == 0) {
                startBehavior = true;
            }
            this.listeners.add(listener);
        }
        listener.onChange(this.props);
        if (startBehavior) {
            this.behavior = this.heartbeat.addBehavior((ITimestampedRunnable)this, "Configuration Watcher", true, 60000L, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfigurationListener(IConfigurationListener listener) {
        boolean stopBehavior = false;
        boolean result = false;
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            if (this.listeners.size() > 0) {
                result = this.listeners.remove(listener);
                if (this.listeners.size() == 0) {
                    stopBehavior = true;
                }
            }
        }
        if (stopBehavior) {
            this.shutdown();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariableResolver(IConfigurationVariableResolver resolver) {
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            this.resolvers.add(resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVariableResolver(IConfigurationVariableResolver resolver) {
        boolean result = false;
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            if (this.resolvers.size() > 0) {
                result = this.resolvers.remove(resolver);
            }
        }
        return result;
    }

    private synchronized boolean contentsChanged() {
        boolean hasChanged = false;
        for (String profileName : this.configWatcherElements.keySet()) {
            long currentLastModified;
            ConfigurationWatcherElement elem = (ConfigurationWatcherElement)this.configWatcherElements.get(profileName);
            if (!elem.getfConfigurationFile().exists() || (currentLastModified = elem.getfConfigurationFile().lastModified()) <= elem.getfLastModified()) continue;
            elem.setfLastModified(currentLastModified);
            hasChanged = true;
        }
        return hasChanged;
    }

    public IndexedProperties getProperties() {
        return this.props;
    }

    public synchronized void addConfigWatcherElement(String profileName, ConfigurationWatcherElement configWatcherElem) {
        if (profileName != null && configWatcherElem != null) {
            this.configWatcherElements.put(profileName, configWatcherElem);
        }
    }

    public synchronized void removeConfigWatcherElement(String profileName) {
        if (this.configWatcherElements.containsKey(profileName)) {
            this.configWatcherElements.remove(profileName);
        }
    }

    public void reloadConfig() {
        this.processContentChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationTweaker(IConfigurationListener tweaker) {
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            this.tweakers.add(tweaker);
        }
        tweaker.onChange(this.props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfigurationTweaker(IConfigurationListener tweaker) {
        boolean result = false;
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            if (this.tweakers.size() > 0) {
                result = this.tweakers.remove(tweaker);
            }
        }
        return result;
    }
}

