/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.feedback.AApplicationFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import java.util.ArrayList;
import java.util.List;

public class ABufferedApplicationFeedbackChannel
extends AApplicationFeedbackChannel {
    public static final String kDisableFeedbackChannelBufferKey = "com.wily.introscope.disableStartupMessageBuffering";
    private final List fEventList = new ArrayList(10);
    private boolean fShouldBuffer = false;

    public ABufferedApplicationFeedbackChannel(String applicationName, String moduleName) {
        this(applicationName, moduleName, "DefaultSystemOut");
    }

    public ABufferedApplicationFeedbackChannel(String applicationName) {
        this(applicationName, null, "DefaultSystemOut");
    }

    public ABufferedApplicationFeedbackChannel(String applicationName, String moduleName, String defaultOutputTarget) {
        super(applicationName, moduleName, defaultOutputTarget);
        this.setShouldBuffer(!Boolean.getBoolean(kDisableFeedbackChannelBufferKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldBuffer(boolean shouldBuffer) {
        Object object = this.getFeedbackChannelLock();
        synchronized (object) {
            boolean shouldFlush = this.fShouldBuffer && !shouldBuffer;
            this.fShouldBuffer = shouldBuffer;
            if (shouldFlush) {
                this.flushBufferedMessages();
            }
        }
    }

    private void flushBufferedMessages() {
        while (!this.fEventList.isEmpty()) {
            BufferedLogMessage e = (BufferedLogMessage)this.fEventList.remove(0);
            this.doLog(e.fSeverity, e.fModule, e.fMessage, e.fThrowable, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void logbottleneck(SeverityLevel severity, Module module, String message, Throwable t) {
        if (this.fShouldBuffer) {
            Object object = this.getFeedbackChannelLock();
            synchronized (object) {
                this.fEventList.add(new BufferedLogMessage(severity, module, message, t));
            }
        }
        if (this.isLogEnabled(severity, module)) {
            Object object = this.getFeedbackChannelLock();
            synchronized (object) {
                this.doLog(severity, module, message, t, false);
            }
        }
    }

    private class BufferedLogMessage {
        public SeverityLevel fSeverity;
        public Module fModule;
        public String fMessage;
        public Throwable fThrowable;

        public BufferedLogMessage(SeverityLevel severity, Module module, String message, Throwable throwable) {
            this.fSeverity = severity;
            this.fModule = module;
            this.fMessage = message;
            this.fThrowable = throwable;
        }
    }
}

