/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import com.wily.isengard.postofficehub.link.http.client.ProxyConfiguration;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.UnknownHostException;

public class ProxySupport {
    private static boolean initialized = false;
    private static ProxyConfiguration proxyConfig = null;
    private static Authenticator parent;
    private static Authenticator authenticator;

    public static void initialize(IndexedProperties props, IModuleFeedbackChannel feedback, Module module) throws UnknownHostException {
        if (!initialized) {
            initialized = true;
            proxyConfig = ProxyConfiguration.newInstance((IndexedProperties)props, (IModuleFeedbackChannel)feedback, (Module)module);
        }
    }

    public static boolean isAuthRequired() {
        return proxyConfig.requiresAuthentication();
    }

    public static String getUserName() {
        return proxyConfig.getUserName();
    }

    public static String getPassword() {
        return proxyConfig.getPassword();
    }

    public static Proxy getProxy() throws IOException {
        if (proxyConfig != null) {
            proxyConfig.pingProxy();
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getHostName(), proxyConfig.getPort()));
            return proxy;
        }
        return null;
    }

    public static class AgentProxyAuthenticator
    extends Authenticator {
        private final String hostName;
        private final String userName;
        private final String password;

        AgentProxyAuthenticator(String host, String user, String pwd) {
            this.hostName = host;
            this.userName = user;
            this.password = pwd;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestingHost().equals(this.hostName)) {
                PasswordAuthentication p = new PasswordAuthentication(this.userName, this.password.toCharArray());
                return p;
            }
            return null;
        }
    }
}

