/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.def;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizdef.definition.BizTrxDef;
import com.wily.introscope.agent.blame.ApplicationNameInfo;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalBizDefAdministrator {
    private static final Module kModule = new Module("ExternalBizDef");
    private IAgent fAgent = null;
    private IModuleFeedbackChannel fFeedback;
    private static int fMaxEbtLimit = 1000;
    private static String sBTCName = "Health";
    public static final long sExternalBizDefIdBase = 14988542509842432L;
    public static final long sFrontendBizDefIdBase = 0x35500000000000L;
    private static IGuaranteedCounter sExternalBizDefCounter;
    private static IGuaranteedCounter sFrontendBizDefCounter;
    private final ConcurrentHashMap fEbtsMap;
    private static IGuaranteedCounter sExternalBizDefKeyCounter;
    private final ConcurrentHashMap fEbtsKeyMap;
    private final ConcurrentHashMap<String, IBizTrx> fFrontendBizDefMap;
    private static volatile boolean fEbtFeatureOn;
    private static volatile boolean fFirstFrontendFeatureOn;
    private static volatile boolean fCrossProcessBTFeatureOn;
    private static final int fMaxEbtMetricPathSize = 200;
    private static int fMaxEbtHeaderSize;
    public static String sSustainabilityBaseMetricName;
    private static int metricPollingDelay;
    private static int sExternalIgnoredBizRequestCounter;
    private static int sErrorMessageCounter;
    public static final String kErrorMessageCountPerDurationTimeProp = "introscope.agent.external.biz.bt.errormessage.count.max";
    public static final String kErrorMessageResetTimeInSecondsProp = "introscope.agent.external.biz.bt.errormessage.resettime.inseconds";
    public static final String kFirstFrontendBTFeatureOnParam = "introscope.agent.first.frontend.biz.enabled";
    public static final String kCrossProcessBTFeatureOnParam = "introscope.agent.crossprocess.biz.enabled";
    public static int fMaxErrorMessageCountPerDurationTime;
    private static int fErrorMessageResetTimeInSeconds;
    private IRegisteredBehavior fEBTSupportMetricBehavior;
    private IRegisteredBehavior fEBTResetErrorMessageCounterBehavior;
    private static final String UNSUPPORTED_BROWSER_NAME = "Unsupported";
    private static boolean fMaxEbtErrorNoticed;
    private final Map fBTMetricHeaderMap;
    private static final Pattern frontendPattern;

    static {
        fEbtFeatureOn = false;
        fFirstFrontendFeatureOn = false;
        fCrossProcessBTFeatureOn = false;
        fMaxEbtHeaderSize = 10;
        sSustainabilityBaseMetricName = "Agent Stats|Sustainability|External Business Transaction";
        metricPollingDelay = 15000;
        fMaxErrorMessageCountPerDurationTime = 20;
        fErrorMessageResetTimeInSeconds = 3600;
        fMaxEbtErrorNoticed = false;
        frontendPattern = Pattern.compile("Frontends\\|Apps\\|([^:\\\\|]+)\\|URLs\\|([^:\\\\|]+)");
    }

    public ExternalBizDefAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fAgent.IAgent_getStringLocalizer();
        this.fEbtsMap = new ConcurrentHashMap();
        this.fEbtsKeyMap = new ConcurrentHashMap();
        this.fBTMetricHeaderMap = new HashMap();
        this.fFrontendBizDefMap = new ConcurrentHashMap();
        sExternalBizDefCounter = agent.IAgent_getGuaranteedCounter();
        sExternalBizDefKeyCounter = agent.IAgent_getGuaranteedCounter();
        sExternalIgnoredBizRequestCounter = 0;
        sErrorMessageCounter = 0;
        sFrontendBizDefCounter = agent.IAgent_getGuaranteedCounter();
        Boolean isUsingOldConfig = agent.IAgent_getComponentTracer().isAgentOldMode();
        if (!isUsingOldConfig.booleanValue()) {
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new EbtFeatureOnProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new MaxEbtHeaderSizeParamProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new MaxEbtSizeParamProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new MaxEbtErrorMessageParamProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new ResetErrorMessageParamProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new FirstFrontendFeatureOnProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new CrossProcessBTFeatureOnProperty(agent), true);
        }
    }

    public IBizTrx getEbtTrxDef(Map valueMap, boolean isDownstream) {
        Boolean processEbtFlag = true;
        processEbtFlag = this.checkEbtHeader(valueMap, processEbtFlag);
        IBizTrx trxDef = null;
        if (processEbtFlag.booleanValue()) {
            trxDef = this.createEbtTrxDef(valueMap, isDownstream);
        }
        return trxDef;
    }

    public String concatVersion(String version) {
        String result = version.trim();
        if (!"".equals(version)) {
            if (version.contains(".") && version.indexOf(".") > 0) {
                result = version.substring(0, version.indexOf("."));
            } else if (version.contains(".") && version.indexOf(".") == 0) {
                result = "";
            }
        }
        return result;
    }

    public Map<String, String> extractCookieFields(Map<String, String> cookieMap) {
        String url;
        String browserVersion;
        HashMap<String, String> result = new HashMap<String, String>(2);
        String browserType = cookieMap.get("x-apm-brtm-bt-p");
        if (!(browserType != null && browserType.trim().equals("-1") || browserType == null)) {
            result.put("x-apm-brtm-bt-p", browserType);
        }
        if ((browserVersion = cookieMap.get("x-apm-brtm-bt-pv")) == null || !browserVersion.trim().equals("-1")) {
            result.put("x-apm-brtm-bt-pv", browserVersion);
        }
        if ((url = cookieMap.get("url")) != null) {
            BTThreadLocalAdministrator.getInstance().insert("url", (Object)url.trim());
        } else {
            BTThreadLocalAdministrator.getInstance().insert("url", (Object)"\\");
        }
        return result;
    }

    public IBizTrx getBRTMTrxDef(IBizTrx bizTrx, Map valueMap) {
        if (bizTrx == null) {
            return null;
        }
        String bsName = bizTrx.getBizProcessName();
        String btName = bizTrx.getBizTrxName();
        String btcName = bizTrx.getBizTrxComponentName();
        String browserType = (String)valueMap.get("p");
        if (bsName != null && btName != null && btcName != null && browserType != null && !browserType.equalsIgnoreCase(UNSUPPORTED_BROWSER_NAME)) {
            btName = String.valueOf(btName) + " via " + browserType;
            bizTrx = this.findAndCreateBizTrx(bsName, btName, btcName);
        }
        return bizTrx;
    }

    private IBizTrx findAndCreateBizTrx(String bsName, String btName, String btcName) {
        String key = bsName.concat(btName).concat(btcName);
        IBizTrx btTrxDef = null;
        if (this.fEbtsMap != null) {
            int count;
            if (this.fEbtsMap.containsKey(key)) {
                btTrxDef = (IBizTrx)this.fEbtsMap.get(key);
                return btTrxDef;
            }
            if (sExternalBizDefCounter.peek() >= fMaxEbtLimit) {
                return null;
            }
            int countKey = sExternalBizDefKeyCounter.next();
            if (this.fEbtsKeyMap.putIfAbsent(key, countKey) == null && (count = sExternalBizDefCounter.next()) <= fMaxEbtLimit) {
                Long id = 14988542509842432L + (long)count;
                BizTrxDef bizTrx = new BizTrxDef(id, bsName, btName, btcName, true, false);
                btTrxDef = this.fEbtsMap.putIfAbsent(key, bizTrx);
            }
            btTrxDef = (IBizTrx)this.fEbtsMap.get(key);
        }
        return btTrxDef;
    }

    public boolean checkExternalEnabled(Map<String, String> valueMap) {
        return valueMap != null && !valueMap.get("bs").toString().trim().equals("-1") && !valueMap.get("bt").toString().trim().equals("-1");
    }

    public Boolean checkEbtHeader(Map<String, String> valueMap, Boolean processEbtFlag) {
        if (!processEbtFlag.booleanValue()) {
            return processEbtFlag;
        }
        if (fMaxErrorMessageCountPerDurationTime == sErrorMessageCounter) {
            this.fFeedback.warn(kModule, "External Business Transaction header errors are no longer being written into the log file. Too many errors have been caught in a certain period of time. See more details in debug mode.");
            ++sErrorMessageCounter;
        }
        if (!valueMap.containsKey("bt-name")) {
            this.logHeaderWarning("Ignoring External Business Transaction because the header does not contain a 'bt-name' field.", "[ header = " + valueMap + "]");
            return false;
        }
        if (valueMap.toString().length() > fMaxEbtHeaderSize * 1024) {
            this.logHeaderWarning("Ignoring External Business Transaction because the size of the header parameter x-apm-bt is too big. [ header size = " + valueMap.toString().length() + " B ] where the maximum limitation is " + fMaxEbtHeaderSize + " KB, see the agent property '" + "introscope.agent.external.biz.header.size.max" + "'.", null);
            return false;
        }
        if (valueMap.get("bs") == null || valueMap.get("bs").toString().indexOf("|") >= 0) {
            this.logHeaderWarning("Ignoring External Business Transaction because the header does not contain a 'bs' field or its format is incorrect.", "[ header = " + valueMap + "]");
            return false;
        }
        if (valueMap.get("bt") == null || valueMap.get("bt").toString().indexOf("|") >= 0) {
            this.logHeaderWarning("Ignoring External Business Transaction because the header does not contain a 'bt' field or its format is incorrect.", "[ header = " + valueMap + "]");
            return false;
        }
        String btname = this.getEbtBTname(valueMap);
        if (btname == null) {
            return false;
        }
        String btMetricPath = valueMap.get("bs") + "|" + btname + "|" + sBTCName;
        if (btMetricPath.length() > 200) {
            this.logHeaderWarning("Ignoring External Business Transaction because the business identifying segment is too long.", "[ header = " + valueMap + "]");
            return false;
        }
        return true;
    }

    private void logHeaderWarning(String message, String debugMessage) {
        if (sErrorMessageCounter < fMaxErrorMessageCountPerDurationTime) {
            this.fFeedback.warn(message);
            ++sErrorMessageCounter;
        } else if (this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug(message);
        }
        if (debugMessage != null && this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug(debugMessage);
        }
        ++sExternalIgnoredBizRequestCounter;
    }

    private IBizTrx createEbtTrxDef(Map valueMap, boolean isDownstream) {
        String metricHeaderKey = (String)valueMap.get("bt-name");
        if (isDownstream) {
            metricHeaderKey = String.valueOf(metricHeaderKey) + "DS";
        }
        IBizTrx btTrxDef = null;
        if (this.fEbtsMap != null) {
            int count;
            if (this.fEbtsMap.containsKey(metricHeaderKey)) {
                btTrxDef = (IBizTrx)this.fEbtsMap.get(metricHeaderKey);
                return btTrxDef;
            }
            if (sExternalBizDefCounter.peek() >= fMaxEbtLimit) {
                return null;
            }
            int countKey = sExternalBizDefKeyCounter.next();
            if (this.fEbtsKeyMap.putIfAbsent(metricHeaderKey, countKey) == null && (count = sExternalBizDefCounter.next()) <= fMaxEbtLimit) {
                Long id = 14988542509842432L + (long)count;
                String btName = this.getEbtBTname(valueMap);
                String bsName = (String)valueMap.get("bs");
                BizTrxDef bt = new BizTrxDef(id, bsName, btName, sBTCName, true, false, isDownstream);
                btTrxDef = this.fEbtsMap.putIfAbsent(metricHeaderKey, bt);
            }
            btTrxDef = (IBizTrx)this.fEbtsMap.get(metricHeaderKey);
        }
        return btTrxDef;
    }

    public String getEbtBTname(Map valueMap) {
        return this.getEbtBTnameWithPlatform(valueMap);
    }

    public String getEbtBTnameWithPlatform(Map valueMap) {
        String name = null;
        StringBuilder result = new StringBuilder();
        String metricHeader = (String)valueMap.get("bt-name");
        if (this.fBTMetricHeaderMap.containsKey(metricHeader)) {
            name = (String)this.fBTMetricHeaderMap.get(metricHeader);
        } else {
            String osName;
            if (sExternalBizDefCounter.peek() >= fMaxEbtLimit) {
                if (!fMaxEbtErrorNoticed) {
                    this.fFeedback.warn(kModule, "Hit the maximum number of External Business Transactions, unable to create a new External Business Transaction, the maximum number = [" + fMaxEbtLimit + "], see the agent property '" + "introscope.agent.external.biz.bt.count.max" + "'.");
                    fMaxEbtErrorNoticed = true;
                }
                return null;
            }
            result = result.append(valueMap.get("bt"));
            if (valueMap.get("p") != null && !"".equals(osName = ((String)valueMap.get("p")).trim())) {
                String osVersion;
                result = result.append(" via ").append(osName);
                if (valueMap.get("pv") != null && !"".equals(osVersion = ((String)valueMap.get("pv")).trim())) {
                    if (osVersion.contains(".") && osVersion.indexOf(".") > 0) {
                        result = result.append(" ").append(osVersion.substring(0, osVersion.indexOf(".")));
                    } else if (!osVersion.contains(".") || osVersion.indexOf(".") != 0) {
                        result = result.append(" ").append(osVersion);
                    }
                }
            }
            name = result.toString();
            this.fBTMetricHeaderMap.put(metricHeader, name);
        }
        return name;
    }

    private void resetEBT() {
        if (!this.fEbtsMap.isEmpty()) {
            for (Object biz : this.fEbtsMap.values()) {
                WilyTransactionStructure.getInstance().ageBizTrxDataImmediately(((IBizTrx)biz).getId());
            }
        }
        this.fEbtsMap.clear();
        this.fEbtsKeyMap.clear();
        sExternalBizDefCounter.reset();
        sExternalBizDefKeyCounter.reset();
        sExternalIgnoredBizRequestCounter = 0;
        sErrorMessageCounter = 0;
    }

    public boolean isExternalbtFeatureOn() {
        return fEbtFeatureOn;
    }

    public boolean isFirstFrontendFeatureOn() {
        return fFirstFrontendFeatureOn;
    }

    public boolean isCrossProcessBTFeatureOn() {
        return fCrossProcessBTFeatureOn;
    }

    public boolean isBRTMFeatureOn() {
        return BTThreadLocalAdministrator.getInstance().isAutoInjectionEnabled() || BTThreadLocalAdministrator.getInstance().isResponseDecorationEnabled() != false;
    }

    public void addEbtProperties(Map valueMap, InvocationData data) {
        if (valueMap.get("n") != null) {
            data.put("x-apm-bt.Carrier", (Object)valueMap.get("n").toString());
        }
        if (valueMap.get("g") != null) {
            data.put("x-apm-bt.Location", (Object)valueMap.get("g").toString());
        }
        if (valueMap.get("ts") != null) {
            data.put("x-apm-bt.Timestamp", (Object)valueMap.get("ts").toString());
        }
        if (valueMap.get("d") != null) {
            data.put("x-apm-bt.Device", (Object)valueMap.get("d").toString());
        }
        if (valueMap.get("l") != null) {
            data.put("x-apm-bt.Connection", (Object)valueMap.get("l").toString());
        }
        if (valueMap.get("v") != null) {
            data.put("x-apm-bt.Identifier Version", (Object)valueMap.get("v").toString());
        }
        if (valueMap.get("t") != null) {
            data.put("x-apm-bt.Tenant", (Object)valueMap.get("t").toString());
        }
        if (valueMap.get("a") != null) {
            data.put("x-apm-bt.Application Name", (Object)valueMap.get("a").toString());
        }
        if (valueMap.get("p") != null) {
            if (valueMap.get("pv") != null) {
                data.put("x-apm-bt.OS Version", (Object)(String.valueOf(valueMap.get("p").toString()) + "/" + valueMap.get("pv").toString()));
            } else {
                data.put("x-apm-bt.OS Version", (Object)valueMap.get("p").toString());
            }
        }
    }

    public IBizTrx createFrontendBusinessTransaction(String frontend) {
        IBizTrx bt = this.fFrontendBizDefMap.get(frontend);
        if (bt != null) {
            return bt;
        }
        String btname = null;
        String bsname = null;
        String appname = null;
        Matcher m = frontendPattern.matcher(frontend);
        if (m.lookingAt() && m.groupCount() == 2) {
            bsname = appname = m.group(1);
            btname = m.group(2);
        }
        if (btname == null) {
            btname = frontend.replace("|", "-");
        }
        if (appname == null) {
            bsname = appname = ApplicationNameInfo.resolveApplicationName((String)"unknown");
        }
        bt = new BizTrxDef(0x35500000000000L + (long)sFrontendBizDefCounter.next(), bsname, btname, sBTCName, true, false);
        this.fFrontendBizDefMap.put(frontend, bt);
        return bt;
    }

    public String buildDownstreamEbtHeader(IBizTrx bt, InvocationData data) {
        String btname = bt.getBizTrxName();
        String bsname = bt.getBizProcessName();
        String appname = bt.getBizProcessName();
        StringBuilder sb = new StringBuilder();
        sb.append("ts").append("=").append(Long.toString(data.getWallClockStartTime())).append(";");
        sb.append("a").append("=").append(appname).append("$");
        sb.append("bs").append("=").append(bsname).append(";");
        sb.append("bt").append("=").append(btname);
        return sb.toString();
    }

    public void startMetricsReporting() {
        this.fEBTSupportMetricBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                DataAccumulatorFactory daf1 = ExternalBizDefAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory();
                daf1.safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(sSustainabilityBaseMetricName) + ":Number of External Business Transactions").IIntegerCounterDataAccumulator_setValue(ExternalBizDefAdministrator.this.fEbtsMap.size());
                DataAccumulatorFactory daf2 = ExternalBizDefAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory();
                daf2.safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(sSustainabilityBaseMetricName) + ":Number of Ignored External Business Transactions").IIntegerCounterDataAccumulator_setValue(sExternalIgnoredBizRequestCounter);
            }
        }, "ExternalBizDefBT", true, (long)metricPollingDelay, false);
    }

    public void stopMetricsReporting() {
        if (this.fEBTSupportMetricBehavior != null) {
            DataAccumulatorFactory daf1 = this.fAgent.IAgent_getDataAccumulatorFactory();
            daf1.safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(sSustainabilityBaseMetricName) + ":Number of External Business Transactions").IIntegerCounterDataAccumulator_setValue(this.fEbtsMap.size());
            DataAccumulatorFactory daf2 = this.fAgent.IAgent_getDataAccumulatorFactory();
            daf2.safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(sSustainabilityBaseMetricName) + ":Number of Ignored External Business Transactions").IIntegerCounterDataAccumulator_setValue(sExternalIgnoredBizRequestCounter);
            this.fAgent.IAgent_getCommonHeartbeat().removeBehavior(this.fEBTSupportMetricBehavior);
        }
    }

    public void startResetErrorMessageCounter() {
        this.fEBTResetErrorMessageCounterBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                sErrorMessageCounter = 0;
            }
        }, "ExternalBizErrorMessageReset", true, (long)(fErrorMessageResetTimeInSeconds * 1000), false);
    }

    public void stopResetErrorMessageCounter() {
        if (this.fEBTResetErrorMessageCounterBehavior != null) {
            this.fAgent.IAgent_getCommonHeartbeat().removeBehavior(this.fEBTResetErrorMessageCounterBehavior);
        }
    }

    public static Map<String, String> metricsExtractor(Map postParamMap) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        String metricString = null;
        if (postParamMap != null) {
            int count = Integer.parseInt((String)postParamMap.get("bCount"));
            int i = 0;
            while (i < count) {
                String postParam = (String)postParamMap.get("b" + String.valueOf(i));
                int index = postParam.indexOf("$");
                if (index >= 0) {
                    metricString = postParam.substring(index + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(metricString, ";");
                    while (stringTokenizer.hasMoreElements()) {
                        String metric = (String)stringTokenizer.nextElement();
                        int positionEqual = metric.indexOf("=");
                        if (positionEqual <= 0) continue;
                        valueMap.put(metric.substring(0, positionEqual), metric.substring(positionEqual + 1));
                    }
                }
                ++i;
            }
        }
        return valueMap;
    }

    final class CrossProcessBTFeatureOnProperty
    extends BooleanConfigurationProperty {
        private CrossProcessBTFeatureOnProperty(IAgent agent) {
            super(ExternalBizDefAdministrator.kCrossProcessBTFeatureOnParam, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fCrossProcessBTFeatureOn = (Boolean)newValue;
        }
    }

    final class EbtFeatureOnProperty
    extends BooleanConfigurationProperty {
        private EbtFeatureOnProperty(IAgent agent) {
            super("introscope.agent.external.biz.enabled", Boolean.FALSE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fEbtFeatureOn = (Boolean)newValue;
            ExternalBizDefAdministrator.this.resetEBT();
            if (fEbtFeatureOn) {
                ExternalBizDefAdministrator.this.startMetricsReporting();
                ExternalBizDefAdministrator.this.startResetErrorMessageCounter();
            } else {
                ExternalBizDefAdministrator.this.stopMetricsReporting();
                ExternalBizDefAdministrator.this.stopResetErrorMessageCounter();
            }
        }
    }

    final class FirstFrontendFeatureOnProperty
    extends BooleanConfigurationProperty {
        private FirstFrontendFeatureOnProperty(IAgent agent) {
            super(ExternalBizDefAdministrator.kFirstFrontendBTFeatureOnParam, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            boolean newState = (Boolean)newValue;
            boolean turnOn = newState && !fFirstFrontendFeatureOn;
            boolean turnOff = !newState && fFirstFrontendFeatureOn;
            fFirstFrontendFeatureOn = newState;
            if (turnOff) {
                WilyTransactionStructure.getInstance().ageAllImmediately();
                ExternalBizDefAdministrator.this.fFrontendBizDefMap.clear();
            }
            if (turnOn) {
                WilyTransactionStructure.getInstance().ageAllImmediately();
            }
        }
    }

    static final class MaxEbtErrorMessageParamProperty
    extends IntegerConfigurationProperty {
        private MaxEbtErrorMessageParamProperty(IAgent agent) {
            super(ExternalBizDefAdministrator.kErrorMessageCountPerDurationTimeProp, Integer.valueOf(20), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fMaxErrorMessageCountPerDurationTime = (Integer)newValue;
            sErrorMessageCounter = 0;
        }
    }

    static final class MaxEbtHeaderSizeParamProperty
    extends IntegerConfigurationProperty {
        private MaxEbtHeaderSizeParamProperty(IAgent agent) {
            super("introscope.agent.external.biz.header.size.max", Integer.valueOf(10), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fMaxEbtHeaderSize = (Integer)newValue;
        }
    }

    final class MaxEbtSizeParamProperty
    extends IntegerConfigurationProperty {
        private MaxEbtSizeParamProperty(IAgent agent) {
            super("introscope.agent.external.biz.bt.count.max", Integer.valueOf(1000), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fMaxEbtLimit = (Integer)newValue;
            ExternalBizDefAdministrator.this.resetEBT();
        }
    }

    final class ResetErrorMessageParamProperty
    extends IntegerConfigurationProperty {
        private ResetErrorMessageParamProperty(IAgent agent) {
            super(ExternalBizDefAdministrator.kErrorMessageResetTimeInSecondsProp, Integer.valueOf(3600), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fErrorMessageResetTimeInSeconds = (Integer)newValue;
            sErrorMessageCounter = 0;
            ExternalBizDefAdministrator.this.stopResetErrorMessageCounter();
            ExternalBizDefAdministrator.this.startResetErrorMessageCounter();
        }
    }
}

