/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizdef.BizDefAdministrator;
import com.wily.introscope.agent.external.biz.trace.BtBaseTracer;
import com.wily.introscope.agent.external.biz.util.MutableInteger;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;

public class BtElapsedTimeTracer
extends BtBaseTracer {
    private static ThreadLocal<MutableInteger> stackDepthLocal = new ThreadLocal<MutableInteger>(){

        @Override
        public MutableInteger initialValue() {
            return new MutableInteger(0);
        }
    };

    public BtElapsedTimeTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected MutableInteger getStackDepth() {
        return stackDepthLocal.get();
    }

    private void updateElapsedTimeMetric(InvocationData data) {
        StringBuilder sb;
        long timeStamp = -1L;
        String timestampString = (String)data.get("x-apm-bt.Timestamp");
        if (timestampString != null) {
            try {
                timeStamp = Long.parseLong(timestampString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (timeStamp > 0L && (sb = BizDefAdministrator.createBtMetricBuilder(data)) != null) {
            int elapsedTime = (int)(System.currentTimeMillis() - timeStamp);
            sb.append(this.getFormattedName());
            IIntegerAverageDataAccumulator counter = this.dataAccumulatorfactory.safeGetBizTrxIntegerAverageDataAccumulator(sb.toString());
            counter.IIntegerAggregatingDataAccumulator_recordDataPoint(elapsedTime);
        }
    }

    @Override
    protected void updateBtMetricAtStart(InvocationData data) {
        this.updateElapsedTimeMetric(data);
    }

    @Override
    protected void updateBtMetricAtFinish(InvocationData data) {
    }
}

