/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agentmgr.common;

import com.ca.apm.agentmgr.common.AgentMgrPropertyNotificationConnector;
import com.ca.apm.agentmgr.common.AgentMrgPropertyCallback;
import com.ca.apm.agentmgr.common.IAgentMgrPropertyListener;
import com.ca.apm.agentmgr.common.IAgentMgrPropertyNotification;
import com.ca.apm.agentmgr.core.result.PropertyAgentMgrResult;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.callback.CallbackConnector;
import com.wily.isengard.messageprimitives.callback.ICallbackConnectorCloseNotification;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AgentMgrPropertyListener
implements IAgentMgrPropertyListener {
    private final PostOffice fPostOffice;
    private final IModuleFeedbackChannel kLog;
    private final Module kModule;
    private final Map kPropertyChangeCallbackConnectors;

    public AgentMgrPropertyListener(IModuleFeedbackChannel log, Module module, PostOffice po) throws IllegalArgumentException {
        if (log == null || module == null) {
            throw new IllegalArgumentException();
        }
        this.kLog = log;
        this.kModule = module;
        this.fPostOffice = po;
        this.kPropertyChangeCallbackConnectors = new ConcurrentHashMap();
    }

    protected void onTeardown() {
    }

    protected void teardown(CallbackConnector connector) {
        this.onTeardown();
        for (Map.Entry currVal : this.kPropertyChangeCallbackConnectors.entrySet()) {
            CopyOnWriteArrayList list = (CopyOnWriteArrayList)currVal.getValue();
            for (AgentMgrPropertyNotificationConnector connectorIterator : list) {
                if (!connectorIterator.equals(connector)) continue;
                list.remove(connectorIterator);
                if (list.isEmpty()) {
                    this.kPropertyChangeCallbackConnectors.remove(currVal.getKey());
                    continue;
                }
                this.kPropertyChangeCallbackConnectors.put(currVal.getKey(), list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForPropertyChangeUpdates(String regKey, AgentMrgPropertyCallback callback) throws ConnectionException {
        AgentMgrPropertyNotificationConnector callbackConnector = null;
        if (callback != null) {
            ICallbackConnectorCloseNotification closeNotification = new ICallbackConnectorCloseNotification(){

                @Override
                public void closing(CallbackConnector connector) {
                    AgentMgrPropertyListener.this.teardown(connector);
                }
            };
            try {
                callbackConnector = new AgentMgrPropertyNotificationConnector(this.fPostOffice, callback, closeNotification);
            }
            catch (EndpointNotFoundException e) {
                this.kLog.error("Could not create connector", e);
            }
            if (callbackConnector != null) {
                Map map = this.kPropertyChangeCallbackConnectors;
                synchronized (map) {
                    if (this.kPropertyChangeCallbackConnectors.containsKey(regKey)) {
                        CopyOnWriteArrayList connectorList = (CopyOnWriteArrayList)this.kPropertyChangeCallbackConnectors.get(regKey);
                        connectorList.add(callbackConnector);
                        this.kPropertyChangeCallbackConnectors.put(regKey, connectorList);
                    } else {
                        CopyOnWriteArrayList<AgentMgrPropertyNotificationConnector> connectorList = new CopyOnWriteArrayList<AgentMgrPropertyNotificationConnector>();
                        connectorList.add(callbackConnector);
                        this.kPropertyChangeCallbackConnectors.put(regKey, connectorList);
                    }
                }
            }
        }
    }

    @Override
    public void notify(String regKey, PropertyAgentMgrResult result) {
        if (this.kPropertyChangeCallbackConnectors.containsKey(regKey)) {
            CopyOnWriteArrayList connectorList = (CopyOnWriteArrayList)this.kPropertyChangeCallbackConnectors.get(regKey);
            for (AgentMgrPropertyNotificationConnector connectorTemp : connectorList) {
                IAgentMgrPropertyNotification notification = this.getNotificationConnectorInterface(connectorTemp);
                if (notification == null) continue;
                if (result != null && this.kLog.isDebugEnabled(this.kModule)) {
                    this.kLog.debug(this.kModule, "Delivering result with error status " + result.getErrorStatus());
                }
                try {
                    notification.deliverPropertyResult(result);
                }
                catch (ConnectionException connectionException) {
                    this.teardown(connectorTemp);
                }
            }
        }
    }

    public void teardownListener() {
        for (Map.Entry currVal : this.kPropertyChangeCallbackConnectors.entrySet()) {
            CopyOnWriteArrayList list = (CopyOnWriteArrayList)currVal.getValue();
            list.clear();
            this.kPropertyChangeCallbackConnectors.remove(currVal.getKey());
        }
        this.kPropertyChangeCallbackConnectors.clear();
    }

    private IAgentMgrPropertyNotification getNotificationConnectorInterface(AgentMgrPropertyNotificationConnector connector) {
        return (IAgentMgrPropertyNotification)connector.getInterface();
    }

    public static String generateHashKey(String agentName, String propertyName) {
        if (propertyName == null) {
            return agentName;
        }
        return String.valueOf(agentName) + "_" + propertyName;
    }
}

