/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter.sampling;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.sampling.BaseStatisticalSampler;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

public class FastestNSlowestNStatisticalSampler
extends BaseStatisticalSampler {
    private final boolean fastestN;

    public FastestNSlowestNStatisticalSampler(boolean fastestN) {
        this.fastestN = fastestN;
    }

    @Override
    protected long appraise(ISamplingInput input) {
        return this.fastestN ? -input.duration() : input.duration();
    }

    @Override
    public String name() {
        return this.fastestN ? "fastestn" : "slowestn";
    }

    @Override
    public void configure(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        final String propertyName = this.fastestN ? "introscope.agent.transactiontracer.sampling.fastestn.perinterval.count" : "introscope.agent.transactiontracer.sampling.slowestn.perinterval.count";
        configManager.add(new PositiveIntegerConfigurationProperty(propertyName, this.fastestN ? 2 : 5, null, null, true, false, feedback, kSamplingModule, localizer){

            @Override
            public void set(Object value) {
                FastestNSlowestNStatisticalSampler.this.updateSamplesCountPerInterval((Integer)value);
            }

            @Override
            public boolean validate(Object value) {
                if (!super.validate(value)) {
                    return false;
                }
                if (value != null && (Integer)value > 50) {
                    throw new IllegalArgumentException(String.valueOf(propertyName) + " property value " + value + " exceeds maximum allowed " + 50 + " and is ignored");
                }
                return true;
            }
        });
        configManager.add(new PositiveIntegerConfigurationProperty(this.fastestN ? "introscope.agent.transactiontracer.sampling.fastestn.interval.seconds" : "introscope.agent.transactiontracer.sampling.slowestn.interval.seconds", 60, null, null, true, false, feedback, kSamplingModule, localizer){

            @Override
            public void set(Object value) {
                FastestNSlowestNStatisticalSampler.this.updateSamplingDuration((Integer)value);
            }
        });
        super.configure(agent);
    }
}

