/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.util.concurrent.atomic.AtomicInteger;

public class DownstreamTransactionHarvester {
    private HighPerformanceTransactionCache highPerformanceCache = HighPerformanceTransactionCache.getInstance();
    private boolean shouldAbort = false;

    public void setAbort(boolean flag) {
        this.shouldAbort = flag;
    }

    public int sendTrace(String transactionGUID) {
        return this.createAndSendTCD(transactionGUID);
    }

    private int createAndSendTCD(final String transactionGUID) {
        Iterable<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> transientDeepStacks = this.highPerformanceCache.getTransientForTransactionTrace(transactionGUID);
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] deepStacks = this.highPerformanceCache.getForTransactionTrace(transactionGUID);
        if (deepStacks == null && transientDeepStacks == null) {
            SustainabilityMetricsHelper.reportNumberOfTracesMissedInCacheMetric(1);
            return 0;
        }
        final AtomicInteger tcdsCount = new AtomicInteger();
        IntelligentTransactionHarvesterHelper.TCDPreSendCallback beforeSendingCallback = new IntelligentTransactionHarvesterHelper.TCDPreSendCallback(){

            @Override
            public TransactionComponentData beforeSending(TransactionComponentData tcd) {
                if (CrossProcessLogger.isDebugEnabled()) {
                    CrossProcessLogger.logDebugMessage("Downstream agent sent the TT for: " + transactionGUID);
                }
                tcd.setParameterValue("Trace Type", "Normal");
                tcd.setParameterValue("Trace Reason", "Autotrace");
                tcd.setParameterValue("Autotrace Trigger Criteria", "Cross Process Trigger");
                SustainabilityMetricsHelper.reportNumberOfTracesFromCacheMetric(1);
                tcdsCount.incrementAndGet();
                return tcd;
            }
        };
        boolean success = false;
        if (deepStacks != null) {
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] highPerformanceIntelligenceStackElementVirtualStackArray = deepStacks;
            int n = deepStacks.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = highPerformanceIntelligenceStackElementVirtualStackArray[n2];
                    if (this.shouldAbort) {
                        return tcdsCount.get();
                    }
                    try {
                        try {
                            success = IntelligentTransactionHarvesterHelper.harvestFromHpTracerWithNormalTcdMap(deepStack, deepStack.sIntelligentThreadLocalObject.fTopTCDElements, beforeSendingCallback);
                        }
                        catch (Exception e) {
                            if (CrossProcessLogger.isDebugEnabled()) {
                                CrossProcessLogger.logDebugMessage("Transaction trace from cache had a failure for: " + transactionGUID, e);
                            }
                            this.highPerformanceCache.removeFromGuidCache(deepStack);
                            deepStack.reinit();
                            deepStack.trySetInUse(false);
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        this.highPerformanceCache.removeFromGuidCache(deepStack);
                        deepStack.reinit();
                        deepStack.trySetInUse(false);
                        throw throwable;
                    }
                    this.highPerformanceCache.removeFromGuidCache(deepStack);
                    deepStack.reinit();
                    deepStack.trySetInUse(false);
                }
                ++n2;
            }
        }
        if (transientDeepStacks != null) {
            for (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack : transientDeepStacks) {
                if (this.shouldAbort) {
                    return tcdsCount.get();
                }
                try {
                    success = IntelligentTransactionHarvesterHelper.harvestFromHpTracerWithNormalTcdMap(deepStack, deepStack.sIntelligentThreadLocalObject.fTopTCDElements, beforeSendingCallback);
                }
                catch (Exception e) {
                    if (!CrossProcessLogger.isDebugEnabled()) continue;
                    CrossProcessLogger.logDebugMessage("Transaction trace from cache had a failure for: " + transactionGUID, e);
                }
            }
        }
        if (success) {
            this.highPerformanceCache.addUpstreamGUID(transactionGUID);
        }
        return tcdsCount.get();
    }

    public boolean hasBeenAborted() {
        return this.shouldAbort;
    }
}

