/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.io.SocketFormatterCache;
import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SocketFormatMetricsCache {
    public static final int kInputStream = 8;
    public static final int kOutputStream = 7;
    public static final int kConcurrentWriters = 6;
    public static final int kConcurrentReaders = 5;
    public static final int kCloseCounter = 4;
    public static final int kAcceptCounter = 3;
    public static final int kConnectCounter = 2;
    public static final int kBackendTracer = 9;
    public static final int kCacheOnAllocate = 0;
    public static final int kCacheOnFinish = 1;
    public static final int kAppMapComponent = 10;
    private static final int kNumberOfMetricsCached = 11;
    private final String[] fFormattedMetrics;
    private final IDataAccumulator[] fAccumulators;
    private final int fPort;
    private final String fHostName;
    private final String fHostAddress;
    private final String fLocalAddress;
    private String fResourceName;
    private boolean fIsClientConnection;
    private AtomicInteger fInputStream = new AtomicInteger();
    private AtomicInteger fOutputStream = new AtomicInteger();
    private AtomicInteger fConcurrentWriters = new AtomicInteger();
    private AtomicInteger fConcurrentReaders = new AtomicInteger();
    private AtomicLong fCloseCounter = new AtomicLong();
    private AtomicLong fAcceptCounter = new AtomicLong();
    private AtomicLong fConnectCounter = new AtomicLong();
    private volatile boolean fInputStreamTouched = false;
    private volatile boolean fOutputStreamTouched = false;
    private volatile boolean fConcurrentWritersTouched = false;
    private volatile boolean fConcurrentReadersTouched = false;
    private volatile boolean fCloseCounterTouched = false;
    private volatile boolean fAcceptCounterTouched = false;
    private volatile boolean fConnectCounterTouched = false;

    public SocketFormatMetricsCache(String localAddress, String hostName, String hostAddress, int port) {
        this.fHostName = hostName;
        this.fHostAddress = hostAddress;
        this.fLocalAddress = localAddress;
        this.fPort = port;
        this.fFormattedMetrics = new String[11];
        this.fAccumulators = new IDataAccumulator[11];
        this.fInputStreamTouched = false;
        this.fOutputStreamTouched = false;
        this.fConcurrentWritersTouched = false;
        this.fConcurrentReadersTouched = false;
        this.fCloseCounterTouched = false;
        this.fAcceptCounterTouched = false;
        this.fConnectCounterTouched = false;
    }

    public SocketFormatMetricsCache(SocketFormatMetricsCache cache) {
        this.fHostName = cache.fHostName;
        this.fHostAddress = cache.fHostAddress;
        this.fLocalAddress = cache.fLocalAddress;
        this.fPort = cache.fPort;
        this.fFormattedMetrics = cache.fFormattedMetrics;
        this.fAccumulators = cache.fAccumulators;
        this.fInputStreamTouched = cache.fInputStreamTouched;
        this.fOutputStreamTouched = cache.fOutputStreamTouched;
        this.fConcurrentWritersTouched = cache.fConcurrentWritersTouched;
        this.fConcurrentReadersTouched = cache.fConcurrentReadersTouched;
        this.fCloseCounterTouched = cache.fCloseCounterTouched;
        this.fAcceptCounterTouched = cache.fAcceptCounterTouched;
        this.fConnectCounterTouched = cache.fConnectCounterTouched;
        this.fInputStream = new AtomicInteger(cache.fInputStream.getAndSet(0));
        this.fOutputStream = new AtomicInteger(cache.fOutputStream.getAndSet(0));
        this.fConcurrentWriters = new AtomicInteger(cache.fConcurrentWriters.getAndSet(0));
        this.fConcurrentReaders = new AtomicInteger(cache.fConcurrentReaders.getAndSet(0));
        this.fCloseCounter = new AtomicLong(cache.fCloseCounter.getAndSet(0L));
        this.fAcceptCounter = new AtomicLong(cache.fAcceptCounter.getAndSet(0L));
        this.fConnectCounter = new AtomicLong(cache.fConnectCounter.getAndSet(0L));
        this.fResourceName = cache.fResourceName;
        this.fIsClientConnection = cache.fIsClientConnection;
    }

    public final String getFormattedMetrics(int position) {
        return this.fFormattedMetrics[position];
    }

    public final void setFormattedMetrics(String value, int position) {
        this.fFormattedMetrics[position] = value;
    }

    public final IDataAccumulator getAccumulators(int position) {
        return this.fAccumulators[position];
    }

    public final void setAccumulators(IDataAccumulator value, int position) {
        this.fAccumulators[position] = value;
    }

    public final int getPort() {
        return this.fPort;
    }

    public final String getHostName() {
        return this.fHostName;
    }

    public final String getHostAddress() {
        return this.fHostAddress;
    }

    public final String getLocalAddress() {
        return this.fLocalAddress;
    }

    public final void setResourceName(String fResourceName) {
        this.fResourceName = fResourceName;
    }

    public final String getResourceName() {
        return this.fResourceName;
    }

    public final void setClientConnection(boolean isClientConnection) {
        this.fIsClientConnection = isClientConnection;
    }

    public final boolean isClientConnection() {
        return this.fIsClientConnection;
    }

    public final void setInputBandwidth(int value) {
        this.fInputStream.set(value);
        this.fInputStreamTouched = true;
    }

    public final void addToInputBandwidth(int value) {
        this.fInputStream.addAndGet(value);
        this.fInputStreamTouched = true;
    }

    public final void setOutputBandwidth(int value) {
        this.fOutputStream.set(value);
        this.fOutputStreamTouched = true;
    }

    public final void addToOutputBandwidth(int value) {
        this.fOutputStream.addAndGet(value);
        this.fOutputStreamTouched = true;
    }

    public final void addToCloseCounter() {
        this.fCloseCounter.incrementAndGet();
        this.fCloseCounterTouched = true;
    }

    public final void addToAcceptCounter() {
        this.fAcceptCounter.incrementAndGet();
        this.fAcceptCounterTouched = true;
    }

    public final void addToConnectCounter() {
        this.fConnectCounter.incrementAndGet();
        this.fConnectCounterTouched = true;
    }

    public final void addToConcurrentWriters() {
        this.fConcurrentWriters.incrementAndGet();
        this.fConcurrentWritersTouched = true;
    }

    public final void removeFromConcurrentWriters() {
        this.fConcurrentWriters.decrementAndGet();
        this.fConcurrentWritersTouched = true;
    }

    public final void touchConcurrentReadersandWriters() {
        this.fConcurrentReadersTouched = true;
        this.fConcurrentWritersTouched = true;
    }

    public final void addToConcurrentReaders() {
        this.fConcurrentReaders.incrementAndGet();
        this.fConcurrentReadersTouched = true;
    }

    public final void removeFromConcurrentReaders() {
        this.fConcurrentReaders.decrementAndGet();
        this.fConcurrentReadersTouched = true;
    }

    protected final DataAccumulatorFactory getDataAccumulatorFactory() throws AgentNotAvailableException {
        return AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
    }

    public final IDataAccumulator checkAccumulator(int position, boolean touched) {
        IDataAccumulator acc = null;
        if (touched && (acc = this.fAccumulators[position]) != null && acc.isRemoved()) {
            try {
                switch (position) {
                    case 5: 
                    case 6: {
                        acc = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.getFormattedMetrics(position));
                        break;
                    }
                    case 7: 
                    case 8: {
                        acc = this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(this.getFormattedMetrics(position));
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        acc = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(this.getFormattedMetrics(position));
                    }
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                acc = null;
            }
        }
        return acc;
    }

    public final void pollConcurrentMetrics() {
        IDataAccumulator acc = this.checkAccumulator(6, this.fConcurrentWritersTouched);
        if (acc != null) {
            ((IIntegerFluctuatingCounterDataAccumulator)acc).IIntegerCounterDataAccumulator_setValue(this.fConcurrentWriters.get());
        }
        if ((acc = this.checkAccumulator(5, this.fConcurrentReadersTouched)) != null) {
            ((IIntegerFluctuatingCounterDataAccumulator)acc).IIntegerCounterDataAccumulator_setValue(this.fConcurrentReaders.get());
        }
        if ((acc = this.checkAccumulator(8, this.fInputStreamTouched)) != null) {
            ((IIntegerRateDataAccumulator)acc).IIntegerRateDataAccumulator_addBatchIncidents(this.fInputStream.getAndSet(0));
        }
        if ((acc = this.checkAccumulator(7, this.fOutputStreamTouched)) != null) {
            ((IIntegerRateDataAccumulator)acc).IIntegerRateDataAccumulator_addBatchIncidents(this.fOutputStream.getAndSet(0));
        }
        if ((acc = this.checkAccumulator(4, this.fCloseCounterTouched)) != null) {
            ((ILongIntervalCounterDataAccumulator)acc).ILongIntervalCounterDataAccumulator_addBatchIncidents(this.fCloseCounter.getAndSet(0L));
        }
        if ((acc = this.checkAccumulator(3, this.fAcceptCounterTouched)) != null) {
            ((ILongIntervalCounterDataAccumulator)acc).ILongIntervalCounterDataAccumulator_addBatchIncidents(this.fAcceptCounter.getAndSet(0L));
        }
        if ((acc = this.checkAccumulator(2, this.fConnectCounterTouched)) != null) {
            ((ILongIntervalCounterDataAccumulator)acc).ILongIntervalCounterDataAccumulator_addBatchIncidents(this.fConnectCounter.getAndSet(0L));
        }
        this.fInputStreamTouched = false;
        this.fOutputStreamTouched = false;
        this.fConcurrentWritersTouched = false;
        this.fConcurrentReadersTouched = false;
        this.fCloseCounterTouched = false;
        this.fAcceptCounterTouched = false;
        this.fConnectCounterTouched = false;
    }

    public void loopMetricPoller(boolean isWrite, boolean increaseConcurrentCount) {
        try {
            String hostName = this.getHostName();
            int port = this.getPort();
            if (!this.fIsClientConnection) {
                this.updateMetricCache(SocketFormatterCache.kServerAddressMetricCache, isWrite, increaseConcurrentCount, port);
            } else {
                ConcurrentHighPerformanceLRUHashMap<Integer, SocketFormatMetricsCache> portMap = null;
                portMap = SocketFormatterCache.kAddressMetricCache.get(hostName);
                if (portMap == null) {
                    portMap = SocketFormatterCache.getCappedCache("AddressMetricCacheL2");
                    SocketFormatMetricsCache cache = new SocketFormatMetricsCache(this);
                    this.updateConcurrentCount(cache, isWrite, increaseConcurrentCount);
                    portMap.put(port, cache);
                    ConcurrentHighPerformanceLRUHashMap<Integer, SocketFormatMetricsCache> hostPortMap = SocketFormatterCache.kAddressMetricCache.putIfAbsent(hostName, portMap);
                    if (hostPortMap != null) {
                        hostPortMap.put(port, cache);
                    }
                } else {
                    this.updateMetricCache(portMap, isWrite, increaseConcurrentCount, port);
                }
            }
        }
        catch (Exception protect) {
            protect.printStackTrace();
        }
    }

    private void updateMetricCache(Map metricCache, boolean isWrite, boolean increaseConcurrentCount, int port) {
        SocketFormatMetricsCache existingCache = (SocketFormatMetricsCache)metricCache.get(port);
        if (existingCache != null) {
            this.updateConcurrentCount(existingCache, isWrite, increaseConcurrentCount);
            if (this.fOutputStream.get() > 0) {
                existingCache.addToOutputBandwidth(this.fOutputStream.getAndSet(0));
            }
            if (this.fInputStream.get() > 0) {
                existingCache.addToInputBandwidth(this.fInputStream.getAndSet(0));
            }
            metricCache.put(port, existingCache);
        } else {
            SocketFormatMetricsCache cache = new SocketFormatMetricsCache(this);
            this.updateConcurrentCount(cache, isWrite, increaseConcurrentCount);
            metricCache.put(port, cache);
        }
    }

    private void updateConcurrentCount(SocketFormatMetricsCache cache, boolean isWrite, boolean increaseConcurrentCount) {
        cache.touchConcurrentReadersandWriters();
        if (!isWrite) {
            if (increaseConcurrentCount) {
                cache.addToConcurrentReaders();
            } else {
                cache.removeFromConcurrentReaders();
            }
        }
    }
}

