/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualElement;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.StallCheckBehaviorCorrect;
import com.wily.introscope.agent.feature.StallPoint;
import com.wily.introscope.agent.feature.VirtualStackFeatureHelper;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.IIntegerFluctuatingCounterDataAccumulatorWrapper;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IStackElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.IStallPoint;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.WeakReferenceKey;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;

public class StallFeatureBase {
    public static final AtomicLong sStallThreshold = new AtomicLong();
    public static final AtomicLong sStallResolution = new AtomicLong();
    public static final AtomicLong sTxnAbortThreshold = new AtomicLong();
    public static final AtomicLong sTxnAsyncAbortThreshold = new AtomicLong();
    private static IRegisteredBehavior sStallBehavior;
    private static boolean fIntelligentInstrumentationEnabled;
    public static final String StallThresholdKey = "introscope.agent.stalls.thresholdseconds";
    public static final int DefaultStallThresholdInSeconds = 30;
    public static final String StallResolutionKey = "introscope.agent.stalls.resolutionseconds";
    public static final int DefaultStallResolutionInSeconds = 10;
    public static final String StallEnableKey = "introscope.agent.stalls.enable";
    private static volatile boolean enableFeature;
    public static final String TxnAbortThresholdKey = "introscope.agent.stalls.transaction.untrack.thresholdseconds";
    public static final int DefaultTxnAbortThresholdInSeconds = 0;
    public static final String TxnAsyncAbortThresholdKey = "introscope.agent.stalls.asynchronous.transaction.untrack.thresholdseconds";
    public static final int DefaultTxnAsyncAbortThresholdInSeconds = 300;
    private static volatile IAgent fAgent;
    static volatile Map fInvocationDataThatReported;
    static volatile IWeakIdentityMap fStallPointsMap;

    static {
        try {
            fIntelligentInstrumentationEnabled = AgentShim.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.deep.instrumentation.enabled", true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static final boolean reportStall(IStackElement data) {
        String corid;
        if (data.isTransactionAborted()) {
            return true;
        }
        TransactionComponentData root = StallFeatureBase.getTCD(data);
        if (root == null) {
            return false;
        }
        String txid = CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot(data);
        if (txid != null) {
            root.setParameterValue("TxnTraceId", txid);
        }
        if ((corid = CrossProcessCorrelationAdmin.getCorrelationIdFromCacheForSnapshot(data)) != null) {
            root.setParameterValue("CorCrossProcessData", corid);
        }
        fAgent.IAgent_queueEvent(root);
        if (ErrorFeature.sThreadStackHelper != null) {
            ErrorFeature.sThreadStackHelper.sendThreadStackSnapshot(root.getResource(), "Stall Event", "Stalled Transaction", corid, txid, data);
        }
        return true;
    }

    private static TransactionComponentData getTCD(IStackElement data) {
        TransactionComponentData tcd = null;
        if (StallFeatureBase.isDeepSnapshotEnabled()) {
            tcd = StallFeatureBase.getMergedTCD(data);
            if (tcd == null) {
                tcd = VirtualStackFeatureHelper.getTransactionSnapshotFromStack(data, data.getMyThread(), null, "Stalled Transaction");
            }
        } else {
            tcd = VirtualStackFeatureHelper.getTransactionSnapshotFromStack(data, data.getMyThread(), null, "Stalled Transaction");
        }
        return tcd;
    }

    private static boolean isDeepSnapshotEnabled() {
        return fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepStallSnapshotEnabled && DeepTraceConfigurations.fDeepTracingEnabled;
    }

    private static TransactionComponentData getMergedTCD(IStackElement data) {
        return HighPerformanceIntelligentStackHelper.getTransactionSnapshotFromStack(data, data.getMyThread(), null, "Stalled Transaction");
    }

    public static final void checkStallAndDecrement(IStackElement data, WilyTransactionStructure structure) {
    }

    public static final boolean checkStallAndDecrement(IStackElement data, boolean isStallClampHit) {
        if (isStallClampHit || data.isStalled() && data.isFinished()) {
            long endTime = data.getWallClockFinishTime();
            StallFeatureBase.updateLastReportedStallTime(data, endTime);
            WeakReferenceKey<IStackElement> key = new WeakReferenceKey<IStackElement>(data);
            Set repositoriesUpdatedByStallChecker = (Set)fInvocationDataThatReported.get(key);
            if (repositoriesUpdatedByStallChecker != null && !repositoriesUpdatedByStallChecker.isEmpty()) {
                StallFeatureBase.decrementRepositories(repositoriesUpdatedByStallChecker, endTime, data);
            }
            data.unsetStalled();
            return true;
        }
        return false;
    }

    private static final boolean decrementAndUnset(IStackElement data) {
        if (data.isStalled()) {
            WeakReferenceKey<IStackElement> key = new WeakReferenceKey<IStackElement>(data);
            Set repositoriesUpdatedByStallChecker = (Set)fInvocationDataThatReported.get(key);
            if (repositoriesUpdatedByStallChecker != null && !repositoriesUpdatedByStallChecker.isEmpty()) {
                StallFeatureBase.decrementRepositories(repositoriesUpdatedByStallChecker, data.getWallClockFinishTime(), data);
            }
            data.unsetStalled();
            fInvocationDataThatReported.remove(key);
            return true;
        }
        return false;
    }

    public static final void decrementForGCedInvocationData(WeakReferenceKey<IStackElement> key, WilyTransactionStructure structure) {
        long endTime = System.currentTimeMillis();
        Set repositoriesUpdatedByStallChecker = (Set)fInvocationDataThatReported.get(key);
        if (repositoriesUpdatedByStallChecker != null && !repositoriesUpdatedByStallChecker.isEmpty()) {
            StallFeatureBase.decrementRepositories(repositoriesUpdatedByStallChecker, endTime, null);
        }
    }

    private static void decrementRepositories(Set repositorisUpdatedByStallChecker, long endTime, IStackElement data) {
        for (Object o : repositorisUpdatedByStallChecker) {
            if (o instanceof IIntegerFluctuatingCounterDataAccumulatorWrapper) {
                IIntegerFluctuatingCounterDataAccumulatorWrapper accumulator = (IIntegerFluctuatingCounterDataAccumulatorWrapper)o;
                BlameStackSnapshot snap = accumulator.getSnapshot();
                accumulator.getAccumulator().IIntegerFluctuatingCounterDataAccumulator_decrement(snap);
                continue;
            }
            if (!(o instanceof IRepository)) continue;
            IRepository repository = (IRepository)o;
            int hashcode = data != null ? data.hashCode() : 1;
            repository.update(UpdaterFactory.getDecreasingUpdater(), 0L, endTime, hashcode);
        }
        repositorisUpdatedByStallChecker.clear();
    }

    public static IWeakIdentityMap startStallFeature(IAgent agent) {
        fAgent = agent;
        enableFeature = fAgent.IAgent_getIndexedProperties().safeGetBooleanProperty(StallEnableKey, true, fAgent.IAgent_getModuleFeedback(), fAgent.IAgent_getStringLocalizer());
        if (!enableFeature) {
            return null;
        }
        ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
        cm.add(new StallThresholdProperty(fAgent), true);
        cm.add(new StallResolutionProperty(fAgent), true);
        cm.add(new TxnAbortThresholdProperty(agent), true);
        cm.add(new TxnAsyncAbortThresholdProperty(agent), true);
        fInvocationDataThatReported = new ConcurrentHashMap();
        fStallPointsMap = fAgent.IAgent_getConcurrentMapFactory().getConcurrentWeakIdentityMap("StalledThreads");
        sStallBehavior = fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new StallCheckBehaviorCorrect(), "High Concurrency Stall Feature", true, sStallResolution.get(), false);
        return fStallPointsMap;
    }

    public static IWeakIdentityMap getStallPoints() {
        return fStallPointsMap;
    }

    public static Set getStallPointsEntrySet() {
        return ((Map)((Object)fStallPointsMap)).entrySet();
    }

    public static final StallPoint initializeStallPoint(Runnable thread) {
        if (enableFeature) {
            IWeakIdentityMap map;
            StallPoint sp;
            if (thread == null) {
                thread = Thread.currentThread();
            }
            if ((sp = (StallPoint)(map = StallFeatureBase.getStallPoints()).getWeak(thread)) == null) {
                sp = new StallPoint();
                map.putWeak(thread, sp);
            }
            return sp;
        }
        return null;
    }

    public static final void putStallPoint(IStackElement data) {
        StallFeatureBase.putStallPoint(data.getStallPoint(), data);
    }

    public static final void putStallPoint(IStallPoint s, IStackElement data) {
        if (enableFeature) {
            IStallPoint sp = s;
            if (sp == null && (sp = data.getStallPoint()) == null) {
                sp = StallFeatureBase.getStallPoint(data);
            }
            if (sp != null) {
                sp.setInvocationData(data);
            }
            return;
        }
    }

    public static void putValidParentInStallPoint(IStackElement data) {
        IStackElement parent = data.getParent();
        IStallPoint stallPoint = data.getStallPoint();
        if ((parent = StackRecursionHelper.staticSafeRecurseAccessParent(parent, new IStackElementCallbackOnRecursion(){

            @Override
            public boolean doOnElement(IStackElement pivot) {
                if (pivot instanceof InvocationData) {
                    return true;
                }
                if (pivot instanceof VirtualElement.Dummy) {
                    return false;
                }
                if (pivot instanceof VirtualElement) {
                    return true;
                }
                return pivot instanceof WrappedInvocationData;
            }
        })) != null) {
            if (parent instanceof WrappedInvocationData) {
                InvocationData invocationData = ((WrappedInvocationData)parent).getInvocationData();
                StallFeatureBase.putStallPoint(stallPoint, invocationData);
            } else {
                StallFeatureBase.putStallPoint(stallPoint, parent);
            }
        } else {
            StallFeatureBase.removeStallPoint(stallPoint, data);
        }
    }

    private static StallPoint getStallPoint(IStackElement data) {
        Runnable myThread = null;
        if (data != null) {
            myThread = data.getMyThread();
        }
        if (myThread == null) {
            myThread = Thread.currentThread();
        }
        return (StallPoint)StallFeatureBase.getStallPoints().getWeak(myThread);
    }

    private static void updateLastReportedStallTime(IStackElement data, long timeToUpdate) {
        StallPoint stallPoint = StallFeatureBase.getStallPoint(data);
        if (stallPoint != null) {
            stallPoint.updateLastReportedStallTime(timeToUpdate);
        }
    }

    public static final boolean isComponentStalled(IStackElement data, long stallStart) {
        long timeToUseForStallCheck;
        StallPoint stallPoint = StallFeatureBase.getStallPoint(data);
        long lastReportedStallTime = 0L;
        if (stallPoint != null) {
            lastReportedStallTime = stallPoint.getLastReportedStallTime();
        }
        long componentStartedTime = data.getWallClockStartTime();
        long l = timeToUseForStallCheck = lastReportedStallTime == 0L || lastReportedStallTime < componentStartedTime ? componentStartedTime : lastReportedStallTime;
        return timeToUseForStallCheck < stallStart;
    }

    public static final void removeStallPoint(IStallPoint s, IStackElement data) {
        IStallPoint sp;
        if (enableFeature) {
            sp = s;
            if (sp == null) {
                if (data != null) {
                    sp = data.getStallPoint();
                }
                if (sp == null) {
                    sp = StallFeatureBase.getStallPoint(data);
                }
            }
            if (sp == null) {
                return;
            }
        } else {
            return;
        }
        sp.updateLastReportedStallTime(0L);
        sp.setInvocationData(null);
    }

    public static void addReportingInvocationData(IStackElement invocationData, IRepository sds) {
        WeakReferenceKey<IStackElement> key = new WeakReferenceKey<IStackElement>(invocationData);
        CopyOnWriteArraySet<IRepository> repositoriesUpdated = (CopyOnWriteArraySet<IRepository>)fInvocationDataThatReported.get(key);
        if (repositoriesUpdated == null) {
            repositoriesUpdated = new CopyOnWriteArraySet<IRepository>();
            fInvocationDataThatReported.put(key, repositoriesUpdated);
        }
        repositoriesUpdated.add(sds);
    }

    public static void addReportingInvocationData(IStackElement invocationData, IIntegerFluctuatingCounterDataAccumulatorWrapper sds) {
        WeakReferenceKey<IStackElement> key = new WeakReferenceKey<IStackElement>(invocationData);
        CopyOnWriteArraySet<IIntegerFluctuatingCounterDataAccumulatorWrapper> repositoriesUpdated = (CopyOnWriteArraySet<IIntegerFluctuatingCounterDataAccumulatorWrapper>)fInvocationDataThatReported.get(key);
        if (repositoriesUpdated == null) {
            repositoriesUpdated = new CopyOnWriteArraySet<IIntegerFluctuatingCounterDataAccumulatorWrapper>();
            fInvocationDataThatReported.put(key, repositoriesUpdated);
        }
        repositoriesUpdated.add(sds);
    }

    public static boolean hasAlreadyReported(IStackElement currentInvocationData) {
        WeakReferenceKey<IStackElement> key = new WeakReferenceKey<IStackElement>(currentInvocationData);
        return fInvocationDataThatReported.containsKey(key);
    }

    public static void checkAndDecrementStallsIfFinished() {
        WilyTransactionStructure inst = WilyTransactionStructure.getInstance();
        int size = fInvocationDataThatReported.size();
        boolean isClampHit = size > WilyTransactionStructure.fstalledInvocationDataThreshold;
        Iterator itr = fInvocationDataThatReported.keySet().iterator();
        while (itr.hasNext()) {
            WeakReferenceKey key = (WeakReferenceKey)itr.next();
            InvocationData data = (InvocationData)key.get();
            if (data != null) {
                boolean stallDecremented = StallFeatureBase.checkStallAndDecrement((IStackElement)data, isClampHit);
                if (!stallDecremented) continue;
                itr.remove();
                continue;
            }
            StallFeatureBase.decrementForGCedInvocationData(key, inst);
            itr.remove();
        }
    }

    public static void doOnTransactionAbort(IStackElement data) {
        StallFeatureBase.decrementAndUnset(data);
    }

    private static class StallResolutionProperty
    extends PositiveIntegerConfigurationProperty {
        public StallResolutionProperty(IAgent agent) {
            super(StallFeatureBase.StallResolutionKey, 10, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            long newLongValue = (Integer)newValue * 1000;
            sStallResolution.set(newLongValue);
            if (sStallBehavior != null) {
                sStallBehavior.IRegisteredBehavior_setPeriod(newLongValue);
            }
        }
    }

    private static class StallThresholdProperty
    extends PositiveIntegerConfigurationProperty {
        public StallThresholdProperty(IAgent agent) {
            super(StallFeatureBase.StallThresholdKey, 30, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            sStallThreshold.set((Integer)newValue * 1000);
        }
    }

    private static class TxnAbortThresholdProperty
    extends PositiveIntegerConfigurationProperty {
        public TxnAbortThresholdProperty(IAgent agent) {
            super(StallFeatureBase.TxnAbortThresholdKey, 0, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            sTxnAbortThreshold.set((Integer)newValue * 1000);
        }
    }

    private static class TxnAsyncAbortThresholdProperty
    extends PositiveIntegerConfigurationProperty {
        public TxnAsyncAbortThresholdProperty(IAgent agent) {
            super(StallFeatureBase.TxnAsyncAbortThresholdKey, 300, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            sTxnAsyncAbortThreshold.set((Integer)newValue * 1000);
        }
    }
}

