/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampHelper;
import com.wily.introscope.agent.trace.intelligent.CrossProcessAutoTracingConfiguration;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.DownstreamTransactionHarvester;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.QueueMapCache;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.concurrent.atomic.AtomicInteger;

public class DownStreamListenerService
implements Runnable {
    private static int tracesClampPollingDelay = 60000;
    private static boolean isClampMessagePrinted = false;
    HighPerformanceTransactionCache highPerformanceCache;
    QueueMapCache<String, Boolean> downStreamGUIDCache;
    int tracesSentSetMaxSize;
    DownstreamTransactionHarvester harvesterInstance;
    IAgent agent;
    private final AtomicInteger tracesPerIntervalCount = new AtomicInteger();

    public DownStreamListenerService(int size, IAgent agent) {
        this.agent = agent;
        this.highPerformanceCache = HighPerformanceTransactionCache.getInstance();
        this.downStreamGUIDCache = this.highPerformanceCache.getDownStreamGUIDCache();
        this.tracesSentSetMaxSize = size;
        this.harvesterInstance = new DownstreamTransactionHarvester();
        this.startCountingTracesSent();
    }

    @Override
    public void run() {
        block8: {
            try {
                if (HighPerformanceTransactionCache.getInstance().isInDiagonsticsMode()) {
                    return;
                }
                this.harvesterInstance.setAbort(false);
                int downStreamPerIntervalTracesClamp = CrossProcessAutoTracingConfiguration.getCrossProcessDownstreamClampMultiplier() * AutoTracingClampHelper.fClampLimit;
                for (String guid : this.downStreamGUIDCache.getMapEntries()) {
                    if (this.harvesterInstance.hasBeenAborted()) {
                        return;
                    }
                    if (guid == HighPerformanceTransactionCache.UPSTREAM_GUID_FILLER) continue;
                    if (this.tracesPerIntervalCount.get() >= downStreamPerIntervalTracesClamp) {
                        if (!isClampMessagePrinted && CrossProcessLogger.isDebugEnabled()) {
                            CrossProcessLogger.logDebugMessage("Downstream per interval trace clamp of size " + downStreamPerIntervalTracesClamp + " is hit");
                            isClampMessagePrinted = true;
                        }
                        return;
                    }
                    if (CrossProcessLogger.isDebugEnabled()) {
                        CrossProcessLogger.logDebugMessage("Downstream agent calling createAndSendTrace for: " + guid);
                    }
                    int tcdsCount = this.createAndSendTrace(guid);
                    this.tracesPerIntervalCount.addAndGet(tcdsCount);
                }
            }
            catch (Exception e) {
                if (!CrossProcessLogger.isDebugEnabled()) break block8;
                CrossProcessLogger.logDebugMessage("Exception occurred in DownStream harvester thread", e);
            }
        }
    }

    public void abortHarvest() {
        this.harvesterInstance.setAbort(true);
    }

    private int createAndSendTrace(String GUID) {
        return this.harvesterInstance.sendTrace(GUID);
    }

    private void startCountingTracesSent() {
        this.agent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                DownStreamListenerService.this.tracesPerIntervalCount.set(0);
                isClampMessagePrinted = false;
            }
        }, "DownStreamListenerService", true, (long)tracesClampPollingDelay, false);
    }
}

