/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import agent.main.AgentShim;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.TransformerNotAvailableException;
import com.wily.introscope.agent.internal.Java15AgentInitializationCallBack;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationHelper;
import com.wily.introscope.agent.transformer.IInstrumentationAcceptor;
import com.wily.introscope.agent.transformer.OnInstrumentationAcceptedCallback;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.api.instrument.AClassRedefinitionDelegate;
import com.wily.introscope.api.instrument.ClassFileTransformerImpl;
import com.wily.introscope.api.instrument.ContinuousRetransformer;
import com.wily.introscope.api.instrument.JavaRedefineRetransformBean;
import com.wily.introscope.api.instrument.KAgentConstants;
import com.wily.introscope.api.instrument.SocketCFT;
import com.wily.introscope.api.instrument.attach.transformers.ClassLoaderTransformer;
import com.wily.introscope.api.instrument.attach.transformers.JBossTransformer;
import com.wily.introscope.properties.IntroscopePropertyUtilities;
import com.wily.util.feedback.DefaultValidationFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.hot.ConfigurationManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class JavaAgent {
    static final ClassFileTransformer sTransformer = new ClassFileTransformerImpl();
    static boolean sTransformerAdded = false;
    private static LinkedHashMap<String, bootstrapRetransformClassInfo> bootstrapRetransformClassMap = null;
    public static volatile CountDownLatch bootstrapRetransformLatch = null;
    public static int bootstrapRetranformReAttempts = 0;
    static boolean isJPMSJava = JavaAgent.getJavaVersion() >= 9;

    public static void premain(final String agentArgs, final Instrumentation instrumentation) {
        JavaAgent.prepareForSocketTracing(instrumentation);
        System.setProperty("com.wily.introscope.agent.starter", "premain");
        String monitor = System.getenv("CA_APM_MONITORING_ENABLED");
        if (monitor != null && !Boolean.parseBoolean(monitor)) {
            System.out.println("CA APM: Monitoring disabled by environment variable CA_APM_MONITORING_ENABLED, agent exiting");
            return;
        }
        String startupMode = System.getProperty("com.wily.introscope.agent.startup.mode", "legacy");
        if (startupMode.equalsIgnoreCase("neo")) {
            if (instrumentation.isRetransformClassesSupported()) {
                Thread agent = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        long delay;
                        try {
                            delay = Long.parseLong(System.getProperty("com.wily.introscope.agent.startup.delay", "300"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("CA APM: Invalid delay value supplied to com.wily.introscope.agent.startup.delay. Please proved a valid value in seconds.");
                            delay = KAgentConstants.kAgentStartupDelayDefaultLong;
                        }
                        try {
                            Thread.sleep(delay * 1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        JavaAgent.agentmain(agentArgs, instrumentation);
                    }
                });
                agent.setDaemon(true);
                agent.start();
                return;
            }
            System.out.println("CA APM: Switching to legacy startup mode, since retransformation isn't supported");
        }
        JavaAgent.initializeAgent(agentArgs, instrumentation, false);
    }

    private static void prepareForSocketTracing(Instrumentation instrumentation) {
        try {
            boolean disableDynamicSocketTracing = false;
            boolean isSocketPatchModuleSet = false;
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            for (String argument : arguments) {
                if (argument.indexOf("patch-module") != -1 && argument.indexOf("AgentSocket") != -1) {
                    isSocketPatchModuleSet = true;
                }
                if (argument.indexOf("disable-dynamic-socket-tracing") == -1) continue;
                disableDynamicSocketTracing = true;
            }
            if (!disableDynamicSocketTracing && isJPMSJava && !isSocketPatchModuleSet) {
                try {
                    instrumentation.addTransformer(new SocketCFT(instrumentation));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
    }

    private static boolean initializeAgent(final String agentArgs, final Instrumentation instrumentation, boolean validate) {
        boolean success = true;
        if (agentArgs != null && agentArgs.startsWith("collector:")) {
            int beginIndex = agentArgs.indexOf(58) + 1;
            com.wily.introscope.agent.AgentShim.sRemoteAgentArgs = agentArgs.substring(beginIndex);
        }
        AInstrumentationHelper.setValidate(validate);
        if (validate) {
            AInstrumentationHelper.setValidationFeedbackChannel(new DefaultValidationFeedbackChannel());
        }
        AInstrumentationHelper.initialize(instrumentation, new OnInstrumentationAcceptedCallback(){

            @Override
            public void onInstrumentationAccepted(IInstrumentationAcceptor accepter) {
                IAgent agent = accepter.getAgent();
                JavaAgent.setModulePrivileges(instrumentation, agent);
                if (accepter instanceof IDynamicInstrumentationTransformer) {
                    JavaRedefineRetransformBean statusOfTransformation = JavaRedefineRetransformBean.getJavaRedefineRetransformBeanInfo(agentArgs, instrumentation);
                    IDynamicInstrumentationTransformer iService = (IDynamicInstrumentationTransformer)((Object)accepter);
                    if (iService != null) {
                        AClassRedefinitionDelegate classRedefinitionDelegate = JavaAgent.getDelegate(instrumentation, statusOfTransformation, agent);
                        if (classRedefinitionDelegate != null) {
                            iService.setClassRedefinitionDelegate(classRedefinitionDelegate);
                        } else {
                            agent.IAgent_getModuleFeedback().warn("The redefinition delegate is not set");
                        }
                    } else {
                        agent.IAgent_getModuleFeedback().warn("The default Dynamic InstrumentationTransformer has not been found");
                    }
                    agent.IAgent_getModuleFeedback().trace("Adding java level transformer");
                    JavaAgent.addTransformer(instrumentation, statusOfTransformation, agent.IAgent_getModuleFeedback());
                    if (iService != null) {
                        agent.IAgent_getModuleFeedback().trace("Executing Premain transformation");
                        iService.executeBootstrapTransform();
                    } else {
                        agent.IAgent_getModuleFeedback().trace("The default Dynamic InstrumentationTransformer has not been found");
                    }
                    agent.IAgent_getModuleFeedback().trace("Done with premain.");
                }
            }
        });
        try {
            Java2PostConstructionInitializationHelper.initialize(new Java15AgentInitializationCallBack(true));
        }
        catch (Exception exception) {
            success = false;
        }
        try {
            AgentShim.kAgent = com.wily.introscope.agent.AgentShim.getAgent();
        }
        catch (AgentNotAvailableException e) {
            com.wily.introscope.agent.AgentShim.handleError("Agent Unavailable", e);
        }
        com.wily.introscope.agent.AgentShim.ProbeBuilderEntryPoint_initializeAgentShim(null);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        String starter = System.getProperty("com.wily.introscope.agent.starter", null);
        if (starter == null || !starter.equals("premain")) {
            if (!instrumentation.isRetransformClassesSupported()) {
                System.out.println("CA APM: Retransformation is disabled in this JVM. Please enable retransformation if you wish to use CA APM");
                return;
            }
            if (agentArgs.contains("ca-apm-java-agent.options")) {
                String agentOptionsPath = agentArgs;
                agentArgs = null;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(agentOptionsPath));
                    String line = bufferedReader.readLine();
                    bufferedReader.close();
                    if (line != null) {
                        agentArgs = line;
                    }
                }
                catch (IOException ioe) {
                    System.out.println("CA APM: Exception reading provided agentOptions. Agent Loading Terminated. Please correct agent options and redeploy UMA");
                    ioe.printStackTrace();
                    return;
                }
            }
            IntroscopePropertyUtilities.loadSystemProperties(agentArgs);
            String monitor = System.getenv("CA_APM_MONITORING_ENABLED");
            if (monitor == null) {
                if (System.getProperty("com.wily.autoattach.mode").equals("whitelist") && !Boolean.parseBoolean(System.getProperty("com.wily.autoattach.overridden", "false"))) {
                    System.out.println("CA APM: Environment variable CA_APM_MONITORING_ENABLED not found while running in whitelist mode, agent exiting");
                    IntroscopePropertyUtilities.cleanSystemProperties();
                    return;
                }
            } else if (!Boolean.parseBoolean(monitor)) {
                System.out.println("CA APM: Monitoring disabled by environment variable CA_APM_MONITORING_ENABLED, agent exiting");
                IntroscopePropertyUtilities.cleanSystemProperties();
                return;
            }
        }
        System.setProperty("com.wily.introscope.agent.starter", "agentmain");
        System.out.println("CA APM: Initiated Java Agent");
        if (isJPMSJava) {
            try {
                Class<?> bootstrapOpenPackages = Class.forName("com.wily.introscope.api.instrument.attach.transformers.BootstrapOpenPackages");
                Method doBootstrapOpening = bootstrapOpenPackages.getDeclaredMethod("doBootstrapOpening", Instrumentation.class);
                doBootstrapOpening.invoke(null, instrumentation);
            }
            catch (Throwable t) {
                System.out.println("CA APM: Failed to redefine required modules");
                t.printStackTrace();
            }
        }
        if (Boolean.parseBoolean(System.getProperty("com.wily.introscope.defer.instrumentation", "false"))) {
            System.out.println("CA APM: Deferring Load Time Transformation");
            JavaAgent.addBootstrapRetransformClass("java.lang.ClassLoader", new ClassLoaderTransformer(), "ClassLoader");
            ClassFileTransformerImpl.agentMain = true;
        }
        if (JBossTransformer.isJBoss()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
            JavaAgent.addBootstrapRetransformClass("org.jboss.modules.Module", new JBossTransformer(), "JBoss");
        }
        JavaAgent.initializeAgentMain(agentArgs, instrumentation);
        if (bootstrapRetranformReAttempts == -1) {
            IntroscopePropertyUtilities.cleanSystemProperties();
            return;
        }
        ContinuousRetransformer retransformer = null;
        try {
            retransformer = new ContinuousRetransformer(instrumentation, com.wily.introscope.agent.AgentShim.getAgent(), 2, 200);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
        }
        catch (TransformerNotAvailableException transformerNotAvailableException) {
            System.err.println("CA APM: Agent cannot proceed without AutoProbe. If you have AutoProbe or Dynamic Instrumentation disabled, please enable them. It may also be that your agent profile path is incorrect or the agent profile property was not set. Please restart your process once corrected. Much Love. Team APM");
            return;
        }
        Class<com.wily.introscope.agent.AgentShim> clazz = com.wily.introscope.agent.AgentShim.class;
        synchronized (com.wily.introscope.agent.AgentShim.class) {
            if (!sTransformerAdded) {
                System.out.println("CA APM: Adding Transformer");
                instrumentation.addTransformer(sTransformer, true);
                sTransformerAdded = true;
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (retransformer != null) {
                retransformer.setName("Agent: Continuous Retransformer");
                retransformer.setDaemon(true);
                retransformer.start();
            }
            IntroscopePropertyUtilities.clearStateOnSuccess();
            return;
        }
    }

    private static boolean initializeAgentMain(final String agentArgs, final Instrumentation instrumentation) {
        JavaAgent.bootstrapRetransform(instrumentation);
        if (bootstrapRetranformReAttempts == -1) {
            return false;
        }
        boolean success = true;
        AInstrumentationHelper.initialize(instrumentation, new OnInstrumentationAcceptedCallback(){

            @Override
            public void onInstrumentationAccepted(IInstrumentationAcceptor accepter) {
                IAgent agent = accepter.getAgent();
                JavaAgent.setModulePrivileges(instrumentation, agent);
                if (accepter instanceof IDynamicInstrumentationTransformer) {
                    JavaRedefineRetransformBean statusOfTransformation = JavaRedefineRetransformBean.getJavaRedefineRetransformBeanInfo(agentArgs, instrumentation);
                    IDynamicInstrumentationTransformer iService = (IDynamicInstrumentationTransformer)((Object)accepter);
                    if (iService != null) {
                        AClassRedefinitionDelegate classRedefinitionDelegate = JavaAgent.getDelegate(instrumentation, statusOfTransformation, agent);
                        if (classRedefinitionDelegate != null) {
                            iService.setClassRedefinitionDelegate(classRedefinitionDelegate);
                        } else {
                            agent.IAgent_getModuleFeedback().warn("The redefinition delegate is not set");
                        }
                        agent.IAgent_getModuleFeedback().trace("Registering Bootstrap Transformer");
                        iService.registerBootstrapTransformer();
                    } else {
                        agent.IAgent_getModuleFeedback().warn("The default Dynamic InstrumentationTransformer has not been found");
                    }
                    agent.IAgent_getModuleFeedback().trace("Done with agentmain.");
                }
            }
        });
        try {
            Java2PostConstructionInitializationHelper.initialize(new Java15AgentInitializationCallBack(false));
        }
        catch (Exception exception) {
            success = false;
        }
        try {
            AgentShim.kAgent = com.wily.introscope.agent.AgentShim.getAgent();
        }
        catch (AgentNotAvailableException e) {
            com.wily.introscope.agent.AgentShim.handleError("Agent Unavailable", e);
        }
        com.wily.introscope.agent.AgentShim.ProbeBuilderEntryPoint_initializeAgentShim(null);
        return success;
    }

    private static void addBootstrapRetransformClass(String name, ClassFileTransformer transformer, String description) {
        if (bootstrapRetransformClassMap == null) {
            bootstrapRetransformClassMap = new LinkedHashMap();
        }
        bootstrapRetransformClassInfo info = new bootstrapRetransformClassInfo();
        info.loadedClasses = new ArrayList<Class>();
        info.transformer = transformer;
        info.description = description;
        bootstrapRetransformClassMap.put(name, info);
    }

    /*
     * WARNING - void declaration
     */
    private static void bootstrapRetransform(Instrumentation instrumentation) {
        void var2_5;
        if (bootstrapRetransformClassMap == null) {
            return;
        }
        if (bootstrapRetranformReAttempts == 11) {
            bootstrapRetranformReAttempts = -1;
            bootstrapRetransformClassMap.clear();
            bootstrapRetransformClassMap = null;
            return;
        }
        Class[] classArray = instrumentation.getAllLoadedClasses();
        int n = classArray.length;
        boolean n2 = false;
        while (var2_5 < n) {
            Class clazz = classArray[var2_5];
            bootstrapRetransformClassInfo info = bootstrapRetransformClassMap.get(clazz.getName());
            if (info != null) {
                info.loadedClasses.add(clazz);
            }
            ++var2_5;
        }
        boolean reAttempt = false;
        for (Map.Entry<String, bootstrapRetransformClassInfo> entry : bootstrapRetransformClassMap.entrySet()) {
            if (entry.getValue().loadedClasses.size() != 0) continue;
            reAttempt = true;
            if (bootstrapRetranformReAttempts != 10) break;
            System.out.println("CA APM: Bootstrap retransform for " + entry.getKey() + " unsuccessful. CA APM " + "exiting");
            break;
        }
        if (reAttempt) {
            for (bootstrapRetransformClassInfo bootstrapRetransformClassInfo2 : bootstrapRetransformClassMap.values()) {
                bootstrapRetransformClassInfo2.loadedClasses.clear();
            }
            ++bootstrapRetranformReAttempts;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
            JavaAgent.bootstrapRetransform(instrumentation);
            return;
        }
        for (Map.Entry entry : bootstrapRetransformClassMap.entrySet()) {
            bootstrapRetransformClassInfo value = (bootstrapRetransformClassInfo)entry.getValue();
            if (value.loadedClasses.size() <= 0) continue;
            bootstrapRetransformLatch = new CountDownLatch(value.loadedClasses.size());
            instrumentation.addTransformer(value.transformer, true);
            for (Class clazz : value.loadedClasses) {
                try {
                    instrumentation.retransformClasses(clazz);
                }
                catch (Throwable throwable) {
                    System.out.println("CA APM: Can't retransform " + value.description);
                    bootstrapRetransformLatch.countDown();
                }
            }
            try {
                bootstrapRetransformLatch.await(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("CA APM: Wait for " + value.description + " configuration interrupted");
            }
            instrumentation.removeTransformer(value.transformer);
            value.loadedClasses.clear();
        }
        bootstrapRetransformClassMap.clear();
        bootstrapRetransformClassMap = null;
    }

    private static boolean addTransformer(Instrumentation i, JavaRedefineRetransformBean status, IModuleFeedbackChannel feedback) {
        try {
            if (status.fCanRetransform && status.fSuggestRetransform) {
                feedback.info("Try and add transformer that can retransform classes");
                Method instrumentationAddTransformer = i.getClass().getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
                instrumentationAddTransformer.invoke((Object)i, sTransformer, Boolean.TRUE);
                return true;
            }
        }
        catch (SecurityException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            feedback.debug("Class retransformation not supported by JVM");
        }
        catch (IllegalArgumentException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (ClassCastException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        feedback.info("Try and add transformer using java5 API");
        i.addTransformer(sTransformer);
        return false;
    }

    private static AClassRedefinitionDelegate getDelegate(Instrumentation instrumentation, JavaRedefineRetransformBean status, IAgent agent) {
        String delegateClassName = "com.wily.introscope.api.instrument.AClassRedefinitionDelegate";
        delegateClassName = status.fPropertyForceRetransformation ? "com.wily.introscope.api.instrument.AClassRetransformationDelegate" : (status.fPropertyForceRedefinition ? "com.wily.introscope.api.instrument.AClassRedefinitionDelegate" : (status.fCanRetransform && status.fSuggestRetransform ? "com.wily.introscope.api.instrument.AClassRetransformationDelegate" : "com.wily.introscope.api.instrument.AClassRedefinitionDelegate"));
        agent.IAgent_getModuleFeedback().info("Using delegate class =" + delegateClassName);
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            try {
                Constructor<?> instrumentationAddTransformer = delegateClass.getConstructor(Instrumentation.class, IAgent.class);
                try {
                    Object result = instrumentationAddTransformer.newInstance(instrumentation, agent);
                    return (AClassRedefinitionDelegate)result;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    agent.IAgent_getModuleFeedback().error("Unexpected argument exception when instatiating delegate class " + delegateClassName);
                }
                catch (InstantiationException instantiationException) {
                    agent.IAgent_getModuleFeedback().error("Unable to instatiate delegate class " + delegateClassName);
                }
                catch (IllegalAccessException illegalAccessException) {
                    agent.IAgent_getModuleFeedback().error("Unable to access instatiation for delegate class " + delegateClassName);
                }
                catch (InvocationTargetException invocationTargetException) {
                    agent.IAgent_getModuleFeedback().error("Exception when instatiating delegate class " + delegateClassName);
                }
            }
            catch (SecurityException securityException) {
                agent.IAgent_getModuleFeedback().error("Unable to access delegate class " + delegateClassName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                agent.IAgent_getModuleFeedback().error("Unable to find constructor for delegate class " + delegateClassName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            agent.IAgent_getModuleFeedback().error("Unable to find delegate class " + delegateClassName);
        }
        return null;
    }

    private static void setModulePrivileges(Instrumentation instrumentation, IAgent agent) {
        block9: {
            try {
                if (!isJPMSJava) break block9;
                String extraExports = null;
                boolean disableDynamicExports = false;
                ConfigurationManager confManager = com.wily.introscope.agent.AgentShim.getAgent().IAgent_getConfigurationManager();
                try {
                    disableDynamicExports = Boolean.parseBoolean(confManager.getProperty("introscope.agent.dynamicmoduleexports.disable"));
                }
                catch (Exception exception) {}
                if (!disableDynamicExports) {
                    List extensions = agent.IAgent_getExtensionAdministrator().getExtensionsList();
                    try {
                        extraExports = confManager.getProperty("introscope.agent.extraexports");
                    }
                    catch (Exception exception) {}
                    Class<?> javaJpmsCFT = Class.forName("com.wily.introscope.api.instrument.JPMSClassFileTransformerImpl");
                    Constructor<?> javaJpmsCFTConstructor = javaJpmsCFT.getConstructor(Instrumentation.class, String.class);
                    javaJpmsCFTConstructor.setAccessible(true);
                    Method addExtensionCL_method = javaJpmsCFT.getDeclaredMethod("addExtensionCL", List.class);
                    ClassFileTransformer jpmsCFL = (ClassFileTransformer)javaJpmsCFTConstructor.newInstance(instrumentation, extraExports);
                    addExtensionCL_method.invoke((Object)jpmsCFL, extensions);
                    instrumentation.addTransformer(jpmsCFL, true);
                    break block9;
                }
                System.out.println("Dynamic export is disabled via the Introscope property 'introscope.agent.dynamicmoduleexports.disable' ");
                com.wily.introscope.agent.AgentShim.getAgent().IAgent_getModuleFeedback().info("Dynamic export is disabled via the Introscope property 'introscope.agent.disableDynamicExports'");
            }
            catch (Exception e) {
                try {
                    System.out.println("error in setModulePrivileges  " + e);
                    com.wily.introscope.agent.AgentShim.getAgent().IAgent_getModuleFeedback().info("Error setModulePrivileges " + e);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static int getJavaVersion() {
        try {
            String javaVersion = System.getProperty("java.version");
            String[] version = javaVersion.split("\\.");
            if (Integer.parseInt(version[0]) >= 9) {
                return Integer.parseInt(version[0]);
            }
            return Integer.parseInt(version[1]);
        }
        catch (Exception e) {
            System.out.println("Error getting java version " + e);
            return -1;
        }
    }

    private static class bootstrapRetransformClassInfo {
        public List<Class> loadedClasses;
        public ClassFileTransformer transformer;
        public String description;

        private bootstrapRetransformClassInfo() {
        }
    }
}

