/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.io;

import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import com.wily.util.io.ScatteringBufferInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FullDuplexPipe {
    public static final int kDefaultIncomingBufferSize = 8192;
    public static final int kDefaultOutgoingBufferSize = 8192;
    private final ScatteringBufferInputStream fInputSource;
    private final InputStreamSyncWrapper fSynchedInputSource;
    private final NonSyncByteArrayOutputStream fOutputSink;
    private final OutputStreamSyncWrapper fSynchedOutputSink;
    private final byte[] fInputSemaphore = new byte[0];
    private final byte[] fOutputSemaphore = new byte[0];

    public FullDuplexPipe() throws IOException {
        this(8192, 8192);
    }

    public FullDuplexPipe(int incomingBufferSize, int outgoingBufferSize) throws IOException {
        CheckParameter.isPositive("Incoming Buffer Size", incomingBufferSize);
        CheckParameter.isPositive("Outgoing Buffer Size", outgoingBufferSize);
        this.fInputSource = new ScatteringBufferInputStream(incomingBufferSize);
        this.fSynchedInputSource = new InputStreamSyncWrapper(this.fInputSource, this.fInputSemaphore);
        this.fOutputSink = new NonSyncByteArrayOutputStream(outgoingBufferSize);
        this.fSynchedOutputSink = new OutputStreamSyncWrapper(this.fOutputSink, this.fOutputSemaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.fSynchedInputSource.close();
            this.fSynchedOutputSink.close();
        }
        catch (Throwable throwable) {
            byte[] byArray = this.fInputSemaphore;
            synchronized (this.fInputSemaphore) {
                this.fInputSemaphore.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                throw throwable;
            }
        }
        byte[] byArray = this.fInputSemaphore;
        synchronized (this.fInputSemaphore) {
            this.fInputSemaphore.notify();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public InputStream getInputStream() {
        return this.fSynchedInputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToInputStream(byte[] bytes) {
        byte[] byArray = this.fInputSemaphore;
        synchronized (this.fInputSemaphore) {
            this.fInputSource.fillFromArray(bytes);
            this.fInputSemaphore.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public OutputStream getOutputStream() {
        return this.fSynchedOutputSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availableFromOutputStream() {
        byte[] byArray = this.fOutputSemaphore;
        synchronized (this.fOutputSemaphore) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fOutputSink.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromOutputStream() {
        byte[] byArray = this.fOutputSemaphore;
        synchronized (this.fOutputSemaphore) {
            byte[] byteArray = this.fOutputSink.toByteArray();
            this.fOutputSink.reset();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byteArray;
        }
    }

    private static class InputStreamSyncWrapper
    extends FilterInputStream {
        private final ScatteringBufferInputStream fIn;
        private final Object fSemaphore;
        private boolean fIsClosed;

        public InputStreamSyncWrapper(ScatteringBufferInputStream in, Object semaphore) {
            super(in);
            this.fIn = in;
            this.fSemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                return this.fIn.available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int read() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                while (this.available() == 0) {
                    try {
                        this.fSemaphore.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("read interrupted.");
                    }
                }
                return this.fIn.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                while (this.available() == 0) {
                    try {
                        this.fSemaphore.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("read interrupted.");
                    }
                }
                return this.fIn.read(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.fIsClosed = true;
                this.fIn.close();
            }
        }

        private void checkIfStreamClosed() throws IOException {
            if (this.fIsClosed) {
                throw new IOException("stream is closed.");
            }
        }
    }

    private static class OutputStreamSyncWrapper
    extends FilterOutputStream {
        private final Object fSemaphore;
        private boolean fIsClosed;

        public OutputStreamSyncWrapper(OutputStream out, Object semaphore) {
            super(out);
            this.fSemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                this.out.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                this.out.write(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.fIsClosed = true;
                this.out.close();
            }
        }

        private void checkIfStreamClosed() throws IOException {
            if (this.fIsClosed) {
                throw new IOException("stream is closed.");
            }
        }
    }
}

