/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncFrontendTracer;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class AsyncFrontendStartTracer
extends AsyncFrontendTracer {
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncFrontendStartTracer");
    protected final AsyncVirtualStack asyncStack;
    protected final IAgent agent;

    public AsyncFrontendStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.asyncStack = AsyncVirtualStack.getInstance(agent);
        this.agent = agent;
    }

    @Override
    protected String getFrontendNameForComponent(String rootName) {
        return AsyncVirtualStack.addFragmentPrefix(rootName);
    }

    protected String getFrontendNameForAsyncComponent(InvocationData data, String rootName) {
        return super.getFrontendNameForComponent(rootName);
    }

    @Override
    protected String getComponentName(InvocationData data) {
        if (!AsyncVirtualStack.reportFragmentsByFrontend()) {
            return super.getComponentName(data);
        }
        String frontendName = null;
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        if (frontendInfo != null) {
            frontendName = frontendInfo.componentName;
        }
        String name = super.formatParameterizedName(data);
        name = AsyncVirtualStack.formatFragmentName(frontendName, name);
        return this.getFrontendNameForComponent(name);
    }

    protected boolean isAsyncStarted(InvocationData data) {
        return true;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
        if (frontendInfo == null) {
            String name = super.formatParameterizedName(data);
            String component = this.getFrontendNameForAsyncComponent(data, name);
            frontendInfo = this.asyncStack.pushFrontend(component, data, this);
            this.asyncStack.putAsyncFrontendInfoToTransactionCache(data, frontendInfo);
        }
        super.ITracer_startTrace(tracerIndex, data);
        TransactionCollectStatus tcs = data.getTransactionCollectionStatus();
        ISamplingResult sampled = tcs.getSampled();
        this.feedback.debug(ISamplingResult.kSamplingModule, "Creating frontend component, sampled=" + sampled);
        if (sampled != null) {
            if (sampled.isDerivative()) {
                this.feedback.debug(ISamplingResult.kSamplingModule, "While creating frontend component found that result is derivative already, sampled=" + sampled);
            }
            this.asyncStack.markSampled(frontendInfo, sampled);
            ISamplingResult derivative = sampled.derivativeSamplingResult();
            this.feedback.debug(ISamplingResult.kSamplingModule, "For sampled=" + sampled + " created derivative=" + derivative + " and set it to the main fragment");
            tcs.setSampled(derivative);
        }
        final AsyncTransactionContext.AsyncComponentInvocation info = frontendInfo;
        data.setParameterCallback(new IInvocationDataParameterCallback(){

            @Override
            public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
                String frontendTxid;
                if (info != null && (frontendTxid = info.transactionId) != null) {
                    parameters.put("FrontendTxnTraceId", frontendTxid);
                }
            }
        });
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!this.isAsyncStarted(data)) {
            AsyncTransactionContext.AsyncComponentInvocation frontendInfo = AsyncVirtualStack.getAsyncFrontendInfoFromTransactionCache(data);
            if (frontendInfo == null) {
                if (this.feedback.isDebugEnabled(module)) {
                    this.feedback.debug(module, "Failed to find correlated frontend info. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
                }
            } else {
                this.asyncStack.pop(frontendInfo, data, this);
            }
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }
}

