/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public final class StalledMethodTracer
extends ABundledTracerFactory {
    private final ReentrancyLevel fReentrancyLevel;
    static StalledMethodTracerHashSet sCurrentInstances;
    final int fThresholdInMillis;
    private IIntegerFluctuatingCounterDataAccumulator fCachedAccumulator;

    private static synchronized void initialize(IAgent agent) {
        if (sCurrentInstances == null) {
            sCurrentInstances = new StalledMethodTracerHashSet();
            agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new StalledMethodsHeartbeatBehavior(), "Stalled Method Evaluation", true, 7500L, false);
        }
    }

    public StalledMethodTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        StalledMethodTracer.initialize(agent);
        this.fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
        this.fThresholdInMillis = this.getIntegerParameter("threshold", -1);
        Assertion.wilyAssert(false);
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    final IIntegerFluctuatingCounterDataAccumulator getDataAccumulator(InvocationData data) {
        if (this.canUseCaching()) {
            if (this.fCachedAccumulator == null) {
                this.fCachedAccumulator = this.createDataAccumulator(this.getFormattedName());
            }
            return this.fCachedAccumulator;
        }
        return this.createDataAccumulator(this.formatParameterizedName(data));
    }

    private final IIntegerFluctuatingCounterDataAccumulator createDataAccumulator(String metricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        return new StalledMethodTracerInstance(tracerIndex, data);
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    static void debug_evaluateMethodsForStall() {
        sCurrentInstances.evaluateMethodsForStall(System.currentTimeMillis());
    }

    private static final class StalledMethodTracerHashSet {
        private static final int kTableEntryCount = 256;
        private static final int kTableEntryMask = 255;
        private static final int kLockCount = 32;
        private static final int kLockMask = 31;
        private final Object[] fLocks = this.createLocks();
        private final StalledMethodTracerInstance[] fTable = new StalledMethodTracerInstance[256];
        private final int[] fCounts = new int[256];

        private Object[] createLocks() {
            Object[] locks = new Object[32];
            int i = 0;
            while (i < locks.length) {
                locks[i] = new Object();
                ++i;
            }
            return locks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(StalledMethodTracerInstance value) {
            int hash = value.hashCode();
            Object object = this.fLocks[hash & 0x1F];
            synchronized (object) {
                Assertion.wilyAssert(false);
                int index = hash & 0xFF;
                value.fNext = this.fTable[index];
                this.fTable[index] = value;
                int n = index;
                this.fCounts[n] = this.fCounts[n] + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(StalledMethodTracerInstance value) {
            int hash = value.hashCode();
            Object object = this.fLocks[hash & 0x1F];
            synchronized (object) {
                Assertion.wilyAssert(false);
                int index = hash & 0xFF;
                StalledMethodTracerInstance previous = null;
                StalledMethodTracerInstance tracer = this.fTable[index];
                while (tracer != null) {
                    if (tracer == value) {
                        if (previous == null) {
                            this.fTable[index] = tracer.fNext;
                        } else {
                            previous.fNext = tracer.fNext;
                        }
                        int n = index;
                        this.fCounts[n] = this.fCounts[n] - 1;
                        return;
                    }
                    previous = tracer;
                    tracer = tracer.fNext;
                }
                Assertion.wilyFail("should never try and remove a tracer not in the set");
            }
        }

        public void evaluateMethodsForStall(long nowInMillis) {
            int index = 0;
            while (index < this.fTable.length) {
                StalledMethodTracerInstance[] thesnapshot = this.snapshot(index);
                int i = 0;
                while (i < thesnapshot.length) {
                    thesnapshot[i].evaluateForStall(nowInMillis);
                    ++i;
                }
                ++index;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StalledMethodTracerInstance[] snapshot(int index) {
            Object object = this.fLocks[index & 0x1F];
            synchronized (object) {
                StalledMethodTracerInstance[] result = new StalledMethodTracerInstance[this.fCounts[index]];
                int resultIndex = 0;
                StalledMethodTracerInstance tracer = this.fTable[index];
                while (tracer != null) {
                    result[resultIndex++] = tracer;
                    tracer = tracer.fNext;
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean contains(StalledMethodTracerInstance value) {
            int hash = value.hashCode();
            Object object = this.fLocks[hash & 0x1F];
            synchronized (object) {
                int index = hash & 0xFF;
                StalledMethodTracerInstance tracer = this.fTable[index];
                while (true) {
                    if (tracer == null) {
                        return false;
                    }
                    if (tracer == value) {
                        return true;
                    }
                    tracer = tracer.fNext;
                }
            }
        }
    }

    private final class StalledMethodTracerInstance
    implements ITracer {
        private final InvocationData fData;
        private final int fHashCode;
        StalledMethodTracerInstance fNext;
        private IIntegerFluctuatingCounterDataAccumulator fAccumulator;
        private boolean fCountedAsStalledMethod;
        private boolean fHasFinished;
        private long fThresholdTime;

        public StalledMethodTracerInstance(int tracerIndex, InvocationData data) {
            this.fData = data;
            this.fHashCode = this.calculateHashCode();
        }

        private int calculateHashCode() {
            int h = super.hashCode();
            return (h << 7) - h + (h >>> 9) + (h >>> 17);
        }

        public int hashCode() {
            return this.fHashCode;
        }

        private Object getInstanceLock() {
            return this;
        }

        @Override
        public void ITracer_startTrace(int tracerIndex, InvocationData data) {
            this.fThresholdTime = data.storeWallClockStartTime() + (long)StalledMethodTracer.this.fThresholdInMillis;
            this.fCountedAsStalledMethod = false;
            this.fHasFinished = false;
            this.fAccumulator = null;
            sCurrentInstances.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
            Object object = this.getInstanceLock();
            synchronized (object) {
                this.fHasFinished = true;
                if (this.fCountedAsStalledMethod) {
                    Assertion.wilyAssert(false);
                    Assertion.wilyAssert(false);
                    if (this.fAccumulator != null) {
                        this.fAccumulator.IIntegerFluctuatingCounterDataAccumulator_decrement();
                    }
                } else {
                    sCurrentInstances.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void evaluateForStall(long currentTime) {
            boolean shouldCountAsStalled = false;
            IIntegerFluctuatingCounterDataAccumulator accumulator = null;
            Object object = this.getInstanceLock();
            synchronized (object) {
                if (!this.fHasFinished && !this.fCountedAsStalledMethod && currentTime > this.fThresholdTime) {
                    shouldCountAsStalled = true;
                }
            }
            if (shouldCountAsStalled) {
                accumulator = StalledMethodTracer.this.getDataAccumulator(this.fData);
                object = this.getInstanceLock();
                synchronized (object) {
                    this.fCountedAsStalledMethod = true;
                    this.fAccumulator = accumulator;
                    this.fAccumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
                    if (this.fHasFinished) {
                        this.fAccumulator.IIntegerFluctuatingCounterDataAccumulator_decrement();
                        Assertion.wilyAssert(false);
                    } else {
                        sCurrentInstances.remove(this);
                    }
                }
            }
        }
    }

    private static final class StalledMethodsHeartbeatBehavior
    implements ITimestampedRunnable {
        private StalledMethodsHeartbeatBehavior() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            sCurrentInstances.evaluateMethodsForStall(nowInMillis);
        }
    }
}

