/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IStackElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.intelligent.ErrorElementsParameterContainer;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentErrorFeature;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.clock.MasterClock;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class HighPerformanceIntelligentStackHelper {
    public static final int kThrottleState_None = 11;
    public static final int kThrottleState_ReduceII = 12;
    public static final int kThrottleState_DisableII = 13;
    public static volatile int kThrottleReduceIITopCount = 3;
    public static final String kClassNameMethodNameSeparator = "::";

    public static TransactionComponentData getErrorTransactionSnapshotFromStack(IStackElement data, IIntelligentInstrumentationStackElement elementWithMTERTracer, Runnable t, Throwable error, String errorMessage, IIntelligentInstrumentationStackElement lastChildWithException) {
        Stack<IIntelligentInstrumentationStackElement> deepElementsStack = new Stack<IIntelligentInstrumentationStackElement>();
        IIntelligentInstrumentationStackElement lastElement = lastChildWithException != null ? lastChildWithException : elementWithMTERTracer;
        HighPerformanceIntelligentStackHelper.getElementStack(deepElementsStack, lastElement);
        int stackLength = deepElementsStack.size();
        Stack<IStackElement> invocationDataStack = new Stack<IStackElement>();
        HighPerformanceIntelligentStackHelper.populateInvocationDataStack(invocationDataStack, data);
        IIntelligentInstrumentationStackElement popped = deepElementsStack.pop();
        Throwable errorForData = null;
        String errorMessageForData = errorMessage;
        if (lastChildWithException != null && popped == lastChildWithException) {
            errorForData = lastChildWithException.getInvocationThrownException();
            errorMessageForData = HighPerformanceIntelligentErrorFeature.constructErrorMessage(lastChildWithException);
        }
        TransactionComponentData root = null;
        InvocationData poppedInvocationData = null;
        IStackElement stackCursor = invocationDataStack.pop();
        int invocationId = popped.getInvocationId();
        boolean triggerElementPopped = false;
        if (invocationId != -1) {
            poppedInvocationData = HighPerformanceIntelligentStackHelper.getInvocationDataFromStack(invocationId, stackCursor);
        }
        long currTimeInMillisend = MasterClock.currentTimeMillis();
        if (poppedInvocationData != null) {
            if (poppedInvocationData == data) {
                errorForData = error;
                errorMessageForData = errorMessage;
                triggerElementPopped = true;
            }
            if (!invocationDataStack.empty()) {
                stackCursor = invocationDataStack.pop();
            }
            root = HighPerformanceIntelligentStackHelper.getTransanctionSnapShotFromInvocationData(t, errorMessage, errorForData, poppedInvocationData, currTimeInMillisend);
        } else {
            root = HighPerformanceIntelligentStackHelper.getTransanctionSnapshotFromStackElement(t, errorMessage, errorForData, popped, currTimeInMillisend);
        }
        if (root == null) {
            return null;
        }
        TransactionComponentData cursor = null;
        cursor = root.getLeftmostLeafOrSelf();
        if (cursor != null) {
            TransactionComponentData bizDefComponent;
            errorMessageForData = errorMessage;
            while (!deepElementsStack.isEmpty()) {
                poppedInvocationData = null;
                popped = deepElementsStack.pop();
                errorForData = null;
                if (triggerElementPopped) {
                    errorMessageForData = "";
                }
                if (lastChildWithException != null && popped == lastChildWithException) {
                    errorForData = lastChildWithException.getInvocationThrownException();
                    errorMessageForData = HighPerformanceIntelligentErrorFeature.constructErrorMessage(popped);
                } else if (triggerElementPopped && popped.hasInvocationThrownException()) {
                    errorMessageForData = HighPerformanceIntelligentErrorFeature.constructErrorMessage(popped);
                    errorForData = null;
                }
                TransactionComponentData child = null;
                invocationId = popped.getInvocationId();
                if (invocationId != -1) {
                    poppedInvocationData = HighPerformanceIntelligentStackHelper.getInvocationDataFromStack(invocationId, stackCursor);
                }
                if (poppedInvocationData != null) {
                    if (poppedInvocationData == data) {
                        errorForData = error;
                        triggerElementPopped = true;
                    }
                    if (!invocationDataStack.empty()) {
                        stackCursor = invocationDataStack.pop();
                    }
                    child = HighPerformanceIntelligentStackHelper.getTransanctionSnapShotFromInvocationData(t, errorMessageForData, errorForData, poppedInvocationData, currTimeInMillisend);
                }
                if (child == null) {
                    child = HighPerformanceIntelligentStackHelper.getTransanctionSnapshotFromStackElement(t, errorMessageForData, errorForData, popped, currTimeInMillisend);
                }
                if (child == null) continue;
                cursor.addSubNode(child);
                cursor = child.getLeftmostLeafOrSelf();
                if (poppedInvocationData != data) continue;
                Map<String, String> paramMap = HighPerformanceIntelligentStackHelper.extractParametersFromTCD(child);
                ErrorElementsParameterContainer errorContainer = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getErrorElementsParameterContainer();
                errorContainer.addParameters(poppedInvocationData.getInvocationId(), paramMap);
            }
            if (!root.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(root)) != null) {
                root = bizDefComponent;
            }
            root.setParameterValue("Trace Type", "ErrorSnapshot");
            root.setParameterValue("Total Methods", new Integer(stackLength).toString());
            IntelligentTransactionHarvesterHelper.validateTransactionFromIntelligentInstrumentation(root, null);
        }
        return root;
    }

    private static Map<String, String> extractParametersFromTCD(TransactionComponentData child) {
        return new HashMap<String, String>(child.getParameters());
    }

    public static TransactionComponentData getTransactionSnapshotFromStack(IStackElement data, Runnable t, Throwable error, String errorMessage) {
        Stack<IStackElement> invocationDataStack = new Stack<IStackElement>();
        HighPerformanceIntelligentStackHelper.populateInvocationDataStack(invocationDataStack, data);
        IStackElement topElement = invocationDataStack.peek();
        if (!(topElement instanceof InvocationData)) {
            return null;
        }
        InvocationData topElementData = (InvocationData)topElement;
        Object highPerfVirtualStack = topElementData.getHighPerformanceIntelligenceStackElementVirtualStack();
        if (highPerfVirtualStack == null || !(highPerfVirtualStack instanceof HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)) {
            return null;
        }
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack iiVirtualStack = (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)highPerfVirtualStack;
        Stack<IIntelligentInstrumentationStackElement> deepElementsStack = new Stack<IIntelligentInstrumentationStackElement>();
        HighPerformanceIntelligenceStackElement lastDeepElement = HighPerformanceIntelligentStackHelper.currentElement(topElementData, iiVirtualStack);
        if (lastDeepElement == null) {
            return null;
        }
        HighPerformanceIntelligentStackHelper.getElementStack(deepElementsStack, lastDeepElement);
        int stackLength = deepElementsStack.size();
        IIntelligentInstrumentationStackElement popped = deepElementsStack.pop();
        Throwable errorForData = null;
        String errorMessageForData = errorMessage;
        TransactionComponentData root = null;
        InvocationData poppedInvocationData = null;
        IStackElement stackCursor = invocationDataStack.pop();
        int invocationId = popped.getInvocationId();
        if (invocationId != -1) {
            poppedInvocationData = HighPerformanceIntelligentStackHelper.getInvocationDataFromStack(invocationId, stackCursor);
        }
        long currTimeInMillisend = MasterClock.currentTimeMillis();
        if (poppedInvocationData != null) {
            if (poppedInvocationData == data) {
                errorForData = error;
                errorMessageForData = errorMessage;
            }
            if (!invocationDataStack.empty()) {
                stackCursor = invocationDataStack.pop();
            }
            root = HighPerformanceIntelligentStackHelper.getTransanctionSnapShotFromInvocationData(t, errorMessage, errorForData, poppedInvocationData, currTimeInMillisend);
        } else {
            root = HighPerformanceIntelligentStackHelper.getTransanctionSnapshotFromStackElement(t, errorMessage, errorForData, popped, currTimeInMillisend);
        }
        if (root == null) {
            return null;
        }
        TransactionComponentData cursor = null;
        cursor = root.getLeftmostLeafOrSelf();
        if (cursor != null) {
            TransactionComponentData bizDefComponent;
            errorMessageForData = errorMessage;
            while (!deepElementsStack.isEmpty()) {
                poppedInvocationData = null;
                popped = deepElementsStack.pop();
                TransactionComponentData child = null;
                invocationId = popped.getInvocationId();
                if (invocationId != -1) {
                    poppedInvocationData = HighPerformanceIntelligentStackHelper.getInvocationDataFromStack(invocationId, stackCursor);
                }
                if (poppedInvocationData != null) {
                    if (!invocationDataStack.empty()) {
                        stackCursor = invocationDataStack.pop();
                    }
                    child = HighPerformanceIntelligentStackHelper.getTransanctionSnapShotFromInvocationData(t, errorMessageForData, errorForData, poppedInvocationData, currTimeInMillisend);
                }
                if (child == null) {
                    child = HighPerformanceIntelligentStackHelper.getTransanctionSnapshotFromStackElement(t, errorMessageForData, errorForData, popped, currTimeInMillisend);
                }
                if (child == null) continue;
                cursor.addSubNode(child);
                cursor = child.getLeftmostLeafOrSelf();
            }
            if (lastDeepElement.isFinished()) {
                return null;
            }
            if (!root.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(root)) != null) {
                root = bizDefComponent;
            }
            root.setParameterValue("Trace Type", "ErrorSnapshot");
            root.setParameterValue("Total Methods", new Integer(stackLength).toString());
            IntelligentTransactionHarvesterHelper.validateTransactionFromIntelligentInstrumentation(root, null);
        }
        return root;
    }

    private static void populateInvocationDataStack(final Stack<IStackElement> stack, IStackElement data) {
        IStackElement cursorData = data;
        StackRecursionHelper.staticSafeRecurseAccessParent(cursorData, new IStackElementCallbackOnRecursion(){

            @Override
            public boolean doOnElement(IStackElement pivot) {
                if (pivot instanceof InvocationData) {
                    stack.push(pivot);
                }
                return false;
            }
        });
    }

    private static void fillComponentParams(TransactionComponentData component, InvocationData data, Runnable r, String errorMessage, Throwable error) {
        ProbeIdentification dataProbIdentification = data.getProbeInformation().getProbeIdentification();
        HashMap<String, String> parameters = new HashMap<String, String>();
        component.setParameters(parameters);
        parameters.put("Method", dataProbIdentification.getProbeMethodName());
        parameters.put("Method Descriptor", dataProbIdentification.getProbeMethodDescriptor());
        parameters.put("Class", dataProbIdentification.getRuntimeFullClassName());
        String lineInfo = dataProbIdentification.getSourceFileLine();
        if (lineInfo != null) {
            parameters.put("Source Line", lineInfo);
        }
        parameters.put("Resource Name", component.getResource());
        data.addParameterCallbacks(parameters);
        IFactoryLevelParameterCallback[] staticCallbacks = data.getProbeInformation().getCallbacks();
        int i = 0;
        while (i < staticCallbacks.length) {
            if (staticCallbacks[i] != null) {
                staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
            }
            ++i;
        }
        if (r instanceof Thread) {
            Thread t = (Thread)r;
            ThreadGroup tg = t.getThreadGroup();
            String threadName = InvocationData.limitSize(t.getName());
            if (threadName != null) {
                parameters.put("Thread Name", threadName);
            }
            if (tg != null) {
                String threadGroupName = InvocationData.limitSize(tg.getName());
                if (threadGroupName != null) {
                    parameters.put("Thread Group Name", threadGroupName);
                }
            } else if (Logger.isDebugEnabled()) {
                Logger.logDebugMessage("Threadgroup for thread " + t + " is null");
            }
        } else if (r != null) {
            String threadName = InvocationData.limitSize(r.toString());
            if (threadName != null) {
                parameters.put("Thread Name", threadName);
            }
            parameters.put("Thread Group Name", "NA");
        }
        if (errorMessage != null) {
            parameters.put("Error Message", InvocationData.limitSize(errorMessage));
            parameters.put("Trace Type", "ErrorSnapshot");
            if (error != null) {
                StackTraceElement[] stackTraceElements = error.getStackTrace();
                if (stackTraceElements.length > 0) {
                    parameters.put("Exception", InvocationData.limitSize(stackTraceElements[0].toString()));
                } else {
                    parameters.put("Exception", InvocationData.limitSize(errorMessage));
                }
            }
        }
    }

    public static InvocationData getInvocationDataFromStack(final int invocationId, IStackElement lastInStack) {
        if (lastInStack == null) {
            lastInStack = VirtualStack.peek();
        }
        InvocationData result = (InvocationData)StackRecursionHelper.staticSafeRecurseAccessParent(lastInStack, new IStackElementCallbackOnRecursion(){

            @Override
            public boolean doOnElement(IStackElement pivot) {
                InvocationData current;
                return pivot instanceof InvocationData && (current = (InvocationData)pivot).getInvocationId() == invocationId;
            }
        });
        return result;
    }

    public static TransactionComponentData getTransanctionSnapShotFromInvocationData(Runnable t, String errorMessage, Throwable error, InvocationData data, long currTimeInMillisend) {
        if (data.getCursor() == null) {
            return null;
        }
        long startTime = data.getWallClockStartTime();
        long roughlyDuration = currTimeInMillisend - startTime;
        TransactionComponentData root = null;
        TransactionComponentData curComponent = null;
        TransactionComponentData nextComponent = null;
        boolean isRootComponentAlreadySet = false;
        int i = 0;
        while (i < data.getStartCursorsCount()) {
            ITransactionElement element = data.getStartCursorAt(i);
            if (element instanceof BlameTransactionElement) {
                nextComponent = TransactionComponentData.createMilliSecTransactionComponentData(((BlameTransactionElement)element).getComponentName(), startTime, roughlyDuration);
                HighPerformanceIntelligentStackHelper.fillComponentParams(nextComponent, data, t, errorMessage, error);
                if (!isRootComponentAlreadySet) {
                    curComponent = root = nextComponent;
                    isRootComponentAlreadySet = true;
                } else {
                    curComponent.addSubNode(nextComponent);
                    curComponent = nextComponent;
                }
            }
            ++i;
        }
        return root;
    }

    public static TransactionComponentData getTransanctionSnapshotFromStackElement(Runnable t, String errorMessage, Throwable error, IIntelligentInstrumentationStackElement data, long currTimeInMillisend) {
        long startTime = data.getWallClockStartTime();
        long duration = currTimeInMillisend - startTime;
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(data.getComponentName(), startTime, duration);
        HashMap<String, String> parameters = new HashMap<String, String>();
        component.setParameters(parameters);
        parameters.put("Method", data.getProbeMethodName());
        parameters.put("Method Descriptor", data.getProbeMethodDescriptor());
        parameters.put("Class", data.getProbeClassName());
        if (error != null) {
            StackTraceElement[] stackTraceElements = error.getStackTrace();
            if (stackTraceElements.length > 0) {
                parameters.put("Exception", InvocationData.limitSize(stackTraceElements[0].toString()));
            } else {
                parameters.put("Exception", InvocationData.limitSize(errorMessage));
            }
        }
        if (errorMessage != null) {
            parameters.put("Error Message", errorMessage);
        }
        return component;
    }

    private static void getElementStack(Stack<IIntelligentInstrumentationStackElement> inStack, IIntelligentInstrumentationStackElement lastElement) {
        int numThrottledHard = 0;
        int hardMaxLimit = StackRecursionHelper.kMaxRecursive;
        inStack.push(lastElement);
        IIntelligentInstrumentationStackElement currElement = (IIntelligentInstrumentationStackElement)lastElement.getParent();
        IIntelligentInstrumentationStackElement parentElement = null;
        while (currElement != null) {
            parentElement = (IIntelligentInstrumentationStackElement)currElement.getParent();
            if (parentElement == null) {
                inStack.push(currElement);
            } else if (inStack.size() + 1 >= hardMaxLimit) {
                ++numThrottledHard;
            } else {
                inStack.push(currElement);
            }
            currElement = parentElement;
        }
        try {
            IAgent agent = AgentShim.getAgent();
            if (agent != null && agent.IAgent_getModuleFeedback().isDebugEnabled() && (currElement = inStack.peek()) != null) {
                String funcName = currElement.getComponentName();
                agent.IAgent_getModuleFeedback().debug("Intelligent Error Snapshot has " + inStack.size() + " components. It skipped " + numThrottledHard + " intelligent components for " + funcName);
            }
        }
        catch (Exception exception) {}
    }

    public static HighPerformanceIntelligenceStackElement currentElement(InvocationData data, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack iiVirtualStack) {
        HighPerformanceIntelligenceStackElement current = null;
        int id = data.getInvocationId();
        if (id != -1) {
            HighPerformanceIntelligenceStackElement peeked = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.peek(iiVirtualStack);
            current = new HighPerformanceIntelligenceStackElement(peeked.fCurrentCursor, peeked.fStack);
            long stallThreshold = StallFeatureBase.sStallThreshold.get();
            boolean hasFinished = current.isFinished();
            while ((hasFinished && current.getDuration() < stallThreshold || !hasFinished && System.currentTimeMillis() - current.getStartTime() < stallThreshold) && current.getInvocationId() != id) {
                if ((current = current.getParent()) == null) {
                    return null;
                }
                hasFinished = current.isFinished();
            }
        }
        return current;
    }
}

